/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis.characterize;

import characterization.shapes.fourier.FourierDescriptors;
import characterization.shapes.shapeIndexes.ShapeIndexesComputer;
import characterization.textures.BasicTexturalFeatures;
import characterization.textures.statisticalmatrices.com.Haralick;
import characterization.textures.statisticalmatrices.rlm.RLMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.DZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.MultiDZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.olzm.GlolzmFeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.olzm.MGlolzm;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiSZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import measures.Measures2D;
import measures.hedgehop.Distance;
import measures.hedgehop.DistanceTools;
import morphee.StructuringElement;
import morphee.granulometry.PatternSpectrum;
import morphee.granulometry.PatternSpectrumMultiSE;
import morphee.levelings.Leveling;
import processing.filters.SignalFilter;
import processing.reducer.ColorReducer;
import processing.thresholding.Binary;

public class CharacterizeCells {
    private final int BASIC_TEXTURAL_FEATURES = 0;
    private final int FOURIER_DESCRIPTORS = 1;
    private final int GLDZM = 2;
    private final int GLDZMMS = 3;
    private final int GLSZM = 4;
    private final int GLSZMMS = 5;
    private final int SHAPE_INDEXES = 6;
    private final int PATTERN_SPECTRUM = 7;
    private final int GLOAGLZM = 8;
    private final int GLOAGLZMMS = 9;
    private final int PATTERN_SPECTRUM_MSE = 10;
    private final int PATTERN_SPECTRUM_BIN = 12;
    private final int HARALICK = 13;
    private final int RUN_LENGTH = 14;
    private int nbErrors = -1;
    private int nbCPU;
    private int CurrentAction = -1;
    private String[] FeaturesNames = null;
    private double[] Features = null;
    private DataOutputStream Out = null;
    private StructuringElement se = null;
    private SignalFilter binary = new Binary(1);
    private ColorReducer reducer = null;
    private Leveling leveling = null;
    private int nbGrayLevel = -1;
    private int nbSizes = -1;
    private int nbDistances = -1;
    private boolean FixedSize = false;
    private boolean Centroid = true;
    private int nbLength = -1;
    private int nbOrientation = -1;
    private boolean UseAverageOrientation = true;
    private boolean UseGapToAO = true;
    private BasicTexturalFeatures btf = null;
    private FourierDescriptors fd = null;
    private final Metric metric = new Euclidian();
    private DZMfeatures gldzm = null;
    private MultiDZM gldzmms = null;
    private SZMfeatures glszm = null;
    private MultiSZM glszmms = null;
    private PatternSpectrumMultiSE psmse = null;
    private PatternSpectrum ps = null;
    private int MinRadius;
    private int MaxRadius;
    private int Step;
    private Distance dist = DistanceTools.CreateMontanariDistance(2, 7);
    private Measures2D measures = null;
    private ShapeIndexesComputer csi = null;
    private GlolzmFeatures gloaglzm = null;
    private MGlolzm gloaglzmms = null;
    private RLMfeatures glrlm = null;
    private Haralick haralick = null;

    public void Extract(File RAMIS, String Marker2, File Result) {
        if (!RAMIS.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] listLames = RAMIS.listFiles();
        try {
            if (!Result.exists()) {
                Result.createNewFile();
            }
            this.Out = new DataOutputStream(new FileOutputStream(Result));
            this.WriteColumnNames();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
        this.nbErrors = 0;
        for (int l = 0; l < listLames.length; ++l) {
            if (!listLames[l].isDirectory()) continue;
            this.ExtractFromLame(listLames[l], Marker2, Result);
        }
        listLames = null;
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    public void ExtractFromLame(File Lame, String Marker2, File Result) {
        if (!Lame.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] listCenters = Lame.listFiles();
        File[] listFields = null;
        File[] listFolders = null;
        File[] listVignettes = null;
        try {
            if (!Result.exists()) {
                Result.createNewFile();
            }
            this.Out = new DataOutputStream(new FileOutputStream(Result));
            this.WriteColumnNames();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
        this.nbErrors = 0;
        for (int c = 0; c < listCenters.length; ++c) {
            if (!listCenters[c].isDirectory()) continue;
            listFields = listCenters[c].listFiles();
            for (int f = 0; f < listFields.length; ++f) {
                if (!listFields[f].isDirectory()) continue;
                listFolders = listFields[f].listFiles();
                for (int r = 0; r < listFolders.length; ++r) {
                    if (!listFolders[r].isDirectory() || !listFolders[r].getName().contains("_" + Marker2 + "_Vignettes")) continue;
                    listVignettes = listFolders[r].listFiles();
                    for (int v = 0; v < listVignettes.length; ++v) {
                        if (!listVignettes[v].getName().contains(".png")) continue;
                        this.Characterize(listVignettes[v].getAbsoluteFile(), Lame.getName(), listCenters[c].getName(), listFields[f].getName(), Marker2.toUpperCase(), listVignettes[v].getName().substring(listVignettes[v].getName().length() - 6, listVignettes[v].getName().length() - 4));
                    }
                }
                listFolders = null;
            }
            listFields = null;
        }
        listCenters = null;
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    public void ExtractFromFolder(File Folder, File Result) {
        if (!Folder.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] list = Folder.listFiles();
        try {
            if (!Result.exists()) {
                Result.createNewFile();
            }
            this.Out = new DataOutputStream(new FileOutputStream(Result));
            this.WriteColumnNames();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
        this.nbErrors = 0;
        for (int v = 0; v < list.length; ++v) {
            if (!list[v].getName().contains(".png")) continue;
            this.Characterize(list[v].getAbsoluteFile(), list[v].getName().substring(0, 8), list[v].getName().substring(9, 11), list[v].getName().substring(12, 14), list[v].getName().substring(15, 16).toUpperCase(), list[v].getName().substring(17, 19));
        }
        list = null;
        System.out.flush();
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void Characterize(File name, String Lame, String Center2, String Field2, String Marker2, String Number2) {
        BufferedImage vignette = null;
        try {
            try {
                vignette = ImageIO.Read(name.getAbsolutePath());
                switch (this.CurrentAction) {
                    case 0: {
                        this.ComputeBasicTexturalFeatures(vignette);
                        break;
                    }
                    case 1: {
                        this.ComputeFourierDescriptors(vignette);
                        break;
                    }
                    case 2: {
                        this.ComputeGldzm(vignette);
                        break;
                    }
                    case 3: {
                        this.ComputeGldzmMS(vignette);
                        break;
                    }
                    case 4: {
                        this.ComputeGlszm(vignette);
                        break;
                    }
                    case 5: {
                        this.ComputeGlszmMS(vignette);
                        break;
                    }
                    case 7: {
                        this.ComputePatternSpectrum(vignette);
                        break;
                    }
                    case 12: {
                        this.ComputePatternSpectrumBin(vignette);
                        break;
                    }
                    case 10: {
                        this.ComputePatternSpectrumMSE(vignette);
                        break;
                    }
                    case 6: {
                        this.ComputeShapeIndexes(vignette);
                        break;
                    }
                    case 8: {
                        this.ComputeGloaglzm(vignette);
                        break;
                    }
                    case 9: {
                        this.ComputeGloaglzmMS(vignette);
                        break;
                    }
                    case 14: {
                        this.ComputeGlrlm(vignette);
                        break;
                    }
                    case 13: {
                        this.ComputeHaralick(vignette);
                        break;
                    }
                    default: {
                        throw new Error("Default: Current action not defined or managed.");
                    }
                }
                vignette = null;
            }
            catch (Error E) {
                Arrays.fill(this.Features, 0.0);
                System.err.println("Error " + this.nbErrors++ + "(computation) => ");
                E.printStackTrace();
                vignette = null;
            }
            catch (Exception E) {
                Arrays.fill(this.Features, 0.0);
                System.err.println("Exception " + this.nbErrors++ + "(computation) => ");
                E.printStackTrace();
                vignette = null;
            }
        }
        catch (Throwable throwable) {
            vignette = null;
            throw throwable;
        }
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= this.Features.length) {
                    this.Out.write(String.valueOf(name.getName() + " " + Lame + " " + Center2 + " " + Field2 + " " + Marker2 + " " + Number2 + "\n").getBytes("ASCII"));
                    return;
                }
                this.Out.write(String.valueOf(this.Features[i2] + " ").getBytes("ASCII"));
                ++i2;
            }
        }
        catch (Error E) {
            System.err.println("Error " + this.nbErrors++ + "(writting) => ");
            E.printStackTrace();
            return;
        }
        catch (Exception E) {
            System.err.println("Exception " + this.nbErrors++ + "(writting) => ");
            E.printStackTrace();
        }
    }

    public void setBasicTexturalFeatures() {
        this.btf = new BasicTexturalFeatures();
        this.FeaturesNames = this.btf.FeaturesNames();
        this.Features = this.btf.Features();
        this.CurrentAction = 0;
    }

    private void ComputeBasicTexturalFeatures(BufferedImage vignette) {
        this.btf.Extract(vignette, null, 0);
    }

    public void setFourierDescriptors(int nbDescriptors) {
        this.fd = new FourierDescriptors(nbDescriptors);
        this.FeaturesNames = this.fd.FeaturesNames();
        this.CurrentAction = 1;
    }

    private void ComputeFourierDescriptors(BufferedImage vignette) {
        BufferedImage bin = this.binary.Filter(vignette, 1);
        this.fd.Compute(bin, this.metric);
        this.Features = this.fd.Feature();
        bin = null;
    }

    public void setGldzm(int nbGrayLevel, int nbDistances, StructuringElement se, ColorReducer reducer, Leveling leveling, boolean Centroid, boolean FixedSize, int nbCPU) {
        this.gldzm = new DZMfeatures();
        this.FeaturesNames = this.gldzm.FeaturesNames();
        this.Features = this.gldzm.Features();
        this.nbGrayLevel = nbGrayLevel;
        this.nbDistances = nbDistances;
        this.se = se;
        this.Centroid = Centroid;
        this.FixedSize = FixedSize;
        this.reducer = reducer;
        this.leveling = leveling;
        this.nbCPU = nbCPU;
        this.CurrentAction = 2;
    }

    private void ComputeGldzm(BufferedImage vignette) {
        this.gldzm.Compute(vignette, null, this.nbGrayLevel, this.nbDistances, this.se, this.Centroid, this.FixedSize, this.reducer, 0, true, 2);
    }

    public void setGldzmMS(int nbDistances, StructuringElement se, ColorReducer reducer, Leveling leveling, boolean Centroid, boolean FixedSize, int nbCPU) {
        this.gldzmms = new MultiDZM();
        this.FeaturesNames = this.gldzmms.FeaturesNames();
        this.Features = this.gldzmms.Features();
        this.nbDistances = nbDistances;
        this.se = se;
        this.FixedSize = FixedSize;
        this.Centroid = Centroid;
        this.reducer = reducer;
        this.leveling = leveling;
        this.nbCPU = nbCPU;
        this.CurrentAction = 3;
    }

    private void ComputeGldzmMS(BufferedImage vignette) {
        this.gldzmms.Compute(vignette, null, this.nbDistances, this.se, this.Centroid, this.FixedSize, this.reducer, 0, true, 2);
    }

    public void setGlszm(int nbGrayLevel, int nbSizes, ColorReducer reducer, Leveling leveling, boolean FixedSize, int nbCPU) {
        this.glszm = new SZMfeatures();
        this.FeaturesNames = this.glszm.FeaturesNames();
        this.Features = this.glszm.Features();
        this.nbGrayLevel = nbGrayLevel;
        this.nbSizes = nbSizes;
        this.FixedSize = FixedSize;
        this.reducer = reducer;
        this.leveling = leveling;
        this.nbCPU = nbCPU;
        this.CurrentAction = 4;
    }

    private void ComputeGlszm(BufferedImage vignette) {
        this.glszm.Compute(vignette, null, this.nbGrayLevel, this.nbSizes, this.reducer, 0, true);
    }

    public void setGlszmMS(int nbSizes, ColorReducer reducer, Leveling leveling, boolean FixedSize, int nbCPU) {
        this.glszmms = new MultiSZM();
        this.FeaturesNames = this.glszmms.FeaturesNames();
        this.Features = this.glszmms.Features();
        this.nbSizes = nbSizes;
        this.FixedSize = FixedSize;
        this.reducer = reducer;
        this.leveling = leveling;
        this.nbCPU = nbCPU;
        this.CurrentAction = 5;
    }

    private void ComputeGlszmMS(BufferedImage vignette) {
        this.glszmms.Compute(vignette, null, this.nbSizes, this.reducer, 0, true);
        this.Features = this.glszmms.Features();
    }

    public void setPatternSpectrumMSE(List<Integer> listse, int MinRadius, int MaxRadius, int Step, Leveling leveling, int nbCPU) {
        this.psmse = new PatternSpectrumMultiSE();
        this.psmse.setParameters(MinRadius, MaxRadius, Step);
        this.psmse.setStructuringElements(listse);
        this.FeaturesNames = new String[(this.psmse.FeaturesNames().length - 3) / 2 + 3];
        this.Features = new double[this.FeaturesNames.length];
        for (int i2 = 0; i2 < (this.psmse.FeaturesNames().length - 3) / 2; ++i2) {
            this.FeaturesNames[i2] = this.psmse.FeaturesNames()[i2].substring(0);
        }
        this.FeaturesNames[i2++] = this.psmse.FeaturesNames()[this.psmse.FeaturesNames().length - 3].substring(0);
        this.FeaturesNames[i2++] = this.psmse.FeaturesNames()[this.psmse.FeaturesNames().length - 2].substring(0);
        this.FeaturesNames[i2++] = this.psmse.FeaturesNames()[this.psmse.FeaturesNames().length - 1].substring(0);
        this.MinRadius = MinRadius;
        this.MaxRadius = MaxRadius;
        this.Step = Step;
        this.leveling = leveling;
        this.nbCPU = nbCPU;
        this.CurrentAction = 10;
    }

    private void ComputePatternSpectrumMSE(BufferedImage vignette) {
        this.psmse.Process(vignette, null, this.MinRadius, this.MaxRadius, this.Step, 0, this.nbCPU);
        for (int i2 = 0; i2 < this.Features.length - 3; ++i2) {
            this.Features[i2] = this.psmse.Features()[i2];
        }
        this.Features[i2++] = this.psmse.Features()[this.psmse.Features().length - 3];
        this.Features[i2++] = this.psmse.Features()[this.psmse.Features().length - 2];
        this.Features[i2++] = this.psmse.Features()[this.psmse.Features().length - 1];
    }

    public void setPatternSpectrum(int MinRadius, int MaxRadius, int Step, Leveling leveling, int nbCPU) {
        this.ps = new PatternSpectrum();
        this.ps.Parameters(MinRadius, MaxRadius, Step, leveling, 0);
        this.FeaturesNames = this.ps.FeaturesNames();
        this.MinRadius = MinRadius;
        this.MaxRadius = MaxRadius;
        this.Step = Step;
        this.leveling = leveling;
        this.nbCPU = nbCPU;
        this.CurrentAction = 7;
    }

    private void ComputePatternSpectrum(BufferedImage vignette) {
        this.ps.Process(vignette, null, this.MinRadius, this.MaxRadius, this.Step, 0, -2, this.nbCPU);
        this.Features = this.ps.Features();
    }

    public void setPatternSpectrumBin(int MinRadius, int MaxRadius, int Step, int nbCPU) {
        this.ps = new PatternSpectrum();
        this.ps.Parameters(MinRadius, MaxRadius, Step, null, 0);
        this.FeaturesNames = this.ps.FeaturesNames();
        this.MinRadius = MinRadius;
        this.MaxRadius = MaxRadius;
        this.Step = Step;
        this.nbCPU = nbCPU;
        this.CurrentAction = 7;
    }

    private void ComputePatternSpectrumBin(BufferedImage vignette) {
        BufferedImage bin = null;
        bin = vignette.getType() != 12 ? this.binary.Filter(vignette, 1) : vignette;
        this.ps.Process(bin, null, this.MinRadius, this.MaxRadius, this.Step, 0, -2, this.nbCPU);
        this.Features = this.ps.Features();
        bin = null;
    }

    public void setShapeIndexes(List<String> list) {
        this.csi = new ShapeIndexesComputer();
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            this.csi.DoNotCompute(iter.next());
        }
        iter = null;
        this.FeaturesNames = this.csi.FeaturesNames();
        this.Features = this.csi.Features();
        this.CurrentAction = 6;
    }

    private void ComputeShapeIndexes(BufferedImage vignette) {
        BufferedImage bin = this.binary.Filter(vignette, 1);
        this.measures = new Measures2D(bin);
        this.measures.Basics(true, false);
        this.measures.MainAxes();
        this.measures.EuclidianDiameter();
        this.measures.DistanceMapAndDiskMax(this.se);
        this.measures.ConvexHull(false, 5);
        this.measures.EuclidianRadii();
        this.csi.ComputeIndexes(this.measures);
        this.Features = this.csi.Features();
        bin = null;
        this.measures = null;
    }

    public void setGloalzm(int nbGrayLevel, int nbLength, int nbOrientation, boolean FixedSize, boolean UseAverageOrientation, boolean UseGapToAO, ColorReducer reducer, Leveling leveling, Distance Montanary, int nbCPU) {
        this.gloaglzm = new GlolzmFeatures();
        this.FeaturesNames = this.gloaglzm.FeaturesNames();
        this.Features = this.gloaglzm.Features();
        this.nbGrayLevel = nbGrayLevel;
        this.nbLength = nbLength;
        this.nbOrientation = nbOrientation;
        this.UseAverageOrientation = UseAverageOrientation;
        this.UseGapToAO = UseGapToAO;
        this.FixedSize = FixedSize;
        this.reducer = reducer;
        this.leveling = leveling;
        this.dist = Montanary;
        this.nbCPU = nbCPU;
        this.CurrentAction = 8;
    }

    private void ComputeGloaglzm(BufferedImage vignette) {
        this.gloaglzm.Compute(vignette, null, this.nbGrayLevel, this.nbLength, this.nbOrientation, this.FixedSize, this.UseAverageOrientation, this.UseGapToAO, this.reducer, this.leveling, 0, true, this.se, 2);
        this.Features = this.gloaglzm.Features();
    }

    public void setGloalzmMS(int nbLength, int nbOrientation, boolean FixedSize, boolean UseAverageOrientation, boolean UseGapToAO, ColorReducer reducer, Leveling leveling, Distance Montanary, int nbCPU) {
        this.gloaglzmms = new MGlolzm();
        this.FeaturesNames = this.gloaglzmms.FeaturesNames();
        this.Features = this.gloaglzmms.Features();
        this.nbLength = nbLength;
        this.nbOrientation = nbOrientation;
        this.UseAverageOrientation = UseAverageOrientation;
        this.UseGapToAO = UseGapToAO;
        this.FixedSize = FixedSize;
        this.reducer = reducer;
        this.leveling = leveling;
        this.dist = Montanary;
        this.nbCPU = nbCPU;
        this.CurrentAction = 9;
    }

    private void ComputeGloaglzmMS(BufferedImage vignette) {
        this.gloaglzmms.Compute(vignette, null, this.nbLength, this.nbOrientation, this.FixedSize, this.UseAverageOrientation, this.UseGapToAO, this.reducer, this.leveling, 0, true, this.se, 2);
        this.Features = this.gloaglzmms.Features();
    }

    public void setGlrlm(int nbGrayLevel, ColorReducer reducer, Leveling leveling, int nbCPU) {
        this.glrlm = new RLMfeatures();
        this.FeaturesNames = this.glrlm.FeaturesNames();
        this.Features = this.glrlm.Features();
        this.nbGrayLevel = nbGrayLevel;
        this.reducer = reducer;
        this.leveling = leveling;
        this.nbCPU = nbCPU;
        this.CurrentAction = 14;
    }

    private void ComputeGlrlm(BufferedImage vignette) {
        this.glrlm.Compute(vignette, null, this.nbGrayLevel, this.reducer, 0, this.nbCPU);
    }

    public void setHaralick(int nbGrayLevel, ColorReducer reducer, int nbCPU) {
        this.haralick = new Haralick();
        this.FeaturesNames = this.haralick.FeaturesNames();
        this.Features = this.haralick.Features();
        this.nbGrayLevel = nbGrayLevel;
        this.reducer = reducer;
        this.nbCPU = nbCPU;
        this.CurrentAction = 13;
    }

    private void ComputeHaralick(BufferedImage vignette) {
        this.haralick.Compute(vignette, null, this.reducer, this.nbGrayLevel, 0);
    }

    private void WriteColumnNames() {
        try {
            for (String FeaturesName : this.FeaturesNames) {
                this.Out.write(String.valueOf(FeaturesName + " ").getBytes("ASCII"));
            }
            this.Out.write(String.valueOf("Image Lame Center Field Marker Number\n").getBytes("ASCII"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }
}

