/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis;

import arrayTiTi.ArrayIO;
import filesAndFolders.fichiersTabules.FichierTabule;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class StatisticsFromMA {
    private int nbErrors = -1;
    private double[][] AnglesOrientations = null;
    private double[][] DistancesNuclei = null;
    private int[][] Neighborhoods = null;
    private double[] Orientations = null;
    private int[] TouchBorder = null;
    private List<Object[]> DistOr = new Vector<Object[]>(113);
    private List<Object[]> DistAnOr = new Vector<Object[]>(113);

    public void ComputeLame(File Lame, String Result) {
        if (!Lame.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] listCenters = null;
        File[] listFields = null;
        this.nbErrors = 0;
        listCenters = Lame.listFiles();
        for (int c = 0; c < listCenters.length; ++c) {
            if (!listCenters[c].isDirectory()) continue;
            listFields = listCenters[c].listFiles();
            for (int f = 0; f < listFields.length; ++f) {
                if (!listFields[f].isDirectory()) continue;
                this.Compute(listFields[f], Lame.getName(), listCenters[c].getName());
            }
            listFields = null;
        }
        listCenters = null;
        this.SaveStats(Result);
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    private void Compute(File Field2, String Lame, String Center2) {
        try {
            System.out.println("Processing " + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6));
            this.AnglesOrientations = ArrayIO.ReadDouble2D(new File(Field2.getAbsolutePath() + "/Informations/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_D_AnglesOrientations.txt"));
            this.DistancesNuclei = ArrayIO.ReadDouble2D(new File(Field2.getAbsolutePath() + "/Informations/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_D_Distances.txt"));
            this.Neighborhoods = ArrayIO.ReadInt2D(new File(Field2.getAbsolutePath() + "/Informations/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_R_Neighborhoods.txt"));
            this.Orientations = ArrayIO.ReadDouble1D(new File(Field2.getAbsolutePath() + "/Informations/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_D_Orientations.txt"));
            this.TouchBorder = ArrayIO.ReadInt1D(new File(Field2.getAbsolutePath() + "/Informations/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_R_TouchBorder.txt"));
            this.ExtractInformation(Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6));
        }
        catch (Exception e) {
            System.err.println("Exception " + this.nbErrors++ + " => Exception: " + e.getMessage());
        }
        catch (Error E) {
            System.err.println("Error " + this.nbErrors++ + " => Error: " + E.getMessage());
        }
    }

    private void ExtractInformation(String Suffixe) {
        int width = this.DistancesNuclei[0].length;
        int height = this.DistancesNuclei.length;
        for (int y = 1; y < height; ++y) {
            for (int x = 1; x < width; ++x) {
                if (this.TouchBorder[x] != 0 || this.TouchBorder[y] != 0 || x <= y) continue;
                String cell1 = Suffixe + "_D_" + (Serializable)(x < 10 ? "0" + x : Integer.valueOf(x));
                String cell2 = Suffixe + "_D_" + (Serializable)(y < 10 ? "0" + y : Integer.valueOf(y));
                this.DistOr.add(new Object[]{this.DistancesNuclei[y][x], this.Orientations[x], cell1});
                this.DistOr.add(new Object[]{this.DistancesNuclei[y][x], this.Orientations[y], cell2});
                if (this.Neighborhoods[y][x] != 1) continue;
                double theta = this.AnglesOrientations[y][x] >= 270.0 ? 360.0 - this.AnglesOrientations[y][x] : this.AnglesOrientations[y][x];
                double phi = this.AnglesOrientations[x][y] >= 270.0 ? 360.0 - this.AnglesOrientations[x][y] : this.AnglesOrientations[x][y];
                this.DistAnOr.add(new Object[]{this.DistancesNuclei[y][x], Math.abs(theta - phi), cell1, cell2});
            }
        }
    }

    private void SaveStats(String Suffixe) {
        Object[] obj2 = null;
        Iterator<Object[]> iter = null;
        FichierTabule F = new FichierTabule(this.DistOr.size(), new int[]{1, 1, 2}, "");
        F.setColumnsNames(new String[]{"Distance Nuclei", "Orientations", "Nuclei"});
        int nb = 0;
        for (Object[] obj2 : this.DistOr) {
            F.setValue(nb, 0, (Double)obj2[0]);
            F.setValue(nb, 1, (Double)obj2[1]);
            F.setValue(nb++, 2, (String)obj2[2]);
        }
        F.Write(Suffixe + "_DistOr.txt", false);
        F = null;
        iter = null;
        F = new FichierTabule(this.DistAnOr.size(), new int[]{1, 1, 2, 2}, "");
        F.setColumnsNames(new String[]{"Distance Nuclei", "Angle Orientations", "Nuclei1", "Nuclei2"});
        nb = 0;
        for (Object[] obj2 : this.DistAnOr) {
            F.setValue(nb, 0, (Double)obj2[0]);
            F.setValue(nb, 1, (Double)obj2[1]);
            F.setValue(nb, 2, (String)obj2[2]);
            F.setValue(nb++, 3, (String)obj2[3]);
        }
        F.Write(Suffixe + "_DistAnOr.txt", false);
        F = null;
        iter = null;
    }
}

