/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis;

import arrayTiTi.ArrayIO;
import dataMining.pca.PCA;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mathematics.Geometry2D;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import mathematics.primitives.Box;
import mathematics.primitives.pointsTiTi.Coordinate;
import measures.BasicMeasures;
import measures.hedgehop.Distance;
import measures.hedgehop.DistanceMapComputer;
import measures.hedgehop.DistanceTools;
import measures.histogram.Histogram;
import morphee.Dilate;
import morphee.StructuringElement;

public class MatricesAdjacences {
    private double[][] Angles = null;
    private double[][] AnglesOrientations = null;
    private double[][] DistancesNuclei = null;
    private double[][] DistancesCells = null;
    private int[][] Neighborhoods = null;
    private double[] Orientations = null;
    private int[] TouchBorder = null;
    private int Width;
    private int Height;
    private BufferedImage Centromeres = null;
    private BufferedImage Centrosomes = null;
    private BufferedImage Dna = null;
    private BufferedImage DnaLabel = null;
    private BufferedImage Microtubules = null;
    private BufferedImage MicrotubulesDilate = null;
    private BufferedImage MicrotubulesLabel = null;
    private Box[] BoundingBoxes = null;
    private Coordinate[] Centroids = null;
    private List<BufferedImage> VignettesCentromeres = null;
    private List<BufferedImage> VignettesCentrosomes = null;
    private List<BufferedImage> VignettesDna = null;
    private List<BufferedImage> VignettesMicrotubules = null;
    private BasicMeasures bbc = new BasicMeasures();
    private Dilate dilate = new Dilate(new StructuringElement(new Object[]{7, -2}));
    private Histogram Hist = new Histogram();
    private Metric metric = new Euclidian();
    private PCA pca = new PCA();
    private Distance dist = DistanceTools.CreateMontanariDistance(2, 13);
    private DistanceMapComputer dmc = new DistanceMapComputer();
    private int Marge = 1;
    private int nbErrors = -1;

    public void Compute(File RAMIS, int nbCPU) {
        if (!RAMIS.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] listLames = RAMIS.listFiles();
        File[] listCenters = null;
        File[] listFields = null;
        this.nbErrors = 0;
        for (int l = 0; l < listLames.length; ++l) {
            if (!listLames[l].isDirectory()) continue;
            listCenters = listLames[l].listFiles();
            for (int c = 0; c < listCenters.length; ++c) {
                if (!listCenters[c].isDirectory()) continue;
                listFields = listCenters[c].listFiles();
                for (int f = 0; f < listFields.length; ++f) {
                    if (!listFields[f].isDirectory()) continue;
                    this.Compute(listFields[f], listLames[l].getName(), listCenters[c].getName(), nbCPU);
                }
                listFields = null;
            }
            listCenters = null;
        }
        listLames = null;
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    public void ComputeLame(File Lame, int nbCPU) {
        if (!Lame.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] listCenters = null;
        File[] listFields = null;
        this.nbErrors = 0;
        listCenters = Lame.listFiles();
        for (int c = 0; c < listCenters.length; ++c) {
            if (!listCenters[c].isDirectory()) continue;
            listFields = listCenters[c].listFiles();
            for (int f = 0; f < listFields.length; ++f) {
                if (!listFields[f].isDirectory()) continue;
                this.Compute(listFields[f], Lame.getName(), listCenters[c].getName(), nbCPU);
            }
            listFields = null;
        }
        listCenters = null;
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Compute(File Field2, String Lame, String Center2, int nbCPU) {
        try {
            System.out.println(Lame + " " + Center2 + " " + Field2.getName());
            this.Centromeres = ImageIO.Read(Field2.getAbsolutePath() + "/Segmented/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_FiltCentroSegment.png");
            this.Centrosomes = ImageIO.Read(Field2.getAbsolutePath() + "/Segmented/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_CentrosomesSegment.png");
            this.Dna = ImageIO.Read(Field2.getAbsolutePath() + "/Marker_d_normalized/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_d_00_BgCorrect.png");
            this.DnaLabel = ImageIO.Read(Field2.getAbsolutePath() + "/Segmented/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_NucleiSegment.png");
            this.Microtubules = ImageIO.Read(Field2.getAbsolutePath() + "/Marker_r_normalized/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_r_00_BgCorrect.png");
            this.MicrotubulesLabel = ImageIO.Read(Field2.getAbsolutePath() + "/Segmented/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_CellsSegment.png");
            this.Width = this.DnaLabel.getWidth();
            this.Height = this.DnaLabel.getHeight();
            this.NewColors();
            this.SeparateAndSave(Field2, Lame, Center2);
            this.SaveBoundingBoxes(Field2, Lame, Center2);
            this.ComputeDistances(Field2, Lame, Center2);
            this.ComputeNeighborhoods(Field2, Lame, Center2, nbCPU);
            this.ComputeOrientations(Field2, Lame, Center2);
            this.ComputeAngles(Field2, Lame, Center2);
        }
        catch (Exception e) {
            System.err.println("Exception " + this.nbErrors++ + " => Exception: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Error E) {
            System.err.println("Error " + this.nbErrors++ + " => Error: " + E.getMessage());
        }
        finally {
            this.Centromeres = null;
            this.Centrosomes = null;
            this.Dna = null;
            this.DnaLabel = null;
            this.Microtubules = null;
            this.MicrotubulesDilate = null;
            this.MicrotubulesLabel = null;
        }
    }

    private void NewColors() {
        int i2;
        int x;
        int y;
        int[] Tab = null;
        WritableRaster wrdna = this.DnaLabel.getRaster();
        WritableRaster wrml = this.MicrotubulesLabel.getRaster();
        for (y = 0; y < this.Height; ++y) {
            for (x = 0; x < this.Width; ++x) {
                if (wrdna.getSample(x, y, 0) <= 0) continue;
                wrdna.setSample(x, y, 0, wrml.getSample(x, y, 0));
            }
        }
        this.Hist.Fill(this.DnaLabel);
        Tab = this.Hist.getValues()[0];
        int size = Tab.length;
        int nb1 = 0;
        for (i2 = 0; i2 < size; ++i2) {
            if (Tab[i2] <= 0) continue;
            Tab[i2] = nb1++;
        }
        for (y = 0; y < this.Height; ++y) {
            for (x = 0; x < this.Width; ++x) {
                wrdna.setSample(x, y, 0, Tab[wrdna.getSample(x, y, 0)]);
            }
        }
        Tab = null;
        this.Hist.Fill(this.MicrotubulesLabel);
        Tab = this.Hist.getValues()[0];
        int nb2 = 0;
        for (i2 = 0; i2 < size; ++i2) {
            if (Tab[i2] <= 0) continue;
            Tab[i2] = nb2++;
        }
        for (y = 0; y < this.Height; ++y) {
            for (x = 0; x < this.Width; ++x) {
                wrml.setSample(x, y, 0, Tab[wrml.getSample(x, y, 0)]);
            }
        }
        Tab = null;
        if (nb1 != nb2) {
            ++this.nbErrors;
            throw new Error("Number of cells/nuclei different from Dna and Microtubules:" + nb1 + " " + nb2);
        }
        this.Allocate(nb1 - 1);
        System.out.println(nb1 + " cells/nuclei.");
        wrdna = null;
        wrml = null;
    }

    private void SeparateAndSave(File Field2, String Lame, String Center2) throws IOException {
        int x;
        int y;
        int i2;
        File file = null;
        String Name2 = null;
        BufferedImage vig = null;
        BufferedImage vigmic = null;
        WritableRaster wrml = this.MicrotubulesLabel.getRaster();
        WritableRaster wrmic = this.Microtubules.getRaster();
        WritableRaster wrvig = null;
        WritableRaster wrvigmic = null;
        for (i2 = 1; i2 < this.BoundingBoxes.length; ++i2) {
            this.BoundingBoxes[i2].SetAll(this.Width, this.Height, 0, 0);
        }
        for (y = 0; y < this.Height; ++y) {
            for (x = 0; x < this.Width; ++x) {
                if (wrml.getSample(x, y, 0) <= 0) continue;
                int val = wrml.getSample(x, y, 0);
                if ((double)x < this.BoundingBoxes[val].getMinX()) {
                    this.BoundingBoxes[val].setMinX(x);
                }
                if ((double)x > this.BoundingBoxes[val].getMaxX()) {
                    this.BoundingBoxes[val].setMaxX(x);
                }
                if ((double)y < this.BoundingBoxes[val].getMinY()) {
                    this.BoundingBoxes[val].setMinY(y);
                }
                if (!((double)y > this.BoundingBoxes[val].getMaxY())) continue;
                this.BoundingBoxes[val].setMaxY(y);
            }
        }
        wrml = null;
        for (i2 = 1; i2 < this.BoundingBoxes.length; ++i2) {
            if (this.BoundingBoxes[i2].getMinX() >= (double)this.Marge) {
                this.BoundingBoxes[i2].setMinX(this.BoundingBoxes[i2].getMinX() - (double)this.Marge);
            }
            if (this.BoundingBoxes[i2].getMinY() >= (double)this.Marge) {
                this.BoundingBoxes[i2].setMinY(this.BoundingBoxes[i2].getMinY() - (double)this.Marge);
            }
            if (this.BoundingBoxes[i2].getMaxX() < (double)(this.Width - this.Marge)) {
                this.BoundingBoxes[i2].setMaxX(this.BoundingBoxes[i2].getMaxX() + (double)this.Marge);
            }
            if (this.BoundingBoxes[i2].getMaxY() < (double)(this.Height - this.Marge)) {
                this.BoundingBoxes[i2].setMaxY(this.BoundingBoxes[i2].getMaxY() + (double)this.Marge);
            }
            this.BoundingBoxes[i2].WidthHeight();
        }
        this.VignettesMicrotubules.add(null);
        for (i2 = 1; i2 < this.BoundingBoxes.length; ++i2) {
            this.VignettesMicrotubules.add(ImageNew.SubImage((BufferedImage)this.MicrotubulesLabel, (int)((int)this.BoundingBoxes[i2].getMinX()), (int)((int)this.BoundingBoxes[i2].getMinY()), (int)((int)this.BoundingBoxes[i2].getMaxX()), (int)((int)this.BoundingBoxes[i2].getMaxY())));
            vigmic = this.VignettesMicrotubules.get(this.VignettesMicrotubules.size() - 1);
            wrvigmic = vigmic.getRaster();
            y = 0;
            while ((double)y <= this.BoundingBoxes[i2].getHeight()) {
                x = 0;
                while ((double)x <= this.BoundingBoxes[i2].getWidth()) {
                    if (wrvigmic.getSample(x, y, 0) != i2) {
                        wrvigmic.setSample(x, y, 0, 0);
                    } else {
                        wrvigmic.setSample(x, y, 0, wrmic.getSample((int)this.BoundingBoxes[i2].getMinX() + x, (int)this.BoundingBoxes[i2].getMinY() + y, 0));
                    }
                    ++x;
                }
                ++y;
            }
            vigmic = null;
            wrvigmic = null;
        }
        file = new File(Field2.getAbsolutePath() + "/Marker_r_Vignettes");
        if (!file.exists()) {
            file.mkdir();
        }
        Name2 = file.getAbsolutePath() + "/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_R_";
        for (i2 = 1; i2 < this.VignettesMicrotubules.size(); ++i2) {
            if (i2 < 10) {
                ImageIO.Write(this.VignettesMicrotubules.get(i2), Name2 + "0" + i2 + ".png", 6);
                continue;
            }
            ImageIO.Write(this.VignettesMicrotubules.get(i2), Name2 + i2 + ".png", 6);
        }
        file = null;
        WritableRaster wrdna = this.Dna.getRaster();
        this.VignettesDna.add(null);
        for (i2 = 1; i2 < this.BoundingBoxes.length; ++i2) {
            this.VignettesDna.add(ImageNew.SubImage((BufferedImage)this.DnaLabel, (int)((int)this.BoundingBoxes[i2].getMinX()), (int)((int)this.BoundingBoxes[i2].getMinY()), (int)((int)this.BoundingBoxes[i2].getMaxX()), (int)((int)this.BoundingBoxes[i2].getMaxY())));
            vig = this.VignettesDna.get(this.VignettesDna.size() - 1);
            wrvig = vig.getRaster();
            y = 0;
            while ((double)y <= this.BoundingBoxes[i2].getHeight()) {
                x = 0;
                while ((double)x <= this.BoundingBoxes[i2].getWidth()) {
                    if (wrvig.getSample(x, y, 0) != i2) {
                        wrvig.setSample(x, y, 0, 0);
                    } else {
                        wrvig.setSample(x, y, 0, wrdna.getSample((int)this.BoundingBoxes[i2].getMinX() + x, (int)this.BoundingBoxes[i2].getMinY() + y, 0));
                    }
                    ++x;
                }
                ++y;
            }
            vig = null;
        }
        file = new File(Field2.getAbsolutePath() + "/Marker_d_Vignettes");
        if (!file.exists()) {
            file.mkdir();
        }
        Name2 = file.getAbsolutePath() + "/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_D_";
        for (i2 = 1; i2 < this.VignettesDna.size(); ++i2) {
            if (i2 < 10) {
                ImageIO.Write(this.VignettesDna.get(i2), Name2 + "0" + i2 + ".png", 6);
                continue;
            }
            ImageIO.Write(this.VignettesDna.get(i2), Name2 + i2 + ".png", 6);
        }
        file = null;
        this.VignettesCentromeres.add(null);
        for (i2 = 1; i2 < this.BoundingBoxes.length; ++i2) {
            this.VignettesCentromeres.add(ImageNew.SubImage((BufferedImage)this.Centromeres, (int)((int)this.BoundingBoxes[i2].getMinX()), (int)((int)this.BoundingBoxes[i2].getMinY()), (int)((int)this.BoundingBoxes[i2].getMaxX()), (int)((int)this.BoundingBoxes[i2].getMaxY())));
            vigmic = this.VignettesMicrotubules.get(i2);
            wrvigmic = vigmic.getRaster();
            vig = this.VignettesCentromeres.get(this.VignettesCentromeres.size() - 1);
            wrvig = vig.getRaster();
            y = 0;
            while ((double)y <= this.BoundingBoxes[i2].getHeight()) {
                x = 0;
                while ((double)x <= this.BoundingBoxes[i2].getWidth()) {
                    if (wrvigmic.getSample(x, y, 0) == 0) {
                        wrvig.getSample(x, y, 0);
                    }
                    ++x;
                }
                ++y;
            }
            vig = null;
            vigmic = null;
            wrvig = null;
            wrvigmic = null;
        }
        file = new File(Field2.getAbsolutePath() + "/Marker_f_Vignettes");
        if (!file.exists()) {
            file.mkdir();
        }
        Name2 = file.getAbsolutePath() + "/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_F_";
        for (i2 = 1; i2 < this.VignettesCentromeres.size(); ++i2) {
            if (i2 < 10) {
                ImageIO.Write(this.VignettesCentromeres.get(i2), Name2 + "0" + i2 + ".png", 6);
                continue;
            }
            ImageIO.Write(this.VignettesCentromeres.get(i2), Name2 + i2 + ".png", 6);
        }
        file = null;
        this.VignettesCentrosomes.add(null);
        for (i2 = 1; i2 < this.BoundingBoxes.length; ++i2) {
            this.VignettesCentrosomes.add(ImageNew.SubImage((BufferedImage)this.Centrosomes, (int)((int)this.BoundingBoxes[i2].getMinX()), (int)((int)this.BoundingBoxes[i2].getMinY()), (int)((int)this.BoundingBoxes[i2].getMaxX()), (int)((int)this.BoundingBoxes[i2].getMaxY())));
            vigmic = this.VignettesMicrotubules.get(i2);
            wrvigmic = vigmic.getRaster();
            vig = this.VignettesCentrosomes.get(this.VignettesCentrosomes.size() - 1);
            wrvig = vig.getRaster();
            y = 0;
            while ((double)y <= this.BoundingBoxes[i2].getHeight()) {
                x = 0;
                while ((double)x <= this.BoundingBoxes[i2].getWidth()) {
                    if (wrvigmic.getSample(x, y, 0) == 0) {
                        wrvig.setSample(x, y, 0, 0);
                    }
                    ++x;
                }
                ++y;
            }
            vig = null;
            vigmic = null;
            wrvig = null;
            wrvigmic = null;
        }
        file = new File(Field2.getAbsolutePath() + "/Marker_c_Vignettes");
        if (!file.exists()) {
            file.mkdir();
        }
        Name2 = file.getAbsolutePath() + "/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_C_";
        for (i2 = 1; i2 < this.VignettesCentrosomes.size(); ++i2) {
            if (i2 < 10) {
                ImageIO.Write(this.VignettesCentrosomes.get(i2), Name2 + "0" + i2 + ".png", 6);
                continue;
            }
            ImageIO.Write(this.VignettesCentrosomes.get(i2), Name2 + i2 + ".png", 6);
        }
        file = null;
    }

    private void SaveBoundingBoxes(File Field2, String Lame, String Center2) throws IOException {
        DataOutputStream Out = null;
        File file = new File(Field2.getAbsolutePath() + "/Informations");
        if (!file.exists()) {
            file.mkdir();
        }
        String Name2 = Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6);
        Out = new DataOutputStream(new FileOutputStream(file.getAbsolutePath() + "/" + Name2 + "_BoundingBoxes.txt"));
        for (int i2 = 1; i2 < this.BoundingBoxes.length; ++i2) {
            Out.write(String.valueOf((int)this.BoundingBoxes[i2].getMinX() + "\t" + (int)this.BoundingBoxes[i2].getMinY() + "\t").getBytes("ASCII"));
            Out.write(String.valueOf((int)this.BoundingBoxes[i2].getMaxX() + "\t" + (int)this.BoundingBoxes[i2].getMaxY() + "\t").getBytes("ASCII"));
            if (i2 < 10) {
                Out.write(String.valueOf(Name2 + "_*_0" + i2 + ".png\n").getBytes("ASCII"));
                continue;
            }
            Out.write(String.valueOf(Name2 + "_*_" + i2 + ".png\n").getBytes("ASCII"));
        }
        Out = null;
    }

    private void ComputeDistances(File Field2, String Lame, String Center2) throws IOException {
        int i2;
        for (i2 = 1; i2 < this.VignettesDna.size(); ++i2) {
            this.bbc.Compute(this.VignettesDna.get(i2), false);
            this.Centroids[i2] = new Coordinate(this.bbc.Centroid.X, this.bbc.Centroid.Y);
        }
        for (i2 = 1; i2 < this.VignettesDna.size() - 1; ++i2) {
            for (int j = i2 + 1; j < this.VignettesDna.size(); ++j) {
                double xi = this.BoundingBoxes[i2].getMinX() + this.Centroids[i2].X;
                double yi = this.BoundingBoxes[i2].getMinY() + this.Centroids[i2].Y;
                double xj = this.BoundingBoxes[j].getMinX() + this.Centroids[j].X;
                double yj = this.BoundingBoxes[j].getMinY() + this.Centroids[j].Y;
                double d = this.metric.Distance(xi, yi, 0.0, xj, yj, 0.0);
                this.DistancesNuclei[j][i2] = d;
                this.DistancesNuclei[i2][j] = d;
            }
        }
        ArrayIO.Write(this.DistancesNuclei, Field2.getAbsolutePath() + "/Informations/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_D_Distances.txt", "\t");
    }

    private void ComputeNeighborhoods(File Field2, String Lame, String Center2, int nbCPU) throws IOException {
        int x;
        int y;
        this.MicrotubulesDilate = this.dilate.Filter(this.MicrotubulesLabel, nbCPU);
        WritableRaster wrmd = this.MicrotubulesDilate.getRaster();
        for (y = 1; y < this.Height - 1; ++y) {
            for (x = 1; x < this.Width - 1; ++x) {
                int p = wrmd.getSample(x, y, 0);
                if (p > 0 && wrmd.getSample(x + 1, y, 0) > 0) {
                    this.Neighborhoods[p][wrmd.getSample((int)(x + 1), (int)y, (int)0)] = 1;
                }
                if (p > 0 && wrmd.getSample(x + 1, y + 1, 0) > 0) {
                    this.Neighborhoods[p][wrmd.getSample((int)(x + 1), (int)(y + 1), (int)0)] = 1;
                }
                if (p > 0 && wrmd.getSample(x, y + 1, 0) > 0) {
                    this.Neighborhoods[p][wrmd.getSample((int)x, (int)(y + 1), (int)0)] = 1;
                }
                if (p > 0 && wrmd.getSample(x - 1, y + 1, 0) > 0) {
                    this.Neighborhoods[p][wrmd.getSample((int)(x - 1), (int)(y + 1), (int)0)] = 1;
                }
                if (p > 0 && wrmd.getSample(x - 1, y, 0) > 0) {
                    this.Neighborhoods[p][wrmd.getSample((int)(x - 1), (int)y, (int)0)] = 1;
                }
                if (p > 0 && wrmd.getSample(x - 1, y - 1, 0) > 0) {
                    this.Neighborhoods[p][wrmd.getSample((int)(x - 1), (int)(y - 1), (int)0)] = 1;
                }
                if (p > 0 && wrmd.getSample(x, y - 1, 0) > 0) {
                    this.Neighborhoods[p][wrmd.getSample((int)x, (int)(y - 1), (int)0)] = 1;
                }
                if (p <= 0 || wrmd.getSample(x + 1, y - 1, 0) <= 0) continue;
                this.Neighborhoods[p][wrmd.getSample((int)(x + 1), (int)(y - 1), (int)0)] = 1;
            }
        }
        for (y = 0; y < this.Height; ++y) {
            if (wrmd.getSample(0, y, 0) > 0) {
                this.TouchBorder[wrmd.getSample((int)0, (int)y, (int)0)] = 1;
            }
            if (wrmd.getSample(this.Width - 1, y, 0) <= 0) continue;
            this.TouchBorder[wrmd.getSample((int)(this.Width - 1), (int)y, (int)0)] = 1;
        }
        for (x = 0; x < this.Width; ++x) {
            if (wrmd.getSample(x, 0, 0) > 0) {
                this.TouchBorder[wrmd.getSample((int)x, (int)0, (int)0)] = 1;
            }
            if (wrmd.getSample(0, this.Height - 1, 0) <= 0) continue;
            this.TouchBorder[wrmd.getSample((int)x, (int)(this.Height - 1), (int)0)] = 1;
        }
        ArrayIO.Write(this.Neighborhoods, Field2.getAbsolutePath() + "/Informations/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_R_Neighborhoods.txt", "\t");
        ArrayIO.Write(this.TouchBorder, Field2.getAbsolutePath() + "/Informations/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_R_TouchBorder.txt", "\t");
        wrmd = null;
    }

    private void ComputeOrientations(File Field2, String Lame, String Center2) throws IOException {
        Coordinate p10 = new Coordinate(1.0, 0.0);
        Coordinate p00 = new Coordinate(0.0, 0.0);
        for (int i2 = 1; i2 < this.VignettesDna.size(); ++i2) {
            this.pca.Compute(this.VignettesDna.get(i2), this.Centroids[i2]);
            this.Orientations[i2] = Geometry2D.AngleBAC(p10, p00, new Coordinate(this.pca.getEigenVectors()[0].get(0), this.pca.getEigenVectors()[0].get(1)), true);
            if (!(90.0 < this.Orientations[i2]) || !(this.Orientations[i2] < 270.0)) continue;
            this.Orientations[i2] = (this.Orientations[i2] + 180.0) % 360.0;
        }
        p00 = null;
        p10 = null;
        ArrayIO.Write(this.Orientations, Field2.getAbsolutePath() + "/Informations/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_D_Orientations.txt", "\t");
    }

    private void ComputeAngles(File Field2, String Lame, String Center2) throws IOException {
        Coordinate p10 = new Coordinate(1.0, 0.0);
        Coordinate p00 = new Coordinate(0.0, 0.0);
        for (int i2 = 1; i2 < this.VignettesDna.size(); ++i2) {
            for (int j = 1; j < this.VignettesDna.size(); ++j) {
                if (i2 != j && this.Neighborhoods[i2][j] == 1) {
                    double Theta = Geometry2D.AngleBAC(p10, p00, new Coordinate(this.Centroids[i2].X - this.Centroids[j].X, this.Centroids[i2].Y - this.Centroids[j].Y), true);
                    if (90.0 < Theta && Theta < 270.0) {
                        Theta = (Theta + 180.0) % 360.0;
                    }
                    this.Angles[i2][j] = Theta;
                    if (Theta > 90.0) {
                        Theta -= -360.0;
                    }
                    double Phi = this.Orientations[i2] < 90.0 ? this.Orientations[i2] : this.Orientations[i2] - 360.0;
                    this.AnglesOrientations[i2][j] = Math.abs(Theta - Phi);
                    continue;
                }
                this.AnglesOrientations[i2][j] = -1.0;
                this.Angles[i2][j] = -1.0;
            }
        }
        p00 = null;
        p10 = null;
        ArrayIO.Write(this.Angles, Field2.getAbsolutePath() + "/Informations/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_D_Angles.txt", "\t");
        ArrayIO.Write(this.AnglesOrientations, Field2.getAbsolutePath() + "/Informations/" + Lame + "_" + Center2.substring(7) + "_" + Field2.getName().substring(6) + "_D_AnglesOrientations.txt", "\t");
    }

    private void ComputeMinimumDistance(File Field2, String Lame, String Center2) {
        throw new IllegalStateException("To Upgrade");
    }

    private void Allocate(int nbNuclei) {
        this.Angles = null;
        this.AnglesOrientations = null;
        this.BoundingBoxes = null;
        this.Centroids = null;
        this.DistancesCells = null;
        this.DistancesNuclei = null;
        this.Neighborhoods = null;
        this.Orientations = null;
        this.TouchBorder = null;
        this.Angles = new double[nbNuclei + 1][nbNuclei + 1];
        this.AnglesOrientations = new double[nbNuclei + 1][nbNuclei + 1];
        this.BoundingBoxes = new Box[nbNuclei + 1];
        for (int i2 = 0; i2 < this.BoundingBoxes.length; ++i2) {
            this.BoundingBoxes[i2] = new Box();
        }
        this.Centroids = new Coordinate[nbNuclei + 1];
        this.DistancesCells = new double[nbNuclei + 1][nbNuclei + 1];
        this.DistancesNuclei = new double[nbNuclei + 1][nbNuclei + 1];
        this.Neighborhoods = new int[nbNuclei + 1][nbNuclei + 1];
        this.Orientations = new double[nbNuclei + 1];
        this.TouchBorder = new int[nbNuclei + 1];
        if (this.VignettesCentromeres == null) {
            this.VignettesCentromeres = new ArrayList<BufferedImage>(13);
        } else {
            this.VignettesCentromeres.clear();
        }
        if (this.VignettesCentrosomes == null) {
            this.VignettesCentrosomes = new ArrayList<BufferedImage>(13);
        } else {
            this.VignettesCentrosomes.clear();
        }
        if (this.VignettesDna == null) {
            this.VignettesDna = new ArrayList<BufferedImage>(13);
        } else {
            this.VignettesDna.clear();
        }
        if (this.VignettesMicrotubules == null) {
            this.VignettesMicrotubules = new ArrayList<BufferedImage>(13);
        } else {
            this.VignettesMicrotubules.clear();
        }
    }
}

