/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis;

import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import utils.times.Chronometer;

public class CutVignetteMicrotubulesEnhanced {
    private int nbErrors = -1;

    public void Extract(File RAMIS, Chronometer Chrono) throws IOException {
        if (!RAMIS.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] listLames = RAMIS.listFiles();
        int marker = 0;
        if (Chrono != null) {
            System.out.print("Extraction des caracteristiques : ");
            marker = Chrono.NewMarker();
        }
        this.nbErrors = 0;
        for (int l = 0; l < listLames.length; ++l) {
            if (!listLames[l].isDirectory() || !listLames[l].getName().contains("AIM_00")) continue;
            this.ExtractFromLame(listLames[l], null);
        }
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
        listLames = null;
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    public void ExtractFromLame(File Lame, Chronometer Chrono) throws IOException {
        if (!Lame.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        if (!Lame.getName().contains("AIM_00")) {
            throw new IllegalArgumentException("This file name doesn't contain 'AIM_00'");
        }
        File[] listCenters = Lame.listFiles();
        File[] listFields = null;
        FichierTabule boundingboxes = null;
        int marker = 0;
        String prefix = null;
        BufferedImage image = null;
        if (Chrono != null) {
            System.out.print("Extraction des caracteristiques d'une lame : ");
            marker = Chrono.NewMarker();
        }
        this.nbErrors = 0;
        for (int c = 0; c < listCenters.length; ++c) {
            if (!listCenters[c].isDirectory()) continue;
            listFields = listCenters[c].listFiles();
            for (int f = 0; f < listFields.length; ++f) {
                if (!listFields[f].isDirectory()) continue;
                try {
                    prefix = Lame.getName() + "_" + listCenters[c].getName().substring(7) + "_" + listFields[f].getName().substring(6) + "_";
                    boundingboxes = new FichierTabule(listFields[f].getAbsolutePath() + "/Informations/" + prefix + "BoundingBoxes.txt", false);
                    image = ImageIO.Read(listFields[f].getAbsolutePath() + "/Marker_r_enhanced/" + prefix + "r_00_BgCorrect_EnhancedMicrotub.png");
                    this.Cut(boundingboxes, image, listFields[f], prefix, "re");
                    image = null;
                    image = ImageIO.Read(listFields[f].getAbsolutePath() + "/Marker_r_enhanced/" + prefix + "r_00_BgCorrect_OrientationMicrotub.png");
                    this.Cut(boundingboxes, image, listFields[f], prefix, "ro");
                    image = null;
                    continue;
                }
                catch (Exception E) {
                    System.out.println("Exception " + this.nbErrors++ + ": " + E.getMessage());
                    continue;
                }
                catch (Error E) {
                    System.out.println("Error " + this.nbErrors++ + ": " + E.getMessage());
                }
            }
            listFields = null;
        }
        listCenters = null;
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    private void Cut(FichierTabule bb, BufferedImage image, File field, String prefix, String marker) throws IOException {
        File resdir = new File(field.getAbsolutePath() + "/Marker_" + marker + "_Vignettes");
        if (!resdir.exists()) {
            resdir.mkdir();
        }
        BufferedImage vignette = null;
        BufferedImage vigcell = null;
        WritableRaster wrvigcell = null;
        WritableRaster wrvignette = null;
        int height = bb.Height();
        for (int i2 = 0; i2 < height; ++i2) {
            try {
                vigcell = ImageIO.Read(field.getAbsolutePath() + "/Marker_r_Vignettes/" + prefix + "R_" + (i2 + 1 < 10 ? "0" : "") + (i2 + 1) + ".png");
                vignette = ImageNew.SubImage((BufferedImage)image, (int)bb.getValueInt(i2, 0), (int)bb.getValueInt(i2, 1), (int)bb.getValueInt(i2, 2), (int)bb.getValueInt(i2, 3));
                if (vignette.getWidth() != vigcell.getWidth() || vignette.getHeight() != vigcell.getHeight()) {
                    throw new Error("Dimension differents.");
                }
                wrvigcell = vigcell.getRaster();
                wrvignette = vignette.getRaster();
                for (int y = 0; y < vignette.getHeight(); ++y) {
                    for (int x = 0; x < vignette.getWidth(); ++x) {
                        if (wrvigcell.getSample(x, y, 0) != 0) continue;
                        wrvignette.setSample(x, y, 0, 0);
                    }
                }
                ImageIO.Write(vignette, resdir.getCanonicalPath() + "/" + prefix + marker.toUpperCase() + "_" + (i2 + 1 < 10 ? "0" : "") + (i2 + 1) + ".png", 6);
                vignette = null;
                continue;
            }
            catch (Exception E) {
                System.out.println("Exception " + this.nbErrors++ + ": " + E.getMessage());
                continue;
            }
            catch (Error E) {
                System.out.println("Error " + this.nbErrors++ + ": " + E.getMessage());
            }
        }
        image = null;
        resdir = null;
    }
}

