/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis;

import dataMining.classifiers.Classification;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class ClassifyAllCells {
    private List<Model> modelschar = new Vector<Model>(13);
    private List<Model> modelsphase = new Vector<Model>(13);
    private Classification classinst = new Classification();

    public void Compute(List<String> Listlames) throws Exception {
        int j;
        int x;
        int begining;
        int i2;
        boolean[] configuration;
        Iterator<Model> iterchars = this.modelschar.iterator();
        Iterator<Model> iterphases = this.modelsphase.iterator();
        String path = null;
        File file = null;
        File[] listfiles = null;
        Model model = null;
        double[][] proba = null;
        FichierTabule filetarget = this.CreateTargetFile(Listlames);
        Classifier classifier = null;
        int column = 0;
        while (iterchars.hasNext()) {
            model = iterchars.next();
            classifier = model.classifier;
            configuration = model.configuration;
            path = model.path;
            file = new File(path.substring(0, path.indexOf(model.prefix.substring(0, model.prefix.length() - 1)) + model.prefix.length()));
            listfiles = file.listFiles();
            System.out.println("Processing characteristic: " + model.name);
            for (i2 = 0; i2 < listfiles.length; ++i2) {
                int numlame = this.isInsideLames(listfiles[i2].getName(), Listlames);
                if (!listfiles[i2].isFile() || numlame < 0 || !this.isInsideModelsChar(listfiles[i2].getName()) || !listfiles[i2].getName().contains(model.corename)) continue;
                FichierTabule filechars = new FichierTabule(listfiles[i2].getAbsolutePath(), true);
                begining = this.FindBegining("AIM_00" + Listlames.get(numlame).substring(1), filetarget);
                if (begining < 0) {
                    throw new IllegalArgumentException("Begining not found!");
                }
                for (x = 0; x < configuration.length; ++x) {
                    filechars.setExcludedColumn(x, configuration[x]);
                }
                ++x;
                while (x < filechars.Width()) {
                    filechars.setExcludedColumn(x, true);
                    ++x;
                }
                FichierTabule filecells = FichierTabuleTools.DeleteExcludedColumns(filechars);
                filecells.setNominal(filecells.Width() - 1, true);
                try {
                    this.classinst.LearnAndPredict(filecells, filecells, classifier, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                proba = this.classinst.Probabilities();
                for (j = 0; j < proba.length; ++j) {
                    filetarget.setValue(begining + j, column, proba[j][0]);
                }
                filechars = null;
                filecells = null;
                proba = null;
            }
            ++column;
            classifier = null;
            file = null;
            listfiles = null;
            model = null;
            path = null;
        }
        System.out.println();
        while (iterphases.hasNext()) {
            model = iterphases.next();
            classifier = model.classifier;
            configuration = model.configuration;
            path = model.path;
            file = new File(path);
            listfiles = file.listFiles();
            System.out.println("Processing phase: " + model.name);
            for (x = 0; x < configuration.length; ++x) {
                filetarget.setExcludedColumn(x, configuration[x]);
            }
            while (x < filetarget.Width()) {
                filetarget.setExcludedColumn(x, true);
                ++x;
            }
            filetarget.setExcludedColumn("Lame", false);
            FichierTabule fileprobas = FichierTabuleTools.DeleteExcludedColumns(filetarget);
            fileprobas.setNominal(fileprobas.Width() - 1, true);
            try {
                this.classinst.LearnAndPredict(fileprobas, fileprobas, classifier, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
            proba = this.classinst.Probabilities();
            for (j = 0; j < proba.length; ++j) {
                filetarget.setValue(j, column, proba[j][0]);
            }
            ++column;
            classifier = null;
            configuration = null;
            file = null;
            fileprobas = null;
            listfiles = null;
            model = null;
            path = null;
        }
        begining = this.modelschar.size();
        int height = filetarget.Height();
        for (int y = 0; y < height; ++y) {
            i2 = -1;
            double best = 0.0;
            for (x = begining; x < begining + this.modelsphase.size(); ++x) {
                if (!(filetarget.getValueDouble(y, x) > best)) continue;
                best = filetarget.getValueDouble(y, x);
                i2 = x - begining;
            }
            if (best > 0.5) {
                filetarget.setValue(y, x, this.modelsphase.get((int)i2).name);
                continue;
            }
            filetarget.setValue(y, x, "Uncertain");
        }
        filetarget.Write("Result_ClassifyAllCells.txt", false);
    }

    public void AddModel(String path, Classifier classifier, String Name2) throws Exception {
        int i2;
        File folder = new File(path);
        File[] listfiles = folder.listFiles();
        FichierTabule occ = null;
        FichierTabule results = null;
        FichierTabule sysres = null;
        FichierTabule workingfile = null;
        Instances instances = null;
        String name = null;
        int line = -1;
        boolean[] configuration = null;
        for (i2 = 0; i2 < listfiles.length; ++i2) {
            if (!listfiles[i2].getName().contains("_OCC.txt")) continue;
            occ = new FichierTabule(listfiles[i2].getAbsolutePath(), true);
            i2 = listfiles.length;
        }
        if (occ == null) {
            throw new IllegalArgumentException("File *_OCC.txt not founded.");
        }
        for (i2 = 0; i2 < listfiles.length; ++i2) {
            if (!listfiles[i2].getName().contains("Results.txt")) continue;
            results = new FichierTabule(listfiles[i2].getAbsolutePath(), false);
            name = results.getValueString(0, 1);
            line = results.getValueInt(0, 2);
            i2 = listfiles.length;
        }
        if (results == null) {
            throw new IllegalArgumentException("File Results.txt not founded.");
        }
        for (i2 = 0; i2 < listfiles.length; ++i2) {
            if (!listfiles[i2].getName().contains(name)) continue;
            sysres = new FichierTabule(listfiles[i2].getAbsolutePath(), true);
            i2 = listfiles.length;
        }
        if (sysres == null) {
            throw new IllegalArgumentException("File containing best solution not founded.");
        }
        configuration = new boolean[sysres.Width() - 2];
        for (i2 = 0; i2 < configuration.length; ++i2) {
            configuration[i2] = sysres.getValueInt(line, i2) != 1;
            occ.setExcludedColumn(i2, configuration[i2]);
        }
        while (i2 < occ.Width()) {
            occ.setExcludedColumn(i2, true);
            ++i2;
        }
        occ.setExcludedColumn(occ.Width() - 3, false);
        workingfile = FichierTabuleTools.DeleteExcludedColumns(occ);
        workingfile.setNominal(workingfile.Width() - 1, true);
        instances = FichierTabuleConverter.FichierTabuleToWekaInstances(workingfile, "Learning Set");
        instances.setClassIndex(workingfile.Width() - 1);
        classifier.buildClassifier(instances);
        this.modelschar.add(new Model(classifier, configuration, Name2, this.Path(path), this.Prefix(name), name.substring(name.indexOf("_All_") + 4, name.length() - 7)));
        configuration = null;
        folder = null;
        listfiles = null;
        name = null;
        occ = null;
        results = null;
        sysres = null;
        workingfile = null;
        instances = null;
    }

    public void AddTarget(String path, Classifier classifier, String Name2) throws Exception {
        int i2;
        File folder = new File(path);
        File[] listfiles = folder.listFiles();
        FichierTabule occ = null;
        FichierTabule results = null;
        FichierTabule sysres = null;
        FichierTabule workingfile = null;
        Instances instances = null;
        String name = null;
        int line = -1;
        boolean[] configuration = null;
        for (i2 = 0; i2 < listfiles.length; ++i2) {
            if (!listfiles[i2].getName().contains("_OCC.txt")) continue;
            occ = new FichierTabule(listfiles[i2].getAbsolutePath(), true);
            i2 = listfiles.length;
        }
        if (occ == null) {
            throw new IllegalArgumentException("File *_OCC.txt not founded.");
        }
        for (i2 = 0; i2 < listfiles.length; ++i2) {
            if (!listfiles[i2].getName().contains("Results.txt")) continue;
            results = new FichierTabule(listfiles[i2].getAbsolutePath(), false);
            name = results.getValueString(0, 1);
            line = results.getValueInt(0, 2);
            i2 = listfiles.length;
        }
        if (results == null) {
            throw new IllegalArgumentException("File Results.txt not founded.");
        }
        for (i2 = 0; i2 < listfiles.length; ++i2) {
            if (!listfiles[i2].getName().contains(name)) continue;
            sysres = new FichierTabule(listfiles[i2].getAbsolutePath(), true);
            i2 = listfiles.length;
        }
        if (sysres == null) {
            throw new IllegalArgumentException("File containing best solution not founded.");
        }
        if (sysres.Width() - 2 != this.modelschar.size()) {
            throw new IllegalArgumentException("Number of characteristics different from model configuration.");
        }
        configuration = new boolean[sysres.Width() - 2];
        for (i2 = 0; i2 < configuration.length; ++i2) {
            configuration[i2] = sysres.getValueInt(line, i2) != 1;
            occ.setExcludedColumn(i2, configuration[i2]);
        }
        while (i2 < occ.Width()) {
            occ.setExcludedColumn(i2, true);
            ++i2;
        }
        occ.setExcludedColumn(occ.Width() - 3, false);
        workingfile = FichierTabuleTools.DeleteExcludedColumns(occ);
        workingfile.setNominal(workingfile.Width() - 1, true);
        instances = FichierTabuleConverter.FichierTabuleToWekaInstances(workingfile, "Learning Set");
        instances.setClassIndex(workingfile.Width() - 1);
        classifier.buildClassifier(instances);
        this.modelsphase.add(new Model(classifier, configuration, Name2, this.Path(name), "", ""));
        configuration = null;
        folder = null;
        listfiles = null;
        name = null;
        occ = null;
        results = null;
        sysres = null;
        workingfile = null;
        instances = null;
    }

    private int isInsideLames(String name, List<String> lames) {
        for (int i2 = 0; i2 < lames.size(); ++i2) {
            if (!name.contains(lames.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    private boolean isInsideModelsChar(String name) {
        for (int i2 = 0; i2 < this.modelschar.size(); ++i2) {
            if (!name.contains(this.modelschar.get((int)i2).corename)) continue;
            return true;
        }
        return false;
    }

    private String Prefix(String name) {
        return name.substring(0, name.indexOf(95) + 1);
    }

    private String Path(String path) {
        int i2;
        for (i2 = path.length() - 2; i2 >= 0 && path.charAt(i2) != '/'; --i2) {
        }
        return path.substring(0, i2 + 1);
    }

    private FichierTabule CreateTargetFile(List<String> Listlames) throws Exception {
        int i2;
        System.out.println("Creating result file... ");
        int count = this.modelschar.size() + this.modelsphase.size();
        int[] types = new int[count + 5];
        Arrays.fill(types, 1);
        types[count] = 2;
        types[count + 1] = 2;
        types[count + 2] = 2;
        types[count + 3] = 2;
        types[count + 4] = 0;
        File file = new File(this.modelschar.get((int)0).path);
        File[] listfiles = file.listFiles();
        FichierTabule filechars = null;
        Vector<FichierTabule> list = new Vector<FichierTabule>(13);
        FichierTabule target = null;
        count = 0;
        for (i2 = 0; i2 < listfiles.length; ++i2) {
            if (!listfiles[i2].isFile() || this.isInsideLames(listfiles[i2].getName(), Listlames) < 0 || !this.isInsideModelsChar(listfiles[i2].getName()) || !listfiles[i2].getName().contains(this.modelschar.get((int)0).corename)) continue;
            filechars = new FichierTabule(listfiles[i2].getAbsolutePath(), true);
            list.add(filechars);
            count += filechars.Height();
            filechars = null;
        }
        target = new FichierTabule(count, types, "Target");
        for (i2 = 0; i2 < this.modelschar.size(); ++i2) {
            target.setColumnName(i2, this.modelschar.get((int)i2).name);
        }
        count = i2;
        for (i2 = 0; i2 < this.modelsphase.size(); ++i2) {
            target.setColumnName(count + i2, this.modelsphase.get((int)i2).name);
        }
        target.setColumnName(count += i2, "Phase");
        target.setColumnName(count + 1, "Lame");
        target.setColumnName(count + 2, "Center");
        target.setColumnName(count + 3, "Field");
        target.setColumnName(count + 4, "Number");
        count = 0;
        for (i2 = 0; i2 < list.size(); ++i2) {
            int y;
            filechars = (FichierTabule)list.get(i2);
            for (y = 0; y < filechars.Height(); ++y) {
                target.setValue(count + y, target.Width() - 4, filechars.getValueString(y, filechars.Width() - 5));
                target.setValue(count + y, target.Width() - 3, filechars.getValueString(y, filechars.Width() - 4));
                target.setValue(count + y, target.Width() - 2, filechars.getValueString(y, filechars.Width() - 3));
                target.setValue(count + y, target.Width() - 1, filechars.getValueInt(y, filechars.Width() - 1));
            }
            count += y;
            filechars = null;
        }
        file = null;
        listfiles = null;
        System.out.println("successfully.");
        return target;
    }

    private int FindBegining(String lame, FichierTabule file) {
        int height = file.Height();
        int pos = file.Width() - 4;
        for (int y = 0; y < height; ++y) {
            if (!file.getValueString(y, pos).equalsIgnoreCase(lame)) continue;
            return y;
        }
        return -1;
    }

    public FichierTabule CorrelationAnnotationsResults(String annotations, String results) throws Exception {
        FichierTabule Annotations = new FichierTabule(annotations, true);
        FichierTabule Results = new FichierTabule(results, true);
        int height = Annotations.Height();
        int Height = Results.Height();
        int ColLameA = Annotations.ColumnNumber("Lame");
        int ColCenterA = Annotations.ColumnNumber("Center");
        int ColFieldA = Annotations.ColumnNumber("Field");
        int ColVig1 = Annotations.ColumnNumber("Vignette1");
        int ColVig2 = Annotations.ColumnNumber("Vignette2");
        int ColPhaseA = Annotations.ColumnNumber("Phase");
        int ColLameR = Results.ColumnNumber("Lame");
        int ColCenterR = Results.ColumnNumber("Center");
        int ColFieldR = Results.ColumnNumber("Field");
        int ColNumberR = Results.ColumnNumber("Number");
        int ColPhaseR = Results.ColumnNumber("Phase");
        FichierTabule result = new FichierTabule(Annotations.Height(), new int[]{2, 2, 2, 0, 0, 0}, "Result_Correlation_AnnotationsResults.txt");
        result.setColumnsNames(new String[]{"PhaseA", "PhaseR", "Lame", "Center", "Field", "Number"});
        for (int y = 0; y < height; ++y) {
            result.setValue(y, 0, Annotations.getValueString(y, ColPhaseA));
            result.setValue(y, 2, Annotations.getValueString(y, ColLameA));
            result.setValue(y, 3, Integer.valueOf(Annotations.getValueString(y, ColCenterA)));
            result.setValue(y, 4, Annotations.getValueInt(y, ColFieldA));
            for (int x = 0; x < Height; ++x) {
                if (!Results.getValueString(x, ColLameR).equalsIgnoreCase(Annotations.getValueString(y, ColLameA)) || Integer.valueOf(Results.getValueString(x, ColCenterR).substring(7)) != Integer.valueOf(Annotations.getValueString(y, ColCenterA)) || Integer.valueOf(Results.getValueString(x, ColFieldR).substring(6)).intValue() != Annotations.getValueInt(y, ColFieldA) || (Results.getValueInt(x, ColNumberR) != Annotations.getValueInt(y, ColVig1) || Annotations.getValueInt(y, ColVig2) != 0) && Results.getValueInt(x, ColNumberR) != Annotations.getValueInt(y, ColVig2)) continue;
                result.setValue(y, 5, Results.getValueInt(y, ColNumberR));
                result.setValue(y, 1, Results.getValueString(y, ColPhaseR));
                x = Height;
            }
        }
        return result;
    }

    private class Model {
        public Classifier classifier = null;
        public boolean[] configuration = null;
        public String name = null;
        public String corename = null;
        public String prefix = null;
        public String path = null;

        public Model(Classifier classifier, boolean[] configuration, String name, String path, String prefix, String corename) {
            this.classifier = classifier;
            this.configuration = (boolean[])configuration.clone();
            this.name = name.substring(0);
            this.path = path.substring(0);
            this.prefix = prefix.substring(0);
            this.corename = corename.substring(0);
        }
    }
}

