/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis;

import dataMining.classifiers.Classification;
import dataMining.imbalanceDataSet.DataSetBalancer;
import dataMining.imbalanceDataSet.OverSampling;
import dataMining.variables.selections.SystematicResearch;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import weka.classifiers.Classifier;

public class CellPhaseClassifier {
    private SystematicResearch sr = new SystematicResearch();
    private DataSetBalancer ids = new OverSampling();
    private List<bestresult> bestresults = new Vector<bestresult>(113);

    public void Classify(String FolderOut, List<String> list, String Target, List<String> Classes, List<String> ToReject, FichierTabule Ann, Classifier classifier, int Validation, int Nb, boolean OneClassClassifier, int nbCPU) throws Exception {
        int y;
        boolean found;
        int Vignette;
        int Field2;
        String Center2;
        String Lame;
        int x;
        String TargetClean = this.Clean(Target);
        String prefixe = TargetClean + "_" + list.size();
        FichierTabule models = this.CreateTargetFile(list, Target);
        FichierTabule bestresult2 = null;
        FichierTabule workfile = null;
        FichierTabule interfile = null;
        Calendar cal = Calendar.getInstance();
        int height = models.Height();
        int width = models.Width();
        File folderOut = new File(FolderOut + "/Results " + TargetClean + " " + list.size() + " " + this.ClassesName(Classes) + "/");
        folderOut.mkdir();
        File savechar = new File(folderOut.getAbsolutePath() + "/" + prefixe + "_ListChar.txt");
        savechar.createNewFile();
        DataOutputStream out = new DataOutputStream(new FileOutputStream(savechar.getAbsoluteFile()));
        int numcol = 0;
        for (String charac : list) {
            out.write((charac + "\n").getBytes("ASCII"));
            bestresult2 = new FichierTabule(charac + "/BestResults_00.txt", true);
            Arrays.fill(models.getColumnDouble(numcol), 0.0);
            int col = bestresult2.ColumnNumber("Lame");
            for (x = 0; x < height; ++x) {
                Lame = models.getValueString(x, width - 4);
                Center2 = models.getValueString(x, width - 3);
                Field2 = models.getValueInt(x, width - 2);
                Vignette = models.getValueInt(x, width - 1);
                found = false;
                for (y = 0; !found && y < bestresult2.Height(); ++y) {
                    if (!Lame.equalsIgnoreCase(bestresult2.getValueString(y, col)) || !Center2.equalsIgnoreCase(bestresult2.getValueString(y, col + 1)) || Field2 != bestresult2.getValueInt(y, col + 2) || Vignette != bestresult2.getValueInt(y, col + 3)) continue;
                    models.setValue(x, numcol, bestresult2.getValueDouble(y, col + 4));
                    found = true;
                }
                if (found) continue;
                models.setExcluded(x, true);
            }
            bestresult2 = null;
            charac = null;
            ++numcol;
        }
        if (models.getNbExcluded() > 0) {
            FichierTabule temps;
            System.out.println("CAUTION: " + models.getNbExcluded() + " row(s) excluded (not found).");
            models = temps = FichierTabuleTools.DeleteExcludedRows(models);
            height = models.Height();
        }
        int phase = Ann.ColumnNumber("Phase");
        for (y = 0; y < height; ++y) {
            Lame = models.getValueString(y, width - 4);
            Center2 = models.getValueString(y, width - 3);
            Field2 = models.getValueInt(y, width - 2);
            Vignette = models.getValueInt(y, width - 1);
            Ann.ClearSelection();
            Ann.SelectWhere("Vignette1", 0, Vignette);
            Ann.ExtendSelectionWhere("Vignette2", 0, Vignette);
            Ann.SelectFromSelectionWhere("Lame", 0, Lame);
            Ann.SelectFromSelectionWhere("Center", 0, Center2);
            Ann.SelectFromSelectionWhere("Field", 0, Field2);
            found = false;
            for (int i2 = 0; !found && i2 < Ann.Height(); ++i2) {
                if (!Ann.isSelected(i2)) continue;
                models.setValue(y, width - 5, Ann.getValueString(i2, phase));
                found = true;
            }
        }
        models.Write(folderOut.getAbsolutePath() + "/" + prefixe + ".txt", false);
        cal = Calendar.getInstance();
        System.out.println("\nStarting research - " + cal.get(5) + "/" + (cal.get(2) + 1) + " at " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13) + "\t");
        x = 0;
        models.ClearSelection();
        for (x = 0; x < list.size() + 5; ++x) {
            models.setSelectedColumn(x, true);
        }
        Iterator<String> iter = ToReject.iterator();
        while (iter.hasNext()) {
            models.ExtendSelectionWhere(Target, 0, iter.next());
        }
        models.InverseSelectionRows();
        models.InverseSelection();
        models.ExcludeSelected();
        interfile = FichierTabuleTools.DeleteExcluded(models);
        interfile.Write(folderOut.getAbsolutePath() + "/" + prefixe + "_Clean.txt", false);
        FichierTabule wft = null;
        FichierTabule wff = null;
        FichierTabule wfb = null;
        interfile.ClearExclusion();
        interfile.ClearSelection();
        iter = Classes.iterator();
        while (iter.hasNext()) {
            interfile.ExtendSelectionWhere(Target, 0, iter.next());
        }
        interfile.ExcludeSelected();
        wff = FichierTabuleTools.DeleteExcludedRows(interfile);
        interfile.ClearExclusion();
        interfile.InverseSelection();
        interfile.ExcludeSelected();
        wft = FichierTabuleTools.DeleteExcludedRows(interfile);
        wfb = this.ids.Balance(wft, true);
        interfile = null;
        interfile = FichierTabuleTools.Merge(wfb, wff);
        interfile.Write(folderOut.getAbsolutePath() + "/" + prefixe + "_Balanced.txt", false);
        if (OneClassClassifier) {
            this.RenameClasses(interfile, interfile.ColumnNumber(Target), Classes);
            interfile.Write(folderOut.getAbsolutePath() + "/" + prefixe + "_OCC.txt", false);
        }
        interfile.setExcludedColumn(interfile.ColumnNumber("Lame"), true);
        interfile.setExcludedColumn(interfile.ColumnNumber("Center"), true);
        interfile.setExcludedColumn(interfile.ColumnNumber("Field"), true);
        interfile.setExcludedColumn(interfile.ColumnNumber("Vignette"), true);
        workfile = FichierTabuleTools.DeleteExcludedColumns(interfile);
        workfile.setNominal(workfile.Width() - 1, true);
        workfile.Target(workfile.Width() - 1);
        this.sr = new SystematicResearch();
        this.sr.Start(classifier, null, workfile, folderOut.getAbsolutePath() + "/" + prefixe + "_SR.txt", Validation, Nb, nbCPU);
        this.FindBestResults(folderOut.getAbsolutePath(), "ValidationKf");
        this.sr = null;
        interfile = null;
        workfile = null;
        wft = null;
        wff = null;
        wfb = null;
        iter = null;
        System.out.println("\n\n");
    }

    private void FindBestResults(String Folder, String Column) {
        int y;
        int nbErrors = 0;
        int colVal = -1;
        int N = 200;
        double max = 0.0;
        File[] list = new File(Folder).listFiles();
        FichierTabule file = null;
        String Result = "Results.txt";
        this.bestresults.clear();
        for (int f = 0; f < list.length; ++f) {
            if (!list[f].getName().contains("_SR.txt")) continue;
            try {
                file = new FichierTabule(list[f].getAbsolutePath(), true);
                colVal = file.ColumnNumber(Column);
            }
            catch (Exception e) {
                System.err.println("Exception " + nbErrors++ + " - " + e.getMessage());
                continue;
            }
            int height = file.Height();
            for (y = 0; y < height; ++y) {
                if (this.bestresults.size() >= N && !(max < file.getValueDouble(y, colVal))) continue;
                max = this.Insert(list[f].getName(), y, file.getValueDouble(y, colVal), N);
            }
            file = null;
        }
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(Folder + "/" + Result));
            for (y = 0; y < N; ++y) {
                out.write(String.valueOf(this.bestresults.get((int)y).value + " " + this.bestresults.get((int)y).file + " " + this.bestresults.get((int)y).row + "\n").getBytes("ASCII"));
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ProbabilitiesBestResults(String BestResults, int N, boolean OneClassClassifier, Classifier classifier, int Validation, int Percentage, int Nb) throws Exception {
        File bestres = new File(BestResults);
        File[] list = bestres.getParentFile().listFiles();
        FichierTabule file = new FichierTabule(bestres.getAbsolutePath(), false);
        FichierTabule syre = null;
        FichierTabule data = null;
        FichierTabule justdata = null;
        FichierTabule result = null;
        FichierTabule resultfull = null;
        int height = file.Height();
        int ColFile = 1;
        int ColLine = 2;
        int[] chars = null;
        int[] datatype = null;
        Classification classification = new Classification();
        if (N > height) {
            throw new IllegalArgumentException("N greater than number of instances in file.");
        }
        for (int y = 0; y < N; ++y) {
            int x;
            int line = file.getValueInt(y, ColLine);
            String filesysres = file.getValueString(y, ColFile);
            String sysres = filesysres.substring(0, filesysres.length() - 7);
            syre = new FichierTabule(bestres.getParent() + "/" + filesysres, true);
            int width = syre.Width();
            for (x = 0; x < list.length; ++x) {
                if (!list[x].getName().contains(sysres) || list[x].getName().contains("_SR.txt")) continue;
                if (!OneClassClassifier && data != null) {
                    throw new Error("Data file already found.");
                }
                if (OneClassClassifier && (!OneClassClassifier || !list[x].getName().contains("_OCC"))) continue;
                data = new FichierTabule(list[x].getAbsolutePath(), true);
            }
            if (data == null) {
                throw new Error("Data file not found.");
            }
            int nbchar = 0;
            datatype = data.ColumnType();
            while (datatype[nbchar] == 1 || datatype[nbchar] == 0) {
                ++nbchar;
            }
            if (nbchar != width - 2) {
                throw new Error("nbchar != width-2");
            }
            chars = new int[nbchar];
            for (x = 0; x < nbchar; ++x) {
                chars[x] = syre.getValueInt(line, x);
            }
            nbchar = 0;
            for (x = 0; x < chars.length; ++x) {
                nbchar += chars[x];
            }
            width = data.Width();
            for (x = 0; x < chars.length; ++x) {
                data.setExcludedColumn(x, chars[x] == 0);
            }
            for (x = chars.length; x < width; ++x) {
                data.setExcludedColumn(x, true);
            }
            data.setExcludedColumn(width - 3, false);
            justdata = FichierTabuleTools.DeleteExcludedColumns(data);
            justdata.setNominal(justdata.Width() - 1, true);
            try {
                classification.LearnAndPredict(justdata, justdata, classifier, null);
                result = classification.ProbabilitiesPredictions();
                resultfull = FichierTabuleTools.MergeSideBySide(data, result);
                resultfull.Write(bestres.getParentFile().getAbsolutePath() + "/BestResults_" + (y < 10 ? "0" : "") + y + ".txt", false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            chars = null;
            data = null;
            justdata = null;
            result = null;
            resultfull = null;
            syre = null;
        }
    }

    private int[] BuildColumnsType(int nb) {
        int[] result = new int[nb + 5];
        Arrays.fill(result, 1);
        result[nb] = 2;
        result[nb + 1] = 2;
        result[nb + 2] = 2;
        result[nb + 3] = 0;
        result[nb + 4] = 0;
        return result;
    }

    private String[] BuildColumnsNames(int nb, String target) {
        String[] result = new String[nb + 5];
        for (int i2 = 0; i2 < nb; ++i2) {
            result[i2] = "Char_" + i2;
        }
        result[nb] = target;
        result[nb + 1] = "Lame";
        result[nb + 2] = "Center";
        result[nb + 3] = "Field";
        result[nb + 4] = "Vignette";
        return result;
    }

    private double Insert(String file, int row, double value, int N) {
        int i2 = 0;
        int size = this.bestresults.size();
        if (size == N) {
            this.bestresults.remove(--size);
        }
        while (i2 < size && value < this.bestresults.get((int)i2).value) {
            ++i2;
        }
        this.bestresults.add(i2, new bestresult(file, row, value));
        return this.bestresults.get((int)(this.bestresults.size() - 1)).value;
    }

    private String ClassesName(List<String> classes) {
        Iterator<String> iter = classes.iterator();
        StringBuilder sb = new StringBuilder(classes.size());
        while (iter.hasNext()) {
            sb.append(iter.next());
        }
        iter = null;
        return sb.toString();
    }

    private void RenameClasses(FichierTabule file, int target, List<String> classes) {
        int height = file.Height();
        switch (classes.size()) {
            case 1: {
                for (int y = 0; y < height; ++y) {
                    if (this.isInside(file.getValueString(y, target), classes)) continue;
                    file.setValue(y, target, "Others");
                }
                break;
            }
            default: {
                for (int y = 0; y < height; ++y) {
                    if (this.isInside(file.getValueString(y, target), classes)) {
                        file.setValue(y, target, "Interest");
                        continue;
                    }
                    file.setValue(y, target, "Others");
                }
            }
        }
    }

    private boolean isInside(String name, List<String> classes) {
        for (int i2 = 0; i2 < classes.size(); ++i2) {
            if (!classes.get(i2).equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private String Clean(String s) {
        return s.replace(":", "").replace(" ", "");
    }

    private FichierTabule CreateTargetFile(List<String> list, String Target) throws Exception {
        int y;
        FichierTabule sample = new FichierTabule(list.get(0) + "/BestResults_00.txt", true);
        int height = sample.Height();
        int collame = sample.ColumnNumber("Lame");
        int colcenter = sample.ColumnNumber("Center");
        int colfield = sample.ColumnNumber("Field");
        int colvig = sample.ColumnNumber("Vignette");
        String lame = "";
        String center = "";
        int vig = -1;
        int field = -1;
        int col = list.size();
        for (y = 0; y < height; ++y) {
            if (sample.getValueString(y, collame).equalsIgnoreCase(lame) && sample.getValueString(y, colcenter).equalsIgnoreCase(center) && sample.getValueInt(y, colfield) == field && sample.getValueInt(y, colvig) == vig) continue;
            sample.setSelected(y, true);
            lame = sample.getValueString(y, collame);
            center = sample.getValueString(y, colcenter);
            field = sample.getValueInt(y, colfield);
            vig = sample.getValueInt(y, colvig);
        }
        FichierTabule result = new FichierTabule(sample.getNbSelected(), this.BuildColumnsType(list.size()), "CellPhaseClassifier.txt");
        result.setColumnsNames(this.BuildColumnsNames(list.size(), Target));
        lame = "";
        center = "";
        vig = -1;
        field = -1;
        int nb = 0;
        for (y = 0; y < height; ++y) {
            if (sample.getValueString(y, collame).equalsIgnoreCase(lame) && sample.getValueString(y, colcenter).equalsIgnoreCase(center) && sample.getValueInt(y, colfield) == field && sample.getValueInt(y, colvig) == vig) continue;
            result.setValue(nb, col + 1, sample.getValueString(y, collame));
            result.setValue(nb, col + 2, sample.getValueString(y, colcenter));
            result.setValue(nb, col + 3, sample.getValueInt(y, colfield));
            result.setValue(nb, col + 4, sample.getValueInt(y, colvig));
            ++nb;
            lame = sample.getValueString(y, collame);
            center = sample.getValueString(y, colcenter);
            field = sample.getValueInt(y, colfield);
            vig = sample.getValueInt(y, colvig);
        }
        return result;
    }

    protected class bestresult {
        public String file = null;
        public int row = -1;
        public double value;

        public bestresult(String file, int row, double value) {
            this.file = file.substring(0);
            this.row = row;
            this.value = value;
        }
    }
}

