/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis;

import dataMining.classifiers.Classification;
import dataMining.imbalanceDataSet.DataSetBalancer;
import dataMining.imbalanceDataSet.OverSampling;
import dataMining.variables.selections.SystematicResearch;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import softwares.cmm.ramis.queries.MergeQueriesAndCharacteristics;
import weka.classifiers.Classifier;

public class AutomaticModelRamis {
    private MergeQueriesAndCharacteristics mqc = new MergeQueriesAndCharacteristics();
    private SystematicResearch sr = new SystematicResearch();
    private DataSetBalancer ids = new OverSampling();
    private List<bestresult> bestresults = new Vector<bestresult>(113);

    public void Classify(String Folder, List<String> Listlames, FichierTabule Ann, String Target, List<String> Classes, List<String> ToReject, Classifier classifier, int Validation, int Nb, boolean Balance, boolean OneClassClassifier, int nbCPU) throws Exception {
        int nbresearches = 0;
        String TargetClean = this.Clean(Target);
        File folder = new File(Folder);
        File[] liste = folder.listFiles();
        boolean[] done = new boolean[liste.length];
        Arrays.fill(done, false);
        FichierTabule[] f = new FichierTabule[Listlames.size()];
        FichierTabule result_mqc = null;
        Vector<FichierTabule> listfiles = new Vector<FichierTabule>(13);
        FichierTabule workingfile = null;
        FichierTabule workfile = null;
        Iterator<String> iter = null;
        Calendar cal = Calendar.getInstance();
        File folderOut = new File(Folder + "/Classification results " + TargetClean + " " + this.ClassesName(Classes) + "/");
        folderOut.mkdir();
        for (int y = 0; y < liste.length; ++y) {
            int i2;
            int x;
            if (done[y] || !liste[y].isFile() || !liste[y].getName().contains(".txt")) continue;
            for (x = 0; x < Listlames.size(); ++x) {
                f[x] = null;
            }
            int nb = 0;
            String name = liste[y].getName();
            int pos = -1;
            x = 0;
            while (pos < 0 && x < Listlames.size()) {
                pos = name.lastIndexOf(Listlames.get(x++));
            }
            if (pos < 0) {
                System.out.println("Fichier non conforme : '" + name + "'");
                continue;
            }
            String prefixe = name.substring(0, pos);
            String suffixe = name.substring(pos + 4, name.length());
            cal = Calendar.getInstance();
            System.out.println("\n" + ++nbresearches + " - " + cal.get(5) + "/" + (cal.get(2) + 1) + " at " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13) + "\t");
            f[nb++] = new FichierTabule(liste[y].getAbsolutePath(), true);
            done[y] = true;
            for (x = y + 1; x < liste.length; ++x) {
                for (i2 = 0; i2 < Listlames.size(); ++i2) {
                    if (!liste[x].getName().equalsIgnoreCase(prefixe + Listlames.get(i2) + "_" + suffixe)) continue;
                    f[nb++] = new FichierTabule(liste[x].getAbsolutePath(), true);
                    done[x] = true;
                }
            }
            if (nb != Listlames.size()) {
                throw new Error("file(s) not founded.");
            }
            for (i2 = 0; i2 < f.length; ++i2) {
                listfiles.add(f[i2]);
            }
            result_mqc = this.mqc.Merge(listfiles, Ann);
            x = 0;
            result_mqc.ClearSelection();
            while (!result_mqc.getColumnName(x).equalsIgnoreCase("id")) {
                result_mqc.setSelectedColumn(x++, true);
            }
            result_mqc.setSelectedColumn(result_mqc.ColumnNumber(Target), true);
            result_mqc.setSelectedColumn(result_mqc.ColumnNumber("Lame"), true);
            result_mqc.setSelectedColumn(result_mqc.ColumnNumber("Center"), true);
            result_mqc.setSelectedColumn(result_mqc.ColumnNumber("Field"), true);
            result_mqc.setSelectedColumn(result_mqc.ColumnNumber("Vignette"), true);
            iter = ToReject.iterator();
            while (iter.hasNext()) {
                result_mqc.ExtendSelectionWhere(Target, 0, iter.next());
            }
            result_mqc.InverseSelectionRows();
            result_mqc.InverseSelection();
            result_mqc.ExcludeSelected();
            workingfile = FichierTabuleTools.DeleteExcluded(result_mqc);
            workingfile.Write(folderOut.getAbsolutePath() + "/" + prefixe + "_All_" + suffixe.substring(0, suffixe.length() - 4) + "_" + TargetClean + ".txt", false);
            if (Balance) {
                FichierTabule wft = null;
                FichierTabule wff = null;
                FichierTabule wfb = null;
                workingfile.ClearExclusion();
                workingfile.ClearSelection();
                iter = Classes.iterator();
                while (iter.hasNext()) {
                    workingfile.ExtendSelectionWhere(Target, 0, iter.next());
                }
                workingfile.ExcludeSelected();
                wff = FichierTabuleTools.DeleteExcludedRows(workingfile);
                workingfile.ClearExclusion();
                workingfile.InverseSelection();
                workingfile.ExcludeSelected();
                wft = FichierTabuleTools.DeleteExcludedRows(workingfile);
                wfb = this.ids.Balance(wft, true);
                workingfile = null;
                workingfile = FichierTabuleTools.Merge(wfb, wff);
                workingfile.Write(folderOut.getAbsolutePath() + "/" + prefixe + "_All_" + suffixe.substring(0, suffixe.length() - 4) + "_" + TargetClean + "_Balanced.txt", false);
                wft = null;
                wff = null;
                wfb = null;
                iter = null;
            }
            if (OneClassClassifier) {
                this.RenameClasses(workingfile, workingfile.ColumnNumber(Target), Classes);
                workingfile.Write(folderOut.getAbsolutePath() + "/" + prefixe + "_All_" + suffixe.substring(0, suffixe.length() - 4) + "_" + TargetClean + "_OCC.txt", false);
            }
            workingfile.ClearExclusion();
            workingfile.ClearSelection();
            workingfile.setExcludedColumn(workingfile.ColumnNumber("Lame"), true);
            workingfile.setExcludedColumn(workingfile.ColumnNumber("Center"), true);
            workingfile.setExcludedColumn(workingfile.ColumnNumber("Field"), true);
            workingfile.setExcludedColumn(workingfile.ColumnNumber("Vignette"), true);
            workfile = FichierTabuleTools.DeleteExcludedColumns(workingfile);
            workfile.setNominal(workfile.Width() - 1, true);
            workfile.Target(workfile.Width() - 1);
            this.sr = new SystematicResearch();
            this.sr.Start(classifier, null, workfile, folderOut.getAbsolutePath() + "/" + prefixe + "_All_" + suffixe.substring(0, suffixe.length() - 4) + "_SR.txt", Validation, Nb, nbCPU);
            this.sr = null;
            result_mqc = null;
            workfile = null;
            workingfile = null;
            listfiles.clear();
            name = null;
            prefixe = null;
            suffixe = null;
            System.out.println("\n\n");
        }
    }

    private String Clean(String s) {
        return s.replace(":", "").replace(" ", "");
    }

    public void FindBestResults(String Folder, int N, String Column, String Result) {
        int y;
        int nbErrors = 0;
        int colVal = -1;
        double max = 0.0;
        File[] list = new File(Folder).listFiles();
        FichierTabule file = null;
        this.bestresults.clear();
        for (int f = 0; f < list.length; ++f) {
            if (!list[f].getName().contains("_SR.txt")) continue;
            try {
                file = new FichierTabule(list[f].getAbsolutePath(), true);
                colVal = file.ColumnNumber(Column);
            }
            catch (Exception e) {
                System.err.println("Exception " + nbErrors++ + " - " + e.getMessage());
                continue;
            }
            int height = file.Height();
            for (y = 0; y < height; ++y) {
                if (this.bestresults.size() >= N && !(max < file.getValueDouble(y, colVal))) continue;
                max = this.Insert(list[f].getName(), y, file.getValueDouble(y, colVal), N);
            }
            file = null;
        }
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(Folder + "/" + Result));
            for (y = 0; y < N; ++y) {
                out.write(String.valueOf(this.bestresults.get((int)y).value + " " + this.bestresults.get((int)y).file + " " + this.bestresults.get((int)y).row + "\n").getBytes("ASCII"));
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ProbabilitiesBestResults(String BestResults, int N, boolean OneClassClassifier, Classifier classifier, int Validation) throws Exception {
        File bestres = new File(BestResults);
        File[] list = bestres.getParentFile().listFiles();
        FichierTabule file = new FichierTabule(bestres.getAbsolutePath(), false);
        FichierTabule syre = null;
        FichierTabule data = null;
        FichierTabule justdata = null;
        FichierTabule result = null;
        FichierTabule resultfull = null;
        int height = file.Height();
        int ColFile = 1;
        int ColLine = 2;
        int[] chars = null;
        int[] datatype = null;
        Classification classification = new Classification();
        if (N > height) {
            throw new IllegalArgumentException("N greater than number of instances in file.");
        }
        for (int y = 0; y < N; ++y) {
            int x;
            int line = file.getValueInt(y, ColLine);
            String filesysres = file.getValueString(y, ColFile);
            String sysres = filesysres.substring(0, filesysres.length() - 7);
            syre = new FichierTabule(bestres.getParent() + "/" + filesysres, true);
            int width = syre.Width();
            for (x = 0; x < list.length; ++x) {
                if (!list[x].getName().contains(sysres) || list[x].getName().contains("_SR.txt")) continue;
                if (!OneClassClassifier && data != null) {
                    throw new Error("Data file already found.");
                }
                if (OneClassClassifier && (!OneClassClassifier || !list[x].getName().contains("_OCC"))) continue;
                data = new FichierTabule(list[x].getAbsolutePath(), true);
            }
            if (data == null) {
                throw new Error("Data file not found.");
            }
            int nbchar = 0;
            datatype = data.ColumnType();
            while (datatype[nbchar] == 1 || datatype[nbchar] == 0) {
                ++nbchar;
            }
            if (nbchar != width - 2) {
                throw new Error("nbchar != width-2");
            }
            chars = new int[nbchar];
            for (x = 0; x < nbchar; ++x) {
                chars[x] = syre.getValueInt(line, x);
            }
            nbchar = 0;
            for (x = 0; x < chars.length; ++x) {
                nbchar += chars[x];
            }
            width = data.Width();
            for (x = 0; x < chars.length; ++x) {
                data.setExcludedColumn(x, chars[x] == 0);
            }
            for (x = chars.length; x < width; ++x) {
                data.setExcludedColumn(x, true);
            }
            data.setExcludedColumn(width - 2, false);
            justdata = FichierTabuleTools.DeleteExcludedColumns(data);
            justdata.setNominal(justdata.Width() - 1, true);
            try {
                classification.LearnAndPredict(justdata, justdata, classifier, null);
                result = classification.ProbabilitiesPredictions();
                resultfull = FichierTabuleTools.MergeSideBySide(data, result);
                resultfull.PermuteColumns(resultfull.ColumnNumber("Field"), resultfull.ColumnNumber("Field") + 1);
                resultfull.PermuteColumns(resultfull.ColumnNumber("Center"), resultfull.ColumnNumber("Center") + 1);
                resultfull.PermuteColumns(resultfull.ColumnNumber("Lame"), resultfull.ColumnNumber("Lame") + 1);
                resultfull.Write(bestres.getParentFile().getAbsolutePath() + "/BestResults_" + (y < 10 ? "0" : "") + y + ".txt", false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            chars = null;
            data = null;
            justdata = null;
            result = null;
            resultfull = null;
            syre = null;
        }
    }

    private double Insert(String file, int row, double value, int N) {
        int i2 = 0;
        int size = this.bestresults.size();
        if (size == N) {
            this.bestresults.remove(--size);
        }
        while (i2 < size && value < this.bestresults.get((int)i2).value) {
            ++i2;
        }
        this.bestresults.add(i2, new bestresult(file, row, value));
        return this.bestresults.get((int)(this.bestresults.size() - 1)).value;
    }

    private String ClassesName(List<String> classes) {
        Iterator<String> iter = classes.iterator();
        StringBuilder sb = new StringBuilder(classes.size());
        while (iter.hasNext()) {
            sb.append(iter.next());
        }
        iter = null;
        return sb.toString();
    }

    private void RenameClasses(FichierTabule file, int target, List<String> classes) {
        int height = file.Height();
        switch (classes.size()) {
            case 1: {
                for (int y = 0; y < height; ++y) {
                    if (this.isInside(file.getValueString(y, target), classes)) continue;
                    file.setValue(y, target, "Others");
                }
                break;
            }
            default: {
                for (int y = 0; y < height; ++y) {
                    if (this.isInside(file.getValueString(y, target), classes)) {
                        file.setValue(y, target, "Interest");
                        continue;
                    }
                    file.setValue(y, target, "Others");
                }
            }
        }
    }

    private boolean isInside(String name, List<String> classes) {
        for (int i2 = 0; i2 < classes.size(); ++i2) {
            if (!classes.get(i2).equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    protected class bestresult {
        public String file = null;
        public int row = -1;
        public double value;

        public bestresult(String file, int row, double value) {
            this.file = file.substring(0);
            this.row = row;
            this.value = value;
        }
    }
}

