/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.michelin;

import characterization.ComputableFeatures;
import characterization.PreComputable;
import characterization.textures.statisticalmatrices.rlm.RLMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.olzm.GlolzmFeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.olzm.MGlolzm;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiSZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import dataMining.InstancesTools;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import measures.hedgehop.DistanceTools;
import morphee.granulometry.AntiGranulometryMultiSE;
import morphee.granulometry.GranulometryMultiSE;
import morphee.granulometry.PatternSpectrumMultiSE;
import morphee.granulometry.PatternSpectrumMultiSE2;
import processing.reducer.LinearGLR;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class TextureClassifier {
    private final List<TextureClassifiers> textclas = new ArrayList<TextureClassifiers>(13);
    private BufferedImage result = null;
    private BufferedImage[] confidencemap = null;
    private List<ConfidenceMap> listcm = new ArrayList<ConfidenceMap>(13);

    public void Classify(BufferedImage image, String name, int windowsize, boolean useweights, int nbCPU) throws FileNotFoundException {
        int t;
        int x;
        int height = image.getHeight();
        int width = image.getWidth();
        int size = this.textclas.size();
        int dim = windowsize / 2;
        double[] probas = new double[size];
        this.result = null;
        this.result = new BufferedImage(width, height, 1);
        this.confidencemap = null;
        this.confidencemap = new BufferedImage[size];
        Calendar cal = null;
        for (x = 0; x < size; ++x) {
            this.confidencemap[x] = new BufferedImage(width, height, 10);
        }
        int step = 1;
        for (int y = 0; y < height; y += step) {
            for (x = 0; x < width; x += step) {
                int m;
                int sx = 0 <= x - dim ? x - dim : 0;
                int sy = 0 <= y - dim ? y - dim : 0;
                int ex = x + dim < width ? x + dim : width - 1;
                int ey = y + dim < height ? y + dim : height - 1;
                BufferedImage vignette = ImageNew.SubImageWH((BufferedImage)image, (int)sx, (int)sy, (int)(ex - sx - 1), (int)(ey - sy - 1));
                Arrays.fill(probas, 0.0);
                for (t = 0; t < size; ++t) {
                    double weights = 0.0;
                    for (m = 0; m < this.textclas.get((int)t).classifiers.length; ++m) {
                        int n;
                        int nb;
                        ComputableFeatures cf = (ComputableFeatures)this.textclas.get((int)t).classifiers[m].object;
                        cf.Compute(vignette, null, cf.ForbiddenValue(), nbCPU);
                        double[] feat = ((ComputableFeatures)this.textclas.get((int)t).classifiers[m].object).Features();
                        boolean[] config = this.textclas.get((int)t).classifiers[m].configuration;
                        if (this.textclas.get((int)t).classifiers[m].name.contains("PSMSE")) {
                            nb = 0;
                            for (n = 0; n < (feat.length - 3) / 2; ++n) {
                                if (config[n]) continue;
                                this.textclas.get((int)t).classifiers[m].instances.instance(0).setValue(nb++, feat[n]);
                            }
                            if (!config[n]) {
                                this.textclas.get((int)t).classifiers[m].instances.instance(0).setValue(nb++, feat[feat.length - 3]);
                            }
                            if (!config[n + 1]) {
                                this.textclas.get((int)t).classifiers[m].instances.instance(0).setValue(nb++, feat[feat.length - 2]);
                            }
                            if (!config[n + 2]) {
                                this.textclas.get((int)t).classifiers[m].instances.instance(0).setValue(nb++, feat[feat.length - 1]);
                            }
                        } else {
                            nb = 0;
                            for (n = 0; n < feat.length; ++n) {
                                if (config[n]) continue;
                                this.textclas.get((int)t).classifiers[m].instances.instance(0).setValue(nb++, feat[n]);
                            }
                        }
                        if (nb != this.textclas.get((int)t).classifiers[m].nbattributs) {
                            throw new Error("Souci recopie => " + this.textclas.get((int)t).classifiers[m].name + " " + nb + " " + this.textclas.get((int)t).classifiers[m].nbattributs);
                        }
                        try {
                            double weight = useweights ? this.textclas.get((int)t).classifiers[m].weight : 1.0;
                            weights += weight;
                            int n2 = t;
                            probas[n2] = probas[n2] + this.textclas.get((int)t).classifiers[m].classifier.distributionForInstance(this.textclas.get((int)t).classifiers[m].instances.instance(0))[0] * weight;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.exit(0);
                        }
                        cf = null;
                    }
                    int n = t;
                    probas[n] = probas[n] / weights;
                    this.confidencemap[t].getRaster().setSample(x, y, 0, (int)(probas[t] * 255.0));
                }
                m = 0;
                for (t = 1; t < size; ++t) {
                    if (!(probas[m] < probas[t])) continue;
                    m = t;
                }
                this.result.getRaster().setSample(x, y, 0, (int)((double)this.textclas.get((int)m).color[0] * 255.0 * probas[m]));
                this.result.getRaster().setSample(x, y, 1, (int)((double)this.textclas.get((int)m).color[1] * 255.0 * probas[m]));
                this.result.getRaster().setSample(x, y, 2, (int)((double)this.textclas.get((int)m).color[2] * 255.0 * probas[m]));
                vignette = null;
            }
            if (y % 10 != 0) continue;
            try {
                for (t = 0; t < size; ++t) {
                    ImageIO.Write(this.confidencemap[t], "ConfidenceMap_" + t + "_" + this.textclas.get((int)t).name + "_" + name + ".png", 6);
                }
                ImageIO.Write(this.result, "ResultTextureClassifier_" + name + ".png", 6);
                cal = Calendar.getInstance();
                System.out.println("y = " + y + " - " + cal.get(5) + "/" + (cal.get(2) + 1) + " at " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13) + "\n\n");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            for (t = 0; t < size; ++t) {
                ImageIO.Write(this.confidencemap[t], "ConfidenceMap_" + t + "_" + this.textclas.get((int)t).name + "_" + name + ".png", 6);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ClassifyFast(BufferedImage image, String name, int windowsize, boolean useweights, int nbCPU) throws FileNotFoundException {
        int m;
        int t;
        int x;
        int height = image.getHeight();
        int width = image.getWidth();
        int size = this.textclas.size();
        int dim = windowsize / 2;
        double[] probas = new double[size];
        this.result = null;
        this.result = new BufferedImage(width, height, 1);
        this.confidencemap = null;
        this.confidencemap = new BufferedImage[size];
        Calendar cal = null;
        for (x = 0; x < size; ++x) {
            this.confidencemap[x] = new BufferedImage(width, height, 10);
        }
        for (t = 0; t < size; ++t) {
            for (m = 0; m < this.textclas.get((int)t).classifiers.length; ++m) {
                ((PreComputable)this.textclas.get((int)t).classifiers[m].object).PreCompute(image, nbCPU);
            }
        }
        int step = 1;
        for (int y = 0; y < height; y += step) {
            for (x = 0; x < width; x += step) {
                int sx = 0 <= x - dim ? x - dim : 0;
                int sy = 0 <= y - dim ? y - dim : 0;
                int ex = x + dim < width ? x + dim : width - 1;
                int ey = y + dim < height ? y + dim : height - 1;
                Arrays.fill(probas, 0.0);
                for (t = 0; t < size; ++t) {
                    double weights = 0.0;
                    for (m = 0; m < this.textclas.get((int)t).classifiers.length; ++m) {
                        int n;
                        int nb;
                        ((PreComputable)this.textclas.get((int)t).classifiers[m].object).FastCompute(sx, sy, ex, ey);
                        double[] feat = ((ComputableFeatures)this.textclas.get((int)t).classifiers[m].object).Features();
                        boolean[] config = this.textclas.get((int)t).classifiers[m].configuration;
                        if (this.textclas.get((int)t).classifiers[m].name.contains("PSMSE")) {
                            nb = 0;
                            for (n = 0; n < (feat.length - 3) / 2; ++n) {
                                if (config[n]) continue;
                                this.textclas.get((int)t).classifiers[m].instances.instance(0).setValue(nb++, feat[n]);
                            }
                            if (!config[n]) {
                                this.textclas.get((int)t).classifiers[m].instances.instance(0).setValue(nb++, feat[feat.length - 3]);
                            }
                            if (!config[n + 1]) {
                                this.textclas.get((int)t).classifiers[m].instances.instance(0).setValue(nb++, feat[feat.length - 2]);
                            }
                            if (!config[n + 2]) {
                                this.textclas.get((int)t).classifiers[m].instances.instance(0).setValue(nb++, feat[feat.length - 1]);
                            }
                        } else {
                            nb = 0;
                            for (n = 0; n < feat.length; ++n) {
                                if (config[n]) continue;
                                this.textclas.get((int)t).classifiers[m].instances.instance(0).setValue(nb++, feat[n]);
                            }
                        }
                        if (nb != this.textclas.get((int)t).classifiers[m].nbattributs) {
                            throw new Error("Souci recopie => " + this.textclas.get((int)t).classifiers[m].name + " " + nb + " " + this.textclas.get((int)t).classifiers[m].nbattributs);
                        }
                        try {
                            double weight = useweights ? this.textclas.get((int)t).classifiers[m].weight : 1.0;
                            weights += weight;
                            int n2 = t;
                            probas[n2] = probas[n2] + this.textclas.get((int)t).classifiers[m].classifier.distributionForInstance(this.textclas.get((int)t).classifiers[m].instances.instance(0))[0] * weight;
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.exit(0);
                        }
                    }
                    int n = t;
                    probas[n] = probas[n] / weights;
                    this.confidencemap[t].getRaster().setSample(x, y, 0, (int)(probas[t] * 255.0));
                }
                m = 0;
                for (t = 1; t < size; ++t) {
                    if (!(probas[m] < probas[t])) continue;
                    m = t;
                }
                this.result.getRaster().setSample(x, y, 0, (int)((double)this.textclas.get((int)m).color[0] * 255.0 * probas[m]));
                this.result.getRaster().setSample(x, y, 1, (int)((double)this.textclas.get((int)m).color[1] * 255.0 * probas[m]));
                this.result.getRaster().setSample(x, y, 2, (int)((double)this.textclas.get((int)m).color[2] * 255.0 * probas[m]));
            }
            if (y % 50 != 0) continue;
            try {
                for (t = 0; t < size; ++t) {
                    ImageIO.Write(this.confidencemap[t], "ConfidenceMap_" + t + "_" + this.textclas.get((int)t).name + "_" + name + "_Fast.png", 6);
                }
                ImageIO.Write(this.result, "ResultTextureClassifier_" + name + "_Fast.png", 6);
                cal = Calendar.getInstance();
                System.out.println("y = " + y + " - " + cal.get(5) + "/" + (cal.get(2) + 1) + " at " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13) + "\n\n");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            for (t = 0; t < size; ++t) {
                ImageIO.Write(this.confidencemap[t], "ConfidenceMap_" + t + "_" + this.textclas.get((int)t).name + "_" + name + "_Fast.png", 6);
            }
            ImageIO.Write(this.result, "ResultTextureClassifier_" + name + "_Fast.png", 6);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ClassifyPatchs(File src, int nbCPU) throws IOException {
        int t;
        int y;
        if (this.textclas.get((int)0).classifiers.length != 1) {
            throw new Error("Only one model required.");
        }
        int size = this.textclas.size();
        File[] patches = src.listFiles();
        double[] probas = new double[size];
        int row = 0;
        for (y = 0; y < patches.length; ++y) {
            if (!patches[y].isFile() || !patches[y].getName().contains(".png")) continue;
            ++row;
        }
        int[] types = new int[size + 3];
        Arrays.fill(types, 1);
        types[0] = 2;
        types[1] = 2;
        types[size + 2] = 2;
        FichierTabule res = new FichierTabule(row, types, "ResultTextureClassifierPatches.txt");
        for (t = 0; t < size; ++t) {
            res.setColumnName(t + 2, "Proba_" + this.textclas.get((int)t).name);
        }
        res.setColumnName(0, "Image");
        res.setColumnName(1, "Class");
        res.setColumnName(size + 2, "Prediction");
        row = 0;
        for (y = 0; y < patches.length; ++y) {
            int m;
            if (!patches[y].isFile() || !patches[y].getName().contains(".png")) continue;
            String name = patches[y].getName();
            res.setValue(row, 0, name);
            res.setValue(row, 1, name.substring(0, name.indexOf(95, name.indexOf(95) + 1)));
            Arrays.fill(probas, 0.0);
            BufferedImage vignette = ImageIO.Read(patches[y].getAbsolutePath());
            if (!ImageTools.isGrayLevel((BufferedImage)vignette)) {
                vignette = ImageConverter.RGB_To_GrayLevel((BufferedImage)vignette, (int)1);
            }
            for (t = 0; t < size; ++t) {
                for (m = 0; m < this.textclas.get((int)t).classifiers.length; ++m) {
                    ComputableFeatures cf = (ComputableFeatures)this.textclas.get((int)t).classifiers[m].object;
                    cf.Compute(vignette, null, cf.ForbiddenValue(), nbCPU);
                    double[] feat = ((ComputableFeatures)this.textclas.get((int)t).classifiers[m].object).Features();
                    boolean[] config = this.textclas.get((int)t).classifiers[m].configuration;
                    cf = null;
                    int nb = 0;
                    for (int n = 0; n < feat.length; ++n) {
                        if (config[n]) continue;
                        this.textclas.get((int)t).classifiers[m].instances.instance(0).setValue(nb++, feat[n]);
                    }
                    if (nb != this.textclas.get((int)t).classifiers[m].nbattributs) {
                        throw new Error("Souci recopie => " + this.textclas.get((int)t).classifiers[m].name + " " + nb + " " + this.textclas.get((int)t).classifiers[m].nbattributs);
                    }
                    try {
                        double p = this.textclas.get((int)t).classifiers[m].classifier.distributionForInstance(this.textclas.get((int)t).classifiers[m].instances.instance(0))[0];
                        res.setValue(row, t + 2, p);
                        int n = t;
                        probas[n] = probas[n] + p * this.textclas.get((int)t).classifiers[m].weight;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(0);
                    }
                }
                int n = t;
                probas[n] = probas[n] / this.textclas.get((int)t).weights;
            }
            m = 0;
            for (t = 1; t < size; ++t) {
                if (!(res.getValueDouble(row, t + 2) > res.getValueDouble(row, m + 2))) continue;
                m = t;
            }
            res.setValue(row++, size + 2, this.textclas.get((int)m).name);
        }
        res.Write("ResultTextureClassifierPatches.txt", false);
    }

    public void AddTextureClass(String name, float[] color, List<String> paths, Classifier classifier, int nbCPU) throws Exception {
        double weights = 0.0;
        TextureClassifiers tc = new TextureClassifiers(name, color, paths.size());
        for (int p = 0; p < paths.size(); ++p) {
            String path = paths.get(p);
            FichierTabule results = new FichierTabule(path + "/Results.txt", false);
            double weight = results.getValueDouble(0, 0);
            String namefile = results.getValueString(0, 1);
            int line = results.getValueInt(0, 2);
            FichierTabule sysres = new FichierTabule(path + "/" + namefile, true);
            FichierTabule occ = new FichierTabule(path + "/" + namefile.substring(0, namefile.length() - 6) + "OCC.txt", true);
            boolean[] configuration = new boolean[sysres.Width() - 1];
            for (int i2 = 0; i2 < configuration.length; ++i2) {
                configuration[i2] = sysres.getValueInt(line, i2) != 1;
                occ.setExcludedColumn(i2, configuration[i2]);
            }
            FichierTabule workingfile = FichierTabuleTools.DeleteExcludedColumns(occ);
            workingfile.setNominal(workingfile.Width() - 1, true);
            Instances instances = FichierTabuleConverter.FichierTabuleToWekaInstances(workingfile, "TrainingSet");
            instances.setClassIndex(workingfile.Width() - 1);
            weights += weight / 100.0;
            tc.classifiers[p] = new Model();
            this.FindCharacterizer(namefile, tc.classifiers[p], nbCPU);
            tc.classifiers[p].weight = weight / 100.0;
            tc.classifiers[p].nbattributs = workingfile.Width() - 1;
            tc.classifiers[p].classifier = AbstractClassifier.makeCopy((Classifier)classifier);
            tc.classifiers[p].classifier.buildClassifier(instances);
            tc.classifiers[p].configuration = (boolean[])configuration.clone();
            tc.classifiers[p].instances = InstancesTools.CreateEmpty(instances, "");
            tc.classifiers[p].instances.add(instances.firstInstance());
            configuration = null;
            instances = null;
            namefile = null;
            occ = null;
            path = null;
            results = null;
            workingfile = null;
        }
        tc.weights = weights;
        this.textclas.add(tc);
    }

    private void FindCharacterizer(String name, Model model, int nbCPU) {
        ArrayList<String> list = new ArrayList<String>(13);
        int pos = 0;
        int p = 0;
        while (p < name.length() && name.charAt(p) != '.') {
            while (p < name.length() && name.charAt(p) != '_' && name.charAt(p) != '.') {
                ++p;
            }
            list.add(name.substring(pos, p));
            pos = ++p;
        }
        list.remove(list.size() - 1);
        list.remove(list.size() - 1);
        list.remove(list.size() - 1);
        list.remove(1);
        if (((String)list.get(0)).equalsIgnoreCase("GloaglzmMS")) {
            model.object = new MGlolzm();
            ((ComputableFeatures)model.object).Parameters(Integer.parseInt((String)list.get(2)), Integer.parseInt((String)list.get(3)), false, true, true, new LinearGLR(), null, -1, true, DistanceTools.CreateMontanariDistance(2, 7), nbCPU);
            model.name = "GloaglzmMS";
        } else if (((String)list.get(0)).equalsIgnoreCase("Gloaglzm")) {
            model.object = new GlolzmFeatures();
            ((ComputableFeatures)model.object).Parameters(Integer.parseInt((String)list.get(2)), Integer.parseInt((String)list.get(3)), Integer.parseInt((String)list.get(4)), false, true, true, new LinearGLR(), null, -1, true, DistanceTools.CreateMontanariDistance(2, 7), nbCPU);
            model.name = "Gloaglzm";
        } else if (((String)list.get(0)).equalsIgnoreCase("Glrlm")) {
            model.object = new RLMfeatures();
            ((ComputableFeatures)model.object).Parameters(Integer.parseInt((String)list.get(2)), new LinearGLR(), null, -1, nbCPU);
            model.name = "Glrlm";
        } else if (((String)list.get(0)).equalsIgnoreCase("GlszmMS")) {
            model.object = new MultiSZM();
            ((ComputableFeatures)model.object).Parameters(Integer.parseInt((String)list.get(2)), false, new LinearGLR(), null, -1, true, nbCPU);
            model.name = "GlszmMS";
        } else if (((String)list.get(0)).equalsIgnoreCase("Glszm")) {
            model.object = new SZMfeatures();
            ((ComputableFeatures)model.object).Parameters(Integer.parseInt((String)list.get(2)), Integer.parseInt((String)list.get(3)), false, new LinearGLR(), null, -1, true, nbCPU);
            model.name = "Glszm";
        } else if (((String)list.get(0)).contains("PSMSE")) {
            ArrayList<Integer> listse = new ArrayList<Integer>(4);
            listse.add(-3);
            listse.add(-4);
            listse.add(-5);
            listse.add(-6);
            if (((String)list.get(0)).contains("2")) {
                model.object = new PatternSpectrumMultiSE2();
                model.name = "PSMSE2";
            } else {
                model.object = new PatternSpectrumMultiSE();
                model.name = "PSMSE";
            }
            ((ComputableFeatures)model.object).Parameters(Integer.parseInt((String)list.get(2)), Integer.parseInt((String)list.get(3)), Integer.parseInt((String)list.get(4)), null, -1, nbCPU, listse);
        } else if (((String)list.get(0)).contains("GranMSE")) {
            ArrayList<Integer> listse = new ArrayList<Integer>(4);
            listse.add(-3);
            listse.add(-4);
            listse.add(-5);
            listse.add(-6);
            model.object = new GranulometryMultiSE();
            model.name = "GranMSE";
            ((ComputableFeatures)model.object).Parameters(Integer.parseInt((String)list.get(2)), Integer.parseInt((String)list.get(3)), Integer.parseInt((String)list.get(4)), null, -1, nbCPU, listse);
        } else if (((String)list.get(0)).contains("AntiGranMSE")) {
            ArrayList<Integer> listse = new ArrayList<Integer>(4);
            listse.add(-3);
            listse.add(-4);
            listse.add(-5);
            listse.add(-6);
            model.object = new AntiGranulometryMultiSE();
            model.name = "AntiGranMSE";
            ((ComputableFeatures)model.object).Parameters(Integer.parseInt((String)list.get(2)), Integer.parseInt((String)list.get(3)), Integer.parseInt((String)list.get(4)), null, -1, nbCPU, listse);
        } else {
            throw new IllegalArgumentException("Technique's name not supported: '" + (String)list.get(0) + "'");
        }
    }

    public void AddCFCM(String imagefile, float[] color) {
        this.listcm.add(new ConfidenceMap(imagefile, color));
    }

    public void ClassifyFromConfidenceMap(String resultname) {
        if (this.listcm.size() < 2) {
            throw new IllegalArgumentException("List too short.");
        }
        BufferedImage[] images = new BufferedImage[this.listcm.size()];
        WritableRaster[] wrs = new WritableRaster[this.listcm.size()];
        float[][] colors = new float[this.listcm.size()][];
        Iterator<ConfidenceMap> iter = this.listcm.iterator();
        ConfidenceMap cm = null;
        int nb = 0;
        while (iter.hasNext()) {
            try {
                cm = iter.next();
                images[nb] = ImageIO.Read(cm.image);
                wrs[nb] = images[nb].getRaster();
                colors[nb] = cm.color;
                ++nb;
                cm = null;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        int height = images[0].getHeight();
        int width = images[0].getWidth();
        BufferedImage res = new BufferedImage(width, height, 1);
        WritableRaster wrr = res.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i2;
                int max = 0;
                for (i2 = 1; i2 < nb; ++i2) {
                    if (wrs[i2].getSample(x, y, 0) <= wrs[max].getSample(x, y, 0)) continue;
                    max = i2;
                }
                for (i2 = 0; i2 < 3; ++i2) {
                    wrr.setSample(x, y, i2, colors[max][i2] * (float)wrs[max].getSample(x, y, 0));
                }
            }
        }
        images = null;
        wrs = null;
        wrr = null;
        colors = null;
        iter = null;
        try {
            ImageIO.Write(res, resultname, 6);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private class TextureClassifiers {
        public Model[] classifiers = null;
        public String name = null;
        public float[] color = null;
        public double weights = 0.0;

        public TextureClassifiers(String name, float[] color, int size) {
            this.name = name.substring(0);
            this.color = color;
            this.classifiers = new Model[size];
        }
    }

    private class ConfidenceMap {
        public String image = null;
        public float[] color;

        public ConfidenceMap(String image, float[] color) {
            this.image = image;
            this.color = color;
        }
    }

    private class Model {
        public Classifier classifier = null;
        public boolean[] configuration = null;
        public int nbattributs = -1;
        public double weight = 0.0;
        public Object object = null;
        public String name = null;
        public Instances instances = null;

        private Model() {
        }
    }
}

