/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.michelin;

import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class PatchEnhancer {
    int coucou;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Resize(File in, File out, int width, int height) {
        File[] images = in.listFiles();
        int nbErrors = 0;
        int length = images.length;
        BufferedImage imin = null;
        BufferedImage imout = null;
        if (!out.exists()) {
            out.mkdirs();
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (!images[i2].isFile()) continue;
            try {
                imin = ImageIO.Read(images[i2].getAbsolutePath());
                if (imin.getWidth() < width || imin.getHeight() < height) {
                    throw new Error("Image dimensions smaller than new dimensions.");
                }
                imout = ImageOperations.Resize((BufferedImage)imin, (int)width, (int)height);
                ImageIO.Write(imout, out.getAbsolutePath() + "/" + images[i2].getName(), 6);
                continue;
            }
            catch (Exception E) {
                System.err.println("Exception " + nbErrors + " => Failure processing file '" + images[i2].getAbsolutePath() + "'");
                continue;
            }
            catch (Error E) {
                System.err.println("Error " + nbErrors + " => Failure processing file '" + images[i2].getAbsolutePath() + "'");
                continue;
            }
            finally {
                imin = null;
                imout = null;
            }
        }
        images = null;
    }

    public void Split(File in, String out) {
        File[] list = in.listFiles();
        BufferedImage image = null;
        File Out = new File(out);
        if (!Out.exists()) {
            Out.mkdirs();
        }
        Out = null;
        for (int i2 = 0; i2 < list.length; ++i2) {
            if (!list[i2].isFile() || !list[i2].getName().contains("png")) continue;
            try {
                image = ImageIO.Read(list[i2].getAbsolutePath());
                String name = this.ChangeSizeName(list[i2].getName().substring(0, list[i2].getName().length() - 4));
                int width = image.getWidth() / 2 - 1;
                int height = image.getHeight() / 2 - 1;
                ImageIO.Write(ImageNew.SubImageWH((BufferedImage)image, (int)0, (int)0, (int)width, (int)height), out + "/" + name + "_1.png", 6);
                ImageIO.Write(ImageNew.SubImageWH((BufferedImage)image, (int)width, (int)0, (int)width, (int)height), out + "/" + name + "_2.png", 6);
                ImageIO.Write(ImageNew.SubImageWH((BufferedImage)image, (int)0, (int)height, (int)width, (int)height), out + "/" + name + "_3.png", 6);
                ImageIO.Write(ImageNew.SubImageWH((BufferedImage)image, (int)width, (int)height, (int)width, (int)height), out + "/" + name + "_4.png", 6);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String ChangeSizeName(String name) {
        int i2 = name.indexOf("x") + 1;
        String prefix = name.substring(0, i2);
        int j = i2;
        while (name.charAt(j) != '_') {
            ++j;
        }
        int num = Integer.parseInt(name.substring(i2, j));
        String suffix = name.substring(j, name.length());
        return prefix + ((num /= 2) < 10 ? "0" : "") + num + suffix;
    }
}

