/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.michelin;

import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.io.File;

public class FindPatchCoordinates {
    private int nbError;

    public void Find(File patchesfolder, BufferedImage image, String dest) {
        File[] list = patchesfolder.listFiles();
        int height = image.getHeight();
        int width = image.getWidth();
        this.nbError = 0;
        for (int p = 0; p < list.length; ++p) {
            if (!list[p].isFile() || !list[p].getName().contains(".png")) continue;
            try {
                BufferedImage patch = ImageIO.Read(list[p].getAbsolutePath());
                if (ImageTools.isColored((BufferedImage)patch)) {
                    patch = ImageConverter.Channel((BufferedImage)patch, (int)0);
                }
                boolean found = false;
                for (int y = patch.getHeight(); !found && y < height - patch.getHeight(); ++y) {
                    for (int x = patch.getWidth(); !found && x < width - patch.getWidth(); ++x) {
                        BufferedImage vignette = image.getSubimage(x, y, patch.getWidth(), patch.getHeight());
                        if (!ImageTools.areEqual((BufferedImage)patch, (BufferedImage)vignette)) continue;
                        found = true;
                        ImageIO.Write(patch, dest + "/" + list[p].getName().substring(0, list[p].getName().length() - 4) + "_" + x + "x" + y + ".png", 6);
                    }
                }
                if (!found) {
                    System.out.flush();
                    System.err.println(++this.nbError + " - Pas Trouve - " + list[p].getName());
                    System.err.flush();
                    ImageIO.Write(patch, dest + "/" + list[p].getName().substring(0, list[p].getName().length() - 4) + "_XxX.png", 6);
                }
                patch = null;
                continue;
            }
            catch (Exception E) {
                System.out.flush();
                System.err.println(++this.nbError + " - Exception - " + E.getMessage());
                System.err.flush();
                continue;
            }
            catch (Error E) {
                System.out.flush();
                System.err.println(++this.nbError + " - Error - " + E.getMessage());
                System.err.flush();
            }
        }
        list = null;
        System.err.println("Program finished with " + this.nbError + " error(s)/exception(s).");
    }
}

