/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.michelin;

import arrayTiTi.ArrayIO;
import filesAndFolders.FilesFolders;
import filesAndFolders.fichiersTabules.FichierTabule;
import java.io.File;
import java.io.IOException;

public class DeleteMisClassifyData {
    private int nbErrors;
    private int nbDelete;

    public void Launh(FichierTabule file, String folder, double threshold) {
        int colimage = file.ColumnNumber("Image");
        int colclass = file.ColumnNumber("Class");
        int colpred = file.ColumnNumber("Prediction");
        int colproba = -1;
        int[][] errors = new int[colpred - colclass - 1][colpred - colclass - 1];
        this.nbDelete = 0;
        this.nbErrors = 0;
        for (int y = 0; y < file.Height(); ++y) {
            boolean todelete = false;
            if (!file.getValueString(y, colclass).equalsIgnoreCase(file.getValueString(y, colpred))) {
                todelete = true;
                int[] nArray = errors[file.ColumnNumber("Proba_" + file.getValueString(y, colclass)) - colclass - 1];
                int n = file.ColumnNumber("Proba_" + file.getValueString(y, colpred)) - colclass - 1;
                nArray[n] = nArray[n] + 1;
            } else {
                colproba = file.ColumnNumber("Proba_" + file.getValueString(y, colclass));
                for (int x = colclass + 1; !todelete && x < colpred; ++x) {
                    if (x == colproba || !(Math.abs(file.getValueDouble(y, x) - file.getValueDouble(y, colproba)) < threshold)) continue;
                    todelete = true;
                    int[] nArray = errors[colproba - colclass - 1];
                    int n = x - colclass - 1;
                    nArray[n] = nArray[n] + 1;
                }
            }
            if (!todelete) continue;
            System.out.print(++this.nbDelete + " - Delete " + file.getValueString(y, colimage) + " ");
            todelete = FilesFolders.Delete(new File(folder + "/" + file.getValueString(y, colimage)));
            if (todelete) {
                System.out.println("successfully.");
                continue;
            }
            System.out.println("failure " + ++this.nbErrors + ".");
        }
        try {
            ArrayIO.Write(errors, "MisClassifyErrors.txt", "\t");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Delete " + (double)this.nbDelete / (double)file.Height() * 100.0);
    }
}

