/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.michelin;

import dataMining.AutomaticModel;
import dataMining.classifiers.parameters.ClassifierParameterFunction;
import dataMining.imbalanceDataSet.OverSampling;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import weka.classifiers.Classifier;

public class AutomaticModelMichelin {
    private AutomaticModel automod = new AutomaticModel();
    private List<bestresult> bestresults = new Vector<bestresult>(113);

    public void Classify(String Folder, List<String> ListSources, String Target, List<String> Classes, List<String> ToReject, Classifier classifier, ClassifierParameterFunction paramfunc, int Validation, int Nb, boolean Balance, boolean OneClassClassifier, int BestResults, int nbCPU) throws Exception {
        int nbresearches = 0;
        String TargetClean = this.Clean(Target);
        File folder = new File(Folder);
        File[] liste = folder.listFiles();
        boolean[] done = new boolean[liste.length];
        Arrays.fill(done, false);
        FichierTabule[] f = new FichierTabule[ListSources.size()];
        FichierTabule merged = null;
        Vector<FichierTabule> listfiles = new Vector<FichierTabule>(13);
        Calendar cal = Calendar.getInstance();
        File folderOut = new File(Folder + "/Classification results " + TargetClean + " " + this.ClassesName(Classes) + "/");
        folderOut.mkdir();
        for (int y = 0; y < liste.length; ++y) {
            int i2;
            int x;
            if (done[y] || !liste[y].isFile() || !liste[y].getName().contains(".txt")) continue;
            for (x = 0; x < ListSources.size(); ++x) {
                f[x] = null;
            }
            int nb = 0;
            String name = liste[y].getName();
            int pos = -1;
            x = 0;
            while (pos < 0 && x < ListSources.size()) {
                pos = name.lastIndexOf(ListSources.get(x++));
            }
            if (pos < 0) {
                System.out.println("Fichier non conforme : '" + name + "'");
                continue;
            }
            String prefixe = name.substring(0, pos);
            while (pos < name.length() && name.charAt(pos) != '_') {
                ++pos;
            }
            String suffixe = name.substring(pos + 1, name.length() - 4);
            cal = Calendar.getInstance();
            System.out.println("\n" + ++nbresearches + " - " + cal.get(5) + "/" + (cal.get(2) + 1) + " at " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13) + "\t");
            f[nb++] = new FichierTabule(liste[y].getAbsolutePath(), true);
            done[y] = true;
            for (x = y + 1; x < liste.length; ++x) {
                for (i2 = 0; i2 < ListSources.size(); ++i2) {
                    if (!liste[x].getName().equalsIgnoreCase(prefixe + ListSources.get(i2) + suffixe)) continue;
                    f[nb++] = new FichierTabule(liste[x].getAbsolutePath(), true);
                    done[x] = true;
                }
            }
            if (nb != ListSources.size()) {
                throw new Error("file(s) not founded.");
            }
            for (i2 = 0; i2 < f.length; ++i2) {
                listfiles.add(f[i2]);
            }
            merged = this.Merge(listfiles);
            merged.Write(folderOut.getAbsolutePath() + "/" + prefixe + "_All_" + suffixe + "_" + TargetClean + ".txt", false);
            merged.Rename(prefixe + "_All_" + suffixe + "_" + TargetClean);
            this.ImageNameToClassName(merged);
            this.automod.Classify(merged, Target, Classes, ToReject, classifier, paramfunc, Validation, Nb, new OverSampling(), OneClassClassifier, new File(Folder), nbCPU);
            System.out.println("\n\n");
            listfiles.clear();
            merged = null;
            prefixe = null;
            suffixe = null;
        }
        if (BestResults > 0) {
            switch (Validation) {
                case 1: {
                    this.FindBestResults(folderOut.getAbsolutePath(), BestResults, "ValidationKFCV", "Results.txt");
                }
            }
        }
    }

    private String Clean(String s) {
        return s.replace(":", "").replace(" ", "");
    }

    public void FindBestResults(String Folder, int N, String Column, String Result) {
        int y;
        int nbErrors = 0;
        int colVal = -1;
        double max = 0.0;
        File[] list = new File(Folder).listFiles();
        FichierTabule file = null;
        this.bestresults.clear();
        for (int f = 0; f < list.length; ++f) {
            if (!list[f].getName().contains("_SR.txt")) continue;
            try {
                file = new FichierTabule(list[f].getAbsolutePath(), true);
                colVal = file.ColumnNumber(Column);
            }
            catch (Exception e) {
                System.err.println("Exception " + nbErrors++ + " - " + e.getMessage());
                continue;
            }
            int height = file.Height();
            for (y = 0; y < height; ++y) {
                if (this.bestresults.size() >= N && !(max < file.getValueDouble(y, colVal))) continue;
                max = this.Insert(list[f].getName(), y, file.getValueDouble(y, colVal), N);
            }
            file = null;
        }
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(Folder + "/" + Result));
            for (y = 0; y < N; ++y) {
                out.write(String.valueOf(this.bestresults.get((int)y).value + " " + this.bestresults.get((int)y).file + " " + this.bestresults.get((int)y).row + "\n").getBytes("ASCII"));
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private double Insert(String file, int row, double value, int N) {
        int i2 = 0;
        int size = this.bestresults.size();
        if (size == N) {
            this.bestresults.remove(--size);
        }
        while (i2 < size && value < this.bestresults.get((int)i2).value) {
            ++i2;
        }
        this.bestresults.add(i2, new bestresult(file, row, value));
        return this.bestresults.get((int)(this.bestresults.size() - 1)).value;
    }

    private String ClassesName(List<String> classes) {
        Iterator<String> iter = classes.iterator();
        StringBuilder sb = new StringBuilder(classes.size());
        while (iter.hasNext()) {
            sb.append(iter.next());
        }
        iter = null;
        return sb.toString();
    }

    private FichierTabule Merge(List<FichierTabule> list) {
        FichierTabule result = list.get(0);
        for (int i2 = 1; i2 < list.size(); ++i2) {
            result = FichierTabuleTools.Merge(result, list.get(i2));
        }
        return result;
    }

    public void ImageNameToClassName(FichierTabule file) {
        int column = file.ColumnNumber("Image");
        int height = file.Height();
        for (int y = 0; y < height; ++y) {
            int pos;
            String image = file.getValueString(y, column);
            for (pos = 0; pos < image.length() && image.charAt(pos) != '_'; ++pos) {
            }
            if (pos == image.length()) {
                throw new Error("Illegal name: '" + image + "'");
            }
            ++pos;
            while (pos < image.length() && image.charAt(pos) != '_') {
                ++pos;
            }
            if (pos == image.length()) {
                throw new Error("Illegal name: '" + image + "'");
            }
            file.setValue(y, column, image.substring(0, pos));
        }
    }

    protected class bestresult {
        public String file = null;
        public int row = -1;
        public double value;

        public bestresult(String file, int row, double value) {
            this.file = file.substring(0);
            this.row = row;
            this.value = value;
        }
    }
}

