/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.loreal;

import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiSZM;
import dv.DV;
import imageTiTi.ImageIO;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import processing.reducer.ColorReducer;

public class ExtractCharacteristics {
    private BufferedImage[] AF = null;
    private BufferedImage[] SHG = null;
    private BufferedImage[] AFD = null;
    private BufferedImage[] SHGD = null;
    private final DV AFdv = null;
    private final DV SHGdv = null;
    private int nbAF = 0;
    private int nbAFD = 0;
    private int nbSHG = 0;
    private int nbSHGD = 0;
    private int nbOldAF = 0;
    private int nbOldSHG = 0;
    private int nbFeatures = 0;
    private int nbCPU = 1;
    private MultiSZM glszmms = null;
    private DataOutputStream Out = null;
    private String CurrentFolder = null;
    private ColorReducer colorreducer = null;

    public ExtractCharacteristics(int nbGrayLevel, int nb, boolean FixedSizes, ColorReducer colorreducer) {
        this.colorreducer = colorreducer;
        this.glszmms = new MultiSZM();
    }

    public void Launch(File SourceFolder, File Result, int Multiply, int nbCPU) throws IOException {
        try {
            if (!Result.exists()) {
                Result.createNewFile();
            }
            this.PrepareOut(Result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.nbCPU = nbCPU;
        System.out.println(SourceFolder.getAbsolutePath());
        File[] list = SourceFolder.listFiles();
        for (int i2 = 0; i2 < list.length; ++i2) {
            if (!list[i2].isDirectory()) continue;
            this.CurrentFolder = list[i2].getName();
            this.Read(list[i2].getAbsoluteFile(), Result, Multiply);
        }
    }

    private void Read(File SourceFolder, File Result, int Multiply) throws IOException {
        int i2;
        Object[] list = SourceFolder.listFiles();
        Arrays.sort(list);
        this.nbOldAF = this.nbAF;
        this.nbOldSHG = this.nbSHG;
        this.nbSHGD = 0;
        this.nbSHG = 0;
        this.nbAFD = 0;
        this.nbAF = 0;
        for (i2 = 0; i2 < list.length; ++i2) {
            if (!((File)list[i2]).isFile() || !((File)list[i2]).getName().contains(".png")) continue;
            if (((File)list[i2]).getName().contains("_AF_Derme")) {
                ++this.nbAFD;
                continue;
            }
            if (((File)list[i2]).getName().contains("_AF_i_max")) {
                ++this.nbAF;
                continue;
            }
            if (((File)list[i2]).getName().contains("_SHG_Derme")) {
                ++this.nbSHGD;
                continue;
            }
            if (!((File)list[i2]).getName().contains("_SHG_i_max")) continue;
            ++this.nbSHG;
        }
        if (this.nbAF != this.nbAFD) {
            throw new Error("nbAF != nbAFD");
        }
        if (this.nbSHG != this.nbSHGD) {
            throw new Error("nbSHG != nbSHGD");
        }
        if (this.nbSHG != this.nbAF) {
            throw new Error("nbSHG != nbAF");
        }
        if (this.nbOldAF != this.nbAF || this.nbOldSHG != this.nbSHG) {
            this.AF = null;
            this.AFD = null;
            this.SHG = null;
            this.SHGD = null;
            this.AF = new BufferedImage[this.nbAF];
            this.AFD = new BufferedImage[this.nbAFD];
            this.SHG = new BufferedImage[this.nbSHG];
            this.SHGD = new BufferedImage[this.nbSHGD];
        }
        this.nbSHGD = 0;
        this.nbSHG = 0;
        this.nbAFD = 0;
        this.nbAF = 0;
        for (i2 = 0; i2 < list.length; ++i2) {
            if (!((File)list[i2]).isFile() || !((File)list[i2]).getName().contains(".png")) continue;
            if (((File)list[i2]).getName().contains("_AF_Derme")) {
                this.AFD[this.nbAFD++] = ImageIO.Read(((File)list[i2]).getAbsolutePath());
                continue;
            }
            if (((File)list[i2]).getName().contains("_AF_i_max")) {
                this.AF[this.nbAF++] = ImageIO.Read(((File)list[i2]).getAbsolutePath());
                continue;
            }
            if (((File)list[i2]).getName().contains("_SHG_Derme")) {
                this.SHGD[this.nbSHGD++] = ImageIO.Read(((File)list[i2]).getAbsolutePath());
                continue;
            }
            if (!((File)list[i2]).getName().contains("_SHG_i_max")) continue;
            this.SHG[this.nbSHG++] = ImageIO.Read(((File)list[i2]).getAbsolutePath());
        }
        this.PrepareImages();
        this.Extract();
    }

    private void PrepareImages() {
        int i2;
        for (i2 = 1; i2 < this.nbAF; ++i2) {
            if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)this.AF[0], (BufferedImage)this.AF[i2])) {
                throw new Error("Dimensions differentes AF");
            }
            if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)this.SHG[0], (BufferedImage)this.SHG[i2])) {
                throw new Error("Dimensions differentes SHG");
            }
            if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)this.AFD[0], (BufferedImage)this.AFD[i2])) {
                throw new Error("Dimensions differentes AFD");
            }
            if (ImageTools.areDimensionsAndTypeEqual((BufferedImage)this.SHGD[0], (BufferedImage)this.SHGD[i2])) continue;
            throw new Error("Dimensions differentes SHGD");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)this.AF[0], (BufferedImage)this.AFD[0])) {
            throw new Error("Dimensions differentes AF AFD");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)this.SHG[0], (BufferedImage)this.SHGD[0])) {
            throw new Error("Dimensions differentes SHG SHGD");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)this.AF[0], (BufferedImage)this.SHG[0])) {
            throw new Error("Dimensions differentes AF SHG");
        }
        int width = this.AF[0].getWidth();
        int height = this.AF[0].getHeight();
        WritableRaster wrafd = null;
        WritableRaster wraf = null;
        WritableRaster wrshg = null;
        WritableRaster wrshgd = null;
        for (i2 = 0; i2 < this.nbAF; ++i2) {
            wraf = this.AF[i2].getRaster();
            wrafd = this.AFD[i2].getRaster();
            wrshg = this.SHG[i2].getRaster();
            wrshgd = this.SHGD[i2].getRaster();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (wrafd.getSample(x, y, 0) == 0) {
                        wraf.setSample(x, y, 0, 0);
                    } else {
                        wraf.setSample(x, y, 0, wraf.getSample(x, y, 0) + 1 <= 255 ? wraf.getSample(x, y, 0) + 1 : 255);
                    }
                    if (wrshgd.getSample(x, y, 0) == 0) {
                        wrshg.setSample(x, y, 0, 0);
                        continue;
                    }
                    wrshg.setSample(x, y, 0, wrshg.getSample(x, y, 0) + 1 <= 255 ? wrshg.getSample(x, y, 0) + 1 : 255);
                }
            }
            wraf = null;
            wrafd = null;
            wrshg = null;
            wrshgd = null;
        }
    }

    private void BuildVolumes(int Multiply) {
        throw new Error("Must be upgraded.");
    }

    private void PrepareOut(File Result) {
        String[] FeaturesNames = null;
        this.nbFeatures = this.glszmms.FeaturesNames().length;
        try {
            int i2;
            this.Out = new DataOutputStream(new FileOutputStream(Result));
            FeaturesNames = this.glszmms.FeaturesNames();
            for (i2 = 0; i2 < this.nbFeatures; ++i2) {
                this.Out.write(String.valueOf("GlszmMS_" + FeaturesNames[i2] + "_AF ").getBytes("ASCII"));
            }
            FeaturesNames = null;
            FeaturesNames = this.glszmms.FeaturesNames();
            for (i2 = 0; i2 < this.nbFeatures; ++i2) {
                this.Out.write(String.valueOf("GlszmMS_" + FeaturesNames[i2] + "_SHG ").getBytes("ASCII"));
            }
            FeaturesNames = null;
            this.Out.write(String.valueOf("Images\n").getBytes("ASCII"));
            this.Out.write("\n".getBytes("ASCII"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void Extract() {
        double[] Features2 = null;
        try {
            int i2;
            this.glszmms.ComputeFromStack(this.AF, null, 1, this.colorreducer, 0, true);
            Features2 = this.glszmms.Features();
            for (i2 = 0; i2 < this.nbFeatures; ++i2) {
                this.Out.write(String.valueOf(Features2[i2] + " ").getBytes("ASCII"));
            }
            Features2 = null;
            this.glszmms.ComputeFromStack(this.SHG, null, 1, this.colorreducer, 0, true);
            Features2 = this.glszmms.Features();
            for (i2 = 0; i2 < this.nbFeatures; ++i2) {
                this.Out.write(String.valueOf(Features2[i2] + " ").getBytes("ASCII"));
            }
            Features2 = null;
            this.Out.write(String.valueOf(this.CurrentFolder + "\n").getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

