/*
 * Decompiled with CFR 0.152.
 */
package softwares.challenges.signatures;

import dataMining.pca.PCA;
import filesAndFolders.FichiersDossiersIHM;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import mathematics.Geometry2D;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;
import measures.BasicMeasures;
import morphee.Close;
import morphee.Open;
import morphee.StructuringElement;
import processing.filters.Invert;
import processing.thresholding.Binary;
import processing.transformations.ModifierCanvas;
import processing.transformations.Rotations;
import utils.times.Chronometer;

public class SignaturePreProcessing {
    private File Folder = null;
    private File FolderOut = null;
    private BufferedImage image = null;
    private String CurrentName = null;
    private Invert invert = new Invert();
    private BufferedImage iminv = null;
    private Binary binary = new Binary();
    private BufferedImage imbin = null;
    private StructuringElement se = new StructuringElement(new Object[]{1, -2});
    private Close close = new Close(this.se);
    private Open open = new Open(this.se);
    private BufferedImage imcl = null;
    private BufferedImage imop = null;
    private PCA pca = new PCA();
    private Point A = new Point3DF(0.0, 0.0);
    private Point B = new Point3DF(1.0, 0.0);
    private Rotations rot = new Rotations();
    private BufferedImage imrot = null;
    private BasicMeasures bbcps = new BasicMeasures();
    private ModifierCanvas mc = new ModifierCanvas();
    private int marge = 2;
    private BufferedImage imadjust = null;

    public void PreProcessing(String FolderPath, int nbCPU, Chronometer Chrono) throws IOException {
        int marker = 0;
        Calendar cal = Calendar.getInstance();
        if (Chrono != null) {
            System.out.println("Extraction des caracteristiques des signatures : ");
            marker = Chrono.NewMarker();
        }
        this.Folder = FolderPath == null ? FichiersDossiersIHM.ChoisirDossier(new File("").getAbsolutePath(), true) : new File(FolderPath);
        Object[] fichiers = this.Folder.listFiles();
        Arrays.sort(fichiers);
        this.FolderOut = new File(this.Folder.getAbsolutePath() + "/PreProcessing");
        this.FolderOut.mkdir();
        for (int i2 = 0; i2 < fichiers.length; ++i2) {
            if (!((File)fichiers[i2]).getName().contains(".png")) continue;
            cal = Calendar.getInstance();
            System.out.print(i2 + " - " + cal.get(5) + "/" + (cal.get(2) + 1) + " e " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13) + "\t");
            this.image = null;
            this.image = ImageIO.Read(((File)fichiers[i2]).getAbsolutePath());
            this.CurrentName = ((File)fichiers[i2]).getName();
            this.PreProcess(nbCPU);
        }
        if (Chrono != null) {
            System.out.println("Duree = " + Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
        fichiers = null;
        this.Folder = null;
        this.image = null;
    }

    private void PreProcess(int nbCPU) {
        this.iminv = null;
        this.iminv = this.invert.Filter(this.image, nbCPU);
        this.imbin = null;
        this.imbin = this.binary.Filter(this.iminv, 1);
        this.imcl = null;
        this.imcl = this.close.Filter(this.imbin, nbCPU);
        this.imop = null;
        this.imop = this.open.Filter(this.imcl, nbCPU);
        this.pca.Compute(this.imop, null);
        double Angle = Geometry2D.AngleBAC(this.B, this.A, new Point3DF(this.pca.getEigenVectors()[0].get(0), this.pca.getEigenVectors()[0].get(1)), true);
        this.imrot = null;
        this.imrot = this.rot.Rotate(this.imop, -Angle);
        this.bbcps.Compute(this.imrot, true);
        this.imadjust = null;
        this.imadjust = this.mc.Reduire(this.imrot, (int)this.bbcps.BoundingBox.getInfG().getX() - this.marge, (int)this.bbcps.BoundingBox.getInfG().getY() - this.marge, (int)this.bbcps.BoundingBox.getWidth() + 2 * this.marge, (int)this.bbcps.BoundingBox.getHeight() + 2 * this.marge);
        try {
            ImageIO.Write(this.imadjust, this.FolderOut.getAbsolutePath() + "/" + this.CurrentName, 6);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

