/*
 * Decompiled with CFR 0.152.
 */
package softwares.challenges.signatures;

import characterization.shapes.fourier.FourierDescriptors;
import filesAndFolders.FichiersDossiersIHM;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FifoCcl;
import measures.cclh.FillHole;
import utils.strings.StringToolsImageDV;
import utils.times.Chronometer;

public class SignatureCharacterization {
    private DataOutputStream Out = null;
    private File Folder = null;
    private BufferedImage image = null;
    private String CurrentName = null;
    private BufferedImage[] images = null;
    private ConnectedComponentLabeling ccl = new FifoCcl();
    private Iterator<BufferedImage> iter = null;
    private BufferedImage im = null;
    private FillHole fh = new FillHole();
    private BufferedImage imfill = null;
    private FourierDescriptors fd = new FourierDescriptors(0);
    private Metric metric = new Euclidian();
    private double[] fd5 = new double[5];
    private double[] fd7 = new double[7];
    private double[] fd11 = new double[11];
    private double[] fd13 = new double[13];
    private double[] fd17 = new double[17];

    public void ExtractCharacteristics(String FolderPath, String ResultFileName, Chronometer Chrono) throws IOException {
        int marker = 0;
        Calendar cal = Calendar.getInstance();
        if (Chrono != null) {
            System.out.println("Extraction des caracteristiques des signatures : ");
            marker = Chrono.NewMarker();
        }
        this.Folder = FolderPath == null ? FichiersDossiersIHM.ChoisirDossier(new File("").getAbsolutePath(), true) : new File(FolderPath);
        Object[] fichiers = this.Folder.listFiles();
        Arrays.sort(fichiers);
        File Results = new File(this.Folder.getAbsolutePath() + "/" + ResultFileName);
        try {
            Results.createNewFile();
            this.Out = new DataOutputStream(new FileOutputStream(Results));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i2 = 0; i2 < fichiers.length; ++i2) {
            if (!((File)fichiers[i2]).getName().contains(".png")) continue;
            cal = Calendar.getInstance();
            System.out.print(i2 + " - " + cal.get(5) + "/" + (cal.get(2) + 1) + " e " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13) + "\t");
            this.image = null;
            this.image = ImageIO.Read(((File)fichiers[i2]).getAbsolutePath());
            this.CurrentName = ((File)fichiers[i2]).getName();
            this.Extract();
        }
        try {
            this.Out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (Chrono != null) {
            System.out.println("Duree = " + Chrono.getTimeSinceMarker(marker) + "s.");
            Chrono.FreeMarker(marker);
        }
        fichiers = null;
        this.Folder = null;
        this.image = null;
    }

    private void Extract() {
        int x;
        for (x = 0; x < this.fd5.length; ++x) {
            this.fd5[x] = 0.0;
        }
        for (x = 0; x < this.fd7.length; ++x) {
            this.fd7[x] = 0.0;
        }
        for (x = 0; x < this.fd11.length; ++x) {
            this.fd11[x] = 0.0;
        }
        for (x = 0; x < this.fd13.length; ++x) {
            this.fd13[x] = 0.0;
        }
        for (x = 0; x < this.fd17.length; ++x) {
            this.fd17[x] = 0.0;
        }
        this.imfill = null;
        this.imfill = this.fh.Fill(this.image, this.ccl, 1000000, true);
        this.ccl.Label(this.imfill, 0, true);
        if (this.images != null) {
            this.images = null;
        }
        this.images = this.ccl.SeparateComponents(null, 30, 1);
        try {
            for (x = 0; x < 5; ++x) {
                this.Out.write(String.valueOf(this.fd5[x] + " ").getBytes("ASCII"));
            }
            for (x = 0; x < 7; ++x) {
                this.Out.write(String.valueOf(this.fd7[x] + " ").getBytes("ASCII"));
            }
            for (x = 0; x < 11; ++x) {
                this.Out.write(String.valueOf(this.fd11[x] + " ").getBytes("ASCII"));
            }
            for (x = 0; x < 13; ++x) {
                this.Out.write(String.valueOf(this.fd13[x] + " ").getBytes("ASCII"));
            }
            for (x = 0; x < 17; ++x) {
                this.Out.write(String.valueOf(this.fd17[x] + " ").getBytes("ASCII"));
            }
            this.Out.write(String.valueOf(this.isAuthentic() + this.CurrentName + "\n").getBytes("ASCII"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String isAuthentic() {
        int deb;
        int enda;
        int endf;
        String OnlyName = StringToolsImageDV.DeleteExtension((String)this.CurrentName);
        for (endf = OnlyName.length() - 1; endf >= 0 && OnlyName.charAt(endf) != '_'; --endf) {
        }
        if (endf < 0) {
            throw new Error("Souci dans l'extraction des informations : numero de signature.");
        }
        for (enda = endf - 1; enda >= 0 && OnlyName.charAt(enda) != '_'; --enda) {
        }
        if (enda < 0) {
            throw new Error("Souci dans l'extraction des informations : nom du faussaire.");
        }
        String Faussaire = OnlyName.substring(enda + 1, endf);
        for (deb = enda - 1; deb >= 0 && OnlyName.charAt(deb) != '-'; --deb) {
        }
        if (deb < 0) {
            throw new Error("Souci dans l'extraction des informations : nom de l'auteur.");
        }
        String Auteur = OnlyName.substring(deb + 1, enda);
        String Type2 = Faussaire.equalsIgnoreCase(Auteur) ? "Authentique" : "Contrefacon";
        return "A" + Auteur + " F" + Faussaire + " " + Type2 + " ";
    }
}

