/*
 * Decompiled with CFR 0.152.
 */
package softwares.challenges.icpr2012;

import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import measures.histogram.Histogram;
import processing.filters.DynamicExpansion;

public class Preprocessings {
    private DynamicExpansion dynexp = new DynamicExpansion();
    private final ImageFeatures IF = new ImageFeatures();
    FileFilter ffdir = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() && pathname.getName().charAt(0) != '.';
        }
    };
    ImageDrawer drawer = new ImageDrawer();
    private Histogram histogram = new Histogram();

    public static void Process(String inputfolder, String outputfolder) {
        String name = null;
        File[] images = new File(inputfolder).listFiles();
        int nbErrors = 0;
        File file = new File(outputfolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains("_mask.png") || images[i2].getName().charAt(0) == '.') continue;
            try {
                BufferedImage maskij;
                BufferedImage mask;
                block8: {
                    name = images[i2].getName().replace("_mask.png", "");
                    mask = null;
                    try {
                        mask = ImageIO.Read(images[i2].getAbsolutePath());
                    }
                    catch (Error e) {
                        maskij = ImageIO.ReadWithImageJ(images[i2].getAbsolutePath());
                        mask = ImageConverter.Universal((BufferedImage)maskij, (int)12);
                        if (!ImageTools.areDimensionsAndValuesEqual((BufferedImage)mask, (BufferedImage)maskij)) {
                            throw new Exception("JAI and ImageJ can't read the image.");
                        }
                    }
                    catch (Exception e) {
                        maskij = ImageIO.ReadWithImageJ(images[i2].getAbsolutePath());
                        mask = ImageConverter.Universal((BufferedImage)maskij, (int)12);
                        if (ImageTools.areDimensionsAndValuesEqual((BufferedImage)mask, (BufferedImage)maskij)) break block8;
                        throw new Exception("JAI and ImageJ can't read the image.");
                    }
                }
                BufferedImage image = ImageIO.Read(inputfolder + "/" + name + ".png");
                image = ImageConverter.Channel((BufferedImage)image, (int)1);
                ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)image, (int)0, (BufferedImage)image);
                ImageIO.Write(image, outputfolder + "/" + name + ".png", 6);
                image = null;
                maskij = null;
                mask = null;
                continue;
            }
            catch (Exception E) {
                E.printStackTrace();
                ++nbErrors;
            }
        }
        file = null;
        System.out.println("Conversion finished with " + nbErrors + " error(s).");
    }

    public void CellExtractor(String directory, String resdir) {
        File[] dirs = new File(directory + "/Images/").listFiles(this.ffdir);
        if (dirs.length != 28) {
            throw new Error("Souci: " + dirs.length);
        }
        int cell_ID = 1;
        int object_type = 4;
        int pattern = 5;
        int minX = 6;
        int minY = 7;
        int maxX = 8;
        int maxY = 9;
        int margin = 3;
        FichierTabule info = new FichierTabule(2000, new int[]{2, 2}, "Information");
        info.setColumnsNames(new String[]{"Image", "Class"});
        int counter = 0;
        for (int d = 0; d < dirs.length; ++d) {
            try {
                BufferedImage rgb = ImageIO.Read(dirs[d].getAbsolutePath() + "/" + dirs[d].getName() + ".bmp");
                BufferedImage image = ImageConverter.Channel((BufferedImage)rgb, (int)1);
                BufferedImage mask = ImageIO.Read(dirs[d].getAbsolutePath() + "/" + dirs[d].getName() + "_mask.bmp");
                ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)image, (int)0, (BufferedImage)image);
                int max = this.MaxSearch(image, 23);
                int min = (int)this.IF.Minimum(image, 0);
                System.out.print("Min / max = " + min + ", " + max);
                ImageConverter.Channel((BufferedImage)rgb, (int)1, (BufferedImage)image);
                this.dynexp.Filter(image, min, max, 1, 255, image, 1);
                BufferedImage copy = ImageNew.Clone((BufferedImage)image);
                FichierTabule file = new FichierTabule(dirs[d].getAbsolutePath() + "/" + dirs[d].getName() + ".csv", true);
                for (int y = 0; y < file.Height(); ++y) {
                    if (!file.getValueString(y, object_type).equalsIgnoreCase("cell")) continue;
                    String num = this.Number(file.getValueInt(y, cell_ID));
                    BufferedImage seg = ImageIO.Read(directory + "/Cells/Cell_Masks/" + dirs[d].getName() + "/" + num + ".png");
                    ImageComparator.Compare((BufferedImage)seg, (String)"!=", (int)0, (BufferedImage)copy, (int)0, (BufferedImage)copy);
                    BufferedImage vig = ImageNew.SubImage((BufferedImage)copy, (int)(file.getValueInt(y, minX) - margin), (int)(file.getValueInt(y, minY) - margin), (int)file.getValueInt(y, maxX), (int)file.getValueInt(y, maxY));
                    if (!ImageTools.isBlack((BufferedImage)vig)) {
                        ImageIO.Write(vig, resdir + "/" + dirs[d].getName() + "_" + num + ".png", 6);
                        info.setValue(counter, 0, dirs[d].getName() + "_" + num + ".png");
                        info.setValue(counter, 1, file.getValueString(y, pattern));
                        ++counter;
                    }
                    ImageNew.Copy((BufferedImage)image, (BufferedImage)copy);
                    num = null;
                    vig = null;
                    seg = null;
                }
                file.Kill();
                file = null;
                copy = null;
                mask = null;
                image = null;
                rgb = null;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        info.SelectNull(0);
        info.ExcludeSelectedRows();
        FichierTabule result = FichierTabuleTools.DeleteExcludedRows(info);
        result.Write(resdir + "/Information.txt", false);
    }

    private int MaxSearch(BufferedImage image, int threshold) {
        this.histogram.Fill(image);
        int[] hist = this.histogram.getValues(0);
        int count = 0;
        for (int index = hist.length - 1; 0 <= index; --index) {
            if (threshold > (count += hist[index])) continue;
            return index;
        }
        throw new Error("Max value not found.");
    }

    private String Number(int num) {
        if (99 < num) {
            return "" + num;
        }
        if (9 < num) {
            return "0" + num;
        }
        return "00" + num;
    }
}

