/*
 * Decompiled with CFR 0.152.
 */
package softwares.challenges.icpr2012;

import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import dataMining.classifiers.AutoMultiClassifier;
import filesAndFolders.fichiersTabules.FichierTabule;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import morphee.granulometry.PatternSpectrum;
import processing.reducer.LinearGLR;
import softwares.challenges.icpr2012.Preprocessings;
import weka.classifiers.Classifier;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.MultilayerPerceptron;
import weka.classifiers.trees.RandomForest;

public class HEp2CellsContest {
    private Preprocessings preprocess = new Preprocessings();

    public HEp2CellsContest(String path) throws Exception {
        int nbCPU = 2;
        Preprocessings.Process(path, "./Images/");
        AutoMultiClassifier amc = new AutoMultiClassifier();
        amc.AddClass("centromere", "centromere");
        amc.AddClass("coarse_speckled", "coarse_speckled");
        amc.AddClass("cytoplasmatic", "cytoplasmatic");
        amc.AddClass("fine_speckled", "fine_speckled");
        amc.AddClass("homogeneous", "homogeneous");
        amc.AddClass("nucleolar", "nucleolar");
        amc.AddClassifier((Classifier)new Logistic(), "LR");
        amc.AddClassifier((Classifier)new RandomForest(), "RF");
        amc.AddClassifier((Classifier)new MultilayerPerceptron(), "NN");
        SZMfeatures glszm = new SZMfeatures();
        glszm.Parameters(32, 5, false, new LinearGLR(), null, 0, true, nbCPU);
        amc.AddCharacterizer(glszm, "Glszm");
        PatternSpectrum ps = new PatternSpectrum();
        ps.Parameters(1, 13, 2, null, 0);
        amc.AddCharacterizer(ps, "PS");
        amc.BuildModels("./Characteristics/", "Best", "SysRes", true);
        amc.Classify("./Images/", ".png", "Result_Intermediate.txt", nbCPU);
        FichierTabule file = new FichierTabule("Result_Intermediate.txt", true);
        DataOutputStream output = new DataOutputStream(new FileOutputStream("ResultFinal_Guillaume_THIBAULT.txt"));
        for (int y = 0; y < file.Height(); ++y) {
            String cellname = file.getValueString(y, file.Width() - 2);
            String cellclass = file.getValueString(y, file.Width() - 1);
            output.write((path + "/" + cellname + ";" + cellclass + "\n").getBytes("ASCII"));
            System.out.println(path + "/" + cellname + ";" + cellclass);
        }
        output.close();
    }
}

