/*
 * Decompiled with CFR 0.152.
 */
package softwares.challenges.icpr2012;

import characterization.textures.statisticalmatrices.rlm.RLMfeatures;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import mathematics.functions.LinearFunctions;
import processing.reducer.ColorReducer;
import processing.reducer.FuzzyGLR;
import processing.reducer.LinearGLR;

public class CharacterizeCells {
    int coucou;
    private RLMfeatures characterizer = new RLMfeatures();
    private ColorReducer reducer = null;
    FileFilter fff = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().charAt(0) != '.';
        }
    };

    public CharacterizeCells() {
        this.reducer = new LinearGLR();
        int N = 3;
        this.reducer = new FuzzyGLR(N, 8, LinearFunctions.DecreasingLinearFrom_01_N0(N));
    }

    public void Process2(String inputfolder, String outputfile, int nbCPU) throws Exception {
        int i2;
        File[] images = new File(inputfolder).listFiles();
        FichierTabule file = new FichierTabule(inputfolder + "/Information.txt", true);
        int nbErrors = 0;
        double[] Features2 = null;
        DataOutputStream Out = new DataOutputStream(new FileOutputStream(outputfile));
        String[] FeaturesNames = this.characterizer.FeaturesNames();
        for (i2 = 0; i2 < FeaturesNames.length; ++i2) {
            Out.write(String.valueOf("\"" + FeaturesNames[i2] + "\" ").getBytes("ASCII"));
        }
        Out.write(String.valueOf("\"Images\" \"Class\"\n").getBytes("ASCII"));
        for (i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            try {
                BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                String name = images[i2].getName();
                this.characterizer.Compute(image, null, 256, this.reducer, 0, nbCPU);
                Features2 = this.characterizer.Features();
                for (int c = 0; c < Features2.length; ++c) {
                    Out.write(String.valueOf(Features2[c] + " ").getBytes("ASCII"));
                }
                file.SelectWhere(0, 0, name);
                if (file.FirstSelected() == -1 || file.nbSelected() != 1) {
                    throw new Exception("Souci: " + name);
                }
                Out.write(String.valueOf("\"" + name + "\" \"" + file.getValueString(file.FirstSelected(), 1) + "\"\n").getBytes("ASCII"));
                continue;
            }
            catch (Exception E) {
                System.out.flush();
                E.printStackTrace();
                System.err.println(images[i2].getAbsolutePath());
                System.err.flush();
                ++nbErrors;
            }
        }
    }

    public void Process(String inputfolder, String outputfile, int nbCPU) throws Exception {
        int i2;
        File[] images = new File(inputfolder).listFiles();
        FichierTabule file = new FichierTabule(inputfolder + "/gt.csv", true);
        int nbErrors = 0;
        double[] Features2 = null;
        DataOutputStream Out = new DataOutputStream(new FileOutputStream(outputfile));
        String[] FeaturesNames = this.characterizer.FeaturesNames();
        for (i2 = 0; i2 < FeaturesNames.length; ++i2) {
            Out.write(String.valueOf("\"" + FeaturesNames[i2] + "\" ").getBytes("ASCII"));
        }
        Out.write(String.valueOf("\"Images\" \"Class\"\n").getBytes("ASCII"));
        for (i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            try {
                BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                String name = images[i2].getName();
                int num = Integer.valueOf(name.substring(0, 3));
                Features2 = this.characterizer.Features();
                for (int c = 0; c < Features2.length; ++c) {
                    Out.write(String.valueOf(Features2[c] + " ").getBytes("ASCII"));
                }
                if (file.getValueInt(num - 1, 0) != num) {
                    throw new Exception("Souci: " + name + " " + num);
                }
                Out.write(String.valueOf("\"" + name + "\" \"" + file.getValueString(num - 1, 1) + "\"\n").getBytes("ASCII"));
                continue;
            }
            catch (Exception E) {
                E.printStackTrace();
                ++nbErrors;
            }
        }
    }

    public void Transformations(String featuresdir, String filematcher, String outputdir) throws Exception {
        FichierTabule file = new FichierTabule(filematcher, true);
        int Set2 = 1;
        int Image2 = 2;
        int Original_cell_ID = 4;
        File[] features = new File(featuresdir).listFiles(this.fff);
        for (int f = 0; f < features.length; ++f) {
            FichierTabule feat = new FichierTabule(features[f].getAbsolutePath(), true);
            FichierTabule train = new FichierTabule(feat.Height(), feat.ColumnType(), "train");
            train.setColumnsNames(feat.getColumnsNames());
            FichierTabule test = new FichierTabule(feat.Height(), feat.ColumnType(), "test");
            test.setColumnsNames(feat.getColumnsNames());
            int colim = feat.ColumnNumber("Images");
            int nbtrain = 0;
            int nbtest = 0;
            block9: for (int im = 0; im < file.Height(); ++im) {
                String imname = this.Number2(file.getValueInt(im, Image2)) + "_" + this.Number(file.getValueInt(im, Original_cell_ID)) + ".png";
                feat.SelectWhere(colim, 0, imname);
                if (feat.nbSelected() != 1) {
                    throw new Error("Souci.");
                }
                int pos = feat.FirstSelected();
                switch (file.getValueString(im, Set2)) {
                    case "training": {
                        FichierTabuleTools.CopyInstance(feat, pos, train, nbtrain++);
                        continue block9;
                    }
                    case "test": {
                        FichierTabuleTools.CopyInstance(feat, pos, test, nbtest++);
                        continue block9;
                    }
                    default: {
                        throw new Error("Default: unknown Set value.");
                    }
                }
            }
            train.SelectNull("Class");
            train.ExcludeSelected();
            FichierTabule training = FichierTabuleTools.DeleteExcluded(train);
            test.SelectNull("Class");
            test.ExcludeSelected();
            FichierTabule testing = FichierTabuleTools.DeleteExcluded(test);
            training.Write(outputdir + "/" + features[f].getName().replace(".txt", "_Training.txt"), false);
            testing.Write(outputdir + "/" + features[f].getName().replace(".txt", "_Test.txt"), false);
            training.Kill();
            testing.Kill();
            feat.Kill();
            train.Kill();
            test.Kill();
            testing = null;
            test = null;
            training = null;
            train = null;
            feat = null;
        }
    }

    private String Number(int num) {
        if (99 < num) {
            return "" + num;
        }
        if (9 < num) {
            return "0" + num;
        }
        return "00" + num;
    }

    private String Number2(int num) {
        if (9 < num) {
            return "" + num;
        }
        return "0" + num;
    }
}

