/*
 * Decompiled with CFR 0.152.
 */
package softwares.challenges.icip2013;

import characterization.textures.lbp.MultiLBP;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiFuzzySZM;
import dataMining.classifiers.AutoMultiClassifierSimple;
import filesAndFolders.fichiersTabules.FichierTabule;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import softwares.challenges.icpr2012.Preprocessings;
import weka.classifiers.Classifier;
import weka.classifiers.trees.RandomForest;

public class Icip2013 {
    public Icip2013(String path, int nbCPU) throws Exception {
        Preprocessings.Process(path, "./Images/");
        AutoMultiClassifierSimple amcs = new AutoMultiClassifierSimple();
        amcs.AddClass("Centromere");
        amcs.AddClass("Golgi");
        amcs.AddClass("Homogeneous");
        amcs.AddClass("Nucleolar");
        amcs.AddClass("NuMem");
        amcs.AddClass("Speckled");
        amcs.AddClassifier((Classifier)new RandomForest());
        MultiLBP mlbp = new MultiLBP();
        mlbp.Parameters(1, 5, 2, 0, 1, new double[]{1.0, 0.9, 0.8});
        amcs.AddCharacterizer(mlbp, "MultiLBP.txt");
        MultiFuzzySZM mfszm = new MultiFuzzySZM();
        mfszm.Parameters(1, 3, 1, 0, true, new double[]{1.0, 0.9, 0.8});
        amcs.AddCharacterizer(mfszm, "MultiFuzzySZM.txt");
        ArrayList<String> coltodelete = new ArrayList<String>(3);
        coltodelete.add("Image");
        amcs.BuildModels("./Features/", coltodelete);
        amcs.Classify("./Images/", ".png", "Result_Intermediate.txt", nbCPU);
        FichierTabule file = new FichierTabule("Result_Intermediate.txt", true);
        DataOutputStream output = new DataOutputStream(new FileOutputStream("ResultFinal_Guillaume_THIBAULT.txt"));
        for (int y = 0; y < file.Height(); ++y) {
            String cellname = file.getValueString(y, file.Width() - 2);
            String cellclass = file.getValueString(y, file.Width() - 1);
            output.write((cellname + ";" + cellclass + "\n").getBytes("ASCII"));
            System.out.println(cellname + ";" + cellclass);
        }
        output.close();
    }
}

