/*
 * Decompiled with CFR 0.152.
 */
package softwares.challenges.icip2013;

import characterization.textures.statisticalmatrices.thibaultmatrices.szm.FuzzySZMfeatures;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageComparator;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import processing.reducer.FuzzyGLR;
import utils.LogFile;

public class CharacterizeCells {
    private final FuzzySZMfeatures characterizer = new FuzzySZMfeatures();
    private final FuzzyGLR reducer = null;

    public void Process(String inputfolder, String outputfile, int nbCPU) throws Exception {
        int i2;
        File[] images = new File(inputfolder).listFiles();
        FichierTabule file = new FichierTabule(inputfolder + "/../gt_training.csv", true);
        LogFile log = new LogFile();
        double[] Features2 = null;
        DataOutputStream Out = new DataOutputStream(new FileOutputStream(outputfile));
        String[] FeaturesNames = this.characterizer.FeaturesNames();
        for (i2 = 0; i2 < FeaturesNames.length; ++i2) {
            Out.write(String.valueOf("\"" + FeaturesNames[i2] + "\" ").getBytes("ASCII"));
        }
        Out.write(String.valueOf("Image Class\n").getBytes("ASCII"));
        for (i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png") || images[i2].getName().contains("_Mask.png")) continue;
            try {
                BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                String name = images[i2].getName();
                BufferedImage mask = ImageIO.Read(images[i2].getAbsolutePath().replace(".png", "_Mask.png"));
                int num = Integer.valueOf(name.replace(".png", ""));
                ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)image, (int)0, (BufferedImage)image);
                this.characterizer.Compute(image, null, -1, this.reducer, 0, true, nbCPU);
                Features2 = this.characterizer.Features();
                for (int c = 0; c < Features2.length; ++c) {
                    Out.write(String.valueOf(Features2[c] + " ").getBytes("ASCII"));
                }
                if (file.getValueInt(num - 1, 0) != num) {
                    throw new Exception("Souci: " + name + " " + num);
                }
                Out.write(String.valueOf("\"" + name + "\" \"" + file.getValueString(num - 1, 1) + "\"\n").getBytes("ASCII"));
                continue;
            }
            catch (Exception E) {
                E.printStackTrace();
                log.addNewException(E, new String[0]);
                continue;
            }
            catch (Error E) {
                E.printStackTrace();
                log.addNewError(E, new String[0]);
            }
        }
        System.out.println(log.Resume());
    }
}

