/*
 * Decompiled with CFR 0.152.
 */
package softwares.challenges.cyto2017;

import characterization.ComputableFeatures;
import characterization.MasterCharacterizer;
import characterization.textures.BasicTexturalFeatures;
import characterization.textures.lbp.LocalBinaryPattern;
import characterization.textures.lbp.MultiLBP;
import characterization.textures.statisticalmatrices.com.Haralick;
import characterization.textures.statisticalmatrices.rlm.FuzzyRLMfeatures;
import characterization.textures.statisticalmatrices.rlm.MultiFuzzyRLM;
import characterization.textures.statisticalmatrices.rlm.MultiRLM;
import characterization.textures.statisticalmatrices.rlm.RLMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.DZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.MultiDZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.FuzzySZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiFuzzySZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiSZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import filesAndFolders.FileNameFilters;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.functions.LinearFunctions;
import morphee.StructuringElement;
import morphee.granulometry.PatternSpectrum;
import processing.reducer.FuzzyGLR;
import processing.reducer.HistogramGLR;
import processing.reducer.MinMaxLinearGLR;

public class Cyto2017 {
    public void Characterize(String dirpath, String result, int nbCPU) {
        File[] images = new File(dirpath).listFiles(FileNameFilters.ImagesPNG);
        List<File> list = Arrays.asList(images);
        this.Characterize(list, result, nbCPU);
        list = null;
        images = null;
    }

    public void Characterize(List<File> files, String result, int nbCPU) {
        ArrayList<ComputableFeatures> characterizers = new ArrayList<ComputableFeatures>(43);
        this.AddBasics(characterizers);
        this.AddSZM(characterizers);
        this.AddMultiSZM(characterizers);
        this.AddHaralick(characterizers);
        this.AddRLM(characterizers);
        this.AddMultiRLM(characterizers);
        this.AddDZM(characterizers);
        this.AddMultiDZM(characterizers);
        this.AddLBP(characterizers);
        this.AddMultiLBP(characterizers);
        this.AddPatternSpectrum(characterizers);
        MasterCharacterizer mc = new MasterCharacterizer();
        mc.Characterize(files, MasterCharacterizer.Source.Image, null, characterizers, result, true, true, nbCPU);
        mc = null;
    }

    private void AddBasics(List<ComputableFeatures> characterizers) {
        BasicTexturalFeatures btf = new BasicTexturalFeatures();
        btf.Parameters(0);
        characterizers.add(btf);
    }

    private void AddSZM(List<ComputableFeatures> characterizers) {
        SZMfeatures szm16 = new SZMfeatures();
        szm16.Parameters(16, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm16);
        SZMfeatures szm32 = new SZMfeatures();
        szm32.Parameters(32, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm32);
        SZMfeatures szm64 = new SZMfeatures();
        szm64.Parameters(64, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm64);
        SZMfeatures szm128 = new SZMfeatures();
        szm128.Parameters(128, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm128);
        SZMfeatures szmhist16 = new SZMfeatures();
        szmhist16.Parameters(16, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist16);
        SZMfeatures szmhist32 = new SZMfeatures();
        szmhist32.Parameters(32, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist32);
        SZMfeatures szmhist64 = new SZMfeatures();
        szmhist64.Parameters(64, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist64);
        SZMfeatures szmhist128 = new SZMfeatures();
        szmhist128.Parameters(128, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist128);
    }

    private void AddMultiSZM(List<ComputableFeatures> characterizers) {
        MultiSZM mmlin = new MultiSZM();
        mmlin.Parameters(1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(mmlin);
        MultiSZM hist = new MultiSZM();
        hist.Parameters(1, new HistogramGLR(), 0, true);
        characterizers.add(hist);
    }

    private void AddFuzzySZM(List<ComputableFeatures> characterizers) {
        FuzzySZMfeatures fszm1 = new FuzzySZMfeatures();
        fszm1.Parameters(-1, new FuzzyGLR(1, 8, LinearFunctions.DecreasingLinearFrom_01_N0(1)), 0, true);
        characterizers.add(fszm1);
        FuzzySZMfeatures fszm2 = new FuzzySZMfeatures();
        fszm2.Parameters(-1, new FuzzyGLR(2, 8, LinearFunctions.DecreasingLinearFrom_01_N0(2)), 0, true);
        characterizers.add(fszm2);
        FuzzySZMfeatures fszm3 = new FuzzySZMfeatures();
        fszm3.Parameters(-1, new FuzzyGLR(3, 8, LinearFunctions.DecreasingLinearFrom_01_N0(3)), 0, true);
        characterizers.add(fszm3);
        FuzzySZMfeatures fszm5 = new FuzzySZMfeatures();
        fszm5.Parameters(-1, new FuzzyGLR(5, 8, LinearFunctions.DecreasingLinearFrom_01_N0(5)), 0, true);
        characterizers.add(fszm5);
        FuzzySZMfeatures fszm7 = new FuzzySZMfeatures();
        fszm7.Parameters(-1, new FuzzyGLR(7, 8, LinearFunctions.DecreasingLinearFrom_01_N0(7)), 0, true);
        characterizers.add(fszm7);
    }

    private void AddMultiFuzzySZM(List<ComputableFeatures> characterizers) {
        double[] weights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        MultiFuzzySZM mfszm = new MultiFuzzySZM();
        mfszm.Parameters(1, 11, 2, -1, 0, true, weights);
        characterizers.add(mfszm);
        MultiFuzzySZM mfszm3 = new MultiFuzzySZM();
        mfszm3.Parameters(2, 17, 3, -1, 0, true, weights);
        characterizers.add(mfszm3);
        MultiFuzzySZM mfszm5 = new MultiFuzzySZM();
        mfszm5.Parameters(5, 30, 5, -1, 0, true, weights);
        characterizers.add(mfszm5);
    }

    private void AddHaralick(List<ComputableFeatures> characterizers) {
        Haralick hmml16 = new Haralick();
        hmml16.Parameters(new MinMaxLinearGLR(), 16, 0);
        characterizers.add(hmml16);
        Haralick hmml32 = new Haralick();
        hmml32.Parameters(new MinMaxLinearGLR(), 32, 0);
        characterizers.add(hmml32);
        Haralick hmml64 = new Haralick();
        hmml64.Parameters(new MinMaxLinearGLR(), 64, 0);
        characterizers.add(hmml64);
        Haralick hmml128 = new Haralick();
        hmml128.Parameters(new MinMaxLinearGLR(), 128, 0);
        characterizers.add(hmml128);
        Haralick hhist16 = new Haralick();
        hhist16.Parameters(new HistogramGLR(), 16, 0);
        characterizers.add(hhist16);
        Haralick hhist32 = new Haralick();
        hhist32.Parameters(new HistogramGLR(), 32, 0);
        characterizers.add(hhist32);
        Haralick hhist64 = new Haralick();
        hhist64.Parameters(new HistogramGLR(), 64, 0);
        characterizers.add(hhist64);
        Haralick hhist128 = new Haralick();
        hhist128.Parameters(new HistogramGLR(), 128, 0);
        characterizers.add(hhist128);
    }

    private void AddRLM(List<ComputableFeatures> characterizers) {
        RLMfeatures rlm16 = new RLMfeatures();
        rlm16.Parameters(16, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm16);
        RLMfeatures rlm32 = new RLMfeatures();
        rlm32.Parameters(32, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm32);
        RLMfeatures rlm64 = new RLMfeatures();
        rlm64.Parameters(64, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm64);
        RLMfeatures rlm128 = new RLMfeatures();
        rlm128.Parameters(128, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm128);
        RLMfeatures rlmhist16 = new RLMfeatures();
        rlmhist16.Parameters(16, new HistogramGLR(), 0);
        characterizers.add(rlmhist16);
        RLMfeatures rlmhist32 = new RLMfeatures();
        rlmhist32.Parameters(32, new HistogramGLR(), 0);
        characterizers.add(rlmhist32);
        RLMfeatures rlmhist64 = new RLMfeatures();
        rlmhist64.Parameters(64, new HistogramGLR(), 0);
        characterizers.add(rlmhist64);
        RLMfeatures rlmhist128 = new RLMfeatures();
        rlmhist128.Parameters(128, new HistogramGLR(), 0);
        characterizers.add(rlmhist128);
    }

    private void AddMultiRLM(List<ComputableFeatures> characterizers) {
        MultiRLM mmlin = new MultiRLM();
        mmlin.Parameters(new MinMaxLinearGLR(), 0);
        characterizers.add(mmlin);
        MultiRLM hist = new MultiRLM();
        hist.Parameters(new HistogramGLR(), 0);
        characterizers.add(hist);
    }

    private void AddFuzzyRLM(List<ComputableFeatures> characterizers) {
        FuzzyRLMfeatures frlm1 = new FuzzyRLMfeatures();
        int fuzzy = 1;
        frlm1.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm1);
        FuzzyRLMfeatures frlm2 = new FuzzyRLMfeatures();
        fuzzy = 2;
        frlm2.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm2);
        FuzzyRLMfeatures frlm3 = new FuzzyRLMfeatures();
        fuzzy = 3;
        frlm3.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm3);
        FuzzyRLMfeatures frlm5 = new FuzzyRLMfeatures();
        fuzzy = 5;
        frlm5.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm5);
        FuzzyRLMfeatures frlm7 = new FuzzyRLMfeatures();
        fuzzy = 7;
        frlm7.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm7);
    }

    private void AddMultiFuzzyRLM(List<ComputableFeatures> characterizers) {
        double[] weights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        MultiFuzzyRLM mfrlm = new MultiFuzzyRLM();
        mfrlm.Parameters(1, 11, 2, -1, 0, weights);
        characterizers.add(mfrlm);
        MultiFuzzyRLM mfrlm3 = new MultiFuzzyRLM();
        mfrlm3.Parameters(2, 17, 3, -1, 0, weights);
        characterizers.add(mfrlm3);
        MultiFuzzyRLM mfrlm5 = new MultiFuzzyRLM();
        mfrlm5.Parameters(5, 30, 5, -1, 0, weights);
        characterizers.add(mfrlm5);
        weights = null;
    }

    private void AddDZM(List<ComputableFeatures> characterizers) {
        DZMfeatures rlm16 = new DZMfeatures();
        rlm16.Parameters(16, 1, new StructuringElement(new Object[]{3, -15}), true, false, new MinMaxLinearGLR(), 0, true);
        characterizers.add(rlm16);
        DZMfeatures rlm32 = new DZMfeatures();
        rlm32.Parameters(32, 1, new StructuringElement(new Object[]{3, -15}), true, false, new MinMaxLinearGLR(), 0, true);
        characterizers.add(rlm32);
        DZMfeatures rlm64 = new DZMfeatures();
        rlm64.Parameters(64, 1, new StructuringElement(new Object[]{3, -15}), true, false, new MinMaxLinearGLR(), 0, true);
        characterizers.add(rlm64);
        DZMfeatures rlm128 = new DZMfeatures();
        rlm128.Parameters(128, 1, new StructuringElement(new Object[]{3, -15}), true, false, new MinMaxLinearGLR(), 0, true);
        characterizers.add(rlm128);
        DZMfeatures rlmhist16 = new DZMfeatures();
        rlmhist16.Parameters(16, 1, new StructuringElement(new Object[]{3, -15}), true, false, new HistogramGLR(), 0, true);
        characterizers.add(rlmhist16);
        DZMfeatures rlmhist32 = new DZMfeatures();
        rlmhist32.Parameters(32, 1, new StructuringElement(new Object[]{3, -15}), true, false, new HistogramGLR(), 0, true);
        characterizers.add(rlmhist32);
        DZMfeatures rlmhist64 = new DZMfeatures();
        rlmhist64.Parameters(64, 1, new StructuringElement(new Object[]{3, -15}), true, false, new HistogramGLR(), 0, true);
        characterizers.add(rlmhist64);
        DZMfeatures rlmhist128 = new DZMfeatures();
        rlmhist128.Parameters(128, 1, new StructuringElement(new Object[]{3, -15}), true, false, new HistogramGLR(), 0, true);
        characterizers.add(rlmhist128);
    }

    private void AddMultiDZM(List<ComputableFeatures> characterizers) {
        MultiDZM mmlin = new MultiDZM();
        mmlin.Parameters(1, new StructuringElement(new Object[]{3, -15}), true, false, new MinMaxLinearGLR(), 0, true);
        characterizers.add(mmlin);
        MultiDZM hist = new MultiDZM();
        hist.Parameters(1, new StructuringElement(new Object[]{3, -15}), true, false, new HistogramGLR(), 0, true);
        characterizers.add(hist);
    }

    private void AddLBP(List<ComputableFeatures> characterizers) {
        LocalBinaryPattern lbp1 = new LocalBinaryPattern();
        lbp1.Parameters(new StructuringElement(new Object[]{1, -13, 8}), 1, 0);
        characterizers.add(lbp1);
        LocalBinaryPattern lbp2 = new LocalBinaryPattern();
        lbp2.Parameters(new StructuringElement(new Object[]{2, -13, 8}), 1, 0);
        characterizers.add(lbp2);
        LocalBinaryPattern lbp21 = new LocalBinaryPattern();
        lbp21.Parameters(new StructuringElement(new Object[]{1, -13, 8}), 2, 0);
        characterizers.add(lbp21);
        LocalBinaryPattern lbp22 = new LocalBinaryPattern();
        lbp22.Parameters(new StructuringElement(new Object[]{2, -13, 8}), 2, 0);
        characterizers.add(lbp22);
    }

    private void AddMultiLBP(List<ComputableFeatures> characterizers) {
        double[] weights = new double[]{1.0, 1.0, 1.0};
        MultiLBP mlbp1 = new MultiLBP();
        mlbp1.Parameters(1, 3, 1, 0, 1, weights);
        characterizers.add(mlbp1);
        MultiLBP mlbp2 = new MultiLBP();
        mlbp2.Parameters(1, 5, 2, 0, 1, weights);
        characterizers.add(mlbp2);
        MultiLBP mlbp12 = new MultiLBP();
        mlbp12.Parameters(1, 3, 1, 0, 2, weights);
        characterizers.add(mlbp12);
        MultiLBP mlbp22 = new MultiLBP();
        mlbp22.Parameters(1, 5, 2, 0, 2, weights);
        characterizers.add(mlbp22);
        weights = null;
    }

    private void AddPatternSpectrum(List<ComputableFeatures> characterizers) {
        PatternSpectrum ps1 = new PatternSpectrum();
        ps1.Parameters(1, 5, 1, 0, -1);
        characterizers.add(ps1);
    }
}

