/*
 * Decompiled with CFR 0.152.
 */
package softwares.challenges.breastcancer;

import filesAndFolders.FileFilters;
import filesAndFolders.fichiersTabules.FichierTabule;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import utils.LogFile;

public class QIN_BMMR {
    int coucou;

    public void Preprocess(String patientsdir, FichierTabule metadata, FichierTabule clinical, String outputdir) throws IllegalStateException, FileNotFoundException {
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        int colpidclin = clinical.ColumnNumber("Patient ID");
        int colpidmeta = metadata.ColumnNumber("Patient Id");
        int colmri1 = clinical.ColumnNumber("MRI 1");
        int colmri2 = clinical.ColumnNumber("MRI 2");
        int colmri3 = clinical.ColumnNumber("MRI 3");
        int colmri4 = clinical.ColumnNumber("MRI 4");
        int coldesc = metadata.ColumnNumber("Series Description");
        int colserie = metadata.ColumnNumber("Series UID");
        File resdir = new File(outputdir);
        if (!resdir.exists()) {
            resdir.mkdirs();
        }
        for (int p = 0; p < clinical.Height(); ++p) {
            try {
                boolean found;
                int row;
                int v;
                String patient = clinical.getValueString(p, colpidclin);
                log.addComment("Patient '" + patient + "'");
                int nbvisits = 0;
                if (clinical.getValueString(p, colmri1).equals("yes")) {
                    ++nbvisits;
                }
                if (clinical.getValueString(p, colmri2).equals("yes")) {
                    ++nbvisits;
                }
                if (clinical.getValueString(p, colmri3).equals("yes")) {
                    ++nbvisits;
                }
                if (clinical.getValueString(p, colmri4).equals("yes")) {
                    ++nbvisits;
                }
                log.addComment(" - " + nbvisits + " visits attended");
                Object visitnames = null;
                File[] visits = new File(patientsdir + "/" + patient + "/").listFiles(FileFilters.Directories);
                log.addComment(" - " + visits.length + " visits found");
                if (nbvisits != visits.length) {
                    log.addComment("------------------------ nbvisits != visits.length ------------------------");
                }
                metadata.SelectWhere(colpidmeta, 0, patient);
                log.addComment(" - " + metadata.nbSelected() + " rows found in metadata");
                if (metadata.nbSelected() == 0) {
                    log.addComment("This patient is not in the contest.\n");
                    continue;
                }
                metadata.SelectFromSelectionWhere(coldesc, 0, "T1-axial-locator");
                log.addComment(" - " + metadata.nbSelected() + " 'T1-axial-locator' rows found in metadata");
                if (metadata.nbSelected() < visits.length) {
                    log.addComment("----------------------------- missing T1-axial-locator serie(s) in metadata -----------------------------");
                } else if (metadata.nbSelected() > visits.length) {
                    log.addComment("----------------------------- more T1-axial-locator serie(s) in metadata than visits -----------------------------");
                } else {
                    v = 0;
                    int vis = 0;
                    while (v < visits.length) {
                        int row2 = metadata.FirstSelected();
                        boolean found2 = false;
                        while (0 <= row2 && !found2) {
                            File serie = new File(patientsdir + "/" + patient + "/" + visits[v].getName() + "/" + metadata.getValueString(row2, colserie));
                            if (serie.exists()) {
                                found2 = true;
                            }
                            serie = null;
                            row2 = metadata.NextSelected();
                        }
                        if (!found2) {
                            log.addComment("------------------- No 'T1-axial-locator' serie found in visit " + visits[v].getName() + " -------------------");
                        } else {
                            while (!clinical.getValueString(p, colmri1 + vis).equals("yes")) {
                                ++vis;
                            }
                            File visitdir = new File(outputdir + "/" + patient + "/V" + vis + "/");
                            System.out.println(visitdir.getAbsolutePath());
                            if (!visitdir.exists()) {
                                visitdir.mkdirs();
                            }
                            visitdir = null;
                        }
                        ++v;
                        ++vis;
                    }
                }
                metadata.SelectWhere(colpidmeta, 0, patient);
                metadata.SelectFromSelectionWhere(coldesc, 0, "Breast Tissue Segmentation");
                log.addComment(" - " + metadata.nbSelected() + " 'Breast Tissue Segmentation' rows found in metadata");
                if (metadata.nbSelected() < visits.length) {
                    log.addComment("----------------------------- missing 'Breast Tissue Segmentation' serie(s) in metadata -----------------------------");
                } else if (metadata.nbSelected() > visits.length) {
                    log.addComment("----------------------------- more 'Breast Tissue Segmentation' serie(s) in metadata than visits -----------------------------");
                } else {
                    for (v = 0; v < visits.length; ++v) {
                        row = metadata.FirstSelected();
                        found = false;
                        while (0 <= row && !found) {
                            File serie = new File(patientsdir + "/" + patient + "/" + visits[v].getName() + "/" + metadata.getValueString(row, colserie));
                            if (serie.exists()) {
                                found = true;
                            }
                            serie = null;
                            row = metadata.NextSelected();
                        }
                        if (found) continue;
                        log.addComment("------------------- No 'Breast Tissue Segmentation' serie found in visit " + visits[v].getName() + " -------------------");
                    }
                }
                metadata.SelectWhere(colpidmeta, 0, patient);
                metadata.SelectFromSelectionWhere(coldesc, 0, "PE Segmentation thresh=70");
                log.addComment(" - " + metadata.nbSelected() + " 'PE Segmentation thresh=70' rows found in metadata");
                if (metadata.nbSelected() < visits.length) {
                    log.addComment("----------------------------- missing 'PE Segmentation thresh=70' serie(s) in metadata -----------------------------");
                } else if (metadata.nbSelected() > visits.length) {
                    log.addComment("----------------------------- more 'PE Segmentation thresh=70' serie(s) in metadata than visits -----------------------------");
                } else {
                    for (v = 0; v < visits.length; ++v) {
                        row = metadata.FirstSelected();
                        found = false;
                        while (0 <= row && !found) {
                            File serie = new File(patientsdir + "/" + patient + "/" + visits[v].getName() + "/" + metadata.getValueString(row, colserie));
                            if (serie.exists()) {
                                found = true;
                            }
                            serie = null;
                            row = metadata.NextSelected();
                        }
                        if (found) continue;
                        log.addComment("------------------- No 'PE Segmentation thresh=70' serie found in visit " + visits[v].getName() + " -------------------");
                    }
                }
                log.addComment("\n");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Map<String, String> MatchVisitsNames(FichierTabule file, int colpidmeta, String patient) {
        file.SelectWhere(colpidmeta, 0, patient);
        return null;
    }
}

