/*
 * Decompiled with CFR 0.152.
 */
package softwares.cedric;

import arrayTiTi.ArrayFeatures;
import filesAndFolders.FichiersDossiersIHM;
import gui.MailBox;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import init.Initializer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import measures.histogram.Histogram;
import processing.filters.ContrastEqualizer;
import processing.filters.DynamicExpansion;
import utils.strings.StringToolsImageDV;

public class CedricIN
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final double Version = 1.1;
    private String about = "Version 1.1\nAuthor: Guillaume THIBAULT\nWeb: www.thibault.biz\nCopyright (c) 2006-Today\nAll Rights Reserved";
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    private final int CPU = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
    private String currentpath1 = "~/";
    private String currentpath2 = "~/";
    private final ContrastEqualizer ce = new ContrastEqualizer();
    private final DynamicExpansion de = new DynamicExpansion();
    private final Histogram histogram = new Histogram();
    private JTextField BinsTextField;
    private JToggleButton BouttonChercher1;
    private JButton BouttonChercher2;
    private JButton BouttonLancer;
    private JTextField CheminImages;
    private JTextField CheminResultat;
    private JComboBox ChoixAlgo;
    private JTextField FiltreNom;
    private JTextField FiltreType;
    private JLabel LabelAlgorithme;
    private JLabel LabelFiltrerNom;
    private JLabel LabelFiltrerType;
    private JLabel LabelIS;
    private JLabel LabelMax;
    private JLabel LabelMin;
    private JLabel LabelResultats;
    private JMenuItem MenuInfos;
    private JMenuItem MenuQuitter;
    private JTextField PourcentageMax;
    private JTextField PourcentageMin;
    private JTextField RadiusTextField;
    private JTextField SlopeTextField;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLayeredPane jLayeredPane1;
    private JLayeredPane jLayeredPane2;
    private JLayeredPane jLayeredPane3;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;

    public CedricIN() {
        this.initComponents();
    }

    private void initComponents() {
        this.LabelIS = new JLabel();
        this.CheminImages = new JTextField();
        this.BouttonChercher1 = new JToggleButton();
        this.jLayeredPane1 = new JLayeredPane();
        this.LabelFiltrerNom = new JLabel();
        this.LabelFiltrerType = new JLabel();
        this.FiltreNom = new JTextField();
        this.FiltreType = new JTextField();
        this.BouttonLancer = new JButton();
        this.LabelResultats = new JLabel();
        this.CheminResultat = new JTextField();
        this.BouttonChercher2 = new JButton();
        this.ChoixAlgo = new JComboBox();
        this.LabelAlgorithme = new JLabel();
        this.jLayeredPane2 = new JLayeredPane();
        this.jLabel2 = new JLabel();
        this.LabelMin = new JLabel();
        this.LabelMax = new JLabel();
        this.PourcentageMin = new JTextField();
        this.PourcentageMax = new JTextField();
        this.jLayeredPane3 = new JLayeredPane();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.RadiusTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.BinsTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.SlopeTextField = new JTextField();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.MenuQuitter = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.MenuInfos = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("C\u00e9dric Image Normalizer");
        this.LabelIS.setText("Dossier");
        this.CheminImages.setEditable(false);
        this.CheminImages.setToolTipText("");
        this.BouttonChercher1.setText("Chercher");
        this.BouttonChercher1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CedricIN.this.BouttonChercher1ActionPerformed(evt);
            }
        });
        this.jLayeredPane1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.LabelFiltrerNom.setText("Filtrer par nom");
        this.LabelFiltrerType.setText("Filtrer par type");
        GroupLayout jLayeredPane1Layout = new GroupLayout(this.jLayeredPane1);
        this.jLayeredPane1.setLayout(jLayeredPane1Layout);
        jLayeredPane1Layout.setHorizontalGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jLayeredPane1Layout.createSequentialGroup().addContainerGap().addGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.LabelFiltrerNom).addComponent(this.LabelFiltrerType)).addGap(18, 18, 18).addGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.FiltreNom, -2, 171, -2).addComponent(this.FiltreType, -1, 172, Short.MAX_VALUE)).addContainerGap(11, Short.MAX_VALUE)));
        jLayeredPane1Layout.setVerticalGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jLayeredPane1Layout.createSequentialGroup().addContainerGap().addGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelFiltrerNom).addComponent(this.FiltreNom, -2, -1, -2)).addGap(18, 18, 18).addGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelFiltrerType).addComponent(this.FiltreType, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLayeredPane1.setLayer(this.LabelFiltrerNom, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane1.setLayer(this.LabelFiltrerType, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane1.setLayer(this.FiltreNom, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane1.setLayer(this.FiltreType, JLayeredPane.DEFAULT_LAYER);
        this.BouttonLancer.setText("Lancer");
        this.BouttonLancer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CedricIN.this.BouttonLancerActionPerformed(evt);
            }
        });
        this.LabelResultats.setText("R\u00e9sultats");
        this.CheminResultat.setEditable(false);
        this.BouttonChercher2.setText("Chercher");
        this.BouttonChercher2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CedricIN.this.BouttonChercher2ActionPerformed(evt);
            }
        });
        this.ChoixAlgo.setModel(new DefaultComboBoxModel<String>(new String[]{"Etirement", "Etalement classique", "Etalement ImageJ classique", "Etalement ImageJ non classique", "Etalement CLAHE"}));
        this.LabelAlgorithme.setText("Algorithme");
        this.jLayeredPane2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLayeredPane2.setToolTipText("");
        this.jLabel2.setText("Param\u00e8tres \u00e9tirement :");
        this.LabelMin.setText("% Min");
        this.LabelMax.setText("% Max");
        this.PourcentageMin.setText("0");
        this.PourcentageMax.setText("0");
        this.PourcentageMax.setToolTipText("");
        GroupLayout jLayeredPane2Layout = new GroupLayout(this.jLayeredPane2);
        this.jLayeredPane2.setLayout(jLayeredPane2Layout);
        jLayeredPane2Layout.setHorizontalGroup(jLayeredPane2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jLayeredPane2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addGap(24, 24, 24).addComponent(this.LabelMin).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.PourcentageMin, -2, 40, -2).addGap(34, 34, 34).addComponent(this.LabelMax).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.PourcentageMax, -2, 40, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jLayeredPane2Layout.setVerticalGroup(jLayeredPane2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jLayeredPane2Layout.createSequentialGroup().addContainerGap().addGroup(jLayeredPane2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jLayeredPane2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PourcentageMax, -1, -1, -2).addComponent(this.LabelMax)).addGroup(jLayeredPane2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.PourcentageMin, -2, -1, -2).addComponent(this.LabelMin))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLayeredPane2.setLayer(this.jLabel2, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane2.setLayer(this.LabelMin, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane2.setLayer(this.LabelMax, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane2.setLayer(this.PourcentageMin, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane2.setLayer(this.PourcentageMax, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLayeredPane3.setPreferredSize(new Dimension(400, 40));
        this.jLabel3.setText("Param\u00e8tres CLAHE :");
        this.jLabel4.setText("Rayon");
        this.RadiusTextField.setText("256");
        this.jLabel5.setText("Bins");
        this.BinsTextField.setText("256");
        this.BinsTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CedricIN.this.BinsTextFieldActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Pente");
        this.SlopeTextField.setText("5.0");
        this.SlopeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CedricIN.this.SlopeTextFieldActionPerformed(evt);
            }
        });
        GroupLayout jLayeredPane3Layout = new GroupLayout(this.jLayeredPane3);
        this.jLayeredPane3.setLayout(jLayeredPane3Layout);
        jLayeredPane3Layout.setHorizontalGroup(jLayeredPane3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jLayeredPane3Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RadiusTextField, -2, 40, -2).addGap(6, 6, 6).addComponent(this.jLabel5).addGap(6, 6, 6).addComponent(this.BinsTextField, -2, 40, -2).addGap(6, 6, 6).addComponent(this.jLabel6).addGap(6, 6, 6).addComponent(this.SlopeTextField, -2, 40, -2).addContainerGap(15, Short.MAX_VALUE)));
        jLayeredPane3Layout.setVerticalGroup(jLayeredPane3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jLayeredPane3Layout.createSequentialGroup().addGroup(jLayeredPane3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jLayeredPane3Layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel3)).addGroup(jLayeredPane3Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jLayeredPane3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.RadiusTextField, -2, -1, -2).addComponent(this.jLabel4))).addGroup(jLayeredPane3Layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel5)).addGroup(jLayeredPane3Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.BinsTextField, -2, -1, -2)).addGroup(jLayeredPane3Layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel6)).addGroup(jLayeredPane3Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.SlopeTextField, -2, -1, -2))).addGap(6, 6, 6)));
        this.jLayeredPane3.setLayer(this.jLabel3, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setLayer(this.jLabel4, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setLayer(this.RadiusTextField, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setLayer(this.jLabel5, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setLayer(this.BinsTextField, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setLayer(this.jLabel6, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane3.setLayer(this.SlopeTextField, JLayeredPane.DEFAULT_LAYER);
        this.jMenu1.setText("Fichier");
        this.MenuQuitter.setText("Quitter");
        this.MenuQuitter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CedricIN.this.MenuQuitterActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.MenuQuitter);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Aide");
        this.MenuInfos.setText("Infos");
        this.MenuInfos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CedricIN.this.MenuInfosActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.MenuInfos);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.LabelResultats).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CheminResultat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.BouttonChercher2).addGap(16, 16, 16)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.LabelAlgorithme).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ChoixAlgo, -2, 320, -2)).addGroup(layout.createSequentialGroup().addComponent(this.LabelIS).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.CheminImages, -2, 248, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.BouttonChercher1)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLayeredPane3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLayeredPane2, GroupLayout.Alignment.LEADING))).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGap(165, 165, 165).addComponent(this.BouttonLancer).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelIS).addComponent(this.CheminImages, -2, -1, -2).addComponent(this.BouttonChercher1)).addGap(18, 18, 18).addComponent(this.jLayeredPane1, -2, -1, -2).addGap(37, 37, 37).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ChoixAlgo, -2, -1, -2).addComponent(this.LabelAlgorithme)).addGap(18, 18, 18).addComponent(this.jLayeredPane2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLayeredPane3, -2, -1, -2).addGap(34, 34, 34).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelResultats).addComponent(this.CheminResultat, -2, -1, -2).addComponent(this.BouttonChercher2)).addGap(18, 18, 18).addComponent(this.BouttonLancer).addContainerGap()));
        this.jLayeredPane3.getAccessibleContext().setAccessibleDescription("");
        this.pack();
    }

    private void BouttonChercher1ActionPerformed(ActionEvent evt) {
        File file = FichiersDossiersIHM.ChoisirDossier(this.currentpath1, false);
        if (file == null) {
            return;
        }
        this.currentpath1 = file.getAbsolutePath();
        this.CheminImages.setText(file.getAbsolutePath());
        this.CheminImages.repaint();
    }

    private void BouttonLancerActionPerformed(ActionEvent evt) {
        if (this.CheminImages.getText() == null || this.CheminImages.getText().equalsIgnoreCase("")) {
            new MailBox(0, "Merci de s\u00e9lectionner le dossier contenant les images !\n(Andouille 1)", "Erreur");
            return;
        }
        if (this.CheminImages.getText() == null || this.CheminImages.getText().equalsIgnoreCase("")) {
            new MailBox(0, "Merci de s\u00e9lectionner le dossier r\u00e9sultat !\n(Andouille 2)", "Erreur");
            return;
        }
        double min = 0.0;
        double max = 0.0;
        if (this.ChoixAlgo.getSelectedIndex() == 0) {
            block36: {
                try {
                    min = Double.valueOf(this.PourcentageMin.getText());
                    max = Double.valueOf(this.PourcentageMax.getText());
                }
                catch (Exception ex) {
                    if (this.CheminImages.getText() != null && !this.CheminImages.getText().equalsIgnoreCase("")) break block36;
                    new MailBox(0, "Nombre flotant attendu dans % min/max !\n(Andouille 3)", "Erreur");
                    return;
                }
            }
            if (min < 0.0 || 100.0 <= min || max < 0.0 || 100.0 <= max || 100.0 <= min + max) {
                new MailBox(0, "Valeur(s) incorrecte(s) dans % min/max !\n(Andouille 4)", "Erreur");
                return;
            }
        }
        if (this.ChoixAlgo.getSelectedIndex() == 4) {
            try {
                this.ce.WindowRadius(Integer.valueOf(this.RadiusTextField.getText()));
                this.ce.Bins(Integer.valueOf(this.BinsTextField.getText()));
                this.ce.Slope(Float.valueOf(this.SlopeTextField.getText()).floatValue());
            }
            catch (Exception ex) {
                new MailBox(0, "CLAHE param\u00e8tres incorrectes !\n1 < Rayon, 2 <= Bins <= 256, 1 < Pente\n(Andouille 5)", "Erreur");
                return;
            }
        }
        File[] files = null;
        files = this.FiltreNom.getText() == null || this.FiltreNom.getText().equalsIgnoreCase("") ? (this.FiltreType.getText() == null || this.FiltreType.getText().equalsIgnoreCase("") ? new File(this.CheminImages.getText()).listFiles((dir, name1) -> name1.charAt(0) != '.') : new File(this.CheminImages.getText()).listFiles((dir, name1) -> name1.charAt(0) != '.' && name1.endsWith(this.FiltreType.getText()))) : (this.FiltreType.getText() == null || this.FiltreType.getText().equalsIgnoreCase("") ? new File(this.CheminImages.getText()).listFiles((dir, name1) -> name1.charAt(0) != '.' && name1.contains(this.FiltreNom.getText())) : new File(this.CheminImages.getText()).listFiles((dir, name1) -> name1.charAt(0) != '.' && name1.endsWith(this.FiltreType.getText()) && name1.contains(this.FiltreNom.getText())));
        if (files == null || files.length == 0) {
            new MailBox(0, "Aucune image trouv\u00e9e !\nV\u00e9rifier le chemin et les filtres (si n\u00e9cessaire)\n(Andouille 6)", "Erreur");
            return;
        }
        double[] avebefore = new double[files.length];
        double[] aveafter = new double[files.length];
        for (int f = 0; f < files.length; ++f) {
            try {
                String name = StringToolsImageDV.DeleteExtension((String)files[f].getName());
                BufferedImage image = ImageIO.Read(files[f]);
                BufferedImage result = null;
                switch (this.ChoixAlgo.getSelectedIndex()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        result = image;
                        break;
                    }
                    case 4: {
                        result = ImageNew.Same((BufferedImage)image);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Default: Algorithme inconnu !!! Must not occur.");
                    }
                }
                int imin = -1;
                int imax = 0;
                switch (image.getType()) {
                    case 13: {
                        image = ImageConverter.Universal((BufferedImage)image, (int)10);
                    }
                    case 10: {
                        imax = 256;
                        break;
                    }
                    case 11: {
                        imax = 65536;
                        break;
                    }
                    default: {
                        new MailBox(0, "Image non support\u00e9e !", "Erreur");
                        return;
                    }
                }
                avebefore[f] = this.IF.Average(image);
                int nbpixels = image.getWidth() * image.getHeight();
                if (this.ChoixAlgo.getSelectedIndex() == 0 && 0.0 < min || 0.0 < max) {
                    this.histogram.Fill(image);
                    int[] hist = this.histogram.getValues(0);
                    int minsum = 0;
                    while ((double)(minsum += hist[++imin]) / (double)nbpixels * 100.0 < min) {
                    }
                    int maxsum = 0;
                    while ((double)(maxsum += hist[--imax]) / (double)nbpixels * 100.0 < max) {
                    }
                    ImageComparator.Compare((BufferedImage)image, (String)">=", (int)imin, (BufferedImage)image, (int)imin, (BufferedImage)image);
                    ImageComparator.Compare((BufferedImage)image, (String)"<=", (int)imax, (BufferedImage)image, (int)imax, (BufferedImage)image);
                }
                block12 : switch (this.ChoixAlgo.getSelectedIndex()) {
                    case 0: {
                        switch (image.getType()) {
                            case 10: {
                                this.de.Filter(image, 0, 255, image, this.CPU);
                                break block12;
                            }
                            case 11: {
                                this.de.Filter(image, 0, 65535, image, this.CPU);
                                break block12;
                            }
                        }
                        new MailBox(0, "Image non support\u00e9e !", "Erreur");
                        return;
                    }
                    case 1: {
                        this.ce.Filter(image, ContrastEqualizer.Equalization.Classic, result, this.CPU);
                        break;
                    }
                    case 2: {
                        this.ce.Filter(image, ContrastEqualizer.Equalization.Mode1, result, this.CPU);
                        break;
                    }
                    case 3: {
                        this.ce.Filter(image, ContrastEqualizer.Equalization.Mode2, result, this.CPU);
                        break;
                    }
                    case 4: {
                        this.ce.Filter(image, ContrastEqualizer.Equalization.CLAHE, result, this.CPU);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Default: Algorithme inconnu !!! Must not occur.");
                    }
                }
                aveafter[f] = this.IF.Average(result);
                ImageIO.Write(result, this.CheminResultat.getText() + "/" + name + ".png", 6);
                name = null;
                result = null;
                image = null;
                continue;
            }
            catch (Error | Exception ex) {
                new MailBox(0, "Probl\u00e8me avec l'image :\n" + files[f].getAbsolutePath() + "\n" + ex.getMessage(), "Erreur");
                return;
            }
        }
        this.AF.Moments(avebefore);
        double sdbefore = this.AF.StandardDeviation();
        this.AF.Moments(aveafter);
        double sdafter = this.AF.StandardDeviation();
        new MailBox(0, "Op\u00e9rations termin\u00e9es avec succ\u00e8s sur " + files.length + " images.\nEcart types :\n- Avant = " + sdbefore + "\n- Apr\u00e8s = " + sdafter, "Fin & Succ\u00e8s");
    }

    private void MenuQuitterActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void MenuInfosActionPerformed(ActionEvent evt) {
        new MailBox(0, this.about, "A propos");
    }

    private void BouttonChercher2ActionPerformed(ActionEvent evt) {
        File file = FichiersDossiersIHM.ChoisirDossier(this.currentpath2, false);
        if (file == null) {
            return;
        }
        this.currentpath2 = file.getAbsolutePath();
        this.CheminResultat.setText(file.getAbsolutePath());
        this.CheminResultat.repaint();
    }

    private void BinsTextFieldActionPerformed(ActionEvent evt) {
    }

    private void SlopeTextFieldActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        Initializer.Start();
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(CedricIN.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> new CedricIN().setVisible(true));
    }
}

