/*
 * Decompiled with CFR 0.152.
 */
package softwares;

import filesAndFolders.FileFilters;
import filesAndFolders.FilesFolders;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import measures.cclh.UnionFindCcl;

public class SortKaggle {
    private final ImageFeatures imfeatures = new ImageFeatures();

    public void Basic_Sort(String InputDir, String OutputDir) {
        File[] dirs;
        File HE = new File(OutputDir + "/H&E/");
        File IF = new File(OutputDir + "/IF/");
        File BR = new File(OutputDir + "/Bright/");
        for (File dir : dirs = new File(InputDir).listFiles(FileFilters.Directories)) {
            try {
                BufferedImage im = ImageIO.Read(dir.getAbsolutePath() + "/images/" + dir.getName() + ".png");
                BufferedImage c1 = ImageConverter.Channel((BufferedImage)im, (int)1);
                BufferedImage c2 = ImageConverter.Channel((BufferedImage)im, (int)2);
                if (!ImageTools.areEqual((BufferedImage)c1, (BufferedImage)c2)) {
                    FilesFolders.MoveFolder(dir, new File(HE.getAbsolutePath()));
                    continue;
                }
                if (this.imfeatures.Average(c1) < 128.0) {
                    FilesFolders.MoveFolder(dir, new File(IF.getAbsolutePath()));
                    continue;
                }
                FilesFolders.MoveFolder(dir, new File(BR.getAbsolutePath()));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void IF(String InputDir, String OutputDir) {
        File out;
        File in = new File(OutputDir + "/In/");
        if (!in.exists()) {
            in.mkdirs();
        }
        if (!(out = new File(OutputDir + "/GT/")).exists()) {
            out.mkdirs();
        }
        Object[] dirs = new File(InputDir).listFiles(FileFilters.Directories);
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            try {
                BufferedImage im = ImageIO.Read(((File)dir).getAbsolutePath() + "/images/" + ((File)dir).getName() + ".png");
                BufferedImage c2 = ImageConverter.Channel((BufferedImage)im, (int)2);
                ImageIO.Write(c2, in.getAbsolutePath() + "/" + ((File)dir).getName() + ".png", 6);
                BufferedImage labels = ImageNew.Integer((int)im.getWidth(), (int)im.getHeight(), (int)1);
                Object[] masks = new File(((File)dir).getAbsolutePath() + "/masks/").listFiles(FileFilters.ImagesPNG);
                Arrays.sort(masks);
                for (int i2 = 0; i2 < masks.length; ++i2) {
                    BufferedImage mask = ImageIO.Read((File)masks[i2]);
                    ImageComparator.Compare((BufferedImage)mask, (String)"==", (int)0, (BufferedImage)labels, (int)(i2 + 1), (BufferedImage)labels);
                }
                ImageIO.Write(labels, out.getAbsolutePath() + "/" + ((File)dir).getName() + ".tif", 8);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void Size_Sort(String InputDir, String OutputDir) throws Exception {
        File[] images;
        File out256 = new File(OutputDir + "/256x256/");
        new File(out256.getAbsolutePath() + "/In/").mkdirs();
        new File(out256.getAbsolutePath() + "/GT/").mkdirs();
        File out360 = new File(OutputDir + "/360x360/");
        new File(out360.getAbsolutePath() + "/In/").mkdirs();
        new File(out360.getAbsolutePath() + "/GT/").mkdirs();
        File out640 = new File(OutputDir + "/650x512/");
        new File(out640.getAbsolutePath() + "/In/").mkdirs();
        new File(out640.getAbsolutePath() + "/GT/").mkdirs();
        File out696 = new File(OutputDir + "/696x520/");
        new File(out696.getAbsolutePath() + "/In/").mkdirs();
        new File(out696.getAbsolutePath() + "/GT/").mkdirs();
        File out1272 = new File(OutputDir + "/1272x603/");
        new File(out1272.getAbsolutePath() + "/In/").mkdirs();
        new File(out1272.getAbsolutePath() + "/GT/").mkdirs();
        File out = new File(OutputDir + "/?x?/");
        new File(out.getAbsolutePath() + "/In/").mkdirs();
        new File(out.getAbsolutePath() + "/GT/").mkdirs();
        UnionFindCcl ccl = new UnionFindCcl();
        for (File image : images = new File(InputDir + "/In/").listFiles(FileFilters.ImagesPNG)) {
            try {
                BufferedImage im = ImageIO.Read(image);
                BufferedImage gt = ImageIO.Read(InputDir + "/GT/" + image.getName().replace(".png", ".tif"));
                block1 : switch (gt.getType()) {
                    case 0: {
                        switch (gt.getRaster().getDataBuffer().getDataType()) {
                            case 3: {
                                break block1;
                            }
                        }
                        throw new Exception("Different GT encoding");
                    }
                    default: {
                        throw new Exception("Different GT encoding");
                    }
                }
                ccl.Label(gt, 0, false);
                System.arraycopy(ccl.Labels1D(), 0, ((DataBufferInt)gt.getRaster().getDataBuffer()).getData(), 0, ccl.Labels1D().length);
                String name = image.getName().substring(0, image.getName().length() - 4);
                switch (im.getWidth()) {
                    case 256: {
                        if (im.getHeight() == 256) {
                            FilesFolders.CopyFile(image, new File(out256.getAbsolutePath() + "/In/"));
                            ImageIO.SaveLabels(gt, out256.getAbsolutePath() + "/GT/" + name);
                            break;
                        }
                        FilesFolders.CopyFile(image, new File(out.getAbsolutePath() + "/In/"));
                        ImageIO.SaveLabels(gt, out.getAbsolutePath() + "/GT/" + name);
                        break;
                    }
                    case 360: {
                        if (im.getHeight() == 360) {
                            FilesFolders.CopyFile(image, new File(out360.getAbsolutePath() + "/In/"));
                            ImageIO.SaveLabels(gt, out360.getAbsolutePath() + "/GT/" + name);
                            break;
                        }
                        FilesFolders.CopyFile(image, new File(out.getAbsolutePath() + "/In/"));
                        ImageIO.SaveLabels(gt, out.getAbsolutePath() + "/GT/" + name);
                        break;
                    }
                    case 640: {
                        if (im.getHeight() == 512) {
                            FilesFolders.CopyFile(image, new File(out640.getAbsolutePath() + "/In/"));
                            ImageIO.SaveLabels(gt, out640.getAbsolutePath() + "/GT/" + name);
                            break;
                        }
                        FilesFolders.CopyFile(image, new File(out.getAbsolutePath() + "/In/"));
                        ImageIO.SaveLabels(gt, out.getAbsolutePath() + "/GT/" + name);
                        break;
                    }
                    case 696: {
                        if (im.getHeight() == 520) {
                            FilesFolders.CopyFile(image, new File(out696.getAbsolutePath() + "/In/"));
                            ImageIO.SaveLabels(gt, out696.getAbsolutePath() + "/GT/" + name);
                            break;
                        }
                        FilesFolders.CopyFile(image, new File(out.getAbsolutePath() + "/In/"));
                        ImageIO.SaveLabels(gt, out.getAbsolutePath() + "/GT/" + name);
                        break;
                    }
                    case 1272: {
                        if (im.getHeight() == 603) {
                            FilesFolders.CopyFile(image, new File(out1272.getAbsolutePath() + "/In/"));
                            ImageIO.SaveLabels(gt, out1272.getAbsolutePath() + "/GT/" + name);
                            break;
                        }
                        FilesFolders.CopyFile(image, new File(out.getAbsolutePath() + "/In/"));
                        ImageIO.SaveLabels(gt, out.getAbsolutePath() + "/GT/" + name);
                        break;
                    }
                    default: {
                        FilesFolders.CopyFile(image, new File(out.getAbsolutePath() + "/In/"));
                        ImageIO.SaveLabels(gt, out.getAbsolutePath() + "/GT/" + name);
                        break;
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

