/*
 * Decompiled with CFR 0.152.
 */
package softwares;

import filesAndFolders.FileNameFilters;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import measures.cclh.UnionFindCcl;
import processing.filters.DynamicExpansion;

public class SortBroad {
    private final DynamicExpansion dynexp = new DynamicExpansion();
    private final UnionFindCcl ccl = new UnionFindCcl();

    public void Images(String InputDir, String OutputDir) {
        File[] images;
        File out = new File(OutputDir);
        if (!out.exists()) {
            out.mkdirs();
        }
        for (File image : images = new File(InputDir).listFiles(FileNameFilters.ImagesTIF)) {
            try {
                BufferedImage im = ImageIO.Read(image);
                BufferedImage stretched = this.dynexp.FilterWithConditions(im, 1.0, 0.05, -1, 0, 65535, 1);
                ImageIO.Write(stretched, OutputDir + "/" + image.getName().replace(".tif", ".png"), 6);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void Masks(String InputDir, int Threshold, String OutputDir) {
        File[] images;
        File out = new File(OutputDir);
        if (!out.exists()) {
            out.mkdirs();
        }
        ImageFeatures IF = new ImageFeatures();
        for (File image : images = new File(InputDir).listFiles(FileNameFilters.ImagesPNG)) {
            try {
                BufferedImage im = ImageIO.Read(image);
                im = ImageConverter.Channel((BufferedImage)im, (int)3);
                System.out.println("is White = " + ImageTools.isWhite((BufferedImage)im) + " => " + (int)IF.Maximum(im));
                this.ccl.Label(im, 0, false);
                this.ccl.DeleteSmallerThan(Threshold);
                BufferedImage labels = ImageNew.Integer((int)im.getWidth(), (int)im.getHeight(), (int)1, (int[])this.ccl.Labels1D());
                ImageIO.SaveLabels(labels, OutputDir + "/" + image.getName().replace(".png", ""));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

