/*
 * Decompiled with CFR 0.152.
 */
package softwares;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayOperations;
import dv.DV;
import dv.DvIO;
import dv.DvNew;
import dv.DvOperations;
import filesAndFolders.FileFilters;
import filesAndFolders.FileNameFilters;
import filesAndFolders.FilesFolders;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import imageTiTi.ImageTransformations;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListTools;
import mathematics.Maths;
import mathematics.functions.Sigmoid;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceMapComputer;
import morphee.Dilate;
import morphee.Erode;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.geodesic.UnderBuild;
import morphee.segmentation.Skiz;
import processing.filters.DynamicExpansion;
import processing.filters.Gaussian;
import processing.filters.Invert;
import processing.filters.Median;
import stackTiTi.StackIO;
import stackTiTi.StackNew;
import stackTiTi.StackOperations;
import stackTiTi.StackTools;
import utils.memory.Allocator;
import utils.strings.IntGenerator;
import utils.strings.StringToolsImageDV;

public class GenerateNNtraining {
    private final Allocator allocator = Allocator.Instance();
    private final Dilate dilate = new Dilate();
    private final Erode erode = new Erode();
    private final Skiz skiz = new Skiz();
    private final UnderBuild ub = new UnderBuild();
    private final StructuringElement sedisk1 = new StructuringElement(new Object[]{1, -2});
    private final StructuringElement sesquare2 = new StructuringElement(new Object[]{2, -1});
    private final StructuringElement sem2 = new StructuringElement(new Object[]{2, -15});
    private final ArrayFeatures AF = new ArrayFeatures();
    private final DistanceMapComputer dmc = new DistanceMapComputer();
    private final DynamicExpansion dynexp = new DynamicExpansion();
    private final FillHole fh = new FillHole();
    private final ImageFeatures IF = new ImageFeatures();
    private final Invert invert = new Invert();
    private final UnionFindCcl ufccl = new UnionFindCcl();
    private final FilenameFilter ImagesMasks = (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && (name.endsWith("-Mask.png") || name.endsWith("-Mask.PNG"));
    private final FilenameFilter ImagesDapi = (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.endsWith("- DAPI.png");
    private final FilenameFilter CytoCrops = (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.startsWith("Crop_") && name.endsWith(".tif");

    public void Generate2DfromEM(String originalsdir, String markersdir, int windowsize, int shakersize, boolean estimate, String resultdir) {
        File[] markers;
        File resblue;
        File resred = new File(resultdir + "/red/");
        if (!resred.exists()) {
            resred.mkdirs();
        }
        if (!(resblue = new File(resultdir + "/blue/")).exists()) {
            resblue.mkdirs();
        }
        int ws = windowsize >> 1;
        int nbred = 0;
        int nbblue = 0;
        File res = null;
        for (File marker1 : markers = new File(markersdir).listFiles(FileNameFilters.ImagesPNGorTIF)) {
            try {
                BufferedImage image = ImageIO.Read(originalsdir + "/" + marker1.getName());
                BufferedImage marker = ImageIO.Read(marker1);
                byte[] bb = ((DataBufferByte)marker.getRaster().getDataBuffer()).getData();
                int width = marker.getWidth();
                int height = marker.getHeight();
                int endx = width - ws;
                int endy = height - ws;
                String name = StringToolsImageDV.DeleteExtension((String)marker1.getName());
                switch (marker.getType()) {
                    case 5: {
                        int xx;
                        int yy;
                        String respath;
                        int pos;
                        int x;
                        int y;
                        for (y = ws; y < endy; ++y) {
                            x = ws;
                            pos = (y * width + x) * 3;
                            while (x < endx) {
                                if (bb[pos] != bb[pos + 2]) {
                                    if (bb[pos] == -1 && bb[pos + 2] == 0) {
                                        res = resblue;
                                        ++nbblue;
                                    } else if (bb[pos + 2] == -1 && bb[pos] == 0) {
                                        res = resred;
                                        ++nbred;
                                    } else {
                                        System.err.println((bb[pos] & 0xFF) + " vs " + (bb[pos + 2] & 0xFF));
                                        System.err.println(x + " x " + y);
                                        throw new IllegalStateException("Must not occur.");
                                    }
                                    if (!estimate) {
                                        respath = res.getAbsolutePath() + "/" + name;
                                        for (yy = -shakersize; yy <= shakersize; ++yy) {
                                            for (xx = -shakersize; xx <= shakersize; ++xx) {
                                                if (0 <= x + xx - ws && x + xx + ws < width && 0 <= y + yy - ws && y + yy + ws >= height) continue;
                                            }
                                        }
                                    }
                                }
                                ++x;
                                pos += 3;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int xx;
                        int yy;
                        String respath;
                        int pos;
                        int x;
                        int y;
                        for (y = ws; y < endy; ++y) {
                            x = ws;
                            pos = (y * width + x) * 4;
                            while (x < endx) {
                                if (bb[pos + 1] != bb[pos + 3]) {
                                    if (bb[pos + 1] == -1 && bb[pos + 3] == 0) {
                                        res = resblue;
                                        ++nbblue;
                                    } else if (bb[pos + 3] == -1 && bb[pos + 1] == 0) {
                                        res = resred;
                                        ++nbred;
                                    } else {
                                        System.err.println((bb[pos + 1] & 0xFF) + " vs " + (bb[pos + 3] & 0xFF));
                                        System.err.println(x + " x " + y);
                                        throw new IllegalStateException("Must not occur.");
                                    }
                                    if (!estimate) {
                                        respath = res.getAbsolutePath() + "/" + name;
                                        for (yy = -shakersize; yy <= shakersize; ++yy) {
                                            for (xx = -shakersize; xx <= shakersize; ++xx) {
                                                if (0 <= x + xx - ws && x + xx + ws < width && 0 <= y + yy - ws && y + yy + ws >= height) continue;
                                            }
                                        }
                                    }
                                }
                                ++x;
                                pos += 4;
                            }
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Image type not supported.");
                    }
                }
                name = null;
                marker = null;
                image = null;
                bb = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("red = " + nbred + ", blue = " + nbblue);
    }

    public void Generate2DFromAmira(String originalsdir, String markersdir, int redvalue, int bluevalue, int windowsize, int shakersize, boolean estimate, String resultdir) {
        File[] markers;
        File resblue;
        File resred = new File(resultdir + "/red/");
        if (!resred.exists()) {
            resred.mkdirs();
        }
        if (!(resblue = new File(resultdir + "/blue/")).exists()) {
            resblue.mkdirs();
        }
        int ws = windowsize >> 1;
        int nbred = 0;
        int nbblue = 0;
        File res = null;
        for (File marker1 : markers = new File(markersdir).listFiles(FileNameFilters.ImagesPNGorTIF)) {
            try {
                BufferedImage image = null;
                if (!estimate) {
                    image = ImageIO.Read(originalsdir + "/" + marker1.getName().replace("---012.Labels", " - "));
                }
                BufferedImage marker = ImageIO.Read(marker1);
                byte[] bb = ((DataBufferByte)marker.getRaster().getDataBuffer()).getData();
                int width = marker.getWidth();
                int height = marker.getHeight();
                int endx = width - ws;
                int endy = height - ws;
                String name = StringToolsImageDV.DeleteExtension((String)marker1.getName());
                switch (marker.getType()) {
                    case 13: {
                        marker = ImageConverter.Universal((BufferedImage)marker, (int)10);
                    }
                    case 10: {
                        for (int y = ws; y < endy; ++y) {
                            int x = ws;
                            int pos = y * width + x;
                            while (x < endx) {
                                if (bb[pos] != 0) {
                                    if ((bb[pos] & 0xFF) == bluevalue) {
                                        res = resblue;
                                        ++nbblue;
                                    } else if ((bb[pos] & 0xFF) == redvalue) {
                                        res = resred;
                                        ++nbred;
                                    } else {
                                        System.err.println(bb[pos] & 0xFF);
                                        System.err.println(x + " x " + y);
                                        throw new IllegalStateException("Must not occur.");
                                    }
                                    if (!estimate) {
                                        String respath = res.getAbsolutePath() + "/" + name;
                                        for (int yy = -shakersize; yy <= shakersize; ++yy) {
                                            for (int xx = -shakersize; xx <= shakersize; ++xx) {
                                                if (0 <= x + xx - ws && x + xx + ws < width && 0 <= y + yy - ws && y + yy + ws >= height) continue;
                                            }
                                        }
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Image type not supported.");
                    }
                }
                name = null;
                marker = null;
                image = null;
                bb = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("red = " + nbred + ", blue = " + nbblue);
    }

    private void Rotate2D(BufferedImage patch, String name) throws IOException {
        BufferedImage sub90 = ImageTransformations.Rotate90(patch);
        BufferedImage sub180 = ImageTransformations.Rotate180(patch);
        BufferedImage sub270 = ImageTransformations.Rotate270(patch);
        ImageIO.Write(sub90, name + "_r90.png", 6);
        ImageIO.Write(sub180, name + "_r180.png", 6);
        ImageIO.Write(sub270, name + "_r270.png", 6);
        sub270 = null;
        sub180 = null;
        sub90 = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void Generate3DFromAmira(String originalsdir, String markersdir, int class0value, int class1value, int windowsize, boolean simulate, int start, int end, String resultdir) {
        File resclass1;
        File resclass0;
        File file = resclass0 = simulate ? null : new File(resultdir + "/Class0/");
        if (!simulate && !resclass0.exists()) {
            resclass0.mkdirs();
        }
        File file2 = resclass1 = simulate ? null : new File(resultdir + "/Class1/");
        if (!simulate && !resclass1.exists()) {
            resclass1.mkdirs();
        }
        int ws = windowsize >> 1;
        int nbclass0 = 0;
        int nbclass1 = 0;
        int nbothers = 0;
        File res = null;
        Object[] originals = new File(originalsdir).listFiles(FileNameFilters.ImagesPNGorTIF);
        Arrays.sort(originals);
        File[] stackfiles = new File[windowsize];
        BufferedImage[] stack = StackNew.New(windowsize, windowsize, windowsize, 10);
        Object[] imseq = null;
        StringBuilder sb = new StringBuilder(1000);
        Object[] markers = new File(markersdir).listFiles(FileNameFilters.ImagesPNGorTIF);
        Arrays.sort(markers);
        if (markers.length != originals.length) {
            throw new IllegalArgumentException("markers.length != originals.length");
        }
        int from = Math.max(ws, start);
        int to = Math.min(markers.length - ws, end);
        int m = from;
        while (true) {
            if (m >= to) {
                System.out.println(sb.toString());
                System.out.println("Total Class 0 = " + nbclass0);
                System.out.println("Total Class 1 = " + nbclass1);
                System.out.println("Total Others  = " + nbothers);
                return;
            }
            try {
                BufferedImage marker = ImageIO.Read((File)markers[m]);
                if (!ImageTools.isBlack((BufferedImage)marker)) {
                    byte[] bb = ((DataBufferByte)marker.getRaster().getDataBuffer()).getData();
                    int width = marker.getWidth();
                    int height = marker.getHeight();
                    int endx = width - ws;
                    int endy = height - ws;
                    String name = StringToolsImageDV.DeleteExtension((String)((File)markers[m]).getName());
                    System.arraycopy(originals, m - ws, stackfiles, 0, windowsize);
                    switch (marker.getType()) {
                        case 13: {
                            marker = ImageConverter.Universal((BufferedImage)marker, (int)10);
                        }
                        case 10: {
                            for (int y = ws; y < endy; ++y) {
                                int x;
                                int pos = y * width + x;
                                for (x = ws; x < endx; ++x, ++pos) {
                                    if (bb[pos] == 0) continue;
                                    if ((bb[pos] & 0xFF) == class1value) {
                                        res = resclass1;
                                        ++nbclass1;
                                    } else if ((bb[pos] & 0xFF) == class0value) {
                                        res = resclass0;
                                        ++nbclass0;
                                    } else {
                                        ++nbothers;
                                        continue;
                                    }
                                    if (simulate) continue;
                                    if (imseq == null) {
                                        imseq = StackIO.ReadImageSequence(stackfiles);
                                        for (int i2 = 0; i2 < imseq.length; ++i2) {
                                            if (((BufferedImage)imseq[i2]).getType() != 13) continue;
                                            imseq[i2] = ImageConverter.Universal((BufferedImage)imseq[i2], (int)10);
                                        }
                                    }
                                    StackNew.SubStackWHD((BufferedImage[])imseq, x - ws, y - ws, 0, windowsize, windowsize, windowsize, stack);
                                    String respath = res.getAbsolutePath() + "/" + name + "_" + x + "x" + y + "/";
                                    File resfile = new File(respath);
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence(stack, resfile.getAbsolutePath(), "", 6);
                                    respath = null;
                                    resfile = null;
                                }
                            }
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Image type not supported.");
                        }
                    }
                    sb.append(((File)markers[m]).getName()).append(": ");
                    sb.append("Class 0 = ").append(nbclass0).append(", Class 1 = ").append(nbclass1).append(", Others = ").append(nbothers);
                    sb.append("\n");
                    name = null;
                    marker = null;
                    bb = null;
                    if (!simulate) {
                        Arrays.fill(imseq, null);
                    }
                    imseq = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++m;
        }
    }

    public void Generate3D_VolumeToVolume(String inputdir, String outputdir, int crop, int volumesize, boolean simulate, int start, int end, boolean binarize, boolean testpositive, String prefix, String resultdir) {
        File resoutput;
        File resinput;
        File file = resinput = simulate ? null : new File(resultdir + "/Inputs/");
        if (!simulate && !resinput.exists()) {
            resinput.mkdirs();
        }
        File file2 = resoutput = simulate ? null : new File(resultdir + "/Outputs/");
        if (!simulate && !resoutput.exists()) {
            resoutput.mkdirs();
        }
        Object[] inputs = new File(inputdir).listFiles(FileNameFilters.ImagesPNGorTIF);
        Arrays.sort(inputs);
        Object[] outputs = new File(outputdir).listFiles(FileNameFilters.ImagesPNGorTIF);
        Arrays.sort(outputs);
        if (inputs.length != outputs.length) {
            throw new IllegalArgumentException("inputs.length != outputs.length");
        }
        Object[] stack = StackNew.New(volumesize, volumesize, volumesize, 10);
        int nbvolumes = 0;
        int from = Math.max(0, start);
        int to = Math.min(end, inputs.length);
        int m = from;
        while (m + volumesize <= to) {
            try {
                Object[] imin = StackIO.ReadImageSequence((File[])Arrays.copyOfRange(inputs, m, m + volumesize));
                Object[] imout = StackIO.ReadImageSequence((File[])Arrays.copyOfRange(outputs, m, m + volumesize));
                if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)imin[0], (BufferedImage)imout[0])) {
                    throw new IllegalStateException("Images in and out have different types or dimensions.");
                }
                int width = imin[0].getWidth();
                int height = imin[0].getHeight();
                int endx = width - crop;
                int endy = height - crop;
                int y = crop;
                while (y + volumesize <= endy) {
                    int x = crop;
                    while (x + volumesize <= endx) {
                        String name = prefix + "_x" + x + "_y" + y + "_z" + m;
                        if (!simulate) {
                            String respath;
                            File resfile;
                            StackNew.SubStackWHD((BufferedImage[])imout, x, y, 0, volumesize, volumesize, volumesize, (BufferedImage[])stack);
                            if (binarize) {
                                for (Object stack1 : stack) {
                                    ImageComparator.Compare((BufferedImage)stack1, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)stack1);
                                }
                            }
                            String add = "";
                            if (testpositive && !StackTools.isBlack((BufferedImage[])stack)) {
                                add = "+";
                            }
                            if (!(resfile = new File(respath = resoutput.getAbsolutePath() + "/" + name + add)).exists()) {
                                resfile.mkdirs();
                            }
                            StackIO.WriteImageSequence((BufferedImage[])stack, resfile.getAbsolutePath(), "", 6);
                            respath = null;
                            resfile = null;
                            StackNew.SubStackWHD((BufferedImage[])imin, x, y, 0, volumesize, volumesize, volumesize, (BufferedImage[])stack);
                            respath = resinput.getAbsolutePath() + "/" + name + add;
                            resfile = new File(respath);
                            if (!resfile.exists()) {
                                resfile.mkdirs();
                            }
                            StackIO.WriteImageSequence((BufferedImage[])stack, resfile.getAbsolutePath(), "", 6);
                            respath = null;
                            resfile = null;
                        }
                        name = null;
                        ++nbvolumes;
                        x += volumesize;
                    }
                    y += volumesize;
                }
                Arrays.fill(imin, null);
                Arrays.fill(imout, null);
                imout = null;
                imin = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
            m += volumesize;
        }
        Arrays.fill(stack, null);
        stack = null;
        Arrays.fill(inputs, null);
        inputs = null;
        Arrays.fill(outputs, null);
        outputs = null;
        resoutput = null;
        resinput = null;
        System.out.println(nbvolumes + " volumes.");
    }

    public void Generate3DfromEM(String originalsdir, String markersdir, int windowsize, String resultdir) {
        File[] markers;
        int y;
        File resblue;
        File resred = new File(resultdir + "/red/");
        if (!resred.exists()) {
            resred.mkdirs();
        }
        if (!(resblue = new File(resultdir + "/blue/")).exists()) {
            resblue.mkdirs();
        }
        int wr = windowsize >> 1;
        File resroot = null;
        File resfile = null;
        File[] stackfiles = new File[windowsize];
        File[] originals = new File(originalsdir).listFiles(FileNameFilters.ImagesPNGorTIF);
        ArrayList<String> orinames = new ArrayList<String>(originals.length);
        for (y = 0; y < originals.length; ++y) {
            orinames.add(originals[y].getName());
        }
        for (File marker1 : markers = new File(markersdir).listFiles(FileNameFilters.ImagesPNGorTIF)) {
            try {
                int posim = ListTools.PositionInList(orinames, (String)marker1.getName());
                if (posim < wr || originals.length - wr <= posim) {
                    System.out.flush();
                    System.err.println("Marker image too close from the stack begining/end.");
                    System.err.flush();
                    continue;
                }
                BufferedImage marker = ImageIO.Read(marker1);
                byte[] bb = ((DataBufferByte)marker.getRaster().getDataBuffer()).getData();
                System.arraycopy(originals, posim - wr, stackfiles, 0, windowsize);
                Object[] imseq = StackIO.ReadImageSequence(stackfiles);
                int width = marker.getWidth();
                int height = marker.getHeight();
                int endx = width - wr;
                int endy = height - wr;
                String name = StringToolsImageDV.DeleteExtension((String)marker1.getName());
                switch (marker.getType()) {
                    case 5: {
                        String resname;
                        int pos;
                        int x;
                        Object[] stack = StackNew.New(windowsize, windowsize, windowsize, 10);
                        Object[] stackrot = StackNew.New(windowsize, windowsize, windowsize, 10);
                        for (y = wr; y < endy; ++y) {
                            x = wr;
                            pos = (y * width + x) * 3;
                            while (x < endx) {
                                if (bb[pos] != bb[pos + 2]) {
                                    if ((bb[pos] & 0xFF) == 255 && bb[pos + 2] == 0) {
                                        resroot = resblue;
                                    } else if ((bb[pos + 2] & 0xFF) == 255 && bb[pos] == 0) {
                                        resroot = resred;
                                    } else {
                                        System.err.println((bb[pos] & 0xFF) + " vs " + (bb[pos + 2] & 0xFF));
                                        System.err.println(x + " x " + y);
                                        throw new IllegalStateException("Must not occur.");
                                    }
                                    resname = resroot.getAbsolutePath() + "/" + name + "_" + x + "x" + y + "x" + posim;
                                    StackNew.SubStackWHD((BufferedImage[])imseq, x - wr, y - wr, 0, windowsize, windowsize, windowsize, (BufferedImage[])stack);
                                    resfile = new File(resname);
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stack, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateX090((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_X090");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateX180((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_X180");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateX270((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_X270");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateY090((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_Y090");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateY180((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_Y180");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateY270((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_Y270");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateZ090((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_Z090");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateZ180((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_Z180");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateZ270((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_Z270");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    resname = null;
                                }
                                ++x;
                                pos += 3;
                            }
                        }
                        Arrays.fill(stack, null);
                        Arrays.fill(stackrot, null);
                        break;
                    }
                    case 6: {
                        String resname;
                        int pos;
                        int x;
                        Object[] stack = StackNew.New(windowsize, windowsize, windowsize, 10);
                        Object[] stackrot = StackNew.New(windowsize, windowsize, windowsize, 10);
                        for (y = wr; y < endy; ++y) {
                            x = wr;
                            pos = (y * width + x) * 4;
                            while (x < endx) {
                                if (bb[pos] != bb[pos + 2]) {
                                    if ((bb[pos + 1] & 0xFF) == 255 && bb[pos + 3] == 0) {
                                        resroot = resblue;
                                    } else if ((bb[pos + 3] & 0xFF) == 255 && bb[pos + 1] == 0) {
                                        resroot = resred;
                                    } else {
                                        System.err.println((bb[pos + 1] & 0xFF) + " vs " + (bb[pos + 3] & 0xFF));
                                        System.err.println(x + " x " + y);
                                        throw new IllegalStateException("Must not occur.");
                                    }
                                    resname = resroot.getAbsolutePath() + "/" + name + "_" + x + "x" + y + "x" + posim;
                                    StackNew.SubStackWHD((BufferedImage[])imseq, x - wr, y - wr, 0, windowsize, windowsize, windowsize, (BufferedImage[])stack);
                                    resfile = new File(resname);
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stack, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateX090((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_X090");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateX180((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_X180");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateX270((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_X270");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateY090((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_Y090");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateY180((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_Y180");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateY270((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_Y270");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateZ090((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_Z090");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateZ180((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_Z180");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    StackOperations.RotateZ270((BufferedImage[])stack, (BufferedImage[])stackrot);
                                    resfile = new File(resname + "_Z270");
                                    if (!resfile.exists()) {
                                        resfile.mkdirs();
                                    }
                                    StackIO.WriteImageSequence((BufferedImage[])stackrot, resfile.getAbsolutePath(), "", 6);
                                    resname = null;
                                }
                                ++x;
                                pos += 4;
                            }
                        }
                        Arrays.fill(stack, null);
                        Arrays.fill(stackrot, null);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Image type not supported.");
                    }
                }
                Arrays.fill(imseq, null);
                name = null;
                marker = null;
                bb = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void Generate3DfromEMbasic(String originalsdir, String markersdir, int class0, int class1, int windowsize, boolean simulate, String resultdir) {
        v0 = resclass0 = simulate != false ? null : new File(resultdir + "/Class0/");
        if (!simulate && !resclass0.exists()) {
            resclass0.mkdirs();
        }
        v1 = resclass1 = simulate != false ? null : new File(resultdir + "/Class1/");
        if (!simulate && !resclass1.exists()) {
            resclass1.mkdirs();
        }
        nbclass0 = 0;
        nbclass1 = 0;
        nbclassother = 0;
        wr = windowsize >> 1;
        resroot = null;
        resfile = null;
        stackfiles = new File[windowsize];
        originals = new File(originalsdir).listFiles(FileNameFilters.ImagesPNGorTIF);
        orinames = new ArrayList<String>(originals.length);
        for (File original : originals) {
            orinames.add(original.getName());
        }
        for (File marker1 : markers = new File(markersdir).listFiles(FileNameFilters.ImagesPNGorTIF)) {
            try {
                posim = ListTools.PositionInList(orinames, (String)marker1.getName());
                if (posim < wr || originals.length - wr <= posim) {
                    System.out.flush();
                    System.err.println("Marker image too close from the stack begining/end.");
                    System.err.flush();
                    continue;
                }
                marker = ImageIO.Read(marker1);
                bb = ((DataBufferByte)marker.getRaster().getDataBuffer()).getData();
                System.arraycopy(originals, posim - wr, stackfiles, 0, windowsize);
                imseq = simulate != false ? null : StackIO.ReadImageSequence(stackfiles);
                width = marker.getWidth();
                height = marker.getHeight();
                endx = width - wr;
                endy = height - wr;
                name = StringToolsImageDV.DeleteExtension((String)marker1.getName());
                switch (marker.getType()) {
                    case 10: {
                        stack = StackNew.New(windowsize, windowsize, windowsize, 10);
                        for (y = wr; y < endy; ++y) {
                            x = wr;
                            pos = y * width + x;
                            while (x < endx) {
                                if (bb[pos] == 0) ** GOTO lbl65
                                if ((bb[pos] & 255) != class0) ** GOTO lbl51
                                resroot = resclass0;
                                ++nbclass0;
                                ** GOTO lbl56
lbl51:
                                // 1 sources

                                if ((bb[pos] & 255) != class1) {
                                    ++nbclassother;
                                } else {
                                    resroot = resclass1;
                                    ++nbclass1;
lbl56:
                                    // 2 sources

                                    if (!simulate) {
                                        resname = resroot.getAbsolutePath() + "/" + name + "_" + x + "x" + y + "x" + posim;
                                        StackNew.SubStackWHD((BufferedImage[])imseq, x - wr, y - wr, 0, windowsize, windowsize, windowsize, (BufferedImage[])stack);
                                        resfile = new File(resname);
                                        if (!resfile.exists()) {
                                            resfile.mkdirs();
                                        }
                                        StackIO.WriteImageSequence((BufferedImage[])stack, resfile.getAbsolutePath(), "", 6);
                                        resname = null;
                                    }
                                }
lbl65:
                                // 5 sources

                                ++x;
                                ++pos;
                            }
                        }
                        Arrays.fill(stack, null);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Image type not supported.");
                    }
                }
                Arrays.fill(imseq, null);
                name = null;
                marker = null;
                bb = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Class 0 = " + nbclass0);
        System.out.println("Class 1 = " + nbclass1);
        System.out.println("Others  = " + nbclassother);
    }

    public void GenerateFromHE(String srcdir, String class1name, List<Integer> class1labels, String class2name, List<Integer> class2labels, int windowsize, int shakersize, int shakerstep, boolean estimate, String resultdir) {
        File resclass2;
        File resclass1 = new File(resultdir + "/" + class1name + "/");
        if (!resclass1.exists()) {
            resclass1.mkdirs();
        }
        if (!(resclass2 = new File(resultdir + "/" + class2name + "/")).exists()) {
            resclass2.mkdirs();
        }
        int[] classnum = this.BuildLut(class1labels, class2labels);
        int ws = windowsize >> 1;
        long nbclass1 = 0L;
        long nbclass2 = 0L;
        long nbcells = 0L;
        Object[] directories = new File(srcdir).listFiles(FileFilters.Directories);
        Arrays.sort(directories);
        for (Object directorie : directories) {
            Object[] images = new File(((File)directorie).getAbsolutePath()).listFiles(this.ImagesMasks);
            Arrays.sort(images);
            for (Object image : images) {
                try {
                    int i2;
                    BufferedImage nuclei = ImageIO.Read(((File)image).getAbsolutePath());
                    switch (nuclei.getType()) {
                        case 10: {
                            nuclei = ImageConverter.ByteToInt((BufferedImage)nuclei);
                            break;
                        }
                        case 11: {
                            nuclei = ImageConverter.ShortToInt((BufferedImage)nuclei);
                            break;
                        }
                        case 5: 
                        case 6: {
                            nuclei = ImageConverter.RGBtoInt((BufferedImage)nuclei);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Image type not supported. Must not occur!");
                        }
                    }
                    BufferedImage annotations = ImageIO.Read(((File)image).getAbsolutePath().replace("-Mask.", "-Annotation."));
                    BufferedImage ann = this.dilate.Filter(annotations, this.sesquare2, 4);
                    BufferedImage source = ImageIO.Read(((File)image).getAbsolutePath().replace("-Mask.", "-Org."));
                    int[] ibnuc = ((DataBufferInt)nuclei.getRaster().getDataBuffer()).getData();
                    byte[] bbann = ((DataBufferByte)ann.getRaster().getDataBuffer()).getData();
                    int width = nuclei.getWidth();
                    int height = nuclei.getHeight();
                    String name = ((File)image).getName().substring(0, ((File)image).getName().indexOf("-Mask.png"));
                    this.ufccl.Label(nuclei, 0, true);
                    int[] labels = this.ufccl.Labels1D();
                    int[] classes = new int[this.ufccl.ConnectedComponentsNumber() + 1];
                    Arrays.fill(classes, -1);
                    this.ufccl.ComputeBoundingBoxes();
                    int[] minx = this.ufccl.minx();
                    int[] miny = this.ufccl.miny();
                    int[] maxx = this.ufccl.maxx();
                    int[] maxy = this.ufccl.maxy();
                    for (i2 = 0; i2 < bbann.length; ++i2) {
                        if (bbann[i2] == 0 || ibnuc[i2] == 0) continue;
                        classes[labels[i2]] = classnum[bbann[i2]];
                    }
                    nbcells += (long)this.ufccl.ConnectedComponentsNumber();
                    for (i2 = 1; i2 < classes.length; ++i2) {
                        if (0 >= classes[i2]) continue;
                        if (classes[i2] == 1) {
                            ++nbclass1;
                        } else {
                            ++nbclass2;
                        }
                        if (estimate) continue;
                        Object respath = classes[i2] == 1 ? resclass1.getAbsolutePath() : resclass2.getAbsolutePath();
                        respath = (String)respath + "/" + name;
                        int cx = minx[i2] + maxx[i2] >> 1;
                        int cy = miny[i2] + maxy[i2] >> 1;
                        int shake = 0;
                        for (int yy = -shakersize; yy <= shakersize; yy += shakerstep) {
                            int xx = -shakersize;
                            while (xx <= shakersize) {
                                if (0 <= cx + xx - ws && cx + xx + ws < width && 0 <= cy + yy - ws && cy + yy + ws < height) {
                                    String path = (String)respath + "_" + cx + "x" + cy + "_s" + shake;
                                    BufferedImage sub = ImageNew.SubImageWH((BufferedImage)source, (int)(cx + xx - ws), (int)(cy + yy - ws), (int)windowsize, (int)windowsize);
                                    ImageIO.Write(sub, path + "_r00.png", 6);
                                    this.Rotate2D(sub, path);
                                    ImageTransformations.FlipX(sub);
                                    ImageIO.Write(sub, path + "_Flip_r00.png", 6);
                                    this.Rotate2D(sub, path + "_Flip");
                                    sub = null;
                                }
                                xx += shakerstep;
                                ++shake;
                            }
                        }
                    }
                    name = null;
                    ibnuc = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println("nbCells = " + nbcells + ", nbClass1 = " + nbclass1 + ", nbClass2 = " + nbclass2);
    }

    private int[] BuildLut(List<Integer> class1labels, List<Integer> class2labels) {
        int i2;
        if (class1labels.isEmpty() || class2labels.isEmpty()) {
            throw new IllegalArgumentException("Empty lists.");
        }
        int[] array1 = class1labels.stream().mapToInt(Integer::intValue).toArray();
        int[] array2 = class2labels.stream().mapToInt(Integer::intValue).toArray();
        int max1 = this.AF.Maximum(array1);
        int max2 = this.AF.Maximum(array2);
        int[] labels = new int[Math.max(max1, max2) + 1];
        Arrays.fill(labels, 0);
        for (i2 = 0; i2 < array1.length; ++i2) {
            labels[array1[i2]] = 1;
        }
        for (i2 = 0; i2 < array2.length; ++i2) {
            int v = array2[i2];
            if (labels[v] != 0) {
                throw new IllegalArgumentException("Same label present in both label lists.");
            }
            labels[v] = 2;
        }
        return labels;
    }

    public void GenerateFromHE_Dapi_CK(String srcdir, String segdir, int windowsize, String resultdir) {
        File cancerouscells;
        int ws = windowsize >> 1;
        File normalcells = new File(resultdir + "/Normal/");
        if (!normalcells.exists()) {
            normalcells.mkdirs();
        }
        if (!(cancerouscells = new File(resultdir + "/Cancerous/")).exists()) {
            cancerouscells.mkdirs();
        }
        Object[] dapifiles = new File(srcdir).listFiles(this.ImagesDapi);
        Arrays.sort(dapifiles);
        for (Object dapifile : dapifiles) {
            try {
                int i2;
                BufferedImage roi = ImageIO.Read(segdir + "/" + ((File)dapifile).getName() + "/Segmentation - ROI.png");
                if (ImageTools.isBlack((BufferedImage)roi)) continue;
                BufferedImage ck = ImageIO.Read(segdir + "/" + ((File)dapifile).getName() + "/Segmentation - CK+.png");
                BufferedImage source = ImageIO.Read(srcdir + "/" + ((File)dapifile).getName().replace(" - DAPI.png", ""));
                BufferedImage basins = ImageIO.Read(srcdir + "/" + ((File)dapifile).getName().replace(" - DAPI.png", " - Masks.png"));
                if (basins.getType() == 5 || basins.getType() == 5) {
                    basins = ImageConverter.RGBtoInt((BufferedImage)basins);
                }
                int width = source.getWidth();
                int height = source.getHeight();
                String imname = ((File)dapifile).getName().substring(0, ((File)dapifile).getName().indexOf(".png"));
                if (width != roi.getWidth() || height != roi.getHeight()) {
                    throw new IllegalStateException("Images have different dimensions");
                }
                if (width != ck.getWidth() || height != ck.getHeight()) {
                    throw new IllegalStateException("Images have different dimensions");
                }
                if (width != basins.getWidth() || height != basins.getHeight()) {
                    throw new IllegalStateException("Images have different dimensions");
                }
                this.ufccl.Label(basins, 0, true);
                this.ufccl.ComputeBoundingBoxes();
                int[] minx = this.ufccl.minx();
                int[] miny = this.ufccl.miny();
                int[] maxx = this.ufccl.maxx();
                int[] maxy = this.ufccl.maxy();
                int[] labels = this.ufccl.Labels1D();
                int[] sizes = this.ufccl.Sizes();
                int[] validnuclei = new int[sizes.length];
                int[] cancerousnuclei = new int[sizes.length];
                short[] bbroi = ((DataBufferUShort)roi.getRaster().getDataBuffer()).getData();
                short[] sbck = ((DataBufferUShort)ck.getRaster().getDataBuffer()).getData();
                for (i2 = 0; i2 < labels.length; ++i2) {
                    if (labels[i2] == 0) continue;
                    if (bbroi[i2] != 0) {
                        int n = labels[i2];
                        validnuclei[n] = validnuclei[n] + 1;
                    }
                    if (sbck[i2] == 0) continue;
                    int n = labels[i2];
                    cancerousnuclei[n] = cancerousnuclei[n] + 1;
                }
                for (i2 = 1; i2 < sizes.length; ++i2) {
                    if (!(0.5 < (double)validnuclei[i2] / (double)sizes[i2])) continue;
                    int cx = minx[i2] + maxx[i2] >> 1;
                    int cy = miny[i2] + maxy[i2] >> 1;
                    String suffixe = "_" + cx + "x" + cy + ".png";
                    if (cx < ws || width <= cx + ws || cy < ws || height <= cy + ws) continue;
                    BufferedImage sub = ImageNew.SubImageWH((BufferedImage)source, (int)(cx - ws), (int)(cy - ws), (int)windowsize, (int)windowsize);
                    if (0.5 < (double)cancerousnuclei[i2] / (double)sizes[i2]) {
                        ImageIO.Write(sub, cancerouscells.getAbsolutePath() + "/" + imname + suffixe, 6);
                    } else {
                        ImageIO.Write(sub, normalcells.getAbsolutePath() + "/" + imname + suffixe, 6);
                    }
                    sub = null;
                }
                maxy = null;
                miny = null;
                maxx = null;
                minx = null;
                cancerousnuclei = null;
                validnuclei = null;
                bbroi = null;
                sbck = null;
                basins = null;
                source = null;
                ck = null;
                roi = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void ArtificialIncrease(String srcdir, int windowsize, int shakersize, int shakerstep, String resultdir) {
        File resfile = new File(resultdir + "/");
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        int ws = windowsize >> 1;
        Object[] images = new File(srcdir).listFiles(FileNameFilters.ImagesPNG);
        Arrays.sort(images);
        for (Object image : images) {
            try {
                BufferedImage nuclei = ImageIO.Read(((File)image).getAbsolutePath());
                int width = nuclei.getWidth();
                int height = nuclei.getHeight();
                int cx = width >> 1;
                int cy = height >> 1;
                String name = ((File)image).getName().substring(0, ((File)image).getName().indexOf(".png"));
                int shake = 0;
                for (int yy = -shakersize; yy <= shakersize; yy += shakerstep) {
                    int xx = -shakersize;
                    while (xx <= shakersize) {
                        if (Maths.ModuloDyadic((int)shake, (int)2) == 0) {
                            String path = resultdir + "/" + name + "_s" + shake;
                            BufferedImage sub = ImageNew.SubImageWH((BufferedImage)nuclei, (int)(cx + xx - ws), (int)(cy + yy - ws), (int)windowsize, (int)windowsize);
                            ImageIO.Write(sub, path + "_r00.png", 6);
                            this.Rotate2D(sub, path);
                            ImageTransformations.FlipX(sub);
                            ImageIO.Write(sub, path + "_Flip_r00.png", 6);
                            this.Rotate2D(sub, path + "_Flip");
                            sub = null;
                            path = null;
                        }
                        xx += shakerstep;
                        ++shake;
                    }
                }
                name = null;
                nuclei = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void Subset(String dirpath, FilenameFilter filter, int nbimage, String resdirpath) {
        File[] images = new File(dirpath).listFiles(filter);
        ArrayOperations.Shuffle((File[])images);
        for (int i2 = 0; i2 < nbimage; ++i2) {
            FilesFolders.CopyFile(images[i2], new File(resdirpath + "/" + images[i2].getName()));
        }
    }

    public void SplitSubset(String dirpath, FilenameFilter filter, int nbimage1, int nbimage2, String resdirpath1, String resdirpath2) {
        int i2;
        int sum;
        File[] images = new File(dirpath).listFiles(filter);
        if (images.length < (sum = nbimage1 + nbimage2)) {
            throw new IllegalArgumentException("images.length < nbimage1+nbimage2");
        }
        ArrayOperations.Shuffle((File[])images);
        for (i2 = 0; i2 < nbimage1; ++i2) {
            FilesFolders.CopyFile(images[i2], new File(resdirpath1 + "/" + images[i2].getName()));
        }
        for (i2 = nbimage1; i2 < sum; ++i2) {
            FilesFolders.CopyFile(images[i2], new File(resdirpath2 + "/" + images[i2].getName()));
        }
    }

    public void ImageToImage(String inputsdir, int patchsizein, String outputsdir, int patchsizeout, int NB, int crop, boolean positiveonly, int speedwhenpositive, boolean subtractaverage, String resultdir, boolean nameasprefix) {
        File resoutputs;
        Object[] outfiles;
        if (patchsizein < patchsizeout) {
            throw new IllegalArgumentException("patchsizein < patchsizeout");
        }
        if (speedwhenpositive < 1 || patchsizein < speedwhenpositive) {
            throw new IllegalArgumentException("speedwhenpositive < 1 || patchsizein < speedwhenpositive");
        }
        Object[] infiles = new File(inputsdir).listFiles(FileNameFilters.ImagesPNGorTIF);
        if (infiles.length != (outfiles = new File(outputsdir).listFiles(FileNameFilters.ImagesPNGorTIF)).length) {
            throw new IllegalStateException("infiles.length != outfiles.length");
        }
        Arrays.sort(infiles);
        Arrays.sort(outfiles);
        File resinputs = new File(resultdir + "/Inputs/");
        if (!resinputs.exists()) {
            resinputs.mkdirs();
        }
        if (!(resoutputs = new File(resultdir + "/Outputs/")).exists()) {
            resoutputs.mkdirs();
        }
        int gap = patchsizein - patchsizeout >> 1;
        IntGenerator gen = new IntGenerator(0, NB + 1);
        int nberrors = 0;
        BufferedImage patchin = null;
        BufferedImage patchout = null;
        BufferedImage patchinbgr = null;
        boolean done = false;
        int nb = Math.min(NB, infiles.length);
        for (int i2 = 0; i2 < nb && !done; ++i2) {
            try {
                if (((File)infiles[i2]).getName().compareTo(((File)outfiles[i2]).getName()) != 0) {
                    throw new UnsupportedOperationException("infiles[i].getName() != outfiles[i].getName()");
                }
                BufferedImage imin = ImageIO.Read((File)infiles[i2]);
                BufferedImage imout = ImageIO.Read((File)outfiles[i2]);
                if (subtractaverage) {
                    int max = (int)this.IF.MaximumPotentialValue(imin);
                    imin = ImageConverter.ToCustomFloat((BufferedImage)imin);
                    ImageArithmetic.Multiply(imin, 2.0 / (double)max, imin);
                    double ave = this.IF.Average(imin);
                    ImageArithmetic.Subtract(imin, ave, imin, -3.4028234663852886E38, 3.4028234663852886E38);
                }
                String name = ((File)infiles[i2]).getName().substring(0, Math.max(((File)infiles[i2]).getName().indexOf(".tif"), ((File)infiles[i2]).getName().indexOf(".png")));
                if (!ImageTools.areDimensionsEqual((BufferedImage)imin, (BufferedImage)imout)) {
                    throw new UnsupportedOperationException("Images have different dimensions.");
                }
                if (patchin == null) {
                    patchin = ImageNew.Same((int)patchsizein, (int)patchsizein, (BufferedImage)imin);
                    patchout = new BufferedImage(patchsizeout, patchsizeout, imout.getType());
                    if (patchin.getType() == 6) {
                        patchinbgr = new BufferedImage(patchsizein, patchsizein, 5);
                    }
                }
                int width = imin.getWidth();
                int height = imin.getHeight();
                int startx = crop;
                int starty = crop;
                int endx = width - crop - patchsizein;
                int endy = height - crop - patchsizein;
                int inc = patchsizein;
                int slowspeed = patchsizein / speedwhenpositive;
                for (int y = starty; y < endy && !done; y += inc) {
                    for (int x = startx; x < endx && !done; x += inc) {
                        ImageNew.SubImageWH((BufferedImage)imout, (int)(x + gap), (int)(y + gap), (int)patchsizeout, (int)patchsizeout, (BufferedImage)patchout);
                        boolean black = ImageTools.isBlack((BufferedImage)patchout);
                        if (positiveonly && black) continue;
                        inc = !black ? slowspeed : patchsizein;
                        String num = gen.Next();
                        ImageComparator.Compare((BufferedImage)patchout, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)patchout);
                        ImageIO.Write(patchout, resoutputs.getAbsolutePath() + "/" + (String)(nameasprefix ? name + " " : "") + num + ".png", 6);
                        ImageNew.SubImageWH((BufferedImage)imin, (int)x, (int)y, (int)patchsizein, (int)patchsizein, (BufferedImage)patchin);
                        if (patchinbgr != null) {
                            ImageConverter.RemoveAlpha((BufferedImage)patchin, (BufferedImage)patchinbgr);
                            ImageIO.Write(patchinbgr, resinputs.getAbsolutePath() + "/" + (String)(nameasprefix ? name + " " : "") + num + ".png", 6);
                        } else if (subtractaverage) {
                            ImageIO.WriteJAI(patchin, resinputs.getAbsolutePath() + "/" + (String)(nameasprefix ? name + " " : "") + num + ".tif", 8);
                        } else {
                            ImageIO.Write(patchin, resinputs.getAbsolutePath() + "/" + (String)(nameasprefix ? name + " " : "") + num + ".png", 6);
                        }
                        if (NB == Integer.valueOf(num)) {
                            done = true;
                        }
                        num = null;
                    }
                }
                imout = null;
                imin = null;
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                ++nberrors;
            }
        }
        System.out.println("Done with " + nberrors + " error(s).");
        gen = null;
        patchinbgr = null;
        patchout = null;
        patchin = null;
    }

    public void Cytomine(String dirspath, int patchsizein, int patchsizeout, String onthology, int NB, int crop, boolean positiveonly, int speedwhenpositive, double factor, boolean factorfirst, String resultdir, boolean nameasprefix) {
        File resoutputs;
        if (patchsizein < patchsizeout) {
            throw new IllegalArgumentException("patchsizein < patchsizeout");
        }
        if (speedwhenpositive < 1 || patchsizein < speedwhenpositive) {
            throw new IllegalArgumentException("speedwhenpositive < 1 || patchsizein < speedwhenpositive");
        }
        Object[] dirs = new File(dirspath).listFiles(FileFilters.Directories);
        Arrays.sort(dirs);
        File resinputs = new File(resultdir + "/" + onthology + "/Inputs/");
        if (!resinputs.exists()) {
            resinputs.mkdirs();
        }
        if (!(resoutputs = new File(resultdir + "/" + onthology + "/Outputs/")).exists()) {
            resoutputs.mkdirs();
        }
        int gap = patchsizein - patchsizeout >> 1;
        IntGenerator gen = new IntGenerator(0, NB + 1);
        int nberrors = 0;
        BufferedImage patchin = null;
        BufferedImage patchout = null;
        BufferedImage patchroi = null;
        BufferedImage patchinbgr = null;
        boolean done = false;
        for (Object dir : dirs) {
            Object[] crops = new File(((File)dir).getAbsolutePath()).listFiles(this.CytoCrops);
            Arrays.sort(crops);
            for (Object crop1 : crops) {
                try {
                    String cropnum = ((File)crop1).getName().substring(5, ((File)crop1).getName().indexOf(95, 6));
                    BufferedImage imin = ImageIO.Read((File)crop1);
                    BufferedImage imout = ImageIO.Read(((File)dir).getAbsolutePath() + "/Crop_" + cropnum + "-Annotation_" + onthology + ".png");
                    ImageComparator.Compare((BufferedImage)imout, (String)"!=", (int)0, (int)((int)this.IF.MaximumPotentialValue(imout)), (int)0, (BufferedImage)imout);
                    BufferedImage imroi = ImageIO.Read(((File)dir).getAbsolutePath() + "/Crop_" + cropnum + "-Annotation_ROI.png");
                    ImageComparator.Compare((BufferedImage)imroi, (String)"!=", (int)0, (int)((int)this.IF.MaximumPotentialValue(imroi)), (int)0, (BufferedImage)imroi);
                    if (!ImageTools.areDimensionsEqual((BufferedImage)imin, (BufferedImage)imout)) {
                        throw new UnsupportedOperationException("Images have different dimensions.");
                    }
                    if (factorfirst && factor != 1.0) {
                        imin = ImageTransformations.Homothetic(imin, factor, factor, factor, ImageTransformations.HomotheticInterpolation.LINEAR);
                        imout = ImageTransformations.Homothetic(imout, factor, factor, factor, ImageTransformations.HomotheticInterpolation.LINEAR);
                        imroi = ImageTransformations.Homothetic(imroi, factor, factor, factor, ImageTransformations.HomotheticInterpolation.LINEAR);
                    }
                    if (patchin == null) {
                        patchin = new BufferedImage(patchsizein, patchsizein, imin.getType());
                        patchout = new BufferedImage(patchsizeout, patchsizeout, imout.getType());
                        patchroi = new BufferedImage(patchsizein, patchsizein, imroi.getType());
                        if (patchin.getType() == 6) {
                            patchinbgr = new BufferedImage(patchsizein, patchsizein, 5);
                        }
                    }
                    Object name = "";
                    if (nameasprefix) {
                        name = ((File)dir).getName() + " - Crop_" + cropnum + " - ";
                    }
                    int width = imin.getWidth();
                    int height = imin.getHeight();
                    int startx = crop;
                    int starty = crop;
                    int endx = width - crop - patchsizein;
                    int endy = height - crop - patchsizein;
                    int slowspeed = patchsizein / speedwhenpositive;
                    int xinc = patchsizein;
                    int yinc = patchsizein;
                    for (int y = starty; y < endy && !done; y += yinc) {
                        xinc = patchsizein;
                        yinc = patchsizein;
                        for (int x = startx; x < endx && !done; x += xinc) {
                            ImageNew.SubImageWH((BufferedImage)imout, (int)(x + gap), (int)(y + gap), (int)patchsizeout, (int)patchsizeout, (BufferedImage)patchout);
                            boolean black = ImageTools.isBlack((BufferedImage)patchout);
                            ImageNew.SubImageWH((BufferedImage)imroi, (int)(x + gap), (int)(y + gap), (int)patchsizein, (int)patchsizein, (BufferedImage)patchroi);
                            boolean white = ImageTools.isWhite((BufferedImage)patchroi);
                            if (!white || positiveonly && black) continue;
                            if (!black) {
                                yinc = xinc = slowspeed;
                            } else {
                                xinc = patchsizein;
                            }
                            String num = gen.Next();
                            if (!factorfirst && factor != 1.0) {
                                ImageIO.Write(ImageTransformations.Homothetic(patchout, factor, factor, factor, ImageTransformations.HomotheticInterpolation.LINEAR), resoutputs.getAbsolutePath() + "/" + (String)name + num + ".png", 6);
                            } else {
                                ImageIO.Write(patchout, resoutputs.getAbsolutePath() + "/" + (String)name + num + ".png", 6);
                            }
                            ImageNew.SubImageWH((BufferedImage)imin, (int)x, (int)y, (int)patchsizein, (int)patchsizein, (BufferedImage)patchin);
                            if (patchinbgr != null) {
                                ImageConverter.RemoveAlpha((BufferedImage)patchin, (BufferedImage)patchinbgr);
                                if (!factorfirst && factor != 1.0) {
                                    ImageIO.Write(ImageTransformations.Homothetic(patchinbgr, factor, factor, factor, ImageTransformations.HomotheticInterpolation.LINEAR), resinputs.getAbsolutePath() + "/" + (String)name + num + ".png", 6);
                                } else {
                                    ImageIO.Write(patchinbgr, resinputs.getAbsolutePath() + "/" + (String)name + num + ".png", 6);
                                }
                            } else if (!factorfirst && factor != 1.0) {
                                ImageIO.Write(ImageTransformations.Homothetic(patchin, factor, factor, factor, ImageTransformations.HomotheticInterpolation.LINEAR), resinputs.getAbsolutePath() + "/" + (String)name + num + ".png", 6);
                            } else {
                                ImageIO.Write(patchin, resinputs.getAbsolutePath() + "/" + (String)name + num + ".png", 6);
                            }
                            if (NB == Integer.valueOf(num)) {
                                done = true;
                            }
                            num = null;
                        }
                    }
                    imout = null;
                    imin = null;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    ++nberrors;
                }
            }
        }
        System.out.println("Done with " + nberrors + " error(s).");
        gen = null;
        patchinbgr = null;
        patchout = null;
        patchin = null;
    }

    public void EM_Denoising2D(String inputsdir, String outputsdir, int NB, int crop, int patchsizein, int patchsizeout, String resultdir) {
        File resoutputs;
        File[] outdir;
        if (patchsizein < patchsizeout) {
            throw new IllegalArgumentException("patchsizein < patchsizeout");
        }
        File[] indirs = new File(inputsdir).listFiles(FileFilters.Directories);
        if (indirs.length != (outdir = new File(outputsdir).listFiles(FileNameFilters.ImagesPNGorTIF)).length) {
            throw new IllegalStateException("indirs.length != outdirs.length");
        }
        File resinputs = new File(resultdir + "/Inputs/");
        if (!resinputs.exists()) {
            resinputs.mkdirs();
        }
        if (!(resoutputs = new File(resultdir + "/Outputs/")).exists()) {
            resoutputs.mkdirs();
        }
        int gap = patchsizein - patchsizeout >> 1;
        IntGenerator gen = new IntGenerator(0, 9999999);
        int nberrors = 0;
        int nb = Math.min(NB, indirs.length);
        for (int i2 = 0; i2 < nb; ++i2) {
            try {
                Object[] noisy = new File(indirs[i2].getAbsolutePath()).listFiles(FileNameFilters.ImagesPNGorTIF);
                BufferedImage denoised = ImageIO.Read(outputsdir + "/" + indirs[i2].getName() + ".png");
                BufferedImage patchin = new BufferedImage(patchsizein, patchsizein, denoised.getType());
                BufferedImage patchout = new BufferedImage(patchsizeout, patchsizeout, denoised.getType());
                for (File file : noisy) {
                    BufferedImage noise = ImageIO.Read(file.getAbsolutePath());
                    int width = noise.getWidth();
                    int height = noise.getHeight();
                    int startx = crop;
                    int starty = crop;
                    int endx = width - crop - patchsizein;
                    int endy = height - crop - patchsizein;
                    for (int y = starty; y < endy; y += patchsizein) {
                        for (int x = startx; x < endx; x += patchsizein) {
                            String num = gen.Next();
                            ImageNew.SubImageWH((BufferedImage)noise, (int)x, (int)y, (int)patchsizein, (int)patchsizein, (BufferedImage)patchin);
                            ImageIO.Write(patchin, resinputs.getAbsolutePath() + "/" + num + ".png", 6);
                            ImageNew.SubImageWH((BufferedImage)denoised, (int)(x + gap), (int)(y + gap), (int)patchsizeout, (int)patchsizeout, (BufferedImage)patchout);
                            ImageIO.Write(patchout, resoutputs.getAbsolutePath() + "/" + num + ".png", 6);
                            num = null;
                        }
                    }
                    noise = null;
                }
                patchout = null;
                patchin = null;
                denoised = null;
                Arrays.fill(noisy, null);
                noisy = null;
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                ++nberrors;
            }
        }
        System.out.println("Done with " + nberrors + " error(s).");
        gen = null;
    }

    public void EM_Denoising2D_NoiseToNoise(String inputsdir, String resultdir) {
        File resoutputs;
        File[] indirs = new File(inputsdir).listFiles(FileFilters.Directories);
        File resinputs = new File(resultdir + "/Inputs/");
        if (!resinputs.exists()) {
            resinputs.mkdirs();
        }
        if (!(resoutputs = new File(resultdir + "/Outputs/")).exists()) {
            resoutputs.mkdirs();
        }
        int nberrors = 0;
        for (File dir : indirs) {
            File[] noisy = new File(dir.getAbsolutePath()).listFiles(FileNameFilters.ImagesPNGorTIF);
            IntGenerator gen = new IntGenerator(0, noisy.length * (noisy.length + 1) / 2 + 1);
            for (int i2 = 0; i2 < noisy.length - 1; ++i2) {
                for (int j = i2 + 1; j < noisy.length; ++j) {
                    String num = gen.Next();
                    FilesFolders.CopyFile(noisy[i2], new File(resinputs.getAbsolutePath() + "/Slice " + dir.getName() + " - " + num + ".png"));
                    FilesFolders.CopyFile(noisy[j], new File(resoutputs.getAbsolutePath() + "/Slice " + dir.getName() + " - " + num + ".png"));
                    num = null;
                }
            }
            gen = null;
            noisy = null;
        }
        System.out.println("Done with " + nberrors + " error(s).");
    }

    public void EM_Denoising2D_PN(String InputsDir, int Frequence, String Match2, String ResultDir) {
        File resoutputs;
        Object[] images = new File(InputsDir).listFiles(FileFilters.ImagesPNGorTIF);
        if (images == null || images.length == 0) {
            throw new IllegalArgumentException("No images found in \"" + InputsDir + "\".");
        }
        Arrays.sort(images);
        File resinputs = new File(ResultDir + "/Inputs/");
        if (!resinputs.exists()) {
            resinputs.mkdirs();
        }
        if (!(resoutputs = new File(ResultDir + "/Outputs/")).exists()) {
            resoutputs.mkdirs();
        }
        IntGenerator gen = new IntGenerator(0, images.length * 2);
        String ext = ((File)images[0]).getName().substring(((File)images[0]).getName().lastIndexOf(46));
        int nberrors = 0;
        block10: for (int i2 = 0; i2 < images.length; ++i2) {
            if (i2 % Frequence != 0) continue;
            switch (Match2) {
                case "Previous": {
                    if (0 >= i2) continue block10;
                    String s = "/Image " + gen.Next() + ext;
                    FilesFolders.CopyFile((File)images[i2], new File(resinputs.getAbsolutePath() + s));
                    FilesFolders.CopyFile((File)images[i2 - 1], new File(resoutputs.getAbsolutePath() + s));
                    s = null;
                    continue block10;
                }
                case "Next": {
                    if (i2 >= images.length - 1) continue block10;
                    String s = "/Image " + gen.Next() + ext;
                    FilesFolders.CopyFile((File)images[i2], new File(resinputs.getAbsolutePath() + s));
                    FilesFolders.CopyFile((File)images[i2 + 1], new File(resoutputs.getAbsolutePath() + s));
                    s = null;
                    continue block10;
                }
                case "Both": {
                    String s;
                    if (0 < i2) {
                        s = "/Image " + gen.Next() + ext;
                        FilesFolders.CopyFile((File)images[i2], new File(resinputs.getAbsolutePath() + s));
                        FilesFolders.CopyFile((File)images[i2 - 1], new File(resoutputs.getAbsolutePath() + s));
                        s = null;
                    }
                    if (i2 >= images.length - 1) continue block10;
                    s = "/Image " + gen.Next() + ext;
                    FilesFolders.CopyFile((File)images[i2], new File(resinputs.getAbsolutePath() + s));
                    FilesFolders.CopyFile((File)images[i2 + 1], new File(resoutputs.getAbsolutePath() + s));
                    s = null;
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Matching type not supported. Expected 'Previous', 'Next' or 'Both'");
                }
            }
        }
        gen = null;
        ext = null;
        System.out.println("Done with " + nberrors + " error(s).");
    }

    public int CountPositiveVolumes(String dirpath) {
        Object[] volumes;
        int nb = 0;
        for (File file : volumes = new File(dirpath).listFiles(FileFilters.Directories)) {
            Object[] images = new File(file.getAbsolutePath()).listFiles(FileNameFilters.ImagesPNGorTIF);
            boolean keepgoing = true;
            for (int i2 = 0; i2 < images.length && keepgoing; ++i2) {
                try {
                    BufferedImage im = ImageIO.Read((File)images[i2]);
                    if (!ImageTools.isBlack((BufferedImage)im)) {
                        ++nb;
                        keepgoing = false;
                    }
                    im = null;
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            Arrays.fill(images, null);
            images = null;
        }
        Arrays.fill(volumes, null);
        volumes = null;
        System.out.println(nb + " positive volumes.");
        return nb;
    }

    public void SegmentationTest3D(int dim, int nb, int margin, int minsize, boolean usemedian, String resdir, int nbCPU) throws IOException {
        File resout;
        File resin = new File(resdir + "/Inputs/");
        if (!resin.exists()) {
            resin.mkdirs();
        }
        if (!(resout = new File(resdir + "/Outputs/")).exists()) {
            resout.mkdirs();
        }
        DV dv = new DV(dim, dim, dim, 1, 8);
        DV gt = DvNew.Same((DV)dv);
        DV res = DvNew.Same((DV)dv);
        DV tmp = DvNew.Same((DV)dv);
        Gaussian gauss = new Gaussian();
        if (usemedian) {
            gauss.CreateMask3D(2, 2.5);
        } else {
            gauss.CreateMask3D(1, 1.0);
        }
        Median median = new Median();
        StructuringElement3D se = new StructuringElement3D(new Object[]{1, -1});
        int roi = dim - 2 * margin - minsize;
        IntGenerator gen = new IntGenerator(0, nb + 2);
        for (int i2 = 0; i2 < nb; ++i2) {
            DvOperations.FillRandomly((DV)dv);
            DvOperations.Fill((DV)gt, (byte)0);
            int X = margin + (int)(Math.random() * (double)roi + 0.5);
            int Y = margin + (int)(Math.random() * (double)roi + 0.5);
            int Z = margin + (int)(Math.random() * (double)roi + 0.5);
            int Width = minsize + (int)(Math.random() * (double)(roi - X));
            int Height = minsize + (int)(Math.random() * (double)(roi - Y));
            int Depth = minsize + (int)(Math.random() * (double)(roi - Z));
            gauss.Filter(dv, res, nbCPU);
            if (usemedian) {
                median.Filter(dv, se, tmp, nbCPU);
                DvNew.Copy((DV)tmp, (DV)dv);
            }
            for (int zz = 0; zz < Depth; ++zz) {
                for (int yy = 0; yy < Height; ++yy) {
                    for (int xx = 0; xx < Width; ++xx) {
                        dv.setVoxel(X + xx, Y + yy, Z + zz, 0, res.getVoxelByte(X + xx, Y + yy, Z + zz, 0));
                        gt.setVoxel(X + xx, Y + yy, Z + zz, 0, (byte)-1);
                    }
                }
            }
            String num = gen.Next();
            File resfile = new File(resin.getAbsolutePath() + "/" + num + "/");
            if (!resfile.exists()) {
                resfile.mkdirs();
            }
            DvIO.WriteStack(dv, resfile.getAbsolutePath(), "", 6);
            resfile = null;
            resfile = new File(resout.getAbsolutePath() + "/" + num + "/");
            if (!resfile.exists()) {
                resfile.mkdirs();
            }
            DvIO.WriteStack(gt, resfile.getAbsolutePath(), "", 6);
            resfile = null;
        }
        gen = null;
        gauss.Kill();
        gauss = null;
        median.Kill();
        median = null;
        dv.Kill();
        res.Kill();
        gt.Kill();
        gt = null;
        res = null;
        dv = null;
    }

    public void MIBtoLabels(String Originals, String MIBpath, boolean Crop, int Margin, boolean Stretch, boolean DistanceMap, String Detection2, String ResultsPath, int nbCPU) {
        File resdir = new File(ResultsPath);
        String Dataset = resdir.getName();
        resdir = new File(ResultsPath + "/Labels/");
        if (!resdir.exists()) {
            resdir.mkdirs();
        }
        if (!(resdir = new File(ResultsPath + "/Untouching Labels/")).exists()) {
            resdir.mkdirs();
        }
        if (!(resdir = new File(ResultsPath + "/Separations/")).exists()) {
            resdir.mkdirs();
        }
        if (!(resdir = new File(ResultsPath + "/Contours/")).exists()) {
            resdir.mkdirs();
        }
        if (!(resdir = new File(ResultsPath + "/Foreground/")).exists()) {
            resdir.mkdirs();
        }
        if (!(resdir = new File(ResultsPath + "/Untouching Foreground/")).exists()) {
            resdir.mkdirs();
        }
        if (DistanceMap && !(resdir = new File(ResultsPath + "/Distance Maps/")).exists()) {
            resdir.mkdirs();
        }
        if (Originals != null && !(resdir = new File(ResultsPath + "/Originals/")).exists()) {
            resdir.mkdirs();
        }
        if (Stretch && !(resdir = new File(ResultsPath + "/Originals Stretched/")).exists()) {
            resdir.mkdirs();
        }
        if (Detection2 != null && !(resdir = new File(ResultsPath + "/Detection/")).exists()) {
            resdir.mkdirs();
        }
        resdir = null;
        Object[] originals = new File(Originals).listFiles(FileNameFilters.ImagesPNGorTIF);
        if (originals == null || originals.length == 0) {
            throw new IllegalArgumentException("No images found in '" + Originals + "'");
        }
        Arrays.sort(originals);
        Object[] mibs = new File(MIBpath).listFiles(FileNameFilters.ImagesPNGorTIF);
        if (mibs == null || mibs.length == 0) {
            throw new IllegalArgumentException("No images found in '" + MIBpath + "'");
        }
        Arrays.sort(mibs);
        if (originals.length != mibs.length) {
            throw new IllegalArgumentException("Different number of images in '" + Originals + "' and '" + MIBpath + "'");
        }
        if (Crop && Margin < 0) {
            throw new IllegalArgumentException("Negative margin for the crop... Moron!");
        }
        for (int i2 = 0; i2 < mibs.length; ++i2) {
            try {
                BufferedImage mib = ImageIO.Read((File)mibs[i2]);
                int width = mib.getWidth();
                int height = mib.getHeight();
                BufferedImage im = ImageIO.Read((File)originals[i2]);
                if (im.getWidth() != width || im.getHeight() != height) {
                    throw new Exception("Image have different dimensions.");
                }
                String name = ((File)originals[i2]).getName().substring(0, ((File)originals[i2]).getName().lastIndexOf(46));
                int minx = width;
                int miny = height;
                int maxx = 0;
                int maxy = 0;
                if (Crop) {
                    byte[] bbmib = ((DataBufferByte)mib.getRaster().getDataBuffer()).getData();
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            if (bbmib[pos] != 0) {
                                if (x < minx) {
                                    minx = x;
                                }
                                if (y < miny) {
                                    miny = y;
                                }
                                if (maxx < x) {
                                    maxx = x;
                                }
                                if (maxy < y) {
                                    maxy = y;
                                }
                            }
                            ++x;
                            ++pos;
                        }
                    }
                    minx = Math.max(0, minx - Margin);
                    miny = Math.max(0, miny - Margin);
                    maxx = Math.min(maxx + Margin, width - 1);
                    maxy = Math.min(maxy + Margin, height - 1);
                }
                BufferedImage separations = ImageNew.Same((BufferedImage)mib);
                ImageComparator.Compare((BufferedImage)mib, (String)"==", (int)2, (int)2, (int)0, (BufferedImage)separations);
                byte[] bbsep = ((DataBufferByte)separations.getRaster().getDataBuffer()).getData();
                BufferedImage nuclei = ImageNew.Same((BufferedImage)mib);
                ImageComparator.Compare((BufferedImage)mib, (String)"==", (int)1, (int)1, (int)0, (BufferedImage)nuclei);
                this.ufccl.Label(nuclei, 0, false);
                int[] labels = this.ufccl.Labels1D();
                BufferedImage imlabels = ImageNew.SameInteger((BufferedImage)mib);
                ImageConverter.ArrayToImage((int[])labels, (BufferedImage)imlabels);
                int[] iblabels = ((DataBufferInt)imlabels.getRaster().getDataBuffer()).getData();
                if (Crop) {
                    BufferedImage crop = ImageNew.SubImage((BufferedImage)imlabels, (int)minx, (int)miny, (int)maxx, (int)maxy);
                    ImageIO.Write(crop, ResultsPath + "/Untouching Labels/" + name + ".tif", 8);
                    this.allocator.Release(crop);
                } else {
                    ImageIO.Write(imlabels, ResultsPath + "/Untouching Labels/" + name + ".tif", 8);
                }
                BufferedImage imlabels2 = ImageNew.Same((BufferedImage)mib, (int)10);
                ImageComparator.Compare((BufferedImage)imlabels, (String)"==", (int)0, (int)0, (int)255, (BufferedImage)imlabels2);
                if (Crop) {
                    BufferedImage crop = ImageNew.SubImage((BufferedImage)imlabels2, (int)minx, (int)miny, (int)maxx, (int)maxy);
                    ImageIO.Write(crop, ResultsPath + "/Untouching Foreground/" + name + ".png", 6);
                    this.allocator.Release(crop);
                } else {
                    ImageIO.Write(imlabels2, ResultsPath + "/Untouching Foreground/" + name + ".png", 6);
                }
                BufferedImage imskiz = this.skiz.Filter(imlabels, this.sem2, nbCPU);
                float[] skizmap = this.skiz.Map();
                int[] skizlabels = ((DataBufferInt)imskiz.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < skizmap.length; ++x) {
                    if (bbsep[x] == 0 || !((double)skizmap[x] < 3.0)) continue;
                    iblabels[x] = skizlabels[x];
                }
                if (Crop) {
                    BufferedImage crop = ImageNew.SubImage((BufferedImage)imlabels, (int)minx, (int)miny, (int)maxx, (int)maxy);
                    ImageIO.Write(crop, ResultsPath + "/Labels/" + name + ".tif", 8);
                    this.allocator.Release(crop);
                } else {
                    ImageIO.Write(imlabels, ResultsPath + "/Labels/" + name + ".tif", 8);
                }
                ImageComparator.Compare((BufferedImage)imlabels, (String)"==", (int)0, (int)0, (int)255, (BufferedImage)imlabels2);
                if (Crop) {
                    BufferedImage crop = ImageNew.SubImage((BufferedImage)imlabels2, (int)minx, (int)miny, (int)maxx, (int)maxy);
                    ImageIO.Write(crop, ResultsPath + "/Foreground/" + name + ".png", 6);
                    this.allocator.Release(crop);
                } else {
                    ImageIO.Write(imlabels2, ResultsPath + "/Foreground/" + name + ".png", 6);
                }
                separations = this.allocator.Release(separations);
                nuclei = this.allocator.Release(nuclei);
                imlabels2 = this.allocator.Release(imlabels2);
                imskiz = this.allocator.Release(imskiz);
                labels = null;
                skizmap = null;
                bbsep = null;
                separations = ImageNew.Same((BufferedImage)mib, (int)10);
                bbsep = ((DataBufferByte)separations.getRaster().getDataBuffer()).getData();
                for (int y = 1; y < height - 1; ++y) {
                    int x = 1;
                    int pos = y * width + x;
                    while (x < width - 1) {
                        if (iblabels[pos] != 0) {
                            if (iblabels[pos - 1] != 0 && iblabels[pos - 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos - 1] != 0 && iblabels[pos - 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos + 1] != 0 && iblabels[pos + 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos - width] != 0 && iblabels[pos - width] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos + width] != 0 && iblabels[pos + width] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos - width - 1] != 0 && iblabels[pos - width - 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos - width + 1] != 0 && iblabels[pos - width + 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos + width - 1] != 0 && iblabels[pos + width - 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos + width + 1] != 0 && iblabels[pos + width + 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                if (Crop) {
                    BufferedImage crop = ImageNew.SubImage((BufferedImage)separations, (int)minx, (int)miny, (int)maxx, (int)maxy);
                    ImageIO.Write(crop, ResultsPath + "/Separations/" + name + ".png", 6);
                    crop = this.allocator.Release(crop);
                } else {
                    ImageIO.Write(separations, ResultsPath + "/Separations/" + name + ".png", 6);
                }
                bbsep = null;
                separations = this.allocator.Release(separations);
                BufferedImage contours = ImageNew.Same((BufferedImage)mib, (int)10);
                byte[] bbcontour = ((DataBufferByte)contours.getRaster().getDataBuffer()).getData();
                for (int y = 1; y < height - 1; ++y) {
                    int x = 1;
                    int pos = y * width + x;
                    while (x < width - 1) {
                        if (iblabels[pos] != 0) {
                            if (iblabels[pos - 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos - 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos + 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos - width] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos + width] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos - width - 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos - width + 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos + width - 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos + width + 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                if (Crop) {
                    BufferedImage crop = ImageNew.SubImage((BufferedImage)contours, (int)minx, (int)miny, (int)maxx, (int)maxy);
                    ImageIO.Write(crop, ResultsPath + "/Contours/" + name + ".png", 6);
                    this.allocator.Release(crop);
                } else {
                    ImageIO.Write(contours, ResultsPath + "/Contours/" + name + ".png", 6);
                }
                bbcontour = null;
                contours = this.allocator.Release(contours);
                if (DistanceMap) {
                    this.dmc.ComputeGrayLevel(mib, this.sem2, true);
                    BufferedImage map = ImageNew.SameFloat((BufferedImage)mib);
                    ImageConverter.FloatToImage((float[])this.dmc.getMontanariMap1D(), (BufferedImage)map);
                    if (Crop) {
                        BufferedImage crop = ImageNew.SubImage((BufferedImage)map, (int)minx, (int)miny, (int)maxx, (int)maxy);
                        ImageIO.Write(crop, ResultsPath + "/Distance Maps/" + name + ".tif", 8);
                        this.allocator.Release(crop);
                    } else {
                        ImageIO.Write(map, ResultsPath + "/Distance Maps/" + name + ".tif", 8);
                    }
                    map = this.allocator.Release(map);
                }
                if (Crop) {
                    BufferedImage crop = ImageNew.SubImage((BufferedImage)im, (int)minx, (int)miny, (int)maxx, (int)maxy);
                    ImageIO.Write(crop, ResultsPath + "/Originals/" + name + ".png", 6);
                    this.allocator.Release(crop);
                } else {
                    ImageIO.Write(im, ResultsPath + "/Originals/" + name + ".png", 6);
                }
                if (Stretch) {
                    BufferedImage stretched = null;
                    switch (im.getType()) {
                        case 10: {
                            stretched = this.dynexp.FilterWithConditions(im, 1.0, 0.05, -1, 0, 255, nbCPU);
                            break;
                        }
                        case 11: {
                            stretched = this.dynexp.FilterWithConditions(im, 1.0, 0.05, -1, 0, 65535, nbCPU);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Image type not supported (yet) for stretching.");
                        }
                    }
                    if (Crop) {
                        BufferedImage crop = ImageNew.SubImage((BufferedImage)stretched, (int)minx, (int)miny, (int)maxx, (int)maxy);
                        ImageIO.Write(crop, ResultsPath + "/Originals Stretched/" + name + ".png", 6);
                        this.allocator.Release(crop);
                    } else {
                        ImageIO.Write(stretched, ResultsPath + "/Originals Stretched/" + name + ".png", 6);
                    }
                }
                if (Detection2 != null) {
                    if (Crop) {
                        imlabels = ImageNew.SubImage((BufferedImage)imlabels, (int)minx, (int)miny, (int)maxx, (int)maxy);
                        this.ufccl.Label(imlabels, 0, false);
                    }
                    int nbobj = this.ufccl.ConnectedComponentsNumber();
                    this.ufccl.ComputeBoundingBoxes();
                    int[] xmin = this.ufccl.minx();
                    int[] ymin = this.ufccl.miny();
                    int[] xmax = this.ufccl.maxx();
                    int[] ymax = this.ufccl.maxy();
                    try (DataOutputStream out = new DataOutputStream(new FileOutputStream(ResultsPath + "/Detection/" + name + ".txt"));){
                        int c;
                        out.write("# Compatible with PASCAL Annotation Version 1.00\n".getBytes("ISO-8859-1"));
                        out.write(("Image filename: \"" + Dataset + "/Originals/" + name + ".png\"\n").getBytes("ISO-8859-1"));
                        out.write(("Image size (X x Y x C): \"" + Dataset + "/Originals/" + imlabels.getWidth() + " x " + imlabels.getHeight() + " x " + imlabels.getRaster().getNumBands() + "\n").getBytes("ISO-8859-1"));
                        out.write(("Objects with ground truth: " + nbobj + " { ").getBytes("ISO-8859-1"));
                        for (c = 0; c < nbobj; ++c) {
                            out.write(("\n" + Detection2 + "\" ").getBytes("ISO-8859-1"));
                        }
                        out.write("}\n\n".getBytes("ISO-8859-1"));
                        for (c = 1; c <= nbobj; ++c) {
                            out.write(("# Details for " + Detection2 + " " + c + "\n").getBytes("ISO-8859-1"));
                            out.write(("Original label for object " + c + "\"" + Detection2 + "\": \"" + Detection2 + "\"\n").getBytes("ISO-8859-1"));
                            out.write(("Bounding box for object " + c + "\"" + Detection2 + "\" (Xmin, Ymin) - (Xmax, Ymax): (").getBytes("ISO-8859-1"));
                            out.write((xmin[c] + ", " + ymin[c] + ") - (" + xmax[c] + ", " + ymax[c] + ")\n").getBytes("ISO-8859-1"));
                            out.write(("Pixel mask for object " + c + "\"" + Detection2 + "\": \"").getBytes("ISO-8859-1"));
                            out.write((Dataset + "/Labels/" + name + ".png\"\n\n").getBytes("ISO-8859-1"));
                        }
                        out.close();
                    }
                }
                mib = null;
                im = null;
                imlabels = this.allocator.Release(imlabels);
                this.allocator.ClearAll(true);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
    }

    public void LabelsToMultipleOutputs(String Originals, String LabelsPath, boolean Crop, int Margin, boolean Stretch, boolean DistanceMap, String Detection2, String ResultsPath, int nbCPU) {
        File resdir = new File(ResultsPath);
        String Dataset = resdir.getName();
        resdir = new File(ResultsPath + "/Labels/");
        if (!resdir.exists()) {
            resdir.mkdirs();
        }
        if (!(resdir = new File(ResultsPath + "/Separations/")).exists()) {
            resdir.mkdirs();
        }
        if (!(resdir = new File(ResultsPath + "/Contours/")).exists()) {
            resdir.mkdirs();
        }
        if (!(resdir = new File(ResultsPath + "/Foreground/")).exists()) {
            resdir.mkdirs();
        }
        if (DistanceMap && !(resdir = new File(ResultsPath + "/Distance Maps/")).exists()) {
            resdir.mkdirs();
        }
        if (Originals != null && !(resdir = new File(ResultsPath + "/Originals/")).exists()) {
            resdir.mkdirs();
        }
        if (Stretch && !(resdir = new File(ResultsPath + "/Originals Stretched/")).exists()) {
            resdir.mkdirs();
        }
        if (Detection2 != null && !(resdir = new File(ResultsPath + "/Detection/")).exists()) {
            resdir.mkdirs();
        }
        resdir = null;
        Object[] originals = new File(Originals).listFiles(FileNameFilters.ImagesPNGorTIF);
        if (originals == null || originals.length == 0) {
            throw new IllegalArgumentException("No images found in '" + Originals + "'");
        }
        Arrays.sort(originals);
        Object[] imLabels = new File(LabelsPath).listFiles(FileNameFilters.ImagesPNGorTIF);
        if (imLabels == null || imLabels.length == 0) {
            throw new IllegalArgumentException("No images found in '" + LabelsPath + "'");
        }
        Arrays.sort(imLabels);
        if (originals.length != imLabels.length) {
            throw new IllegalArgumentException("Different number of images in '" + Originals + "' and '" + LabelsPath + "'");
        }
        if (Crop && Margin < 0) {
            throw new IllegalArgumentException("Negative margin for the crop... Moron!");
        }
        for (int i2 = 0; i2 < imLabels.length; ++i2) {
            try {
                BufferedImage crop;
                BufferedImage mib = ImageIO.Read((File)imLabels[i2]);
                int width = mib.getWidth();
                int height = mib.getHeight();
                BufferedImage im = ImageIO.Read((File)originals[i2]);
                if (im.getWidth() != width || im.getHeight() != height) {
                    throw new Exception("Images have different dimensions.");
                }
                String name = ((File)originals[i2]).getName().substring(0, ((File)originals[i2]).getName().lastIndexOf(46));
                int minx = width;
                int miny = height;
                int maxx = 0;
                int maxy = 0;
                if (Crop) {
                    byte[] bbmib = ((DataBufferByte)mib.getRaster().getDataBuffer()).getData();
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            if (bbmib[pos] != 0) {
                                if (x < minx) {
                                    minx = x;
                                }
                                if (y < miny) {
                                    miny = y;
                                }
                                if (maxx < x) {
                                    maxx = x;
                                }
                                if (maxy < y) {
                                    maxy = y;
                                }
                            }
                            ++x;
                            ++pos;
                        }
                    }
                    minx = Math.max(0, minx - Margin);
                    miny = Math.max(0, miny - Margin);
                    maxx = Math.min(maxx + Margin, width - 1);
                    maxy = Math.min(maxy + Margin, height - 1);
                }
                this.ufccl.Label(mib, 0, false);
                int[] labels = this.ufccl.Labels1D();
                BufferedImage imlabels = ImageNew.SameInteger((BufferedImage)mib);
                ImageConverter.ArrayToImage((int[])labels, (BufferedImage)imlabels);
                int[] iblabels = ((DataBufferInt)imlabels.getRaster().getDataBuffer()).getData();
                BufferedImage imlabels2 = ImageNew.Same((BufferedImage)mib, (int)10);
                ImageComparator.Compare((BufferedImage)imlabels, (String)"==", (int)0, (int)0, (int)255, (BufferedImage)imlabels2);
                if (Crop) {
                    crop = ImageNew.SubImage((BufferedImage)imlabels, (int)minx, (int)miny, (int)maxx, (int)maxy);
                    ImageIO.Write(crop, ResultsPath + "/Labels/" + name + ".tif", 8);
                    this.allocator.Release(crop);
                } else {
                    ImageIO.Write(imlabels, ResultsPath + "/Labels/" + name + ".tif", 8);
                }
                ImageComparator.Compare((BufferedImage)imlabels, (String)"==", (int)0, (int)0, (int)255, (BufferedImage)imlabels2);
                if (Crop) {
                    crop = ImageNew.SubImage((BufferedImage)imlabels2, (int)minx, (int)miny, (int)maxx, (int)maxy);
                    ImageIO.Write(crop, ResultsPath + "/Foreground/" + name + ".png", 6);
                    this.allocator.Release(crop);
                } else {
                    ImageIO.Write(imlabels2, ResultsPath + "/Foreground/" + name + ".png", 6);
                }
                imlabels2 = this.allocator.Release(imlabels2);
                labels = null;
                BufferedImage separations = ImageNew.Same((BufferedImage)mib, (int)10);
                byte[] bbsep = ((DataBufferByte)separations.getRaster().getDataBuffer()).getData();
                for (int y = 1; y < height - 1; ++y) {
                    int x = 1;
                    int pos = y * width + x;
                    while (x < width - 1) {
                        if (iblabels[pos] != 0) {
                            if (iblabels[pos - 1] != 0 && iblabels[pos - 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos - 1] != 0 && iblabels[pos - 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos + 1] != 0 && iblabels[pos + 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos - width] != 0 && iblabels[pos - width] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos + width] != 0 && iblabels[pos + width] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos - width - 1] != 0 && iblabels[pos - width - 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos - width + 1] != 0 && iblabels[pos - width + 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos + width - 1] != 0 && iblabels[pos + width - 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            } else if (iblabels[pos + width + 1] != 0 && iblabels[pos + width + 1] != iblabels[pos]) {
                                bbsep[pos] = -1;
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                if (Crop) {
                    BufferedImage crop2 = ImageNew.SubImage((BufferedImage)separations, (int)minx, (int)miny, (int)maxx, (int)maxy);
                    ImageIO.Write(crop2, ResultsPath + "/Separations/" + name + ".png", 6);
                    crop2 = this.allocator.Release(crop2);
                } else {
                    ImageIO.Write(separations, ResultsPath + "/Separations/" + name + ".png", 6);
                }
                bbsep = null;
                separations = this.allocator.Release(separations);
                BufferedImage contours = ImageNew.Same((BufferedImage)mib, (int)10);
                byte[] bbcontour = ((DataBufferByte)contours.getRaster().getDataBuffer()).getData();
                for (int y = 1; y < height - 1; ++y) {
                    int x = 1;
                    int pos = y * width + x;
                    while (x < width - 1) {
                        if (iblabels[pos] != 0) {
                            if (iblabels[pos - 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos - 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos + 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos - width] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos + width] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos - width - 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos - width + 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos + width - 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            } else if (iblabels[pos + width + 1] != iblabels[pos]) {
                                bbcontour[pos] = -1;
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                if (Crop) {
                    BufferedImage crop3 = ImageNew.SubImage((BufferedImage)contours, (int)minx, (int)miny, (int)maxx, (int)maxy);
                    ImageIO.Write(crop3, ResultsPath + "/Contours/" + name + ".png", 6);
                    this.allocator.Release(crop3);
                } else {
                    ImageIO.Write(contours, ResultsPath + "/Contours/" + name + ".png", 6);
                }
                bbcontour = null;
                contours = this.allocator.Release(contours);
                if (DistanceMap) {
                    this.dmc.ComputeGrayLevel(mib, this.sem2, true);
                    BufferedImage map = ImageNew.SameFloat((BufferedImage)mib);
                    ImageConverter.FloatToImage((float[])this.dmc.getMontanariMap1D(), (BufferedImage)map);
                    if (Crop) {
                        BufferedImage crop4 = ImageNew.SubImage((BufferedImage)map, (int)minx, (int)miny, (int)maxx, (int)maxy);
                        ImageIO.Write(crop4, ResultsPath + "/Distance Maps/" + name + ".tif", 8);
                        this.allocator.Release(crop4);
                    } else {
                        ImageIO.Write(map, ResultsPath + "/Distance Maps/" + name + ".tif", 8);
                    }
                    map = this.allocator.Release(map);
                }
                if (Crop) {
                    BufferedImage crop5 = ImageNew.SubImage((BufferedImage)im, (int)minx, (int)miny, (int)maxx, (int)maxy);
                    ImageIO.Write(crop5, ResultsPath + "/Originals/" + name + ".png", 6);
                    this.allocator.Release(crop5);
                } else {
                    ImageIO.Write(im, ResultsPath + "/Originals/" + name + ".png", 6);
                }
                if (Stretch) {
                    BufferedImage stretched = null;
                    switch (im.getType()) {
                        case 10: {
                            stretched = this.dynexp.FilterWithConditions(im, 1.0, 0.05, -1, 0, 255, nbCPU);
                            break;
                        }
                        case 11: {
                            stretched = this.dynexp.FilterWithConditions(im, 1.0, 0.05, -1, 0, 65535, nbCPU);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Image type not supported (yet) for stretching.");
                        }
                    }
                    if (Crop) {
                        BufferedImage crop6 = ImageNew.SubImage((BufferedImage)stretched, (int)minx, (int)miny, (int)maxx, (int)maxy);
                        ImageIO.Write(crop6, ResultsPath + "/Originals Stretched/" + name + ".png", 6);
                        this.allocator.Release(crop6);
                    } else {
                        ImageIO.Write(stretched, ResultsPath + "/Originals Stretched/" + name + ".png", 6);
                    }
                }
                if (Detection2 != null) {
                    if (Crop) {
                        imlabels = ImageNew.SubImage((BufferedImage)imlabels, (int)minx, (int)miny, (int)maxx, (int)maxy);
                        this.ufccl.Label(imlabels, 0, false);
                    }
                    int nbobj = this.ufccl.ConnectedComponentsNumber();
                    this.ufccl.ComputeBoundingBoxes();
                    int[] xmin = this.ufccl.minx();
                    int[] ymin = this.ufccl.miny();
                    int[] xmax = this.ufccl.maxx();
                    int[] ymax = this.ufccl.maxy();
                    try (DataOutputStream out = new DataOutputStream(new FileOutputStream(ResultsPath + "/Detection/" + name + ".txt"));){
                        int c;
                        out.write("# Compatible with PASCAL Annotation Version 1.00\n".getBytes("ISO-8859-1"));
                        out.write(("Image filename: \"" + Dataset + "/Originals/" + name + ".png\"\n").getBytes("ISO-8859-1"));
                        out.write(("Image size (X x Y x C): \"" + Dataset + "/Originals/" + imlabels.getWidth() + " x " + imlabels.getHeight() + " x " + imlabels.getRaster().getNumBands() + "\n").getBytes("ISO-8859-1"));
                        out.write(("Objects with ground truth: " + nbobj + " { ").getBytes("ISO-8859-1"));
                        for (c = 0; c < nbobj; ++c) {
                            out.write(("\n" + Detection2 + "\" ").getBytes("ISO-8859-1"));
                        }
                        out.write("}\n\n".getBytes("ISO-8859-1"));
                        for (c = 1; c <= nbobj; ++c) {
                            out.write(("# Details for " + Detection2 + " " + c + "\n").getBytes("ISO-8859-1"));
                            out.write(("Original label for object " + c + "\"" + Detection2 + "\": \"" + Detection2 + "\"\n").getBytes("ISO-8859-1"));
                            out.write(("Bounding box for object " + c + "\"" + Detection2 + "\" (Xmin, Ymin) - (Xmax, Ymax): (").getBytes("ISO-8859-1"));
                            out.write((xmin[c] + ", " + ymin[c] + ") - (" + xmax[c] + ", " + ymax[c] + ")\n").getBytes("ISO-8859-1"));
                            out.write(("Pixel mask for object " + c + "\"" + Detection2 + "\": \"").getBytes("ISO-8859-1"));
                            out.write((Dataset + "/Labels/" + name + ".png\"\n\n").getBytes("ISO-8859-1"));
                        }
                        out.close();
                    }
                }
                mib = null;
                im = null;
                imlabels = this.allocator.Release(imlabels);
                this.allocator.ClearAll(true);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
    }

    public void LabelsToMIBinputs(String LabelsPath, String ResultsPath, int nbCPU) {
        File resdir = new File(ResultsPath);
        resdir.mkdirs();
        File[] images = new File(LabelsPath).listFiles(FileNameFilters.ImagesTIF);
        if (images == null || images.length == 0) {
            throw new IllegalArgumentException("No images found in '" + LabelsPath + "'");
        }
        for (File image : images) {
            try {
                BufferedImage im = ImageIO.Read(image);
                String name = image.getName().substring(0, image.getName().lastIndexOf(46));
                int width = im.getWidth();
                int height = im.getHeight();
                int[] iblabels = ((DataBufferInt)im.getRaster().getDataBuffer()).getData();
                BufferedImage result = ImageNew.Same((BufferedImage)im, (int)10);
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                ImageComparator.Compare((BufferedImage)im, (String)"!=", (int)0, (int)1, (int)0, (BufferedImage)result);
                for (int y = 1; y < height - 1; ++y) {
                    int x = 1;
                    int pos = y * width + x;
                    while (x < width - 1) {
                        if (iblabels[pos] != 0) {
                            if (iblabels[pos - 1] != 0 && iblabels[pos - 1] < iblabels[pos]) {
                                bbres[pos] = 2;
                            } else if (iblabels[pos - 1] != 0 && iblabels[pos - 1] < iblabels[pos]) {
                                bbres[pos] = 2;
                            } else if (iblabels[pos + 1] != 0 && iblabels[pos + 1] < iblabels[pos]) {
                                bbres[pos] = 2;
                            } else if (iblabels[pos - width] != 0 && iblabels[pos - width] < iblabels[pos]) {
                                bbres[pos] = 2;
                            } else if (iblabels[pos + width] != 0 && iblabels[pos + width] < iblabels[pos]) {
                                bbres[pos] = 2;
                            } else if (iblabels[pos - width - 1] != 0 && iblabels[pos - width - 1] < iblabels[pos]) {
                                bbres[pos] = 2;
                            } else if (iblabels[pos - width + 1] != 0 && iblabels[pos - width + 1] < iblabels[pos]) {
                                bbres[pos] = 2;
                            } else if (iblabels[pos + width - 1] != 0 && iblabels[pos + width - 1] < iblabels[pos]) {
                                bbres[pos] = 2;
                            } else if (iblabels[pos + width + 1] != 0 && iblabels[pos + width + 1] < iblabels[pos]) {
                                bbres[pos] = 2;
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                ImageIO.Write(result, ResultsPath + "/" + name + " - MIB.png", 6);
                result = this.allocator.Release(result);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        this.allocator.ClearAll(true);
    }

    public void Crop(String inputdir, String resultdir) throws Exception {
        File[] dirs = new File(inputdir).listFiles(FileFilters.Directories);
        int nbImages = dirs[0].listFiles(FileFilters.ImagesPNGorTIF).length;
        for (int i2 = 0; i2 < nbImages; ++i2) {
            int X = -1;
            int Y = -1;
            int SizeX = -1;
            int SizeY = -1;
            for (File dir : dirs) {
                Object[] Images = dir.listFiles(FileFilters.ImagesPNGorTIF);
                Arrays.sort(Images);
                if (Images.length != nbImages) {
                    throw new Exception("Images.length != nbImages");
                }
                BufferedImage image = ImageIO.Read(dir + "/" + ((File)Images[i2]).getName());
                if (X == -1 || Y == -1) {
                    X = (int)(Math.random() * (double)(image.getWidth() >> 1));
                    Y = (int)(Math.random() * (double)(image.getHeight() >> 1));
                    SizeX = 600 + (int)(Math.random() * 100.0);
                    SizeY = 600 + (int)(Math.random() * 100.0);
                }
                BufferedImage crop = ImageNew.SubImageWH((BufferedImage)image, (int)X, (int)Y, (int)SizeX, (int)SizeY);
                File resdir = new File(resultdir + "/" + dir.getName());
                if (!resdir.exists()) {
                    resdir.mkdirs();
                }
                ImageIO.Write(crop, resdir.getAbsolutePath() + "/" + ((File)Images[i2]).getName(), StringToolsImageDV.FindExtension((String)((File)Images[i2]).getName()).equalsIgnoreCase("tif") ? 8 : 6);
            }
            System.out.println();
        }
    }

    private BufferedImage Separations(BufferedImage image, boolean EightConnex) {
        int width = image.getWidth();
        int height = image.getHeight();
        int w1 = width - 1;
        int h1 = height - 1;
        int p0 = -1;
        int p1 = -width - 1;
        int p2 = -width;
        int p3 = -width + 1;
        boolean p4 = true;
        int p5 = width + 1;
        int p6 = width;
        int p7 = width - 1;
        BufferedImage result = null;
        switch (image.getType()) {
            case 10: {
                byte[] labels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                result = ImageNew.Same((BufferedImage)image, (int)10);
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (labels[pos] != 0) {
                            byte label = labels[pos];
                            if (0 < x && labels[pos + -1] != 0 && labels[pos + -1] != label || x < w1 && labels[pos + 1] != 0 && labels[pos + 1] != label || 0 < y && labels[pos + p2] != 0 && labels[pos + p2] != label || y < h1 && labels[pos + p6] != 0 && labels[pos + p6] != label) {
                                bbres[pos] = 1;
                            } else if (!EightConnex && (0 < x && 0 < y && labels[pos + p1] != 0 && labels[pos + p1] != label || x < w1 && 0 < y && labels[pos + p3] != 0 && labels[pos + p3] != label || x < w1 && y < h1 && labels[pos + p5] != 0 && labels[pos + p5] != label || 0 < x && y < h1 && labels[pos + p7] != 0 && labels[pos + p7] != label)) {
                                bbres[pos] = 1;
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 11: {
                short[] slabels = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                result = ImageNew.Same((BufferedImage)image, (int)11);
                short[] sbres = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (slabels[pos] != 0) {
                            short label = slabels[pos];
                            if (0 < x && slabels[pos + -1] != 0 && slabels[pos + -1] != label || x < w1 && slabels[pos + 1] != 0 && slabels[pos + 1] != label || 0 < y && slabels[pos + p2] != 0 && slabels[pos + p2] != label || y < h1 && slabels[pos + p6] != 0 && slabels[pos + p6] != label) {
                                sbres[pos] = 1;
                            } else if (!EightConnex && (0 < x && 0 < y && slabels[pos + p1] != 0 && slabels[pos + p1] != label || x < w1 && 0 < y && slabels[pos + p3] != 0 && slabels[pos + p3] != label || x < w1 && y < h1 && slabels[pos + p5] != 0 && slabels[pos + p5] != label || 0 < x && y < h1 && slabels[pos + p7] != 0 && slabels[pos + p7] != label)) {
                                sbres[pos] = 1;
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
        }
        return result;
    }

    public void HMS(String inputdir, boolean toFix, String outputdir, int nbCPU) {
        File[] imFiles;
        float[] coefficients = new float[512];
        Sigmoid sig = new Sigmoid(1.0);
        int limit = 23;
        Arrays.fill(coefficients, 0, limit, 1.0f);
        for (float f = 5.0f; f >= -5.0f; f -= 0.2f) {
            coefficients[limit++] = sig.Compute(f);
        }
        Arrays.fill(coefficients, limit, coefficients.length, 0.0f);
        for (File imFile : imFiles = new File(inputdir).listFiles(file -> file.getName().charAt(0) != '.' && !file.getName().contains("DS_Store") && file.getName().endsWith("_DAPI.png"))) {
            try {
                String name = imFile.getName();
                BufferedImage dapi = ImageIO.Read(imFile);
                BufferedImage contours = ImageIO.Read(inputdir + "/" + name.replace("_DAPI.png", "_class1.png"));
                int max = contours.getType() == 10 ? 255 : 65535;
                ImageComparator.Compare((BufferedImage)contours, (String)"==", (int)0, (int)0, (int)max, (BufferedImage)contours);
                BufferedImage inv = this.invert.Filter(contours, 1);
                File fileback = new File(inputdir + "/" + name.replace("_DAPI.png", "_class4.png"));
                if (!fileback.exists()) continue;
                HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>();
                this.ufccl.Label(inv, 0, false);
                int[] labels = this.ufccl.Labels1D();
                BufferedImage imback = ImageIO.Read(fileback);
                switch (imback.getType()) {
                    case 10: {
                        byte[] bbimb = ((DataBufferByte)imback.getRaster().getDataBuffer()).getData();
                        for (int i2 = 0; i2 < bbimb.length; ++i2) {
                            if (bbimb[i2] == 0 || labels[i2] == 0) continue;
                            hm.put(labels[i2], 0);
                        }
                        bbimb = null;
                        break;
                    }
                    case 11: {
                        short[] sbimb = ((DataBufferUShort)imback.getRaster().getDataBuffer()).getData();
                        for (int i3 = 0; i3 < sbimb.length; ++i3) {
                            if (sbimb[i3] == 0 || labels[i3] == 0) continue;
                            hm.put(labels[i3], 0);
                        }
                        sbimb = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Default");
                    }
                }
                LinkedList toDelete = new LinkedList(hm.keySet());
                this.ufccl.DeleteCCs(inv, toDelete);
                toDelete.clear();
                BufferedImage foreground = ImageNew.Same((BufferedImage)contours);
                ImageComparator.Compare((BufferedImage)inv, (String)"==", (int)0, (BufferedImage)contours, (int)max, (BufferedImage)foreground);
                BufferedImage result = ImageNew.Same((BufferedImage)foreground, (int)10);
                ImageComparator.Compare((BufferedImage)foreground, (String)"==", (int)0, (int)0, (int)1, (BufferedImage)result);
                this.ufccl.Label(inv, 0, false);
                BufferedImage nuclei = ImageConverter.ArrayToImage((int[])this.ufccl.Labels1D(), (int)inv.getWidth(), (int)inv.getHeight());
                BufferedImage imskiz = this.skiz.Filter(nuclei, this.sem2, 0, nbCPU);
                ImageComparator.Compare((BufferedImage)foreground, (String)"!=", (int)0, (BufferedImage)imskiz, (int)0, (BufferedImage)imskiz);
                BufferedImage sep = this.Separations(imskiz, true);
                ImageComparator.Compare((BufferedImage)sep, (String)"==", (int)0, (BufferedImage)result, (int)2, (BufferedImage)result);
                ImageIO.Write(result, outputdir + "/" + name.replace("_DAPI.png", ".png"), 6);
                if (toFix) {
                    ImageComparator.Compare((BufferedImage)result, (String)"==", (int)0, (int)max, (int)0, (BufferedImage)inv);
                    this.dmc.Compute(inv, this.sem2);
                    float[] map = this.dmc.getMontanariMap1D();
                    short[] sbdapi = ((DataBufferUShort)dapi.getRaster().getDataBuffer()).getData();
                    switch (result.getType()) {
                        case 10: {
                            byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                            for (int i4 = 0; i4 < bbres.length; ++i4) {
                                if (bbres[i4] != 0) continue;
                                sbdapi[i4] = (short)((float)(sbdapi[i4] & 0xFFF) * map[i4]);
                            }
                            break;
                        }
                        case 11: {
                            short[] sbres = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                            for (int i5 = 0; i5 < sbres.length; ++i5) {
                                if (sbres[i5] != 0) continue;
                                sbdapi[i5] = (short)((float)(sbdapi[i5] & 0xFFF) * map[i5]);
                            }
                            break;
                        }
                    }
                    ImageIO.Write(dapi, outputdir + "/" + name, 6);
                }
                imback = null;
                dapi = null;
                inv = this.allocator.Release(inv);
                foreground = this.allocator.Release(foreground);
                result = this.allocator.Release(result);
                nuclei = this.allocator.Release(nuclei);
                imskiz = this.allocator.Release(imskiz);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public BufferedImage UnMiscImagestoLabels(BufferedImage Nuclei, BufferedImage Contours, int nbCPU) throws IOException {
        if (!ImageTools.areDimensionsEqual((BufferedImage)Nuclei, (BufferedImage)Contours)) {
            throw new IllegalArgumentException("Different images dimensions.");
        }
        int width = Nuclei.getWidth();
        int height = Nuclei.getHeight();
        if (Nuclei.getType() != 10) {
            Nuclei = ImageConverter.Universal((BufferedImage)Nuclei, (int)10);
        }
        ImageComparator.Compare((BufferedImage)Nuclei, (String)"==", (int)0, (int)0, (int)1, (BufferedImage)Nuclei);
        if (Contours.getType() != 10) {
            Contours = ImageConverter.Universal((BufferedImage)Contours, (int)10);
        }
        ImageComparator.Compare((BufferedImage)Contours, (String)"==", (int)0, (int)0, (int)1, (BufferedImage)Contours);
        byte[] bbcon = ((DataBufferByte)Contours.getRaster().getDataBuffer()).getData();
        BufferedImage imSep = ImageArithmetic.Subtract(Nuclei, Contours, 0, 0);
        System.out.println(ImageTools.areEqual((BufferedImage)Nuclei, (BufferedImage)imSep));
        this.ufccl.Label(imSep, 0, false);
        int[] labels = this.ufccl.Labels1D();
        BufferedImage imLabels = ImageNew.SameInteger((BufferedImage)Nuclei);
        ImageConverter.ArrayToImage((int[])labels, (BufferedImage)imLabels);
        int[] iblabels = ((DataBufferInt)imLabels.getRaster().getDataBuffer()).getData();
        BufferedImage imskiz = this.skiz.Filter(imLabels, this.sem2, nbCPU);
        float[] skizmap = this.skiz.Map();
        int[] skizlabels = ((DataBufferInt)imskiz.getRaster().getDataBuffer()).getData();
        ImageIO.Write(ImageConverter.ArrayToImage((float[])skizmap, (int)width, (int)height), "./Skiz_Map.tif", 8);
        ImageIO.SaveLabels(imskiz, "./Skiz_Labels");
        for (int x = 0; x < skizmap.length; ++x) {
            if (bbcon[x] == 0) continue;
            iblabels[x] = skizlabels[x];
        }
        bbcon = null;
        skizlabels = null;
        iblabels = null;
        labels = null;
        skizmap = null;
        imSep = this.allocator.Release(imSep);
        imskiz = this.allocator.Release(imskiz);
        this.allocator.ClearAll(true);
        return imLabels;
    }
}

