/*
 * Decompiled with CFR 0.152.
 */
package softwares;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import utils.times.Chronometer;

public class CityHall {
    private boolean[] winner = new boolean[3];
    private List<Integer> candidates = new ArrayList<Integer>(5);
    private Chronometer chrono = new Chronometer();

    public void Compute(int nbIterations) {
        int nbwin = 0;
        int nbwinchange = 0;
        System.out.println("City Hall empirical proof on " + nbIterations + " iterations");
        int marker = this.chrono.NewMarker();
        for (int n = 0; n < nbIterations; ++n) {
            this.Initialize();
            int choice = (int)(Math.random() * 3.0);
            int opened = this.OpenLostDoor(choice);
            int last = this.FinLast(choice, opened);
            if (this.winner[last]) {
                ++nbwinchange;
            }
            if (!this.winner[choice]) continue;
            ++nbwin;
        }
        System.out.println("Computed in " + this.chrono.getTimeSinceMarker(marker) + "s");
        System.out.println("nb win = " + nbwin + ", probability = " + (double)nbwin / (double)nbIterations);
        System.out.println("nb win change = " + nbwinchange + ", probability = " + (double)nbwinchange / (double)nbIterations);
    }

    private void Initialize() {
        Arrays.fill(this.winner, false);
        this.winner[(int)(Math.random() * 3.0)] = true;
    }

    private int OpenLostDoor(int choice) {
        this.candidates.clear();
        for (int i2 = 0; i2 < this.winner.length; ++i2) {
            if (this.winner[i2] || i2 == choice) continue;
            this.candidates.add(i2);
        }
        return this.candidates.get((int)(Math.random() * (double)this.candidates.size()));
    }

    private int FinLast(int choice, int opened) {
        int i2 = 0;
        for (i2 = 0; i2 < this.winner.length; ++i2) {
            if (i2 == choice || i2 == opened) continue;
            return i2;
        }
        if (i2 == this.winner.length) {
            throw new Error("Ouch... must not occured.");
        }
        return -1;
    }
}

