/*
 * Decompiled with CFR 0.152.
 */
package segmentation.cells;

import displays.Colors;
import displays.Display;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.io.IOException;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceMapComputer;
import morphee.Dilate;
import morphee.Erode;
import morphee.Open;
import morphee.StructuringElement;
import morphee.WhiteTopHat;
import morphee.filters.AreaOpening;
import morphee.filters.ToggleMapping;
import morphee.residues.UltimateOpening;
import morphee.segmentation.minmax.Maxima;
import morphee.segmentation.watershed.Watershed;
import processing.filters.DynamicExpansion;
import processing.filters.Median;
import processing.filters.gradients.Sobel;
import processing.thresholding.Huang;
import processing.zprojection.ZProjectionCMM;

public class Lamin {
    private final AreaOpening areaop = new AreaOpening();
    private final UnionFindCcl ccl = new UnionFindCcl();
    private final DistanceMapComputer dmc = new DistanceMapComputer();
    private final Dilate dilate = new Dilate();
    private final Erode erode = new Erode();
    private final Huang huang = new Huang();
    private final Maxima maxima = new Maxima();
    private final Median median = new Median();
    private final Open open = new Open();
    private final Sobel sobel = new Sobel();
    private final ToggleMapping tm = new ToggleMapping();
    private final UltimateOpening uo = new UltimateOpening();
    private final Watershed watershed = new Watershed();
    private final WhiteTopHat wth = new WhiteTopHat();
    private final ZProjectionCMM zp = new ZProjectionCMM();
    private final StructuringElement se_disk_1 = new StructuringElement(new Object[]{1, -2});
    private final StructuringElement se_disk_2 = new StructuringElement(new Object[]{2, -2});
    private final StructuringElement se_disk_3 = new StructuringElement(new Object[]{2, -2});
    private final StructuringElement se_disk_5 = new StructuringElement(new Object[]{5, -2});
    private final StructuringElement se_hexagon_1 = new StructuringElement(new Object[]{1, -9});
    private final StructuringElement se_hexagon_3 = new StructuringElement(new Object[]{3, -9});
    private final StructuringElement se_montanari_3 = new StructuringElement(new Object[]{3, -15});
    private final StructuringElement se_montanari_5 = new StructuringElement(new Object[]{5, -15});
    public Display display = null;
    public boolean DeleteOnBorders = false;
    private final ImageFeatures IF = new ImageFeatures();
    public int ZProjectionIter = 13;
    public int ZProjectionType = 1;
    public int AreaOpSize = 511;
    public StructuringElement wthse = new StructuringElement(new Object[]{123, -2});
    public StructuringElement uose = new StructuringElement(new Object[]{163, -9});
    private final DynamicExpansion de = new DynamicExpansion();

    public BufferedImage LaminAC_2D(BufferedImage[] lamin, String respath, int nbCPU) throws IOException {
        BufferedImage zproj = ImageNew.Same((BufferedImage)lamin[0]);
        this.zp.Classic(lamin, this.ZProjectionType, -9, this.ZProjectionIter, true, zproj, nbCPU);
        if (respath != null) {
            ImageIO.Write(zproj, respath + "/ZProjection.png", 6);
        }
        zproj = this.Converter(zproj);
        return this.LaminABC_2D(zproj, respath, nbCPU);
    }

    public BufferedImage LaminABC_2D(BufferedImage source, String respath, int nbCPU) throws IOException {
        if (source.getType() != 10) {
            throw new IllegalArgumentException("TYPE_BYTE_GRAY image required.");
        }
        BufferedImage result = ImageNew.Clone((BufferedImage)source);
        BufferedImage tmp1 = ImageNew.Same((BufferedImage)source);
        BufferedImage tmp2 = ImageNew.Same((BufferedImage)source);
        BufferedImage tmp3 = ImageNew.Same((BufferedImage)source);
        this.median.Filter(source, this.se_disk_2, tmp1, nbCPU);
        BufferedImage resmed = tmp1;
        this.uo.Filter(resmed, this.uose, tmp2, nbCPU);
        BufferedImage resuo = tmp2;
        this.wth.Filter(resmed, this.wthse, tmp3, nbCPU);
        BufferedImage reswth = tmp3;
        this.areaop.Filter(reswth, tmp1, this.AreaOpSize, true);
        BufferedImage resao = tmp1;
        this.open.Filter(resao, this.se_hexagon_3, tmp3, nbCPU);
        BufferedImage resop = tmp3;
        BufferedImage resclean = ImageNew.Same((BufferedImage)source);
        ImageComparator.Compare((BufferedImage)resop, (String)">", (int)5, (BufferedImage)resop, (int)0, (BufferedImage)resclean);
        ImageComparator.Compare((BufferedImage)resuo, (String)">", (int)1, (BufferedImage)resclean, (int)0, (BufferedImage)resclean);
        int mean = (int)Math.round(this.IF.Average(resclean, 0));
        this.sobel.HowCorrect(2);
        this.sobel.Filter(resao, tmp3, nbCPU);
        BufferedImage ressobel = tmp3;
        BufferedImage markers = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)1);
        ImageComparator.Compare((BufferedImage)resclean, (String)">=", (int)mean, (int)255, (int)0, (BufferedImage)markers);
        ImageComparator.Compare((BufferedImage)resclean, (String)"!=", (int)0, (BufferedImage)markers, (int)128, (BufferedImage)markers);
        ImageComparator.Compare((BufferedImage)resuo, (String)">", (int)1, (BufferedImage)markers, (int)128, (BufferedImage)markers);
        this.watershed.watershed(ressobel, markers, this.se_disk_1);
        ImageComparator.Compare((BufferedImage)this.watershed.Basins(), (String)"==", (int)255, (int)255, (int)0, (BufferedImage)this.watershed.Basins());
        ImageConverter.IntToByte((BufferedImage)this.watershed.Basins(), (BufferedImage)tmp1);
        if (this.DeleteOnBorders) {
            this.ccl.Label(tmp1, 0, true);
            this.ccl.DeleteOnBorder(tmp1, new int[0]);
        }
        ImageComparator.Compare((BufferedImage)tmp1, (String)"!=", (int)0, (BufferedImage)result, (int)0, (BufferedImage)result);
        if (respath != null) {
            ImageIO.Write(result, respath + "/Segmentation.png", 6);
        }
        if (respath != null) {
            BufferedImage rbg = ImageConverter.GrayToColor((BufferedImage)source);
            ImageDrawer.Draw(rbg, this.watershed.Edges(), Colors.RED);
            ImageIO.Write(rbg, respath + "/Segmentation RGB.png", 6);
            rbg = null;
        }
        ressobel = null;
        resop = null;
        resao = null;
        reswth = null;
        resuo = null;
        resmed = null;
        markers = null;
        resclean = null;
        tmp3 = null;
        tmp2 = null;
        tmp1 = null;
        return result;
    }

    public BufferedImage LaminB_2D(BufferedImage[] lamin, String respath, int nbCPU) throws IOException {
        BufferedImage zproj = ImageNew.Same((BufferedImage)lamin[0]);
        this.zp.Classic(lamin, this.ZProjectionType, -9, this.ZProjectionIter, true, zproj, nbCPU);
        if (respath != null) {
            ImageIO.Write(zproj, respath + "/ZProjection.png", 6);
        }
        zproj = this.Converter(zproj);
        return this.LaminABC_2D(zproj, respath, nbCPU);
    }

    private BufferedImage Converter(BufferedImage image) {
        if (image.getType() == 10) {
            return image;
        }
        int max = (int)this.IF.Maximum(image);
        this.de.Filter(image, 0, max, 0, 255, image, 1);
        BufferedImage im8 = ImageNew.Same((BufferedImage)image, (int)10);
        ImageConverter.Universal((BufferedImage)image, (BufferedImage)im8);
        return im8;
    }
}

