/*
 * Decompiled with CFR 0.152.
 */
package segmentation.cells;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayConverter;
import displays.Colors;
import displays.Display;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListTools;
import listTiTi.Queue;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import morphee.Dilate;
import morphee.Open;
import morphee.StructuringElement;
import morphee.WhiteTopHat;
import morphee.adaptive.DilateConstrained;
import morphee.filters.AreaClosing;
import morphee.filters.AreaOpening;
import morphee.residues.UltimateErode;
import morphee.residues.UltimateErode2;
import morphee.segmentation.SkizGeodesic;
import morphee.segmentation.watershed.Watershed;
import processing.filters.ContrastEqualizer;
import processing.filters.DynamicExpansion;
import processing.filters.Invert;
import processing.filters.gradients.Sobel;
import processing.thresholding.Binary;
import utils.memory.Allocator;

public class DapiMM {
    public static final int NUCLEI = 255;
    public static final int ROI100 = 200;
    public static final int ROI75 = 100;
    private AreaOpening areaop = new AreaOpening();
    private AreaClosing areacl = new AreaClosing();
    private Binary binary = new Binary();
    private ContrastEqualizer equalizer = new ContrastEqualizer();
    private Dilate dilate = new Dilate();
    private DilateConstrained dilconst = new DilateConstrained();
    private DynamicExpansion de = new DynamicExpansion();
    private FillHole fh = new FillHole();
    private Invert invert = new Invert();
    private Open open = new Open();
    private SkizGeodesic skiz = new SkizGeodesic();
    private Sobel sobel = new Sobel();
    private UltimateErode ue = new UltimateErode();
    private UltimateErode2 ue2 = new UltimateErode2(-9);
    private UnionFindCcl ccl = new UnionFindCcl();
    private Watershed watershed = new Watershed();
    private WhiteTopHat wth = new WhiteTopHat();
    private final ImageFeatures IF = new ImageFeatures();
    public Display display = null;
    private Allocator allocator = Allocator.Instance();
    public int AreaOpSize = -1;
    public int AreaClSize = -1;
    public int SubtractToTopHat = 500;
    private final int Magnification;
    private final boolean smallnuclei;
    private StructuringElement uese = new StructuringElement(new Object[]{2, -15});
    private StructuringElement dilse2 = new StructuringElement(new Object[]{2, -1});
    private StructuringElement wthse = null;
    private StructuringElement opse = new StructuringElement(new Object[]{1, -9});
    private StructuringElement dilse3 = new StructuringElement(new Object[]{3, -9});
    private StructuringElement sehex5 = new StructuringElement(new Object[]{5, -9});
    private StructuringElement sehex7 = new StructuringElement(new Object[]{7, -9});
    private StructuringElement sehex13 = new StructuringElement(new Object[]{13, -9});
    private StructuringElement wsse = new StructuringElement(new Object[]{1, -2});

    public DapiMM(int Magnification, boolean smallnuclei) {
        switch (Magnification) {
            case 5: {
                this.wthse = new StructuringElement(new Object[]{17, -9});
                this.AreaOpSize = 37;
                break;
            }
            case 10: {
                this.wthse = new StructuringElement(new Object[]{29, -9});
                this.AreaOpSize = 67;
                break;
            }
            case 20: {
                this.wthse = new StructuringElement(new Object[]{53, -9});
                this.AreaOpSize = 131;
                break;
            }
            case 40: {
                this.wthse = new StructuringElement(new Object[]{101, -9});
                this.AreaOpSize = 263;
                break;
            }
            default: {
                throw new IllegalArgumentException("Magnification not supported (yet).");
            }
        }
        this.Magnification = Magnification;
        this.smallnuclei = smallnuclei;
    }

    public void Segmentation(BufferedImage source, boolean dirtybackground, int simplifytexture, boolean equalize, boolean fillholes, boolean DeleteOnTop, boolean roi100saver, BufferedImage mask, int minsurface, String respath, int nbCPU) throws IOException, InterruptedException {
        int[] sizes;
        int[] labels;
        int width = source.getWidth();
        int height = source.getHeight();
        int length = width * height;
        BufferedImage tmp = ImageNew.Same((BufferedImage)source);
        BufferedImage reswth = ImageNew.Same((BufferedImage)source);
        if (equalize) {
            BufferedImage gray = ImageConverter.UShortGrayToGray((BufferedImage)source, (boolean)true);
            BufferedImage equal = this.equalizer.Filter(gray, ContrastEqualizer.Equalization.CLAHE, nbCPU);
            BufferedImage ushort = ImageConverter.GrayToUShort((BufferedImage)equal, (boolean)true);
            this.wth.Filter(ushort, this.wthse, reswth, nbCPU);
            ushort = this.allocator.Release(ushort);
            equal = null;
            gray = null;
        } else {
            this.wth.Filter(source, this.wthse, reswth, nbCPU);
        }
        if (dirtybackground) {
            ImageComparator.Compare((BufferedImage)reswth, (String)">", (int)0, (BufferedImage)source, (int)0, (BufferedImage)reswth);
        }
        BufferedImage reswthclean = ImageArithmetic.Subtract(reswth, (dirtybackground ? 2 : 1) * this.SubtractToTopHat, 0, 0);
        reswth = this.allocator.Release(reswth);
        if (ImageTools.isBlack((BufferedImage)reswthclean)) {
            if (respath != null) {
                ImageIO.Write(ImageNew.Same((BufferedImage)reswthclean, (int)10), respath + "/Segmentation - ROI.png", 6);
                ImageIO.Write(ImageNew.SameInteger((BufferedImage)reswthclean), respath + "/Watershed - Basins.tif", 8);
                System.out.println("----------------- WARNING ----------------- Empty image, premature exit 0.");
            }
            tmp = this.allocator.Release(tmp);
            reswthclean = this.allocator.Release(reswthclean);
            return;
        }
        this.de.Filter(reswthclean, 0, 65535, reswthclean, nbCPU);
        if (dirtybackground) {
            ImageComparator.Compare((BufferedImage)reswthclean, (String)">=", (int)5000, (BufferedImage)reswthclean, (int)0, (BufferedImage)reswthclean);
        }
        if (respath != null) {
            ImageIO.Write(reswthclean, respath + "/Intermediate - WhiteTopHat.png", 6);
        }
        BufferedImage resop = this.open.Filter(reswthclean, this.opse, nbCPU);
        if (0 < this.AreaClSize) {
            this.areacl.Filter(resop, tmp, this.AreaClSize, true);
            ImageNew.Copy((BufferedImage)tmp, (BufferedImage)resop);
        }
        BufferedImage resao = this.areaop.Filter(resop, this.AreaOpSize, true);
        if (respath != null) {
            ImageIO.Write(resao, respath + "/Intermediate - AreaOpening.png", 6);
        }
        ImageComparator.Compare((BufferedImage)resao, (String)">=", (int)(dirtybackground ? 3000 : 1000), (BufferedImage)resao, (int)0, (BufferedImage)resao);
        BufferedImage aocontour = ImageOperations.Contour((BufferedImage)resao, (boolean)true);
        ImageComparator.Compare((BufferedImage)resao, (String)"<=", (int)(dirtybackground ? 3000 : 1000), (int)0, (int)65535, (BufferedImage)tmp);
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)tmp, (int)0, (BufferedImage)tmp);
        }
        BufferedImage resue0 = this.ue2.Filter(tmp, nbCPU);
        int[] radii = ArrayConverter.UnsignedByteToInt((byte[])((DataBufferByte)this.ue2.Radii().getRaster().getDataBuffer()).getData());
        ArrayArithmetic.Multiply((int[])radii, (double)0.333, (int[])radii);
        BufferedImage resuemask = this.dilconst.Filter(resue0, this.opse, radii, nbCPU);
        resue0 = this.allocator.Release(resue0);
        if (respath != null) {
            ImageIO.Write(resuemask, respath + "/Intermediate - UltimateEroded.png", 6);
        }
        ImageComparator.Compare((BufferedImage)resuemask, (String)"==", (int)0, (int)0, (int)65535, (BufferedImage)resuemask);
        if (ImageTools.isBlack((BufferedImage)resuemask)) {
            if (respath != null) {
                ImageIO.Write(ImageNew.Same((BufferedImage)resuemask, (int)10), respath + "/Segmentation - ROI.png", 6);
                ImageIO.Write(ImageNew.SameInteger((BufferedImage)resuemask), respath + "/Watershed - Basins.tif", 8);
                System.out.println("----------------- WARNING ----------------- Empty image, premature exit 1.");
            }
            tmp = this.allocator.Release(tmp);
            resop = this.allocator.Release(resop);
            resuemask = this.allocator.Release(resuemask);
            resao = this.allocator.Release(resao);
            aocontour = this.allocator.Release(aocontour);
            reswthclean = this.allocator.Release(reswthclean);
            this.allocator.ClearAll(true);
            return;
        }
        BufferedImage markers = ImageNew.Integer((int)width, (int)height, (int)1);
        this.binary.Filter(resao, 1, tmp, nbCPU);
        BufferedImage aodil = this.dilate.Filter(tmp, this.sehex13, nbCPU);
        BufferedImage backgroundmarkers = ImageOperations.Contour((BufferedImage)aodil, (boolean)true);
        if (mask != null) {
            this.dilate.Filter(mask, this.sehex13, aodil, nbCPU);
            BufferedImage maskcontours = ImageOperations.Contour((BufferedImage)aodil, (boolean)true);
            ImageComparator.Compare((BufferedImage)backgroundmarkers, (String)"!=", (int)0, (BufferedImage)backgroundmarkers, (BufferedImage)maskcontours, (BufferedImage)backgroundmarkers);
            maskcontours = this.allocator.Release(maskcontours);
        }
        aodil = this.allocator.Release(aodil);
        this.invert.Filter(tmp, tmp, nbCPU);
        BufferedImage backgroundcore = this.ue.Filter(tmp, this.uese, nbCPU);
        ImageComparator.Compare((BufferedImage)backgroundmarkers, (String)"!=", (int)0, (BufferedImage)backgroundmarkers, (BufferedImage)backgroundcore, (BufferedImage)backgroundmarkers);
        backgroundcore = this.allocator.Release(backgroundcore);
        if (0 < simplifytexture) {
            this.ccl.Label(resao, 0, false);
            labels = this.ccl.Labels1D();
            sizes = this.ccl.Sizes();
            for (int i2 = 0; i2 < simplifytexture; ++i2) {
                this.MergeMediumCCs(labels, width, height, sizes, this.AreaOpSize >> 1, this.AreaOpSize << 2);
            }
            System.arraycopy(labels, 0, ((DataBufferInt)markers.getRaster().getDataBuffer()).getData(), 0, length);
        }
        this.ccl.Label(markers, 0, true);
        labels = this.ccl.Labels1D();
        sizes = this.ccl.Sizes();
        this.ccl.DeleteSmallerThan(markers, this.AreaOpSize);
        this.ccl.Label(markers, 0, true);
        System.arraycopy(labels, 0, ((DataBufferInt)markers.getRaster().getDataBuffer()).getData(), 0, length);
        this.MergeMarkers(markers, this.ccl, resuemask, this.ccl.ConnectedComponentsNumber());
        int nbinner = this.ccl.ConnectedComponentsNumber();
        int background = nbinner + 11;
        ImageComparator.Compare((BufferedImage)backgroundmarkers, (String)"!=", (int)0, (int)background, (int)0, (BufferedImage)backgroundmarkers);
        BufferedImage dilatedmarker = this.dilate.Filter(markers, this.sehex7, nbCPU);
        int[] ibdm = ((DataBufferInt)dilatedmarker.getRaster().getDataBuffer()).getData();
        int[] ibmarkers = ((DataBufferInt)markers.getRaster().getDataBuffer()).getData();
        switch (backgroundmarkers.getType()) {
            case 10: {
                byte[] bbback = ((DataBufferByte)backgroundmarkers.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < length; ++x) {
                    if (ibdm[x] != 0 || bbback[x] == 0) continue;
                    ibmarkers[x] = background;
                }
                bbback = null;
                break;
            }
            case 11: {
                short[] sbback = ((DataBufferUShort)backgroundmarkers.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < length; ++x) {
                    if (ibdm[x] != 0 || sbback[x] == 0) continue;
                    ibmarkers[x] = background;
                }
                sbback = null;
                break;
            }
            default: {
                throw new IllegalStateException("Image type not supported (yet).");
            }
        }
        ibdm = null;
        backgroundmarkers = this.allocator.Release(backgroundmarkers);
        dilatedmarker = this.allocator.Release(dilatedmarker);
        if (respath != null) {
            if (background < 256) {
                ImageIO.Write(ImageConverter.IntToByte((BufferedImage)markers), respath + "/Watershed - Markers.png", 6);
            } else if (background < 65536) {
                ImageIO.Write(ImageConverter.IntToShort((BufferedImage)markers), respath + "/Watershed - Markers.png", 6);
            } else {
                ImageIO.Write(ImageConverter.IntToABGR((BufferedImage)markers), respath + "/Watershed - Markers.png", 6);
            }
        }
        this.sobel.HowCorrect(2);
        BufferedImage resgrad = this.sobel.Filter(dirtybackground ? reswthclean : source, nbCPU);
        System.gc();
        this.watershed.watershed(resgrad, markers, this.wsse);
        ImageComparator.Compare((BufferedImage)this.watershed.Basins(), (String)"!=", (int)background, (BufferedImage)this.watershed.Basins(), (int)0, (BufferedImage)this.watershed.Basins());
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)this.watershed.Basins(), (int)0, (BufferedImage)this.watershed.Basins());
        }
        BufferedImage roi = resao;
        BufferedImage basins = ImageNew.Clone((BufferedImage)this.watershed.Basins());
        int[] ibbassins = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
        switch (resao.getType()) {
            case 11: {
                short[] sbroi = ((DataBufferUShort)roi.getRaster().getDataBuffer()).getData();
                short[] sbwth = ((DataBufferUShort)reswthclean.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        sbroi[pos] = ibbassins[pos] != 0 ? 255 : (sbroi[pos] != 0 || sbwth[pos] != 0 ? 200 : 0);
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Type not supported.");
            }
        }
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)roi, (int)0, (BufferedImage)roi);
        }
        ImageComparator.Compare((BufferedImage)roi, (String)"==", (int)0, (int)0, (int)1, (BufferedImage)tmp);
        BufferedImage resfh = this.fh.Fill(tmp, (ConnectedComponentLabeling)this.ccl, 23, true);
        ImageArithmetic.Subtract(resfh, tmp, tmp);
        ImageComparator.Compare((BufferedImage)tmp, (String)"==", (int)0, (BufferedImage)roi, (int)200, (BufferedImage)roi);
        resfh = this.allocator.Release(resfh);
        BufferedImage imnuc = ImageNew.Clone((BufferedImage)roi);
        ImageComparator.Compare((BufferedImage)imnuc, (String)"==", (int)200, (BufferedImage)imnuc, (int)0, (BufferedImage)imnuc);
        this.open.Filter(imnuc, this.smallnuclei ? this.dilse3 : this.sehex5, resop, nbCPU);
        this.ccl.Label(imnuc, 0, false);
        labels = null;
        sizes = null;
        sizes = this.ccl.Sizes();
        labels = this.ccl.Labels1D();
        boolean[] stillexist = new boolean[sizes.length];
        Arrays.fill(stillexist, false);
        short[] sbop = ((DataBufferUShort)resop.getRaster().getDataBuffer()).getData();
        for (int i3 = 0; i3 < labels.length; ++i3) {
            if (sbop[i3] == 0) continue;
            stillexist[labels[i3]] = true;
        }
        int p1 = -1;
        int p2 = -width - 1;
        int p3 = -width;
        int p4 = -width + 1;
        boolean p5 = true;
        int p6 = width + 1;
        int p7 = width;
        int p8 = width - 1;
        boolean[] touch = new boolean[sizes.length];
        Arrays.fill(touch, false);
        int y = 1;
        int pos = width + 1;
        while (y < height - 1) {
            int x = 1;
            while (x < width - 1) {
                if (labels[pos] != 0 && (ibbassins[pos + -1] != 0 || ibbassins[pos + p2] != 0 || ibbassins[pos + p3] != 0 || ibbassins[pos + p4] != 0 || ibbassins[pos + 1] != 0 || ibbassins[pos + p6] != 0 || ibbassins[pos + p7] != 0 || ibbassins[pos + p8] != 0)) {
                    touch[labels[pos]] = true;
                }
                ++x;
                ++pos;
            }
            ++y;
            pos += 2;
        }
        BufferedImage imlut = imnuc;
        short[] sblut = ((DataBufferUShort)imlut.getRaster().getDataBuffer()).getData();
        for (int i4 = 0; i4 < sblut.length; ++i4) {
            if (!stillexist[labels[i4]] && touch[labels[i4]]) continue;
            sblut[i4] = 0;
        }
        if (ImageTools.isBlack((BufferedImage)basins)) {
            if (respath != null) {
                ImageOperations.Fill((BufferedImage)roi, (int)0);
                ImageIO.Write(roi, respath + "/Segmentation - ROI.png", 6);
                ImageIO.Write(ImageNew.SameInteger((BufferedImage)roi), respath + "/Watershed - Basins.tif", 8);
            }
            roi = this.allocator.Release(roi);
            tmp = this.allocator.Release(tmp);
            imlut = this.allocator.Release(imlut);
            imnuc = this.allocator.Release(imnuc);
            resop = this.allocator.Release(resop);
            resao = this.allocator.Release(resao);
            aocontour = this.allocator.Release(aocontour);
            reswthclean = this.allocator.Release(reswthclean);
            resuemask = this.allocator.Release(resuemask);
            basins = this.allocator.Release(basins);
            this.allocator.ClearAll(true);
            return;
        }
        this.skiz.Filter(basins, imnuc, new StructuringElement(new Object[]{3, -15}), this.watershed.Basins());
        ImageComparator.Compare((BufferedImage)imlut, (String)"!=", (int)0, (BufferedImage)this.watershed.Basins(), (BufferedImage)basins, (BufferedImage)basins);
        ImageComparator.Compare((BufferedImage)imlut, (String)"==", (int)0, (BufferedImage)roi, (int)255, (BufferedImage)roi);
        ibbassins = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
        int threshold = this.smallnuclei ? this.AreaOpSize >> 2 : this.AreaOpSize >> 1;
        switch (resao.getType()) {
            case 11: {
                short[] sbroi = ((DataBufferUShort)roi.getRaster().getDataBuffer()).getData();
                short[] sbwth = ((DataBufferUShort)reswthclean.getRaster().getDataBuffer()).getData();
                int pos2 = 0;
                for (int y2 = 0; y2 < height; ++y2) {
                    int x = 0;
                    while (x < width) {
                        if (ibbassins[pos2] != 0) {
                            sbroi[pos2] = 255;
                        } else if (threshold <= sizes[labels[pos2]] && (sbroi[pos2] != 0 || sbwth[pos2] != 0)) {
                            sbroi[pos2] = 200;
                        } else {
                            sbroi[pos2] = 0;
                            ibbassins[pos2] = 0;
                        }
                        ++x;
                        ++pos2;
                    }
                }
                sbwth = null;
                sbroi = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Type not supported.");
            }
        }
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)roi, (int)0, (BufferedImage)roi);
        }
        if (fillholes) {
            ibbassins = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
            BufferedImage holes = ImageNew.Same((BufferedImage)roi, (int)10);
            ImageComparator.Compare((BufferedImage)roi, (String)"!=", (int)255, (int)255, (int)0, (BufferedImage)holes);
            this.ccl.Label(holes, 0, true);
            this.ccl.DeleteOnBorder(holes, new int[0]);
            this.ccl.Label(holes, 0, true);
            if (0 < this.ccl.ConnectedComponentsNumber()) {
                int i5;
                this.ccl.ComputeBoundingBoxes();
                int[] holeslabels = this.ccl.Labels1D();
                List[] neighbors = new List[this.ccl.ConnectedComponentsNumber() + 1];
                for (int i6 = 1; i6 < neighbors.length; ++i6) {
                    neighbors[i6] = new LinkedList();
                }
                int y3 = 1;
                int pos3 = width + 1;
                while (y3 < height - 1) {
                    int x = 1;
                    while (x < width - 1) {
                        if (holeslabels[pos3] != 0) {
                            int label = holeslabels[pos3];
                            if (ibbassins[pos3 - 1] != 0 && !ListTools.isInList((List)neighbors[label], (int)ibbassins[pos3 - 1])) {
                                neighbors[label].add(ibbassins[pos3 - 1]);
                            }
                            if (ibbassins[pos3 + 1] != 0 && !ListTools.isInList((List)neighbors[label], (int)ibbassins[pos3 + 1])) {
                                neighbors[label].add(ibbassins[pos3 + 1]);
                            }
                            if (ibbassins[pos3 - width] != 0 && !ListTools.isInList((List)neighbors[label], (int)ibbassins[pos3 - width])) {
                                neighbors[label].add(ibbassins[pos3 - width]);
                            }
                            if (ibbassins[pos3 + width] != 0 && !ListTools.isInList((List)neighbors[label], (int)ibbassins[pos3 + width])) {
                                neighbors[label].add(ibbassins[pos3 + width]);
                            }
                        }
                        ++x;
                        ++pos3;
                    }
                    ++y3;
                    pos3 += 2;
                }
                int[] minx = this.ccl.minx();
                int[] maxx = this.ccl.maxx();
                int[] miny = this.ccl.miny();
                int[] maxy = this.ccl.maxy();
                short[] sbroi = ((DataBufferUShort)roi.getRaster().getDataBuffer()).getData();
                for (i5 = 1; i5 < neighbors.length; ++i5) {
                    if (neighbors[i5].size() != 1) continue;
                    int label = (Integer)neighbors[i5].get(0);
                    for (int y4 = miny[i5]; y4 <= maxy[i5]; ++y4) {
                        int x = minx[i5];
                        int pos4 = x + y4 * width;
                        while (x <= maxx[i5]) {
                            if (holeslabels[pos4] == i5) {
                                ibbassins[pos4] = label;
                                sbroi[pos4] = 255;
                            }
                            ++x;
                            ++pos4;
                        }
                    }
                }
                holeslabels = null;
                for (i5 = 1; i5 < neighbors.length; ++i5) {
                    neighbors[i5].clear();
                }
                neighbors = null;
            }
            holes = this.allocator.Release(holes);
            this.ccl.Label(basins, 0, true);
            System.arraycopy(this.ccl.Labels1D(), 0, ibbassins, 0, length);
        }
        if (DeleteOnTop) {
            this.DeleteOnTop(basins);
        }
        if (roi100saver) {
            this.Roi100saver(basins, roi, width, height);
        }
        if (minsurface != 1) {
            int minsize;
            ibbassins = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
            this.ccl.Label(basins, 0, true);
            if (minsurface < 1) {
                int[] clone = (int[])this.ccl.Sizes().clone();
                Arrays.sort(clone);
                minsize = clone[(int)((double)clone.length * 0.05)];
                clone = null;
            } else {
                minsize = minsurface;
            }
            this.MergeSmallCCs((ConnectedComponentLabeling)this.ccl, minsize);
            System.arraycopy(this.ccl.Labels1D(), 0, ibbassins, 0, ibbassins.length);
            this.ccl.Label(basins, 0, true);
            System.arraycopy(this.ccl.Labels1D(), 0, ibbassins, 0, ibbassins.length);
            short[] sbroi = ((DataBufferUShort)roi.getRaster().getDataBuffer()).getData();
            for (int x = 0; x < ibbassins.length; ++x) {
                if (0 != ibbassins[x] || (sbroi[x] & 0xFFFF) != 255) continue;
                sbroi[x] = 0;
            }
            sbroi = null;
        }
        if (DeleteOnTop) {
            this.DeleteOnTop(basins);
        }
        this.ccl.Label(basins, 0, true);
        System.arraycopy(this.ccl.Labels1D(), 0, ibbassins, 0, length);
        source = this.de.Filter(source, 0, 65535, nbCPU);
        BufferedImage srccolor = ImageConverter.GrayToColor((BufferedImage)source);
        DapiMM.Paint(basins, roi, srccolor);
        if (respath != null) {
            ImageIO.tag = 1;
            ImageIO.Write(srccolor, respath + "/Segmentation - Full Color.png", 6);
            ImageIO.tag = 0;
        }
        if (respath != null) {
            ImageIO.Write(ImageConverter.UShortGrayToGray((BufferedImage)roi, (boolean)false), respath + "/Segmentation - ROI.png", 6);
        }
        if (respath != null) {
            ImageIO.Write(basins, respath + "/Watershed - Basins.tif", 8);
        }
        sizes = null;
        labels = null;
        ibbassins = null;
        tmp = this.allocator.Release(tmp);
        imlut = this.allocator.Release(imlut);
        roi = this.allocator.Release(roi);
        basins = this.allocator.Release(basins);
        srccolor = this.allocator.Release(srccolor);
        aocontour = this.allocator.Release(aocontour);
        markers = this.allocator.Release(markers);
        this.allocator.ClearAll(true);
    }

    private void MergeMarkers(BufferedImage markers, UnionFindCcl ccl, BufferedImage ue, int maxlabel) {
        int i2;
        int width = markers.getWidth();
        int height = markers.getHeight();
        int[] ibmarkers = ((DataBufferInt)markers.getRaster().getDataBuffer()).getData();
        UnionFindCcl ccl2 = new UnionFindCcl();
        ccl2.Label(ue, 0, true);
        int[] uelabels = ccl2.Labels1D();
        Object[] uecontacts = new List[ccl2.ConnectedComponentsNumber() + 1];
        for (int i3 = 1; i3 < uecontacts.length; ++i3) {
            uecontacts[i3] = new LinkedList();
        }
        int y = 1;
        int pos = width + 1;
        while (y < height - 1) {
            int x = 1;
            while (x < width - 1) {
                if (0 < uelabels[pos]) {
                    int label = uelabels[pos];
                    if (ibmarkers[pos] != 0 && !ListTools.isInList((List)uecontacts[label], (int)ibmarkers[pos])) {
                        uecontacts[label].add(ibmarkers[pos]);
                    }
                    if (ibmarkers[pos - 1] != 0 && !ListTools.isInList((List)uecontacts[label], (int)ibmarkers[pos - 1])) {
                        uecontacts[label].add(ibmarkers[pos - 1]);
                    }
                    if (ibmarkers[pos + 1] != 0 && !ListTools.isInList((List)uecontacts[label], (int)ibmarkers[pos + 1])) {
                        uecontacts[label].add(ibmarkers[pos + 1]);
                    }
                    if (ibmarkers[pos - width] != 0 && !ListTools.isInList((List)uecontacts[label], (int)ibmarkers[pos - width])) {
                        uecontacts[label].add(ibmarkers[pos - width]);
                    }
                    if (ibmarkers[pos + width] != 0 && !ListTools.isInList((List)uecontacts[label], (int)ibmarkers[pos + width])) {
                        uecontacts[label].add(ibmarkers[pos + width]);
                    }
                }
                ++x;
                ++pos;
            }
            ++y;
            pos += 2;
        }
        int nb = maxlabel;
        ccl.ComputeBoundingBoxes();
        int[] minx = ccl.minx();
        int[] maxx = ccl.maxx();
        int[] miny = ccl.miny();
        int[] maxy = ccl.maxy();
        ccl2.ComputeBoundingBoxes();
        int[] ueminx = ccl2.minx();
        int[] uemaxx = ccl2.maxx();
        int[] ueminy = ccl2.miny();
        int[] uemaxy = ccl2.maxy();
        block7: for (i2 = 1; i2 < uecontacts.length; ++i2) {
            switch (uecontacts[i2].size()) {
                case 0: {
                    for (int y2 = ueminy[i2]; y2 <= uemaxy[i2]; ++y2) {
                        int x = ueminx[i2];
                        int pos2 = x + y2 * width;
                        while (x <= uemaxx[i2]) {
                            if (uelabels[pos2] == i2) {
                                ibmarkers[pos2] = nb;
                            }
                            ++x;
                            ++pos2;
                        }
                    }
                    ++nb;
                    continue block7;
                }
                case 1: {
                    int pos3;
                    int x;
                    int y3;
                    int label = (Integer)uecontacts[i2].get(0);
                    if (label == 0) continue block7;
                    for (y3 = ueminy[i2]; y3 <= uemaxy[i2]; ++y3) {
                        x = ueminx[i2];
                        pos3 = x + y3 * width;
                        while (x <= uemaxx[i2]) {
                            if (uelabels[pos3] == i2) {
                                ibmarkers[pos3] = label;
                            }
                            ++x;
                            ++pos3;
                        }
                    }
                    continue block7;
                }
                default: {
                    int pos3;
                    int x;
                    int y3;
                    for (int l = 0; l < uecontacts[i2].size(); ++l) {
                        int lab = (Integer)uecontacts[i2].get(l);
                        for (int y4 = miny[lab]; y4 <= maxy[lab]; ++y4) {
                            int x2 = minx[lab];
                            int pos4 = x2 + y4 * width;
                            while (x2 <= maxx[lab]) {
                                if (ibmarkers[pos4] == lab) {
                                    ibmarkers[pos4] = nb;
                                }
                                ++x2;
                                ++pos4;
                            }
                        }
                    }
                    for (y3 = ueminy[i2]; y3 <= uemaxy[i2]; ++y3) {
                        x = ueminx[i2];
                        pos3 = x + y3 * width;
                        while (x <= uemaxx[i2]) {
                            if (uelabels[pos3] == i2) {
                                ibmarkers[pos3] = nb;
                            }
                            ++x;
                            ++pos3;
                        }
                    }
                    ++nb;
                }
            }
        }
        for (i2 = 1; i2 < uecontacts.length; ++i2) {
            uecontacts[i2].clear();
        }
        Arrays.fill(uecontacts, null);
        uecontacts = null;
        ccl2.Kill();
        ccl2 = null;
        ccl.Label(markers, 0, true);
        System.arraycopy(ccl.Labels1D(), 0, ibmarkers, 0, ibmarkers.length);
    }

    private void Roi100saver(BufferedImage basins, BufferedImage roi, int width, int height) {
        int[] ibbassins = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
        BufferedImage roinew = ImageNew.Clone((BufferedImage)roi);
        ImageComparator.Compare((BufferedImage)roinew, (String)"==", (int)200, (int)200, (int)0, (BufferedImage)roinew);
        this.ccl.Label(roinew, 0, true);
        int[] roilabels = (int[])this.ccl.Labels1D().clone();
        int[] roisizes = (int[])this.ccl.Sizes().clone();
        int[] lut = new int[roisizes.length];
        this.ccl.Label(basins, 0, true);
        int maxgray = (int)this.IF.Maximum(basins);
        int[] basizes = this.ccl.Sizes();
        Arrays.sort(basizes);
        int minsize = basizes[basizes.length / 10];
        int maxsize = basizes[9 * basizes.length / 10];
        int nb = 1;
        short[] sbroi = ((DataBufferUShort)roi.getRaster().getDataBuffer()).getData();
        short[] sbroinew = ((DataBufferUShort)roinew.getRaster().getDataBuffer()).getData();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int label;
                if (sbroinew[pos] != 0 && roisizes[label = roilabels[pos]] >= minsize && maxsize >= roisizes[label]) {
                    if (lut[label] == 0) {
                        lut[label] = maxgray + nb++;
                    }
                    sbroinew[pos] = 255;
                    sbroi[pos] = 255;
                    ibbassins[pos] = lut[label];
                }
                ++x;
                ++pos;
            }
        }
        sbroinew = null;
        sbroi = null;
        this.ccl.Label(basins, 0, true);
        int[] labs = this.ccl.Labels1D();
        this.MergeMediumCCs(labs, width, height, this.ccl.Sizes(), this.AreaOpSize >> 1, this.AreaOpSize << 2);
        labs = null;
        basizes = null;
        roisizes = null;
        roilabels = null;
        lut = null;
    }

    public void DeleteOnTop(BufferedImage basins) {
        int i2;
        int width = basins.getWidth();
        int height = basins.getHeight();
        int[] ibbassins = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
        this.ccl.Label(basins, 0, true);
        this.ccl.ComputeBoundingBoxes();
        int[] labels = this.ccl.Labels1D();
        Object[] neighbors = new List[this.ccl.ConnectedComponentsNumber() + 1];
        for (int i3 = 1; i3 < neighbors.length; ++i3) {
            neighbors[i3] = new LinkedList();
        }
        int y = 1;
        int pos = width + 1;
        while (y < height - 1) {
            int x = 1;
            while (x < width - 1) {
                if (0 < labels[pos]) {
                    int label = labels[pos];
                    if (labels[pos - 1] != label && !ListTools.isInList((List)neighbors[label], (int)labels[pos - 1])) {
                        neighbors[label].add(labels[pos - 1]);
                    }
                    if (labels[pos + 1] != label && !ListTools.isInList((List)neighbors[label], (int)labels[pos + 1])) {
                        neighbors[label].add(labels[pos + 1]);
                    }
                    if (labels[pos - width] != label && !ListTools.isInList((List)neighbors[label], (int)labels[pos - width])) {
                        neighbors[label].add(labels[pos - width]);
                    }
                    if (labels[pos + width] != label && !ListTools.isInList((List)neighbors[label], (int)labels[pos + width])) {
                        neighbors[label].add(labels[pos + width]);
                    }
                }
                ++x;
                ++pos;
            }
            ++y;
            pos += 2;
        }
        int[] minx = this.ccl.minx();
        int[] maxx = this.ccl.maxx();
        int[] miny = this.ccl.miny();
        int[] maxy = this.ccl.maxy();
        for (i2 = 1; i2 < neighbors.length; ++i2) {
            int label;
            if (neighbors[i2].size() != 1 || (label = ((Integer)neighbors[i2].get(0)).intValue()) == 0) continue;
            for (int y2 = miny[i2]; y2 <= maxy[i2]; ++y2) {
                int x = minx[i2];
                int pos2 = x + y2 * width;
                while (x <= maxx[i2]) {
                    if (labels[pos2] == i2) {
                        labels[pos2] = label;
                    }
                    ++x;
                    ++pos2;
                }
            }
        }
        for (i2 = 1; i2 < neighbors.length; ++i2) {
            neighbors[i2].clear();
        }
        Arrays.fill(neighbors, null);
        neighbors = null;
        System.arraycopy(labels, 0, ibbassins, 0, labels.length);
        this.ccl.Label(basins, 0, true);
        System.arraycopy(labels, 0, ibbassins, 0, labels.length);
    }

    public void MergeSmallCCs(ConnectedComponentLabeling ccl, int minsize) {
        ccl.ComputeBoundingBoxes();
        int width = ccl.Width();
        int height = ccl.Height();
        int[] labels = ccl.Labels1D();
        int[] sizes = ccl.Sizes();
        for (int y = 1; y < height - 1; ++y) {
            int x = 1;
            int pos = y * width + x;
            while (x < width - 1) {
                if (labels[pos] != 0 && sizes[labels[pos]] < minsize) {
                    LinkedList<Integer> neighbors = new LinkedList<Integer>();
                    int label = labels[pos];
                    int minx = Math.max(1, ccl.minx()[label]);
                    int miny = Math.max(1, ccl.miny()[label]);
                    int maxx = Math.min(width - 2, ccl.maxx()[label]);
                    int maxy = Math.min(height - 2, ccl.maxy()[label]);
                    for (int yy = miny; yy <= maxy; ++yy) {
                        int xx = minx;
                        int p = yy * width + xx;
                        while (xx <= maxx) {
                            if (labels[p - 1] != 0 && labels[p - 1] != label && !ListTools.isInList(neighbors, (int)labels[p - 1])) {
                                neighbors.add(labels[p - 1]);
                            }
                            if (labels[p + 1] != 0 && labels[p + 1] != label && !ListTools.isInList(neighbors, (int)labels[p + 1])) {
                                neighbors.add(labels[p + 1]);
                            }
                            if (labels[p - width] != 0 && labels[p - width] != label && !ListTools.isInList(neighbors, (int)labels[p - width])) {
                                neighbors.add(labels[p - width]);
                            }
                            if (labels[p + width] != 0 && labels[p + width] != label && !ListTools.isInList(neighbors, (int)labels[p + width])) {
                                neighbors.add(labels[p + width]);
                            }
                            ++xx;
                            ++p;
                        }
                    }
                    int newlabel = 0;
                    if (!neighbors.isEmpty()) {
                        Iterator iter = neighbors.iterator();
                        while (iter.hasNext()) {
                            int lab = (Integer)iter.next();
                            if (sizes[lab] >= sizes[newlabel]) continue;
                            newlabel = lab;
                        }
                        iter = null;
                    }
                    this.ModifyCC(x, y, pos, labels, width, height, newlabel);
                    int n = newlabel;
                    sizes[n] = sizes[n] + sizes[label];
                    sizes[label] = 0;
                }
                ++x;
                ++pos;
            }
        }
        for (int i2 = 1; i2 < sizes.length; ++i2) {
            if (0 >= sizes[i2] || sizes[i2] >= minsize) continue;
            ArrayComparator.Compare((int[])labels, (String)"!=", (int)i2, (int[])labels, (int)0, (int[])labels);
            sizes[i2] = 0;
        }
    }

    private void MergeMediumCCs(int[] labels, int width, int height, int[] sizes, int minsize, int midsize) {
        for (int y = 1; y < height; ++y) {
            int x = 1;
            int pos = y * width + x;
            while (x < width - 1) {
                if (labels[pos] != 0 && minsize <= sizes[labels[pos]] && sizes[labels[pos]] <= midsize) {
                    int label = labels[pos];
                    int size = sizes[label];
                    if (labels[pos - 1] != 0 && labels[pos - 1] != label && midsize <= size + sizes[labels[pos - 1]]) {
                        this.ModifyCC(x - 1, y, pos - 1, labels, width, height, label);
                        int n = label;
                        sizes[n] = sizes[n] + sizes[labels[pos - 1]];
                        sizes[labels[pos - 1]] = 0;
                    } else if (labels[pos - width] != 0 && labels[pos - width] != label && midsize <= size + sizes[labels[pos - width]]) {
                        this.ModifyCC(x, y - 1, pos - width, labels, width, height, label);
                        int n = label;
                        sizes[n] = sizes[n] + sizes[labels[pos - width]];
                        sizes[labels[pos - width]] = 0;
                    } else if (labels[pos - width - 1] != 0 && labels[pos - width - 1] != label && midsize <= size + sizes[labels[pos - width - 1]]) {
                        this.ModifyCC(x - 1, y - 1, pos - width - 1, labels, width, height, label);
                        int n = label;
                        sizes[n] = sizes[n] + sizes[labels[pos - width - 1]];
                        sizes[labels[pos - width - 1]] = 0;
                    } else if (labels[pos - width + 1] != 0 && labels[pos - width + 1] != label && midsize <= size + sizes[labels[pos - width + 1]]) {
                        this.ModifyCC(x + 1, y - 1, pos - width + 1, labels, width, height, label);
                        int n = label;
                        sizes[n] = sizes[n] + sizes[labels[pos - width + 1]];
                        sizes[labels[pos - width + 1]] = 0;
                    }
                }
                ++x;
                ++pos;
            }
        }
    }

    private void ModifyCC(int xx, int yy, int p, int[] array, int width, int height, int val) {
        int origin = array[p];
        Queue<Coordinates> fifo = new Queue<Coordinates>();
        fifo.Push(new Coordinates(xx, yy, 0, p));
        while (!fifo.Empty()) {
            Coordinates c = (Coordinates)fifo.FrontPop();
            if (array[c.Pos] == origin) {
                array[c.Pos] = val;
                if (0 < c.X && array[c.Pos - 1] == origin) {
                    fifo.push(new Coordinates(c.X - 1, c.Y, 0, c.Pos - 1));
                }
                if (c.X + 1 < width && array[c.Pos + 1] == origin) {
                    fifo.push(new Coordinates(c.X + 1, c.Y, 0, c.Pos + 1));
                }
                if (0 < c.Y && array[c.Pos - width] == origin) {
                    fifo.push(new Coordinates(c.X, c.Y - 1, 0, c.Pos - width));
                }
                if (c.Y + 1 < height && array[c.Pos + width] == origin) {
                    fifo.push(new Coordinates(c.X, c.Y + 1, 0, c.Pos + width));
                }
                if (0 < c.X && 0 < c.Y && array[c.Pos - width - 1] == origin) {
                    fifo.push(new Coordinates(c.X - 1, c.Y - 1, 0, c.Pos - width - 1));
                }
                if (c.X + 1 < width && 0 < c.Y && array[c.Pos - width + 1] == origin) {
                    fifo.push(new Coordinates(c.X + 1, c.Y - 1, 0, c.Pos - width + 1));
                }
                if (0 < c.X && c.Y + 1 < height && array[c.Pos + width - 1] == origin) {
                    fifo.push(new Coordinates(c.X - 1, c.Y + 1, 0, c.Pos + width - 1));
                }
                if (c.X + 1 < width && c.Y + 1 < height && array[c.Pos + width + 1] == origin) {
                    fifo.push(new Coordinates(c.X + 1, c.Y + 1, 0, c.Pos + width + 1));
                }
            }
            c = null;
        }
    }

    public static void Paint(BufferedImage basins, BufferedImage rois, BufferedImage rgb) {
        byte[] bbrgb = ((DataBufferByte)rgb.getRaster().getDataBuffer()).getData();
        switch (rois.getType()) {
            case 10: {
                byte[] bbroi = ((DataBufferByte)rois.getRaster().getDataBuffer()).getData();
                int x = 0;
                int posrgb = 0;
                while (x < bbroi.length) {
                    switch (bbroi[x] & 0xFF) {
                        case 255: {
                            bbrgb[posrgb + 1] = 0;
                            bbrgb[posrgb] = 0;
                            break;
                        }
                        case 200: {
                            bbrgb[posrgb + 2] = 0;
                            bbrgb[posrgb + 1] = 0;
                        }
                    }
                    ++x;
                    posrgb += 3;
                }
                break;
            }
            case 11: {
                short[] sbroi = ((DataBufferUShort)rois.getRaster().getDataBuffer()).getData();
                int x = 0;
                int posrgb = 0;
                while (x < sbroi.length) {
                    switch (sbroi[x] & 0xFFFF) {
                        case 255: {
                            bbrgb[posrgb + 1] = 0;
                            bbrgb[posrgb] = 0;
                            break;
                        }
                        case 200: {
                            bbrgb[posrgb + 2] = 0;
                            bbrgb[posrgb + 1] = 0;
                        }
                    }
                    ++x;
                    posrgb += 3;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image ROIs type not supported. ");
            }
        }
        ImageDrawer.Contour(rgb, basins, Colors.YELLOW7);
    }
}

