/*
 * Decompiled with CFR 0.152.
 */
package segmentation.cells;

import filesAndFolders.FilesFolders;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import utils.LogFile;
import utils.cmd.LaunchCMD;
import utils.python.PythonLauncher;

public class DapiDL {
    private final int Magnification;
    private final String Python_Path;
    public String Keyword = null;
    public String ModelName = null;
    public float Threshold = 0.13f;
    public int BatchSize = 5;
    public int BorderEffectSize = 73;
    public int CheckOverlap = 7;
    public boolean SaveNuclei = true;

    public DapiDL(String Python_Path, int Magnification) {
        this.Python_Path = Python_Path;
        this.Magnification = Magnification;
    }

    public boolean Segmentation(String outputdir, boolean AllowMultipleGPUs, LogFile log) throws Exception {
        if (this.ModelName == null) {
            throw new IllegalArgumentException("No model name.");
        }
        if (this.Keyword == null) {
            throw new IllegalArgumentException("No keyword.");
        }
        if (this.ModelName.toLowerCase().startsWith("maskrcnn")) {
            return this.SegmentationMaskRCNN(outputdir, AllowMultipleGPUs, log);
        }
        if (this.ModelName.toLowerCase().startsWith("cellpose")) {
            return this.SegmentationCellPose(outputdir, log);
        }
        if (this.ModelName.toLowerCase().startsWith("mesmer")) {
            return this.SegmentationMesmer(outputdir, log);
        }
        throw new IllegalArgumentException("Unsupported model name: '" + this.ModelName + "'.");
    }

    private boolean SegmentationMaskRCNN(String outputdir, boolean AllowMultipleGPUs, LogFile log) throws IOException, InterruptedException {
        int ModelDim;
        System.out.println("\n\nStarting nuclei segmentation using Mask R-CNN.");
        if (this.ModelName.contains("256x256")) {
            ModelDim = 256;
        } else if (this.ModelName.contains("512x512")) {
            ModelDim = 512;
        } else {
            throw new IllegalArgumentException("Model dimensions not found.");
        }
        if (this.Threshold <= 0.0f || 1.0f <= this.Threshold) {
            throw new IllegalArgumentException("Threshold <= 0.0f or 1.0f <= Threshold.");
        }
        if (this.BorderEffectSize < 0) {
            throw new IllegalArgumentException("BorderEffectSize < 0.");
        }
        int normpos = this.ModelName.indexOf("_Norm=");
        if (normpos < 0) {
            IOException ex = new IOException("Nuclei segmentation model name does not respect the norm. (1)");
            if (log != null) {
                log.addNewException(ex, "Normalization issue.");
            }
            throw ex;
        }
        String Norm2 = null;
        if (this.ModelName.charAt(normpos += 6) == 'B') {
            Norm2 = "B";
        } else if (this.ModelName.charAt(normpos) == 'C' && this.ModelName.charAt(normpos + 1) == 'R') {
            Norm2 = "CR";
        } else {
            IOException ex = new IOException("Nuclei segmentation model name does not respect the norm. (2)");
            if (log != null) {
                log.addNewException(ex, "Normalization issue.");
            }
            throw ex;
        }
        System.out.println("\nNuclei segmentation configuration:");
        System.out.println(" - Python_Path = " + this.Python_Path);
        System.out.println(" - ModelName = " + this.ModelName);
        System.out.println(" - Normalization = " + Norm2);
        System.out.println(" - Threshold = " + this.Threshold);
        System.out.println(" - BatchSize = " + this.BatchSize);
        System.out.println(" - BorderEffectSize = " + this.BorderEffectSize);
        System.out.println(" - CheckOverlap = " + this.CheckOverlap);
        System.out.println("");
        String path = System.getProperty("user.dir");
        String Model_Path = path + "/DeepLearningModels/" + this.ModelName;
        StringBuilder sb = new StringBuilder(1001);
        sb.append("import os").append("\n");
        sb.append("import sys").append("\n");
        sb.append("import torch").append("\n");
        sb.append("from torch import nn").append("\n\n");
        sb.append("import FiReTiTiPyLib.Normalizers as Normalizers").append("\n");
        sb.append("import FiReTiTiPyLib.FiReTiTiPyTorchLib.FiReTiTiPyTorchLib_Segmentator as FiReTiTiPyTorchLib_Segmentator").append("\n\n");
        sb.append("device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')").append("\n");
        sb.append("warning = '' if str(device) == 'cuda' else \"WARNING - \"").append("\n");
        sb.append("print(warning + \"Device = \" + str(device))").append("\n\n");
        sb.append("if str(device) == 'cpu':").append("\n");
        sb.append("\tmodel = torch.load('").append(Model_Path).append("', map_location=torch.device('cpu'))").append("\n");
        sb.append("else:").append("\n");
        sb.append("\tmodel = torch.load('").append(Model_Path).append("')").append("\n\n");
        if (AllowMultipleGPUs) {
            sb.append("if str(device) == 'cuda' and 1 < torch.cuda.device_count():").append("\n");
            sb.append("\tprint(\"Let's use\", torch.cuda.device_count(), \"GPUs!\")").append("\n");
            sb.append("\tmodel = nn.DataParallel(model)").append("\n\n");
        }
        sb.append("model = model.to(device)").append("\n");
        sb.append("model.eval()").append("\n\n");
        sb.append("inputs = '").append(outputdir).append("'").append("\n");
        sb.append("dim = ").append(ModelDim).append("\n");
        switch (Norm2) {
            case "B": {
                sb.append("InputsNormalizers = [Normalizers.Basic(MaxValue=65535.0)]").append("\n");
                break;
            }
            case "CR": {
                sb.append("InputsNormalizers = [Normalizers.CenterReduce(MaxValue=65535.0)]").append("\n");
                break;
            }
            default: {
                throw new IOException("Unknown normalization. Must not occur.");
            }
        }
        sb.append("BatchSize = ").append(this.BatchSize).append("\n");
        sb.append("BorderEffectSize = ").append(this.BorderEffectSize).append("\n");
        sb.append("CheckFullOverlap = ").append(this.CheckOverlap).append("\n\n");
        sb.append("segmentator = FiReTiTiPyTorchLib_Segmentator.Segment()").append("\n");
        sb.append("segmentator.MaskRCNN(inputs, '");
        sb.append(this.Keyword);
        sb.append("', model, device, CropSize=dim, BorderEffectSize=BorderEffectSize, ");
        sb.append("InputsNormalizers=InputsNormalizers, BatchSize=BatchSize, CheckFullOverlap=CheckFullOverlap, ");
        sb.append("ResultsDirPath='").append(outputdir);
        sb.append("', SaveIndividualObject=").append(this.SaveNuclei ? "True" : "False");
        sb.append(", BoxProbability=").append(this.Threshold).append(")\n\n");
        sb.append("print('Segmentation Done!')").append("\n");
        sb.append("sys.exit(0)").append("\n");
        PythonLauncher pl = new PythonLauncher(this.Python_Path);
        if (pl.Run(outputdir + "/tmp/Script.py", sb, "-X faulthandler", log, true)) {
            System.out.println("Deep learning (Mask R-CNN) based nuclei segmentation done.");
            return true;
        }
        System.out.println("Deep learning (Mask R-CNN) based nuclei segmentation FAILURE!!!");
        System.err.println("Deep learning (Mask R-CNN) based nuclei segmentation FAILURE!!!");
        log.addNewError(new Error("Nuclei segmentation failure."), "Failed to segment nuclei.");
        return false;
    }

    private boolean SegmentationCellPose(String outputdir, LogFile log) throws Exception {
        String[] env;
        File[] images;
        System.out.println("\n\nStarting nuclei segmentation using CellPose.");
        System.out.println("\u001b[32m WARNING - CellPose might be extremely slow for big images.\u001b[0m");
        String[] parts = this.ModelName.split("_");
        if (parts == null || parts.length == 1) {
            throw new IllegalArgumentException("Wrong format for CellPose. Expected at least: 'CellPose_[gpu/cpu]'.");
        }
        if (!parts[0].equalsIgnoreCase("CellPose")) {
            throw new IllegalArgumentException("Wrong segmentation model calling. First element is not 'CellPose'.");
        }
        File tmpdir = new File(outputdir + "/tmpImages/");
        if (!tmpdir.exists()) {
            tmpdir.mkdirs();
        }
        LinkedList<String> args = new LinkedList<String>();
        args.add(this.Python_Path);
        args.add("-m");
        args.add("cellpose");
        args.add("--dir");
        args.add(tmpdir.getAbsolutePath());
        args.add("--pretrained_model");
        args.add("nuclei");
        args.add("--chan");
        args.add("0");
        System.out.println("\nNuclei segmentation configuration:");
        System.out.println(" - Python_Path = " + this.Python_Path);
        System.out.println(" - ModelName = " + this.ModelName);
        for (int i2 = 1; i2 < parts.length; ++i2) {
            File[] part = parts[i2].toLowerCase();
            if (part.startsWith("cpu")) {
                System.out.println("\t => CPU");
                continue;
            }
            if (part.equals("gpu")) {
                args.add("--use_gpu");
                System.out.println("\t => GPU");
                continue;
            }
            if (part.startsWith("d=") || part.startsWith("diam=") || part.startsWith("diameter=")) {
                int Diameter = Math.max(0, Integer.parseInt(part.substring(part.indexOf("=") + 1)));
                args.add("--diameter");
                args.add(String.valueOf(Diameter));
                System.out.println("\t => Diameter = " + Diameter);
                continue;
            }
            if (part.startsWith("f=") || part.startsWith("flow=")) {
                float Flow = Math.max(0.0f, Math.min(1.0f, Float.parseFloat(part.substring(part.indexOf("=") + 1))));
                args.add("--flow_threshold");
                args.add(String.valueOf(Flow));
                System.out.println("\t => Flow = " + Flow);
                continue;
            }
            if (part.startsWith("b=") || part.startsWith("bs=") || part.startsWith("batch=") || part.startsWith("batchsize=")) {
                int batch = Math.max(0, Math.min(1, Integer.parseInt(part.substring(part.indexOf("=") + 1))));
                args.add("--batch_size");
                args.add(String.valueOf(batch));
                System.out.println("\t => Batch size = " + batch);
                continue;
            }
            if (part.equals("fast")) {
                args.add("--fast_mode");
                System.out.println("\t => Fast mode activated");
                continue;
            }
            System.out.println("Unknown CellPose parameter '" + (String)part + "'.\n");
            System.out.println("Supported parameters: cpu/gpu, d/diam/diameter, f/flow/ b/bs/batch/batchsize, fast.\n");
            System.err.println("Unknown CellPose parameter '" + (String)part + "'.\n");
            IllegalArgumentException ex = new IllegalArgumentException("Unknown parameter: '" + (String)part + "'.");
            log.addNewException(ex, "Unknown parameter.");
            throw ex;
        }
        args.add("--save_tif");
        args.add("--no_npy");
        System.out.println("");
        for (File im : images = new File(outputdir).listFiles((dir, name) -> name.charAt(0) != '.' && name.contains(this.Keyword) && (name.endsWith(".png") || name.endsWith(".PNG")))) {
            FilesFolders.CopyFile(im, new File(tmpdir.getAbsolutePath() + "/" + im.getName()));
        }
        String[] cpcmd = args.toArray(new String[1]);
        if (new LaunchCMD().Run(cpcmd, env = new String[]{"LC_ALL=en_US.UTF-8", "LANG=en_US.UTF-8"}, log)) {
            File[] cpres;
            System.out.println("Deep learning (cellPose) based nuclei segmentation done.\n");
            ImageFeatures IF = new ImageFeatures();
            for (File im : cpres = new File(tmpdir.getAbsolutePath()).listFiles((dir, name) -> name.charAt(0) != '.' && name.endsWith("_cp_masks.tif"))) {
                BufferedImage image = ImageIO.Read(im);
                int max = (int)IF.Maximum(image);
                if (max <= 65535) {
                    ImageIO.Write(image, outputdir + "/" + im.getName().replace("_cp_masks.tif", " - Labels.png"), 6);
                } else {
                    ImageIO.Write(image, outputdir + "/" + im.getName().replace("_cp_masks.tif", " - Labels.tif"), 8);
                }
                image = null;
            }
            FilesFolders.Delete(tmpdir);
            return true;
        }
        System.out.println("Deep learning (CellPose) based nuclei segmentation FAILURE!!!\n");
        System.err.println("Deep learning (CellPose) based nuclei segmentation FAILURE!!!\n");
        log.addNewException(new Exception("Nuclei segmentation failure."), "Failed to segment nuclei.");
        return false;
    }

    private boolean SegmentationMesmer(String outputdir, LogFile log) throws IOException, InterruptedException {
        File[] images;
        System.out.println("\n\nStarting nuclei segmentation using Mesmer.");
        String[] parts = this.ModelName.split("_");
        if (2 < parts.length) {
            String txt = "Mesmer - more than one argument found.";
            System.out.println("Mesmer - more than one argument found. Expected: Mesmer_mpp=???\n");
            System.err.println("Mesmer - more than one argument found. Expected: Mesmer_mpp=???\n");
            log.addNewException(new Exception("Mesmer - more than one argument found."), "Mesmer - more than one argument found.");
            return false;
        }
        String image_mpp = "None";
        for (int i2 = 1; i2 < parts.length; ++i2) {
            if (!parts[i2].toLowerCase().startsWith("mpp=")) {
                String txt = "Mesmer - unknown argument: '" + parts[i2] + "'.";
                System.out.println(txt);
                System.err.println(txt);
                log.addNewException(new Exception(txt), txt);
                return false;
            }
            image_mpp = parts[i2].substring(4);
        }
        System.out.println("\nNuclei segmentation configuration:");
        System.out.println(" - Python_Path = " + this.Python_Path);
        System.out.println(" - ModelName = " + this.ModelName);
        System.out.println("\t => Micron per pixel = " + image_mpp);
        System.out.println("");
        PythonLauncher pl = new PythonLauncher(this.Python_Path);
        File tmpdir = new File(outputdir + "/tmp/");
        if (!tmpdir.exists()) {
            tmpdir.mkdirs();
        }
        for (File im : images = new File(outputdir).listFiles((dir, name) -> name.charAt(0) != '.' && name.contains(this.Keyword) && (name.endsWith(".png") || name.endsWith(".PNG")))) {
            StringBuilder sb = new StringBuilder(1001);
            sb.append("import sys").append("\n");
            sb.append("import numpy").append("\n");
            sb.append("import FiReTiTiPyLib.ImagesIO as imIO").append("\n\n");
            sb.append("from deepcell.applications import Mesmer").append("\n");
            sb.append("from skimage.io import imread").append("\n\n");
            sb.append("path = '").append(im.getAbsolutePath()).append("'\n");
            sb.append("print('Segmenting: ' + path)\n");
            sb.append("image = imread(path)\n");
            sb.append("imstack = numpy.stack((image, image), axis=-1)\n");
            sb.append("imstack = numpy.expand_dims(imstack, 0)\n\n");
            sb.append("app = Mesmer()\n");
            sb.append("labels = app.predict(imstack, batch_size=1, image_mpp=").append(image_mpp).append(", compartment='nuclear')\n");
            sb.append("labels = labels.squeeze()\n");
            sb.append("imIO.Write(labels, True, '").append(im.getAbsolutePath().replace(this.Keyword, "Nuclei Labels.")).append("')\n\n");
            sb.append("print('Nuclei segmentation done.')\n");
            sb.append("sys.exit(0)\n");
            if (!pl.Run(tmpdir.getAbsolutePath() + "/Script.py", sb, "-X faulthandler", log, true)) {
                System.out.println("Deep learning (Mesmer) based nuclei segmentation FAILURE!!!");
                System.err.println("Deep learning (Mesmer) based nuclei segmentation FAILURE!!!");
                log.addNewError(new Error("Nuclei segmentation failure for image '" + im.getAbsolutePath() + "'."), "Failed to segment nuclei for image '" + im.getAbsolutePath() + "'.");
                return false;
            }
            System.out.println("Deep learning (Mesmer) based nuclei segmentation done.");
        }
        FilesFolders.Delete(tmpdir);
        return true;
    }
}

