/*
 * Decompiled with CFR 0.152.
 */
package registration.turboregold;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Stack;
import registration.turboregold.turboRegImage;
import registration.turboregold.turboRegMask;
import registration.turboregold.turboRegPointHandler;
import registration.turboregold.turboRegProgressBar;

class turboRegTransform {
    private static final int FEW_ITERATIONS = 5;
    private static final double FIRST_LAMBDA = 1.0;
    private static final double LAMBDA_MAGSTEP = 4.0;
    private static final int MANY_ITERATIONS = 10;
    private static final double PIXEL_HIGH_PRECISION = 0.001;
    private static final double PIXEL_LOW_PRECISION = 0.1;
    private static final int ITERATION_PROGRESSION = 2;
    private boolean accelerated;
    private boolean interactive;
    private double c0;
    private double c0u;
    private double c0v;
    private double c0uv;
    private double c1;
    private double c1u;
    private double c1v;
    private double c1uv;
    private double c2;
    private double c2u;
    private double c2v;
    private double c2uv;
    private double c3;
    private double c3u;
    private double c3v;
    private double c3uv;
    private double pixelPrecision;
    private double s;
    private double t;
    private double targetJacobian;
    private double x;
    private double y;
    private double[][] sourcePoint;
    private double[][] targetPoint;
    private final double[] dxWeight = new double[4];
    private final double[] dyWeight = new double[4];
    private final double[] xWeight = new double[4];
    private final double[] yWeight = new double[4];
    private final int[] xIndex = new int[4];
    private final int[] yIndex = new int[4];
    private float[] inImg;
    private float[] inMsk;
    private float[] outImg;
    private float[] outMsk;
    private float[] xGradient;
    private float[] yGradient;
    private int inNx;
    private int inNy;
    private int iterationCost;
    private int iterationPower;
    private int maxIterations;
    private int outNx;
    private int outNy;
    private int p;
    private int pyramidDepth;
    private int q;
    private int transformation;
    private int twiceInNx;
    private int twiceInNy;
    private turboRegImage sourceImg;
    private turboRegImage targetImg;
    private turboRegMask sourceMsk;
    private turboRegMask targetMsk;
    private turboRegPointHandler sourcePh;

    public turboRegTransform(turboRegImage sourceImg, turboRegMask sourceMsk, turboRegPointHandler sourcePh, turboRegImage targetImg, turboRegMask targetMsk, turboRegPointHandler targetPh, int transformation, boolean accelerated, boolean interactive) {
        this.sourceImg = sourceImg;
        this.sourceMsk = sourceMsk;
        this.sourcePh = sourcePh;
        this.targetImg = targetImg;
        this.targetMsk = targetMsk;
        this.transformation = transformation;
        this.accelerated = accelerated;
        this.interactive = interactive;
        this.sourcePoint = sourcePh.getPoints();
        this.targetPoint = targetPh.getPoints();
        if (accelerated) {
            this.pixelPrecision = 0.1;
            this.maxIterations = 5;
        } else {
            this.pixelPrecision = 0.001;
            this.maxIterations = 10;
        }
    }

    public void appendTransformation(String pathAndFilename) {
        this.outNx = this.targetImg.getWidth();
        this.outNy = this.targetImg.getHeight();
        this.inNx = this.sourceImg.getWidth();
        this.inNy = this.sourceImg.getHeight();
        if (pathAndFilename == null) {
            return;
        }
        try {
            int i2;
            FileWriter fw = new FileWriter(pathAndFilename, true);
            fw.write("\n");
            switch (this.transformation) {
                case 2: {
                    fw.write("TRANSLATION\n");
                    break;
                }
                case 3: {
                    fw.write("RIGID_BODY\n");
                    break;
                }
                case 4: {
                    fw.write("SCALED_ROTATION\n");
                    break;
                }
                case 6: {
                    fw.write("AFFINE\n");
                    break;
                }
                case 8: {
                    fw.write("BILINEAR\n");
                }
            }
            fw.write("\n");
            fw.write("Source size\n");
            fw.write(this.inNx + "\t" + this.inNy + "\n");
            fw.write("\n");
            fw.write("Target size\n");
            fw.write(this.outNx + "\t" + this.outNy + "\n");
            fw.write("\n");
            fw.write("Refined source landmarks\n");
            if (this.transformation == 3) {
                for (i2 = 0; i2 < this.transformation; ++i2) {
                    fw.write(this.sourcePoint[i2][0] + "\t" + this.sourcePoint[i2][1] + "\n");
                }
            } else {
                for (i2 = 0; i2 < this.transformation / 2; ++i2) {
                    fw.write(this.sourcePoint[i2][0] + "\t" + this.sourcePoint[i2][1] + "\n");
                }
            }
            fw.write("\n");
            fw.write("Target landmarks\n");
            if (this.transformation == 3) {
                for (i2 = 0; i2 < this.transformation; ++i2) {
                    fw.write(this.targetPoint[i2][0] + "\t" + this.targetPoint[i2][1] + "\n");
                }
            } else {
                for (i2 = 0; i2 < this.transformation / 2; ++i2) {
                    fw.write(this.targetPoint[i2][0] + "\t" + this.targetPoint[i2][1] + "\n");
                }
            }
            fw.close();
        }
        catch (IOException e) {
            IJ.log((String)("IOException exception " + e.getMessage()));
        }
        catch (SecurityException e) {
            IJ.log((String)("Security exception " + e.getMessage()));
        }
    }

    public void doBatchFinalTransform(float[] pixels) {
        this.inImg = this.accelerated ? this.sourceImg.getImage() : this.sourceImg.getCoefficient();
        this.inNx = this.sourceImg.getWidth();
        this.inNy = this.sourceImg.getHeight();
        this.twiceInNx = 2 * this.inNx;
        this.twiceInNy = 2 * this.inNy;
        this.outImg = pixels;
        this.outNx = this.targetImg.getWidth();
        this.outNy = this.targetImg.getHeight();
        double[][] matrix = this.getTransformationMatrix(this.targetPoint, this.sourcePoint);
        switch (this.transformation) {
            case 2: {
                this.translationTransform(matrix);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                this.affineTransform(matrix);
                break;
            }
            case 8: {
                this.bilinearTransform(matrix);
            }
        }
    }

    public ImagePlus doFinalTransform(int width, int height) {
        this.inImg = this.accelerated ? this.sourceImg.getImage() : this.sourceImg.getCoefficient();
        this.inMsk = this.sourceMsk.getMask();
        this.inNx = this.sourceImg.getWidth();
        this.inNy = this.sourceImg.getHeight();
        this.twiceInNx = 2 * this.inNx;
        this.twiceInNy = 2 * this.inNy;
        ImageStack is = new ImageStack(width, height);
        FloatProcessor dataFp = new FloatProcessor(width, height);
        is.addSlice("Data", (ImageProcessor)dataFp);
        FloatProcessor maskFp = new FloatProcessor(width, height);
        is.addSlice("Mask", (ImageProcessor)maskFp);
        ImagePlus imp = new ImagePlus("Output", is);
        imp.setSlice(1);
        this.outImg = (float[])dataFp.getPixels();
        imp.setSlice(2);
        float[] outMsk = (float[])maskFp.getPixels();
        this.outNx = imp.getWidth();
        this.outNy = imp.getHeight();
        double[][] matrix = this.getTransformationMatrix(this.targetPoint, this.sourcePoint);
        switch (this.transformation) {
            case 2: {
                this.translationTransform(matrix, outMsk);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                this.affineTransform(matrix, outMsk);
                break;
            }
            case 8: {
                this.bilinearTransform(matrix, outMsk);
            }
        }
        imp.setSlice(1);
        imp.getProcessor().resetMinAndMax();
        if (this.interactive) {
            imp.show();
            imp.updateAndDraw();
        }
        return imp;
    }

    public float[] doFinalTransform(turboRegImage sourceImg, turboRegPointHandler sourcePh, turboRegImage targetImg, turboRegPointHandler targetPh, int transformation, boolean accelerated) {
        this.sourceImg = sourceImg;
        this.targetImg = targetImg;
        this.sourcePh = sourcePh;
        this.transformation = transformation;
        this.accelerated = accelerated;
        this.sourcePoint = sourcePh.getPoints();
        this.targetPoint = targetPh.getPoints();
        this.inImg = accelerated ? sourceImg.getImage() : sourceImg.getCoefficient();
        this.inNx = sourceImg.getWidth();
        this.inNy = sourceImg.getHeight();
        this.twiceInNx = 2 * this.inNx;
        this.twiceInNy = 2 * this.inNy;
        this.outNx = targetImg.getWidth();
        this.outNy = targetImg.getHeight();
        this.outImg = new float[this.outNx * this.outNy];
        double[][] matrix = this.getTransformationMatrix(this.targetPoint, this.sourcePoint);
        switch (transformation) {
            case 2: {
                this.translationTransform(matrix);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                this.affineTransform(matrix);
                break;
            }
            case 8: {
                this.bilinearTransform(matrix);
            }
        }
        return this.outImg;
    }

    public void doRegistration() {
        Stack targetMskPyramid;
        Stack<Object> targetImgPyramid;
        Stack<float[]> sourceMskPyramid;
        Stack<Object> sourceImgPyramid;
        if (this.sourceMsk == null) {
            sourceImgPyramid = this.sourceImg.getPyramid();
            sourceMskPyramid = null;
            targetImgPyramid = (Stack<Object>)this.targetImg.getPyramid().clone();
            targetMskPyramid = (Stack)this.targetMsk.getPyramid().clone();
        } else {
            sourceImgPyramid = this.sourceImg.getPyramid();
            sourceMskPyramid = this.sourceMsk.getPyramid();
            targetImgPyramid = this.targetImg.getPyramid();
            targetMskPyramid = this.targetMsk.getPyramid();
        }
        this.pyramidDepth = this.targetImg.getPyramidDepth();
        this.iterationPower = (int)Math.pow(2.0, this.pyramidDepth);
        turboRegProgressBar.addWorkload(this.pyramidDepth * this.maxIterations * this.iterationPower / 2 - (this.iterationPower - 1) / 1);
        this.iterationCost = 1;
        this.scaleBottomDownLandmarks();
        while (!targetImgPyramid.isEmpty()) {
            this.iterationPower /= 2;
            if (this.transformation == 8) {
                this.inNx = (Integer)sourceImgPyramid.pop();
                this.inNy = (Integer)sourceImgPyramid.pop();
                this.inImg = (float[])sourceImgPyramid.pop();
                this.inMsk = (float[])(sourceMskPyramid == null ? null : sourceMskPyramid.pop());
                this.outNx = (Integer)targetImgPyramid.pop();
                this.outNy = (Integer)targetImgPyramid.pop();
                this.outImg = (float[])targetImgPyramid.pop();
                this.outMsk = (float[])targetMskPyramid.pop();
            } else {
                this.inNx = (Integer)targetImgPyramid.pop();
                this.inNy = (Integer)targetImgPyramid.pop();
                this.inImg = (float[])targetImgPyramid.pop();
                this.inMsk = (float[])targetMskPyramid.pop();
                this.outNx = (Integer)sourceImgPyramid.pop();
                this.outNy = (Integer)sourceImgPyramid.pop();
                this.outImg = (float[])sourceImgPyramid.pop();
                this.xGradient = (float[])sourceImgPyramid.pop();
                this.yGradient = (float[])sourceImgPyramid.pop();
                this.outMsk = (float[])(sourceMskPyramid == null ? null : sourceMskPyramid.pop());
            }
            this.twiceInNx = 2 * this.inNx;
            this.twiceInNy = 2 * this.inNy;
            switch (this.transformation) {
                case 2: {
                    this.targetJacobian = 1.0;
                    this.inverseMarquardtLevenbergOptimization(this.iterationPower * this.maxIterations - 1);
                    break;
                }
                case 3: {
                    this.inverseMarquardtLevenbergRigidBodyOptimization(this.iterationPower * this.maxIterations - 1);
                    break;
                }
                case 4: {
                    this.targetJacobian = (this.targetPoint[0][0] - this.targetPoint[1][0]) * (this.targetPoint[0][0] - this.targetPoint[1][0]) + (this.targetPoint[0][1] - this.targetPoint[1][1]) * (this.targetPoint[0][1] - this.targetPoint[1][1]);
                    this.inverseMarquardtLevenbergOptimization(this.iterationPower * this.maxIterations - 1);
                    break;
                }
                case 6: {
                    this.targetJacobian = (this.targetPoint[1][0] - this.targetPoint[2][0]) * this.targetPoint[0][1] + (this.targetPoint[2][0] - this.targetPoint[0][0]) * this.targetPoint[1][1] + (this.targetPoint[0][0] - this.targetPoint[1][0]) * this.targetPoint[2][1];
                    this.inverseMarquardtLevenbergOptimization(this.iterationPower * this.maxIterations - 1);
                    break;
                }
                case 8: {
                    this.marquardtLevenbergOptimization(this.iterationPower * this.maxIterations - 1);
                }
            }
            this.scaleUpLandmarks();
            this.sourcePh.setPoints(this.sourcePoint);
            this.iterationCost *= 2;
        }
        this.iterationPower /= 2;
        if (this.transformation == 8) {
            this.inNx = this.sourceImg.getWidth();
            this.inNy = this.sourceImg.getHeight();
            this.inImg = this.sourceImg.getCoefficient();
            this.inMsk = (float[])(this.sourceMsk == null ? null : this.sourceMsk.getMask());
            this.outNx = this.targetImg.getWidth();
            this.outNy = this.targetImg.getHeight();
            this.outImg = this.targetImg.getImage();
            this.outMsk = this.targetMsk.getMask();
        } else {
            this.inNx = this.targetImg.getWidth();
            this.inNy = this.targetImg.getHeight();
            this.inImg = this.targetImg.getCoefficient();
            this.inMsk = this.targetMsk.getMask();
            this.outNx = this.sourceImg.getWidth();
            this.outNy = this.sourceImg.getHeight();
            this.outImg = this.sourceImg.getImage();
            this.xGradient = this.sourceImg.getXGradient();
            this.yGradient = this.sourceImg.getYGradient();
            this.outMsk = (float[])(this.sourceMsk == null ? null : this.sourceMsk.getMask());
        }
        this.twiceInNx = 2 * this.inNx;
        this.twiceInNy = 2 * this.inNy;
        if (this.accelerated) {
            turboRegProgressBar.skipProgressBar(this.iterationCost * (this.maxIterations - 1));
        } else {
            switch (this.transformation) {
                case 3: {
                    this.inverseMarquardtLevenbergRigidBodyOptimization(this.maxIterations - 1);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.inverseMarquardtLevenbergOptimization(this.maxIterations - 1);
                    break;
                }
                case 8: {
                    this.marquardtLevenbergOptimization(this.maxIterations - 1);
                }
            }
        }
        this.sourcePh.setPoints(this.sourcePoint);
        this.iterationPower = (int)Math.pow(2.0, this.pyramidDepth);
        turboRegProgressBar.workloadDone(this.pyramidDepth * this.maxIterations * this.iterationPower / 2 - (this.iterationPower - 1) / 1);
    }

    public String saveTransformation(String filename) {
        this.inNx = this.sourceImg.getWidth();
        this.inNy = this.sourceImg.getHeight();
        this.outNx = this.targetImg.getWidth();
        this.outNy = this.targetImg.getHeight();
        String path = "";
        if (filename == null) {
            Frame f = new Frame();
            FileDialog fd = new FileDialog(f, "Save landmarks", 1);
            filename = "landmarks.txt";
            fd.setFile(filename);
            fd.setVisible(true);
            path = fd.getDirectory();
            filename = fd.getFile();
            if (path == null || filename == null) {
                return "";
            }
        }
        try {
            int i2;
            FileWriter fw = new FileWriter(path + filename);
            fw.write("Transformation\n");
            switch (this.transformation) {
                case 2: {
                    fw.write("TRANSLATION\n");
                    break;
                }
                case 3: {
                    fw.write("RIGID_BODY\n");
                    break;
                }
                case 4: {
                    fw.write("SCALED_ROTATION\n");
                    break;
                }
                case 6: {
                    fw.write("AFFINE\n");
                    break;
                }
                case 8: {
                    fw.write("BILINEAR\n");
                }
            }
            fw.write("\n");
            fw.write("Source size\n");
            fw.write(this.inNx + "\t" + this.inNy + "\n");
            fw.write("\n");
            fw.write("Target size\n");
            fw.write(this.outNx + "\t" + this.outNy + "\n");
            fw.write("\n");
            fw.write("Refined source landmarks\n");
            if (this.transformation == 3) {
                for (i2 = 0; i2 < this.transformation; ++i2) {
                    fw.write(this.sourcePoint[i2][0] + "\t" + this.sourcePoint[i2][1] + "\n");
                }
            } else {
                for (i2 = 0; i2 < this.transformation / 2; ++i2) {
                    fw.write(this.sourcePoint[i2][0] + "\t" + this.sourcePoint[i2][1] + "\n");
                }
            }
            fw.write("\n");
            fw.write("Target landmarks\n");
            if (this.transformation == 3) {
                for (i2 = 0; i2 < this.transformation; ++i2) {
                    fw.write(this.targetPoint[i2][0] + "\t" + this.targetPoint[i2][1] + "\n");
                }
            } else {
                for (i2 = 0; i2 < this.transformation / 2; ++i2) {
                    fw.write(this.targetPoint[i2][0] + "\t" + this.targetPoint[i2][1] + "\n");
                }
            }
            fw.close();
        }
        catch (IOException e) {
            IJ.log((String)("IOException exception " + e.getMessage()));
        }
        catch (SecurityException e) {
            IJ.log((String)("Security exception " + e.getMessage()));
        }
        return path + filename;
    }

    private void affineTransform(double[][] matrix) {
        int k = 0;
        turboRegProgressBar.addWorkload(this.outNy);
        double yx = matrix[0][0];
        double yy = matrix[1][0];
        for (int v = 0; v < this.outNy; ++v) {
            double x0 = yx;
            double y0 = yy;
            for (int u = 0; u < this.outNx; ++u) {
                int yMsk;
                this.x = x0;
                this.y = y0;
                int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy) {
                    xMsk += yMsk * this.inNx;
                    if (this.accelerated) {
                        this.outImg[k++] = this.inImg[xMsk];
                    } else {
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        this.outImg[k++] = (float)this.interpolate();
                    }
                } else {
                    this.outImg[k++] = 0.0f;
                }
                x0 += matrix[0][1];
                y0 += matrix[1][1];
            }
            yx += matrix[0][2];
            yy += matrix[1][2];
            turboRegProgressBar.stepProgressBar();
        }
        turboRegProgressBar.workloadDone(this.outNy);
    }

    private void affineTransform(double[][] matrix, float[] outMsk) {
        int k = 0;
        turboRegProgressBar.addWorkload(this.outNy);
        double yx = matrix[0][0];
        double yy = matrix[1][0];
        for (int v = 0; v < this.outNy; ++v) {
            double x0 = yx;
            double y0 = yy;
            for (int u = 0; u < this.outNx; ++u) {
                int yMsk;
                this.x = x0;
                this.y = y0;
                int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy) {
                    xMsk += yMsk * this.inNx;
                    if (this.accelerated) {
                        this.outImg[k] = this.inImg[xMsk];
                    } else {
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        this.outImg[k] = (float)this.interpolate();
                    }
                    outMsk[k++] = this.inMsk[xMsk];
                } else {
                    this.outImg[k] = 0.0f;
                    outMsk[k++] = 0.0f;
                }
                x0 += matrix[0][1];
                y0 += matrix[1][1];
            }
            yx += matrix[0][2];
            yy += matrix[1][2];
            turboRegProgressBar.stepProgressBar();
        }
        turboRegProgressBar.workloadDone(this.outNy);
    }

    private void bilinearTransform(double[][] matrix) {
        int k = 0;
        turboRegProgressBar.addWorkload(this.outNy);
        double yx = matrix[0][0];
        double yy = matrix[1][0];
        double yxy = 0.0;
        double yyy = 0.0;
        for (int v = 0; v < this.outNy; ++v) {
            double x0 = yx;
            double y0 = yy;
            for (int u = 0; u < this.outNx; ++u) {
                int yMsk;
                this.x = x0;
                this.y = y0;
                int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy) {
                    xMsk += yMsk * this.inNx;
                    if (this.accelerated) {
                        this.outImg[k++] = this.inImg[xMsk];
                    } else {
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        this.outImg[k++] = (float)this.interpolate();
                    }
                } else {
                    this.outImg[k++] = 0.0f;
                }
                x0 += matrix[0][1] + yxy;
                y0 += matrix[1][1] + yyy;
            }
            yx += matrix[0][2];
            yy += matrix[1][2];
            yxy += matrix[0][3];
            yyy += matrix[1][3];
            turboRegProgressBar.stepProgressBar();
        }
        turboRegProgressBar.workloadDone(this.outNy);
    }

    private void bilinearTransform(double[][] matrix, float[] outMsk) {
        int k = 0;
        turboRegProgressBar.addWorkload(this.outNy);
        double yx = matrix[0][0];
        double yy = matrix[1][0];
        double yxy = 0.0;
        double yyy = 0.0;
        for (int v = 0; v < this.outNy; ++v) {
            double x0 = yx;
            double y0 = yy;
            for (int u = 0; u < this.outNx; ++u) {
                int yMsk;
                this.x = x0;
                this.y = y0;
                int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy) {
                    xMsk += yMsk * this.inNx;
                    if (this.accelerated) {
                        this.outImg[k] = this.inImg[xMsk];
                    } else {
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        this.outImg[k] = (float)this.interpolate();
                    }
                    outMsk[k++] = this.inMsk[xMsk];
                } else {
                    this.outImg[k] = 0.0f;
                    outMsk[k++] = 0.0f;
                }
                x0 += matrix[0][1] + yxy;
                y0 += matrix[1][1] + yyy;
            }
            yx += matrix[0][2];
            yy += matrix[1][2];
            yxy += matrix[0][3];
            yyy += matrix[1][3];
            turboRegProgressBar.stepProgressBar();
        }
        turboRegProgressBar.workloadDone(this.outNy);
    }

    private void computeBilinearGradientConstants() {
        double u1 = this.targetPoint[0][0];
        double u2 = this.targetPoint[1][0];
        double u3 = this.targetPoint[2][0];
        double u4 = this.targetPoint[3][0];
        double v1 = this.targetPoint[0][1];
        double v2 = this.targetPoint[1][1];
        double v3 = this.targetPoint[2][1];
        double v4 = this.targetPoint[3][1];
        double v12 = v1 - v2;
        double v13 = v1 - v3;
        double v14 = v1 - v4;
        double v23 = v2 - v3;
        double v24 = v2 - v4;
        double v34 = v3 - v4;
        double uv12 = u1 * u2 * v12;
        double uv13 = u1 * u3 * v13;
        double uv14 = u1 * u4 * v14;
        double uv23 = u2 * u3 * v23;
        double uv24 = u2 * u4 * v24;
        double uv34 = u3 * u4 * v34;
        double det = uv12 * v34 - uv13 * v24 + uv14 * v23 + uv23 * v14 - uv24 * v13 + uv34 * v12;
        this.c0 = (-uv34 * v2 + uv24 * v3 - uv23 * v4) / det;
        this.c0u = (u3 * v3 * v24 - u2 * v2 * v34 - u4 * v4 * v23) / det;
        this.c0v = (uv23 - uv24 + uv34) / det;
        this.c0uv = (u4 * v23 - u3 * v24 + u2 * v34) / det;
        this.c1 = (uv34 * v1 - uv14 * v3 + uv13 * v4) / det;
        this.c1u = (-u3 * v3 * v14 + u1 * v1 * v34 + u4 * v4 * v13) / det;
        this.c1v = (-uv13 + uv14 - uv34) / det;
        this.c1uv = (-u4 * v13 + u3 * v14 - u1 * v34) / det;
        this.c2 = (-uv24 * v1 + uv14 * v2 - uv12 * v4) / det;
        this.c2u = (u2 * v2 * v14 - u1 * v1 * v24 - u4 * v4 * v12) / det;
        this.c2v = (uv12 - uv14 + uv24) / det;
        this.c2uv = (u4 * v12 - u2 * v14 + u1 * v24) / det;
        this.c3 = (uv23 * v1 - uv13 * v2 + uv12 * v3) / det;
        this.c3u = (-u2 * v2 * v13 + u1 * v1 * v23 + u3 * v3 * v12) / det;
        this.c3v = (-uv12 + uv13 - uv23) / det;
        this.c3uv = (-u3 * v1 + u2 * v13 + u3 * v2 - u1 * v23) / det;
    }

    private double getAffineMeanSquares(double[][] sourcePoint, double[][] matrix) {
        double u1 = sourcePoint[0][0];
        double u2 = sourcePoint[1][0];
        double u3 = sourcePoint[2][0];
        double v1 = sourcePoint[0][1];
        double v2 = sourcePoint[1][1];
        double v3 = sourcePoint[2][1];
        double uv32 = u3 * v2 - u2 * v3;
        double uv21 = u2 * v1 - u1 * v2;
        double uv13 = u1 * v3 - u3 * v1;
        double det = uv32 + uv21 + uv13;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        if (this.outMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        return meanSquares / ((double)area * Math.abs(det / this.targetJacobian));
    }

    private double getAffineMeanSquares(double[][] sourcePoint, double[][] matrix, double[] gradient) {
        int v;
        double u1 = sourcePoint[0][0];
        double u2 = sourcePoint[1][0];
        double u3 = sourcePoint[2][0];
        double v1 = sourcePoint[0][1];
        double v2 = sourcePoint[1][1];
        double v3 = sourcePoint[2][1];
        double uv32 = u3 * v2 - u2 * v3;
        double uv21 = u2 * v1 - u1 * v2;
        double uv13 = u1 * v3 - u3 * v1;
        double det = uv32 + uv21 + uv13;
        double u12 = (u1 - u2) / det;
        double u23 = (u2 - u3) / det;
        double u31 = (u3 - u1) / det;
        double v12 = (v1 - v2) / det;
        double v23 = (v2 - v3) / det;
        double v31 = (v3 - v1) / det;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        uv32 /= det;
        uv21 /= det;
        uv13 /= det;
        for (int i2 = 0; i2 < this.transformation; ++i2) {
            gradient[i2] = 0.0;
        }
        if (this.outMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                        double g0 = u23 * (double)v - v23 * (double)u + uv32;
                        double g1 = u31 * (double)v - v31 * (double)u + uv13;
                        double g2 = u12 * (double)v - v12 * (double)u + uv21;
                        double dx0 = (double)this.xGradient[k] * g0;
                        double dy0 = (double)this.yGradient[k] * g0;
                        double dx1 = (double)this.xGradient[k] * g1;
                        double dy1 = (double)this.yGradient[k] * g1;
                        double dx2 = (double)this.xGradient[k] * g2;
                        double dy2 = (double)this.yGradient[k] * g2;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                        gradient[4] = gradient[4] + difference * dx2;
                        gradient[5] = gradient[5] + difference * dy2;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                        double g0 = u23 * (double)v - v23 * (double)u + uv32;
                        double g1 = u31 * (double)v - v31 * (double)u + uv13;
                        double g2 = u12 * (double)v - v12 * (double)u + uv21;
                        double dx0 = (double)this.xGradient[k] * g0;
                        double dy0 = (double)this.yGradient[k] * g0;
                        double dx1 = (double)this.xGradient[k] * g1;
                        double dy1 = (double)this.yGradient[k] * g1;
                        double dx2 = (double)this.xGradient[k] * g2;
                        double dy2 = (double)this.yGradient[k] * g2;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                        gradient[4] = gradient[4] + difference * dx2;
                        gradient[5] = gradient[5] + difference * dy2;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        return meanSquares / ((double)area * Math.abs(det / this.targetJacobian));
    }

    private double getAffineMeanSquares(double[][] sourcePoint, double[][] matrix, double[][] hessian, double[] gradient) {
        double dy2;
        double dx2;
        double dy1;
        double dx1;
        double dy0;
        double dx0;
        double g2;
        double g1;
        double g0;
        double difference;
        int yMsk;
        int xMsk;
        int u;
        double y0;
        double x0;
        int v;
        double yy;
        double yx;
        int j;
        int i2;
        double u1 = sourcePoint[0][0];
        double u2 = sourcePoint[1][0];
        double u3 = sourcePoint[2][0];
        double v1 = sourcePoint[0][1];
        double v2 = sourcePoint[1][1];
        double v3 = sourcePoint[2][1];
        double uv32 = u3 * v2 - u2 * v3;
        double uv21 = u2 * v1 - u1 * v2;
        double uv13 = u1 * v3 - u3 * v1;
        double det = uv32 + uv21 + uv13;
        double u12 = (u1 - u2) / det;
        double u23 = (u2 - u3) / det;
        double u31 = (u3 - u1) / det;
        double v12 = (v1 - v2) / det;
        double v23 = (v2 - v3) / det;
        double v31 = (v3 - v1) / det;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        uv32 /= det;
        uv21 /= det;
        uv13 /= det;
        for (i2 = 0; i2 < this.transformation; ++i2) {
            gradient[i2] = 0.0;
            for (j = 0; j < this.transformation; ++j) {
                hessian[i2][j] = 0.0;
            }
        }
        if (this.outMsk == null) {
            yx = matrix[0][0];
            yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    this.x = x0;
                    this.y = y0;
                    xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                        g0 = u23 * (double)v - v23 * (double)u + uv32;
                        g1 = u31 * (double)v - v31 * (double)u + uv13;
                        g2 = u12 * (double)v - v12 * (double)u + uv21;
                        dx0 = (double)this.xGradient[k] * g0;
                        dy0 = (double)this.yGradient[k] * g0;
                        dx1 = (double)this.xGradient[k] * g1;
                        dy1 = (double)this.yGradient[k] * g1;
                        dx2 = (double)this.xGradient[k] * g2;
                        dy2 = (double)this.yGradient[k] * g2;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                        gradient[4] = gradient[4] + difference * dx2;
                        gradient[5] = gradient[5] + difference * dy2;
                        double[] dArray = hessian[0];
                        dArray[0] = dArray[0] + dx0 * dx0;
                        double[] dArray2 = hessian[0];
                        dArray2[1] = dArray2[1] + dx0 * dy0;
                        double[] dArray3 = hessian[0];
                        dArray3[2] = dArray3[2] + dx0 * dx1;
                        double[] dArray4 = hessian[0];
                        dArray4[3] = dArray4[3] + dx0 * dy1;
                        double[] dArray5 = hessian[0];
                        dArray5[4] = dArray5[4] + dx0 * dx2;
                        double[] dArray6 = hessian[0];
                        dArray6[5] = dArray6[5] + dx0 * dy2;
                        double[] dArray7 = hessian[1];
                        dArray7[1] = dArray7[1] + dy0 * dy0;
                        double[] dArray8 = hessian[1];
                        dArray8[2] = dArray8[2] + dy0 * dx1;
                        double[] dArray9 = hessian[1];
                        dArray9[3] = dArray9[3] + dy0 * dy1;
                        double[] dArray10 = hessian[1];
                        dArray10[4] = dArray10[4] + dy0 * dx2;
                        double[] dArray11 = hessian[1];
                        dArray11[5] = dArray11[5] + dy0 * dy2;
                        double[] dArray12 = hessian[2];
                        dArray12[2] = dArray12[2] + dx1 * dx1;
                        double[] dArray13 = hessian[2];
                        dArray13[3] = dArray13[3] + dx1 * dy1;
                        double[] dArray14 = hessian[2];
                        dArray14[4] = dArray14[4] + dx1 * dx2;
                        double[] dArray15 = hessian[2];
                        dArray15[5] = dArray15[5] + dx1 * dy2;
                        double[] dArray16 = hessian[3];
                        dArray16[3] = dArray16[3] + dy1 * dy1;
                        double[] dArray17 = hessian[3];
                        dArray17[4] = dArray17[4] + dy1 * dx2;
                        double[] dArray18 = hessian[3];
                        dArray18[5] = dArray18[5] + dy1 * dy2;
                        double[] dArray19 = hessian[4];
                        dArray19[4] = dArray19[4] + dx2 * dx2;
                        double[] dArray20 = hessian[4];
                        dArray20[5] = dArray20[5] + dx2 * dy2;
                        double[] dArray21 = hessian[5];
                        dArray21[5] = dArray21[5] + dy2 * dy2;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            yx = matrix[0][0];
            yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    this.x = x0;
                    this.y = y0;
                    xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                        g0 = u23 * (double)v - v23 * (double)u + uv32;
                        g1 = u31 * (double)v - v31 * (double)u + uv13;
                        g2 = u12 * (double)v - v12 * (double)u + uv21;
                        dx0 = (double)this.xGradient[k] * g0;
                        dy0 = (double)this.yGradient[k] * g0;
                        dx1 = (double)this.xGradient[k] * g1;
                        dy1 = (double)this.yGradient[k] * g1;
                        dx2 = (double)this.xGradient[k] * g2;
                        dy2 = (double)this.yGradient[k] * g2;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                        gradient[4] = gradient[4] + difference * dx2;
                        gradient[5] = gradient[5] + difference * dy2;
                        double[] dArray = hessian[0];
                        dArray[0] = dArray[0] + dx0 * dx0;
                        double[] dArray22 = hessian[0];
                        dArray22[1] = dArray22[1] + dx0 * dy0;
                        double[] dArray23 = hessian[0];
                        dArray23[2] = dArray23[2] + dx0 * dx1;
                        double[] dArray24 = hessian[0];
                        dArray24[3] = dArray24[3] + dx0 * dy1;
                        double[] dArray25 = hessian[0];
                        dArray25[4] = dArray25[4] + dx0 * dx2;
                        double[] dArray26 = hessian[0];
                        dArray26[5] = dArray26[5] + dx0 * dy2;
                        double[] dArray27 = hessian[1];
                        dArray27[1] = dArray27[1] + dy0 * dy0;
                        double[] dArray28 = hessian[1];
                        dArray28[2] = dArray28[2] + dy0 * dx1;
                        double[] dArray29 = hessian[1];
                        dArray29[3] = dArray29[3] + dy0 * dy1;
                        double[] dArray30 = hessian[1];
                        dArray30[4] = dArray30[4] + dy0 * dx2;
                        double[] dArray31 = hessian[1];
                        dArray31[5] = dArray31[5] + dy0 * dy2;
                        double[] dArray32 = hessian[2];
                        dArray32[2] = dArray32[2] + dx1 * dx1;
                        double[] dArray33 = hessian[2];
                        dArray33[3] = dArray33[3] + dx1 * dy1;
                        double[] dArray34 = hessian[2];
                        dArray34[4] = dArray34[4] + dx1 * dx2;
                        double[] dArray35 = hessian[2];
                        dArray35[5] = dArray35[5] + dx1 * dy2;
                        double[] dArray36 = hessian[3];
                        dArray36[3] = dArray36[3] + dy1 * dy1;
                        double[] dArray37 = hessian[3];
                        dArray37[4] = dArray37[4] + dy1 * dx2;
                        double[] dArray38 = hessian[3];
                        dArray38[5] = dArray38[5] + dy1 * dy2;
                        double[] dArray39 = hessian[4];
                        dArray39[4] = dArray39[4] + dx2 * dx2;
                        double[] dArray40 = hessian[4];
                        dArray40[5] = dArray40[5] + dx2 * dy2;
                        double[] dArray41 = hessian[5];
                        dArray41[5] = dArray41[5] + dy2 * dy2;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        for (i2 = 1; i2 < this.transformation; ++i2) {
            for (j = 0; j < i2; ++j) {
                hessian[i2][j] = hessian[j][i2];
            }
        }
        return meanSquares / ((double)area * Math.abs(det / this.targetJacobian));
    }

    private double getBilinearMeanSquares(double[][] matrix) {
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        if (this.inMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            double yxy = 0.0;
            double yyy = 0.0;
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    if (this.outMsk[k] != 0.0f) {
                        int yMsk;
                        this.x = x0;
                        this.y = y0;
                        int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                        int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy) {
                            this.xIndexes();
                            this.yIndexes();
                            ++area;
                            this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                            this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                            this.xWeights();
                            this.yWeights();
                            double difference = this.interpolate() - (double)this.outImg[k];
                            meanSquares += difference * difference;
                        }
                    }
                    x0 += matrix[0][1] + yxy;
                    y0 += matrix[1][1] + yyy;
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
                yxy += matrix[0][3];
                yyy += matrix[1][3];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            double yxy = 0.0;
            double yyy = 0.0;
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[xMsk += yMsk * this.inNx] != 0.0f) {
                        this.xIndexes();
                        this.yIndexes();
                        ++area;
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = this.interpolate() - (double)this.outImg[k];
                        meanSquares += difference * difference;
                    }
                    x0 += matrix[0][1] + yxy;
                    y0 += matrix[1][1] + yyy;
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
                yxy += matrix[0][3];
                yyy += matrix[1][3];
            }
        }
        return meanSquares / (double)area;
    }

    private double getBilinearMeanSquares(double[][] matrix, double[][] hessian, double[] gradient) {
        double dy3;
        double dx3;
        double dy2;
        double dx2;
        double dy1;
        double dx1;
        double dy0;
        double dx0;
        double g3;
        double g2;
        double g1;
        double g0;
        double uv;
        double yGradient;
        double xGradient;
        double difference;
        int yMsk;
        int xMsk;
        int u;
        double y0;
        double x0;
        int v;
        double yyy;
        double yxy;
        double yy;
        double yx;
        int j;
        int i2;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        this.computeBilinearGradientConstants();
        for (i2 = 0; i2 < this.transformation; ++i2) {
            gradient[i2] = 0.0;
            for (j = 0; j < this.transformation; ++j) {
                hessian[i2][j] = 0.0;
            }
        }
        if (this.inMsk == null) {
            yx = matrix[0][0];
            yy = matrix[1][0];
            yxy = 0.0;
            yyy = 0.0;
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    if (this.outMsk[k] != 0.0f) {
                        this.x = x0;
                        this.y = y0;
                        xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                        int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy) {
                            ++area;
                            this.xIndexes();
                            this.yIndexes();
                            this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                            this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                            this.xDxWeights();
                            this.yDyWeights();
                            difference = this.interpolate() - (double)this.outImg[k];
                            meanSquares += difference * difference;
                            xGradient = this.interpolateDx();
                            yGradient = this.interpolateDy();
                            uv = (double)u * (double)v;
                            g0 = this.c0uv * uv + this.c0u * (double)u + this.c0v * (double)v + this.c0;
                            g1 = this.c1uv * uv + this.c1u * (double)u + this.c1v * (double)v + this.c1;
                            g2 = this.c2uv * uv + this.c2u * (double)u + this.c2v * (double)v + this.c2;
                            g3 = this.c3uv * uv + this.c3u * (double)u + this.c3v * (double)v + this.c3;
                            dx0 = xGradient * g0;
                            dy0 = yGradient * g0;
                            dx1 = xGradient * g1;
                            dy1 = yGradient * g1;
                            dx2 = xGradient * g2;
                            dy2 = yGradient * g2;
                            dx3 = xGradient * g3;
                            dy3 = yGradient * g3;
                            gradient[0] = gradient[0] + difference * dx0;
                            gradient[1] = gradient[1] + difference * dy0;
                            gradient[2] = gradient[2] + difference * dx1;
                            gradient[3] = gradient[3] + difference * dy1;
                            gradient[4] = gradient[4] + difference * dx2;
                            gradient[5] = gradient[5] + difference * dy2;
                            gradient[6] = gradient[6] + difference * dx3;
                            gradient[7] = gradient[7] + difference * dy3;
                            double[] dArray = hessian[0];
                            dArray[0] = dArray[0] + dx0 * dx0;
                            double[] dArray2 = hessian[0];
                            dArray2[1] = dArray2[1] + dx0 * dy0;
                            double[] dArray3 = hessian[0];
                            dArray3[2] = dArray3[2] + dx0 * dx1;
                            double[] dArray4 = hessian[0];
                            dArray4[3] = dArray4[3] + dx0 * dy1;
                            double[] dArray5 = hessian[0];
                            dArray5[4] = dArray5[4] + dx0 * dx2;
                            double[] dArray6 = hessian[0];
                            dArray6[5] = dArray6[5] + dx0 * dy2;
                            double[] dArray7 = hessian[0];
                            dArray7[6] = dArray7[6] + dx0 * dx3;
                            double[] dArray8 = hessian[0];
                            dArray8[7] = dArray8[7] + dx0 * dy3;
                            double[] dArray9 = hessian[1];
                            dArray9[1] = dArray9[1] + dy0 * dy0;
                            double[] dArray10 = hessian[1];
                            dArray10[2] = dArray10[2] + dy0 * dx1;
                            double[] dArray11 = hessian[1];
                            dArray11[3] = dArray11[3] + dy0 * dy1;
                            double[] dArray12 = hessian[1];
                            dArray12[4] = dArray12[4] + dy0 * dx2;
                            double[] dArray13 = hessian[1];
                            dArray13[5] = dArray13[5] + dy0 * dy2;
                            double[] dArray14 = hessian[1];
                            dArray14[6] = dArray14[6] + dy0 * dx3;
                            double[] dArray15 = hessian[1];
                            dArray15[7] = dArray15[7] + dy0 * dy3;
                            double[] dArray16 = hessian[2];
                            dArray16[2] = dArray16[2] + dx1 * dx1;
                            double[] dArray17 = hessian[2];
                            dArray17[3] = dArray17[3] + dx1 * dy1;
                            double[] dArray18 = hessian[2];
                            dArray18[4] = dArray18[4] + dx1 * dx2;
                            double[] dArray19 = hessian[2];
                            dArray19[5] = dArray19[5] + dx1 * dy2;
                            double[] dArray20 = hessian[2];
                            dArray20[6] = dArray20[6] + dx1 * dx3;
                            double[] dArray21 = hessian[2];
                            dArray21[7] = dArray21[7] + dx1 * dy3;
                            double[] dArray22 = hessian[3];
                            dArray22[3] = dArray22[3] + dy1 * dy1;
                            double[] dArray23 = hessian[3];
                            dArray23[4] = dArray23[4] + dy1 * dx2;
                            double[] dArray24 = hessian[3];
                            dArray24[5] = dArray24[5] + dy1 * dy2;
                            double[] dArray25 = hessian[3];
                            dArray25[6] = dArray25[6] + dy1 * dx3;
                            double[] dArray26 = hessian[3];
                            dArray26[7] = dArray26[7] + dy1 * dy3;
                            double[] dArray27 = hessian[4];
                            dArray27[4] = dArray27[4] + dx2 * dx2;
                            double[] dArray28 = hessian[4];
                            dArray28[5] = dArray28[5] + dx2 * dy2;
                            double[] dArray29 = hessian[4];
                            dArray29[6] = dArray29[6] + dx2 * dx3;
                            double[] dArray30 = hessian[4];
                            dArray30[7] = dArray30[7] + dx2 * dy3;
                            double[] dArray31 = hessian[5];
                            dArray31[5] = dArray31[5] + dy2 * dy2;
                            double[] dArray32 = hessian[5];
                            dArray32[6] = dArray32[6] + dy2 * dx3;
                            double[] dArray33 = hessian[5];
                            dArray33[7] = dArray33[7] + dy2 * dy3;
                            double[] dArray34 = hessian[6];
                            dArray34[6] = dArray34[6] + dx3 * dx3;
                            double[] dArray35 = hessian[6];
                            dArray35[7] = dArray35[7] + dx3 * dy3;
                            double[] dArray36 = hessian[7];
                            dArray36[7] = dArray36[7] + dy3 * dy3;
                        }
                    }
                    x0 += matrix[0][1] + yxy;
                    y0 += matrix[1][1] + yyy;
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
                yxy += matrix[0][3];
                yyy += matrix[1][3];
            }
        } else {
            yx = matrix[0][0];
            yy = matrix[1][0];
            yxy = 0.0;
            yyy = 0.0;
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    this.x = x0;
                    this.y = y0;
                    xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[xMsk += yMsk * this.inNx] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xDxWeights();
                        this.yDyWeights();
                        difference = this.interpolate() - (double)this.outImg[k];
                        meanSquares += difference * difference;
                        xGradient = this.interpolateDx();
                        yGradient = this.interpolateDy();
                        uv = (double)u * (double)v;
                        g0 = this.c0uv * uv + this.c0u * (double)u + this.c0v * (double)v + this.c0;
                        g1 = this.c1uv * uv + this.c1u * (double)u + this.c1v * (double)v + this.c1;
                        g2 = this.c2uv * uv + this.c2u * (double)u + this.c2v * (double)v + this.c2;
                        g3 = this.c3uv * uv + this.c3u * (double)u + this.c3v * (double)v + this.c3;
                        dx0 = xGradient * g0;
                        dy0 = yGradient * g0;
                        dx1 = xGradient * g1;
                        dy1 = yGradient * g1;
                        dx2 = xGradient * g2;
                        dy2 = yGradient * g2;
                        dx3 = xGradient * g3;
                        dy3 = yGradient * g3;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                        gradient[4] = gradient[4] + difference * dx2;
                        gradient[5] = gradient[5] + difference * dy2;
                        gradient[6] = gradient[6] + difference * dx3;
                        gradient[7] = gradient[7] + difference * dy3;
                        double[] dArray = hessian[0];
                        dArray[0] = dArray[0] + dx0 * dx0;
                        double[] dArray37 = hessian[0];
                        dArray37[1] = dArray37[1] + dx0 * dy0;
                        double[] dArray38 = hessian[0];
                        dArray38[2] = dArray38[2] + dx0 * dx1;
                        double[] dArray39 = hessian[0];
                        dArray39[3] = dArray39[3] + dx0 * dy1;
                        double[] dArray40 = hessian[0];
                        dArray40[4] = dArray40[4] + dx0 * dx2;
                        double[] dArray41 = hessian[0];
                        dArray41[5] = dArray41[5] + dx0 * dy2;
                        double[] dArray42 = hessian[0];
                        dArray42[6] = dArray42[6] + dx0 * dx3;
                        double[] dArray43 = hessian[0];
                        dArray43[7] = dArray43[7] + dx0 * dy3;
                        double[] dArray44 = hessian[1];
                        dArray44[1] = dArray44[1] + dy0 * dy0;
                        double[] dArray45 = hessian[1];
                        dArray45[2] = dArray45[2] + dy0 * dx1;
                        double[] dArray46 = hessian[1];
                        dArray46[3] = dArray46[3] + dy0 * dy1;
                        double[] dArray47 = hessian[1];
                        dArray47[4] = dArray47[4] + dy0 * dx2;
                        double[] dArray48 = hessian[1];
                        dArray48[5] = dArray48[5] + dy0 * dy2;
                        double[] dArray49 = hessian[1];
                        dArray49[6] = dArray49[6] + dy0 * dx3;
                        double[] dArray50 = hessian[1];
                        dArray50[7] = dArray50[7] + dy0 * dy3;
                        double[] dArray51 = hessian[2];
                        dArray51[2] = dArray51[2] + dx1 * dx1;
                        double[] dArray52 = hessian[2];
                        dArray52[3] = dArray52[3] + dx1 * dy1;
                        double[] dArray53 = hessian[2];
                        dArray53[4] = dArray53[4] + dx1 * dx2;
                        double[] dArray54 = hessian[2];
                        dArray54[5] = dArray54[5] + dx1 * dy2;
                        double[] dArray55 = hessian[2];
                        dArray55[6] = dArray55[6] + dx1 * dx3;
                        double[] dArray56 = hessian[2];
                        dArray56[7] = dArray56[7] + dx1 * dy3;
                        double[] dArray57 = hessian[3];
                        dArray57[3] = dArray57[3] + dy1 * dy1;
                        double[] dArray58 = hessian[3];
                        dArray58[4] = dArray58[4] + dy1 * dx2;
                        double[] dArray59 = hessian[3];
                        dArray59[5] = dArray59[5] + dy1 * dy2;
                        double[] dArray60 = hessian[3];
                        dArray60[6] = dArray60[6] + dy1 * dx3;
                        double[] dArray61 = hessian[3];
                        dArray61[7] = dArray61[7] + dy1 * dy3;
                        double[] dArray62 = hessian[4];
                        dArray62[4] = dArray62[4] + dx2 * dx2;
                        double[] dArray63 = hessian[4];
                        dArray63[5] = dArray63[5] + dx2 * dy2;
                        double[] dArray64 = hessian[4];
                        dArray64[6] = dArray64[6] + dx2 * dx3;
                        double[] dArray65 = hessian[4];
                        dArray65[7] = dArray65[7] + dx2 * dy3;
                        double[] dArray66 = hessian[5];
                        dArray66[5] = dArray66[5] + dy2 * dy2;
                        double[] dArray67 = hessian[5];
                        dArray67[6] = dArray67[6] + dy2 * dx3;
                        double[] dArray68 = hessian[5];
                        dArray68[7] = dArray68[7] + dy2 * dy3;
                        double[] dArray69 = hessian[6];
                        dArray69[6] = dArray69[6] + dx3 * dx3;
                        double[] dArray70 = hessian[6];
                        dArray70[7] = dArray70[7] + dx3 * dy3;
                        double[] dArray71 = hessian[7];
                        dArray71[7] = dArray71[7] + dy3 * dy3;
                    }
                    x0 += matrix[0][1] + yxy;
                    y0 += matrix[1][1] + yyy;
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
                yxy += matrix[0][3];
                yyy += matrix[1][3];
            }
        }
        for (i2 = 1; i2 < this.transformation; ++i2) {
            for (j = 0; j < i2; ++j) {
                hessian[i2][j] = hessian[j][i2];
            }
        }
        return meanSquares / (double)area;
    }

    private double getRigidBodyMeanSquares(double[][] matrix) {
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        if (this.outMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        return meanSquares / (double)area;
    }

    private double getRigidBodyMeanSquares(double[][] matrix, double[] gradient) {
        int v;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        for (int i2 = 0; i2 < this.transformation; ++i2) {
            gradient[i2] = 0.0;
        }
        if (this.outMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                        gradient[0] = gradient[0] + difference * ((double)this.yGradient[k] * (double)u - (double)this.xGradient[k] * (double)v);
                        gradient[1] = gradient[1] + difference * (double)this.xGradient[k];
                        gradient[2] = gradient[2] + difference * (double)this.yGradient[k];
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                        gradient[0] = gradient[0] + difference * ((double)this.yGradient[k] * (double)u - (double)this.xGradient[k] * (double)v);
                        gradient[1] = gradient[1] + difference * (double)this.xGradient[k];
                        gradient[2] = gradient[2] + difference * (double)this.yGradient[k];
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        return meanSquares / (double)area;
    }

    private double getRigidBodyMeanSquares(double[][] matrix, double[][] hessian, double[] gradient) {
        double dTheta;
        double difference;
        int yMsk;
        int xMsk;
        int u;
        double y0;
        double x0;
        int v;
        double yy;
        double yx;
        int j;
        int i2;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        for (i2 = 0; i2 < this.transformation; ++i2) {
            gradient[i2] = 0.0;
            for (j = 0; j < this.transformation; ++j) {
                hessian[i2][j] = 0.0;
            }
        }
        if (this.outMsk == null) {
            yx = matrix[0][0];
            yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    this.x = x0;
                    this.y = y0;
                    xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                        dTheta = (double)this.yGradient[k] * (double)u - (double)this.xGradient[k] * (double)v;
                        gradient[0] = gradient[0] + difference * dTheta;
                        gradient[1] = gradient[1] + difference * (double)this.xGradient[k];
                        gradient[2] = gradient[2] + difference * (double)this.yGradient[k];
                        double[] dArray = hessian[0];
                        dArray[0] = dArray[0] + dTheta * dTheta;
                        double[] dArray2 = hessian[0];
                        dArray2[1] = dArray2[1] + dTheta * (double)this.xGradient[k];
                        double[] dArray3 = hessian[0];
                        dArray3[2] = dArray3[2] + dTheta * (double)this.yGradient[k];
                        double[] dArray4 = hessian[1];
                        dArray4[1] = dArray4[1] + (double)(this.xGradient[k] * this.xGradient[k]);
                        double[] dArray5 = hessian[1];
                        dArray5[2] = dArray5[2] + (double)(this.xGradient[k] * this.yGradient[k]);
                        double[] dArray6 = hessian[2];
                        dArray6[2] = dArray6[2] + (double)(this.yGradient[k] * this.yGradient[k]);
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            yx = matrix[0][0];
            yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    this.x = x0;
                    this.y = y0;
                    xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                        dTheta = (double)this.yGradient[k] * (double)u - (double)this.xGradient[k] * (double)v;
                        gradient[0] = gradient[0] + difference * dTheta;
                        gradient[1] = gradient[1] + difference * (double)this.xGradient[k];
                        gradient[2] = gradient[2] + difference * (double)this.yGradient[k];
                        double[] dArray = hessian[0];
                        dArray[0] = dArray[0] + dTheta * dTheta;
                        double[] dArray7 = hessian[0];
                        dArray7[1] = dArray7[1] + dTheta * (double)this.xGradient[k];
                        double[] dArray8 = hessian[0];
                        dArray8[2] = dArray8[2] + dTheta * (double)this.yGradient[k];
                        double[] dArray9 = hessian[1];
                        dArray9[1] = dArray9[1] + (double)(this.xGradient[k] * this.xGradient[k]);
                        double[] dArray10 = hessian[1];
                        dArray10[2] = dArray10[2] + (double)(this.xGradient[k] * this.yGradient[k]);
                        double[] dArray11 = hessian[2];
                        dArray11[2] = dArray11[2] + (double)(this.yGradient[k] * this.yGradient[k]);
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        for (i2 = 1; i2 < this.transformation; ++i2) {
            for (j = 0; j < i2; ++j) {
                hessian[i2][j] = hessian[j][i2];
            }
        }
        return meanSquares / (double)area;
    }

    private double getScaledRotationMeanSquares(double[][] sourcePoint, double[][] matrix) {
        double u1 = sourcePoint[0][0];
        double u2 = sourcePoint[1][0];
        double v1 = sourcePoint[0][1];
        double v2 = sourcePoint[1][1];
        double u12 = u1 - u2;
        double v12 = v1 - v2;
        double uv2 = u12 * u12 + v12 * v12;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        if (this.outMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        return meanSquares / ((double)area * uv2 / this.targetJacobian);
    }

    private double getScaledRotationMeanSquares(double[][] sourcePoint, double[][] matrix, double[] gradient) {
        int v;
        double u1 = sourcePoint[0][0];
        double u2 = sourcePoint[1][0];
        double v1 = sourcePoint[0][1];
        double v2 = sourcePoint[1][1];
        double u12 = u1 - u2;
        double v12 = v1 - v2;
        double uv2 = u12 * u12 + v12 * v12;
        double c = 0.5 * (u2 * v1 - u1 * v2) / uv2;
        double c1 = u12 / uv2;
        double c2 = v12 / uv2;
        double c3 = (uv2 - u12 * v12) / uv2;
        double c4 = (uv2 + u12 * v12) / uv2;
        double c5 = c + u1 * c1 + u2 * c2;
        double c6 = c * (u12 * u12 - v12 * v12) / uv2;
        double c7 = c1 * c4;
        double c8 = c1 - c2 - c1 * c2 * v12;
        double c9 = c1 + c2 - c1 * c2 * u12;
        double c0 = c2 * c3;
        double dgxx0 = c1 * u2 + c2 * v2;
        double dgyx0 = 2.0 * c;
        double dgxx1 = c5 + c6;
        double dgyy1 = c5 - c6;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        for (int i2 = 0; i2 < this.transformation; ++i2) {
            gradient[i2] = 0.0;
        }
        if (this.outMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                        double gxx0 = (double)u * c1 + (double)v * c2 - dgxx0;
                        double gyx0 = (double)v * c1 - (double)u * c2 + dgyx0;
                        double gxy0 = -gyx0;
                        double gyy0 = gxx0;
                        double gxx1 = (double)v * c8 - (double)u * c7 + dgxx1;
                        double gyx1 = -c3 * gyx0;
                        double gxy1 = c4 * gyx0;
                        double gyy1 = dgyy1 - (double)u * c9 - (double)v * c0;
                        double dx0 = (double)this.xGradient[k] * gxx0 + (double)this.yGradient[k] * gyx0;
                        double dy0 = (double)this.xGradient[k] * gxy0 + (double)this.yGradient[k] * gyy0;
                        double dx1 = (double)this.xGradient[k] * gxx1 + (double)this.yGradient[k] * gyx1;
                        double dy1 = (double)this.xGradient[k] * gxy1 + (double)this.yGradient[k] * gyy1;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    this.x = x0;
                    this.y = y0;
                    int xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        double difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                        double gxx0 = (double)u * c1 + (double)v * c2 - dgxx0;
                        double gyx0 = (double)v * c1 - (double)u * c2 + dgyx0;
                        double gxy0 = -gyx0;
                        double gyy0 = gxx0;
                        double gxx1 = (double)v * c8 - (double)u * c7 + dgxx1;
                        double gyx1 = -c3 * gyx0;
                        double gxy1 = c4 * gyx0;
                        double gyy1 = dgyy1 - (double)u * c9 - (double)v * c0;
                        double dx0 = (double)this.xGradient[k] * gxx0 + (double)this.yGradient[k] * gyx0;
                        double dy0 = (double)this.xGradient[k] * gxy0 + (double)this.yGradient[k] * gyy0;
                        double dx1 = (double)this.xGradient[k] * gxx1 + (double)this.yGradient[k] * gyx1;
                        double dy1 = (double)this.xGradient[k] * gxy1 + (double)this.yGradient[k] * gyy1;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        return meanSquares / ((double)area * uv2 / this.targetJacobian);
    }

    private double getScaledRotationMeanSquares(double[][] sourcePoint, double[][] matrix, double[][] hessian, double[] gradient) {
        double dy1;
        double dx1;
        double dy0;
        double dx0;
        double gyy1;
        double gxy1;
        double gyx1;
        double gxx1;
        double gyy0;
        double gxy0;
        double gyx0;
        double gxx0;
        double difference;
        int yMsk;
        int xMsk;
        int u;
        double y0;
        double x0;
        int v;
        double yy;
        double yx;
        int j;
        int i2;
        double u1 = sourcePoint[0][0];
        double u2 = sourcePoint[1][0];
        double v1 = sourcePoint[0][1];
        double v2 = sourcePoint[1][1];
        double u12 = u1 - u2;
        double v12 = v1 - v2;
        double uv2 = u12 * u12 + v12 * v12;
        double c = 0.5 * (u2 * v1 - u1 * v2) / uv2;
        double c1 = u12 / uv2;
        double c2 = v12 / uv2;
        double c3 = (uv2 - u12 * v12) / uv2;
        double c4 = (uv2 + u12 * v12) / uv2;
        double c5 = c + u1 * c1 + u2 * c2;
        double c6 = c * (u12 * u12 - v12 * v12) / uv2;
        double c7 = c1 * c4;
        double c8 = c1 - c2 - c1 * c2 * v12;
        double c9 = c1 + c2 - c1 * c2 * u12;
        double c0 = c2 * c3;
        double dgxx0 = c1 * u2 + c2 * v2;
        double dgyx0 = 2.0 * c;
        double dgxx1 = c5 + c6;
        double dgyy1 = c5 - c6;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        for (i2 = 0; i2 < this.transformation; ++i2) {
            gradient[i2] = 0.0;
            for (j = 0; j < this.transformation; ++j) {
                hessian[i2][j] = 0.0;
            }
        }
        if (this.outMsk == null) {
            yx = matrix[0][0];
            yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    this.x = x0;
                    this.y = y0;
                    xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                        gxx0 = (double)u * c1 + (double)v * c2 - dgxx0;
                        gyx0 = (double)v * c1 - (double)u * c2 + dgyx0;
                        gxy0 = -gyx0;
                        gyy0 = gxx0;
                        gxx1 = (double)v * c8 - (double)u * c7 + dgxx1;
                        gyx1 = -c3 * gyx0;
                        gxy1 = c4 * gyx0;
                        gyy1 = dgyy1 - (double)u * c9 - (double)v * c0;
                        dx0 = (double)this.xGradient[k] * gxx0 + (double)this.yGradient[k] * gyx0;
                        dy0 = (double)this.xGradient[k] * gxy0 + (double)this.yGradient[k] * gyy0;
                        dx1 = (double)this.xGradient[k] * gxx1 + (double)this.yGradient[k] * gyx1;
                        dy1 = (double)this.xGradient[k] * gxy1 + (double)this.yGradient[k] * gyy1;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                        double[] dArray = hessian[0];
                        dArray[0] = dArray[0] + dx0 * dx0;
                        double[] dArray2 = hessian[0];
                        dArray2[1] = dArray2[1] + dx0 * dy0;
                        double[] dArray3 = hessian[0];
                        dArray3[2] = dArray3[2] + dx0 * dx1;
                        double[] dArray4 = hessian[0];
                        dArray4[3] = dArray4[3] + dx0 * dy1;
                        double[] dArray5 = hessian[1];
                        dArray5[1] = dArray5[1] + dy0 * dy0;
                        double[] dArray6 = hessian[1];
                        dArray6[2] = dArray6[2] + dy0 * dx1;
                        double[] dArray7 = hessian[1];
                        dArray7[3] = dArray7[3] + dy0 * dy1;
                        double[] dArray8 = hessian[2];
                        dArray8[2] = dArray8[2] + dx1 * dx1;
                        double[] dArray9 = hessian[2];
                        dArray9[3] = dArray9[3] + dx1 * dy1;
                        double[] dArray10 = hessian[3];
                        dArray10[3] = dArray10[3] + dy1 * dy1;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            yx = matrix[0][0];
            yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    this.x = x0;
                    this.y = y0;
                    xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes();
                        this.yIndexes();
                        this.x -= 0.0 <= this.x ? (double)((int)this.x) : (double)((int)this.x - 1);
                        this.y -= 0.0 <= this.y ? (double)((int)this.y) : (double)((int)this.y - 1);
                        this.xWeights();
                        this.yWeights();
                        difference = (double)this.outImg[k] - this.interpolate();
                        meanSquares += difference * difference;
                        gxx0 = (double)u * c1 + (double)v * c2 - dgxx0;
                        gyx0 = (double)v * c1 - (double)u * c2 + dgyx0;
                        gxy0 = -gyx0;
                        gyy0 = gxx0;
                        gxx1 = (double)v * c8 - (double)u * c7 + dgxx1;
                        gyx1 = -c3 * gyx0;
                        gxy1 = c4 * gyx0;
                        gyy1 = dgyy1 - (double)u * c9 - (double)v * c0;
                        dx0 = (double)this.xGradient[k] * gxx0 + (double)this.yGradient[k] * gyx0;
                        dy0 = (double)this.xGradient[k] * gxy0 + (double)this.yGradient[k] * gyy0;
                        dx1 = (double)this.xGradient[k] * gxx1 + (double)this.yGradient[k] * gyx1;
                        dy1 = (double)this.xGradient[k] * gxy1 + (double)this.yGradient[k] * gyy1;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                        double[] dArray = hessian[0];
                        dArray[0] = dArray[0] + dx0 * dx0;
                        double[] dArray11 = hessian[0];
                        dArray11[1] = dArray11[1] + dx0 * dy0;
                        double[] dArray12 = hessian[0];
                        dArray12[2] = dArray12[2] + dx0 * dx1;
                        double[] dArray13 = hessian[0];
                        dArray13[3] = dArray13[3] + dx0 * dy1;
                        double[] dArray14 = hessian[1];
                        dArray14[1] = dArray14[1] + dy0 * dy0;
                        double[] dArray15 = hessian[1];
                        dArray15[2] = dArray15[2] + dy0 * dx1;
                        double[] dArray16 = hessian[1];
                        dArray16[3] = dArray16[3] + dy0 * dy1;
                        double[] dArray17 = hessian[2];
                        dArray17[2] = dArray17[2] + dx1 * dx1;
                        double[] dArray18 = hessian[2];
                        dArray18[3] = dArray18[3] + dx1 * dy1;
                        double[] dArray19 = hessian[3];
                        dArray19[3] = dArray19[3] + dy1 * dy1;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        for (i2 = 1; i2 < this.transformation; ++i2) {
            for (j = 0; j < i2; ++j) {
                hessian[i2][j] = hessian[j][i2];
            }
        }
        return meanSquares / ((double)area * uv2 / this.targetJacobian);
    }

    private double[][] getTransformationMatrix(double[][] fromCoord, double[][] toCoord) {
        double[][] matrix = null;
        double[][] a = null;
        double[] v = null;
        switch (this.transformation) {
            case 2: {
                matrix = new double[2][1];
                matrix[0][0] = toCoord[0][0] - fromCoord[0][0];
                matrix[1][0] = toCoord[0][1] - fromCoord[0][1];
                break;
            }
            case 3: {
                double angle = Math.atan2(fromCoord[2][0] - fromCoord[1][0], fromCoord[2][1] - fromCoord[1][1]) - Math.atan2(toCoord[2][0] - toCoord[1][0], toCoord[2][1] - toCoord[1][1]);
                double c = Math.cos(angle);
                double s = Math.sin(angle);
                matrix = new double[2][3];
                matrix[0][0] = toCoord[0][0] - c * fromCoord[0][0] + s * fromCoord[0][1];
                matrix[0][1] = c;
                matrix[0][2] = -s;
                matrix[1][0] = toCoord[0][1] - s * fromCoord[0][0] - c * fromCoord[0][1];
                matrix[1][1] = s;
                matrix[1][2] = c;
                break;
            }
            case 4: {
                int j;
                int i2;
                matrix = new double[2][3];
                a = new double[3][3];
                v = new double[3];
                a[0][0] = 1.0;
                a[0][1] = fromCoord[0][0];
                a[0][2] = fromCoord[0][1];
                a[1][0] = 1.0;
                a[1][1] = fromCoord[1][0];
                a[1][2] = fromCoord[1][1];
                a[2][0] = 1.0;
                a[2][1] = fromCoord[0][1] - fromCoord[1][1] + fromCoord[1][0];
                a[2][2] = fromCoord[1][0] + fromCoord[1][1] - fromCoord[0][0];
                this.invertGauss(a);
                v[0] = toCoord[0][0];
                v[1] = toCoord[1][0];
                v[2] = toCoord[0][1] - toCoord[1][1] + toCoord[1][0];
                for (i2 = 0; i2 < 3; ++i2) {
                    matrix[0][i2] = 0.0;
                    for (j = 0; j < 3; ++j) {
                        double[] dArray = matrix[0];
                        int n = i2;
                        dArray[n] = dArray[n] + a[i2][j] * v[j];
                    }
                }
                v[0] = toCoord[0][1];
                v[1] = toCoord[1][1];
                v[2] = toCoord[1][0] + toCoord[1][1] - toCoord[0][0];
                for (i2 = 0; i2 < 3; ++i2) {
                    matrix[1][i2] = 0.0;
                    for (j = 0; j < 3; ++j) {
                        double[] dArray = matrix[1];
                        int n = i2;
                        dArray[n] = dArray[n] + a[i2][j] * v[j];
                    }
                }
                break;
            }
            case 6: {
                int j;
                int i3;
                matrix = new double[2][3];
                a = new double[3][3];
                v = new double[3];
                a[0][0] = 1.0;
                a[0][1] = fromCoord[0][0];
                a[0][2] = fromCoord[0][1];
                a[1][0] = 1.0;
                a[1][1] = fromCoord[1][0];
                a[1][2] = fromCoord[1][1];
                a[2][0] = 1.0;
                a[2][1] = fromCoord[2][0];
                a[2][2] = fromCoord[2][1];
                this.invertGauss(a);
                v[0] = toCoord[0][0];
                v[1] = toCoord[1][0];
                v[2] = toCoord[2][0];
                for (i3 = 0; i3 < 3; ++i3) {
                    matrix[0][i3] = 0.0;
                    for (j = 0; j < 3; ++j) {
                        double[] dArray = matrix[0];
                        int n = i3;
                        dArray[n] = dArray[n] + a[i3][j] * v[j];
                    }
                }
                v[0] = toCoord[0][1];
                v[1] = toCoord[1][1];
                v[2] = toCoord[2][1];
                for (i3 = 0; i3 < 3; ++i3) {
                    matrix[1][i3] = 0.0;
                    for (j = 0; j < 3; ++j) {
                        double[] dArray = matrix[1];
                        int n = i3;
                        dArray[n] = dArray[n] + a[i3][j] * v[j];
                    }
                }
                break;
            }
            case 8: {
                int j;
                int i4;
                matrix = new double[2][4];
                a = new double[4][4];
                v = new double[4];
                a[0][0] = 1.0;
                a[0][1] = fromCoord[0][0];
                a[0][2] = fromCoord[0][1];
                a[0][3] = fromCoord[0][0] * fromCoord[0][1];
                a[1][0] = 1.0;
                a[1][1] = fromCoord[1][0];
                a[1][2] = fromCoord[1][1];
                a[1][3] = fromCoord[1][0] * fromCoord[1][1];
                a[2][0] = 1.0;
                a[2][1] = fromCoord[2][0];
                a[2][2] = fromCoord[2][1];
                a[2][3] = fromCoord[2][0] * fromCoord[2][1];
                a[3][0] = 1.0;
                a[3][1] = fromCoord[3][0];
                a[3][2] = fromCoord[3][1];
                a[3][3] = fromCoord[3][0] * fromCoord[3][1];
                this.invertGauss(a);
                v[0] = toCoord[0][0];
                v[1] = toCoord[1][0];
                v[2] = toCoord[2][0];
                v[3] = toCoord[3][0];
                for (i4 = 0; i4 < 4; ++i4) {
                    matrix[0][i4] = 0.0;
                    for (j = 0; j < 4; ++j) {
                        double[] dArray = matrix[0];
                        int n = i4;
                        dArray[n] = dArray[n] + a[i4][j] * v[j];
                    }
                }
                v[0] = toCoord[0][1];
                v[1] = toCoord[1][1];
                v[2] = toCoord[2][1];
                v[3] = toCoord[3][1];
                for (i4 = 0; i4 < 4; ++i4) {
                    matrix[1][i4] = 0.0;
                    for (j = 0; j < 4; ++j) {
                        double[] dArray = matrix[1];
                        int n = i4;
                        dArray[n] = dArray[n] + a[i4][j] * v[j];
                    }
                }
                break;
            }
        }
        return matrix;
    }

    private double getTranslationMeanSquares(double[][] matrix) {
        double dx = matrix[0][0];
        double dy = matrix[1][0];
        double dx0 = dx;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        this.x = dx - Math.floor(dx);
        this.y = dy - Math.floor(dy);
        this.xWeights();
        this.yWeights();
        if (this.outMsk == null) {
            for (int v = 0; v < this.outNy; ++v) {
                int yMsk;
                dy += 1.0;
                this.y = this.y;
                int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                if (0 <= yMsk && yMsk < this.inNy) {
                    yMsk *= this.inNx;
                    this.yIndexes();
                    dx = dx0;
                    int u = 0;
                    while (u < this.outNx) {
                        int xMsk;
                        dx += 1.0;
                        this.x = this.x;
                        int n2 = xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && this.inMsk[yMsk + xMsk] != 0.0f) {
                            this.xIndexes();
                            ++area;
                            double difference = (double)this.outImg[k] - this.interpolate();
                            meanSquares += difference * difference;
                        }
                        ++u;
                        ++k;
                    }
                    continue;
                }
                k += this.outNx;
            }
        } else {
            for (int v = 0; v < this.outNy; ++v) {
                int yMsk;
                dy += 1.0;
                this.y = this.y;
                int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                if (0 <= yMsk && yMsk < this.inNy) {
                    yMsk *= this.inNx;
                    this.yIndexes();
                    dx = dx0;
                    int u = 0;
                    while (u < this.outNx) {
                        int xMsk;
                        dx += 1.0;
                        this.x = this.x;
                        int n3 = xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && this.outMsk[k] * this.inMsk[yMsk + xMsk] != 0.0f) {
                            this.xIndexes();
                            ++area;
                            double difference = (double)this.outImg[k] - this.interpolate();
                            meanSquares += difference * difference;
                        }
                        ++u;
                        ++k;
                    }
                    continue;
                }
                k += this.outNx;
            }
        }
        return meanSquares / (double)area;
    }

    private double getTranslationMeanSquares(double[][] matrix, double[] gradient) {
        int v;
        double dx = matrix[0][0];
        double dy = matrix[1][0];
        double dx0 = dx;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        for (int i2 = 0; i2 < this.transformation; ++i2) {
            gradient[i2] = 0.0;
        }
        this.x = dx - Math.floor(dx);
        this.y = dy - Math.floor(dy);
        this.xWeights();
        this.yWeights();
        if (this.outMsk == null) {
            for (v = 0; v < this.outNy; ++v) {
                int yMsk;
                dy += 1.0;
                this.y = this.y;
                int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                if (0 <= yMsk && yMsk < this.inNy) {
                    yMsk *= this.inNx;
                    this.yIndexes();
                    dx = dx0;
                    int u = 0;
                    while (u < this.outNx) {
                        int xMsk;
                        dx += 1.0;
                        this.x = this.x;
                        int n2 = xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && this.inMsk[yMsk + xMsk] != 0.0f) {
                            ++area;
                            this.xIndexes();
                            double difference = (double)this.outImg[k] - this.interpolate();
                            meanSquares += difference * difference;
                            gradient[0] = gradient[0] + difference * (double)this.xGradient[k];
                            gradient[1] = gradient[1] + difference * (double)this.yGradient[k];
                        }
                        ++u;
                        ++k;
                    }
                    continue;
                }
                k += this.outNx;
            }
        } else {
            for (v = 0; v < this.outNy; ++v) {
                int yMsk;
                dy += 1.0;
                this.y = this.y;
                int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                if (0 <= yMsk && yMsk < this.inNy) {
                    yMsk *= this.inNx;
                    this.yIndexes();
                    dx = dx0;
                    int u = 0;
                    while (u < this.outNx) {
                        int xMsk;
                        dx += 1.0;
                        this.x = this.x;
                        int n3 = xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && this.outMsk[k] * this.inMsk[yMsk + xMsk] != 0.0f) {
                            ++area;
                            this.xIndexes();
                            double difference = (double)this.outImg[k] - this.interpolate();
                            meanSquares += difference * difference;
                            gradient[0] = gradient[0] + difference * (double)this.xGradient[k];
                            gradient[1] = gradient[1] + difference * (double)this.yGradient[k];
                        }
                        ++u;
                        ++k;
                    }
                    continue;
                }
                k += this.outNx;
            }
        }
        return meanSquares / (double)area;
    }

    private double getTranslationMeanSquares(double[][] matrix, double[][] hessian, double[] gradient) {
        double difference;
        int xMsk;
        int u;
        int yMsk;
        int v;
        int j;
        int i2;
        double dx = matrix[0][0];
        double dy = matrix[1][0];
        double dx0 = dx;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        for (i2 = 0; i2 < this.transformation; ++i2) {
            gradient[i2] = 0.0;
            for (j = 0; j < this.transformation; ++j) {
                hessian[i2][j] = 0.0;
            }
        }
        this.x = dx - Math.floor(dx);
        this.y = dy - Math.floor(dy);
        this.xWeights();
        this.yWeights();
        if (this.outMsk == null) {
            for (v = 0; v < this.outNy; ++v) {
                dy += 1.0;
                this.y = this.y;
                int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                if (0 <= yMsk && yMsk < this.inNy) {
                    yMsk *= this.inNx;
                    this.yIndexes();
                    dx = dx0;
                    u = 0;
                    while (u < this.outNx) {
                        dx += 1.0;
                        this.x = this.x;
                        int n2 = xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && this.inMsk[yMsk + xMsk] != 0.0f) {
                            ++area;
                            this.xIndexes();
                            difference = (double)this.outImg[k] - this.interpolate();
                            meanSquares += difference * difference;
                            gradient[0] = gradient[0] + difference * (double)this.xGradient[k];
                            gradient[1] = gradient[1] + difference * (double)this.yGradient[k];
                            double[] dArray = hessian[0];
                            dArray[0] = dArray[0] + (double)(this.xGradient[k] * this.xGradient[k]);
                            double[] dArray2 = hessian[0];
                            dArray2[1] = dArray2[1] + (double)(this.xGradient[k] * this.yGradient[k]);
                            double[] dArray3 = hessian[1];
                            dArray3[1] = dArray3[1] + (double)(this.yGradient[k] * this.yGradient[k]);
                        }
                        ++u;
                        ++k;
                    }
                    continue;
                }
                k += this.outNx;
            }
        } else {
            for (v = 0; v < this.outNy; ++v) {
                dy += 1.0;
                this.y = this.y;
                int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
                if (0 <= yMsk && yMsk < this.inNy) {
                    yMsk *= this.inNx;
                    this.yIndexes();
                    dx = dx0;
                    u = 0;
                    while (u < this.outNx) {
                        dx += 1.0;
                        this.x = this.x;
                        int n3 = xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && this.outMsk[k] * this.inMsk[yMsk + xMsk] != 0.0f) {
                            ++area;
                            this.xIndexes();
                            difference = (double)this.outImg[k] - this.interpolate();
                            meanSquares += difference * difference;
                            gradient[0] = gradient[0] + difference * (double)this.xGradient[k];
                            gradient[1] = gradient[1] + difference * (double)this.yGradient[k];
                            double[] dArray = hessian[0];
                            dArray[0] = dArray[0] + (double)(this.xGradient[k] * this.xGradient[k]);
                            double[] dArray4 = hessian[0];
                            dArray4[1] = dArray4[1] + (double)(this.xGradient[k] * this.yGradient[k]);
                            double[] dArray5 = hessian[1];
                            dArray5[1] = dArray5[1] + (double)(this.yGradient[k] * this.yGradient[k]);
                        }
                        ++u;
                        ++k;
                    }
                    continue;
                }
                k += this.outNx;
            }
        }
        for (i2 = 1; i2 < this.transformation; ++i2) {
            for (j = 0; j < i2; ++j) {
                hessian[i2][j] = hessian[j][i2];
            }
        }
        return meanSquares / (double)area;
    }

    private double interpolate() {
        this.t = 0.0;
        for (int j = 0; j < 4; ++j) {
            this.s = 0.0;
            this.p = this.yIndex[j];
            for (int i2 = 0; i2 < 4; ++i2) {
                this.s += this.xWeight[i2] * (double)this.inImg[this.p + this.xIndex[i2]];
            }
            this.t += this.yWeight[j] * this.s;
        }
        return this.t;
    }

    private double interpolateDx() {
        this.t = 0.0;
        for (int j = 0; j < 4; ++j) {
            this.s = 0.0;
            this.p = this.yIndex[j];
            for (int i2 = 0; i2 < 4; ++i2) {
                this.s += this.dxWeight[i2] * (double)this.inImg[this.p + this.xIndex[i2]];
            }
            this.t += this.yWeight[j] * this.s;
        }
        return this.t;
    }

    private double interpolateDy() {
        this.t = 0.0;
        for (int j = 0; j < 4; ++j) {
            this.s = 0.0;
            this.p = this.yIndex[j];
            for (int i2 = 0; i2 < 4; ++i2) {
                this.s += this.xWeight[i2] * (double)this.inImg[this.p + this.xIndex[i2]];
            }
            this.t += this.dyWeight[j] * this.s;
        }
        return this.t;
    }

    private void inverseMarquardtLevenbergOptimization(int workload) {
        int k;
        double displacement;
        double[][] attempt = new double[this.transformation / 2][2];
        double[][] hessian = new double[this.transformation][this.transformation];
        double[][] pseudoHessian = new double[this.transformation][this.transformation];
        double[] gradient = new double[this.transformation];
        double[][] matrix = this.getTransformationMatrix(this.sourcePoint, this.targetPoint);
        double[] update = new double[this.transformation];
        double bestMeanSquares = 0.0;
        double meanSquares = 0.0;
        double lambda = 1.0;
        int iteration = 0;
        switch (this.transformation) {
            case 2: {
                bestMeanSquares = this.getTranslationMeanSquares(matrix, hessian, gradient);
                break;
            }
            case 4: {
                bestMeanSquares = this.getScaledRotationMeanSquares(this.sourcePoint, matrix, hessian, gradient);
                break;
            }
            case 6: {
                bestMeanSquares = this.getAffineMeanSquares(this.sourcePoint, matrix, hessian, gradient);
            }
        }
        ++iteration;
        do {
            for (k = 0; k < this.transformation; ++k) {
                pseudoHessian[k][k] = (1.0 + lambda) * hessian[k][k];
            }
            this.invertGauss(pseudoHessian);
            update = this.matrixMultiply(pseudoHessian, gradient);
            displacement = 0.0;
            for (k = 0; k < this.transformation / 2; ++k) {
                attempt[k][0] = this.sourcePoint[k][0] - update[2 * k];
                attempt[k][1] = this.sourcePoint[k][1] - update[2 * k + 1];
                displacement += Math.sqrt(update[2 * k] * update[2 * k] + update[2 * k + 1] * update[2 * k + 1]);
            }
            displacement /= 0.5 * (double)this.transformation;
            matrix = this.getTransformationMatrix(attempt, this.targetPoint);
            switch (this.transformation) {
                case 2: {
                    if (this.accelerated) {
                        meanSquares = this.getTranslationMeanSquares(matrix, gradient);
                        break;
                    }
                    meanSquares = this.getTranslationMeanSquares(matrix, hessian, gradient);
                    break;
                }
                case 4: {
                    if (this.accelerated) {
                        meanSquares = this.getScaledRotationMeanSquares(attempt, matrix, gradient);
                        break;
                    }
                    meanSquares = this.getScaledRotationMeanSquares(attempt, matrix, hessian, gradient);
                    break;
                }
                case 6: {
                    meanSquares = this.accelerated ? this.getAffineMeanSquares(attempt, matrix, gradient) : this.getAffineMeanSquares(attempt, matrix, hessian, gradient);
                }
            }
            ++iteration;
            if (meanSquares < bestMeanSquares) {
                bestMeanSquares = meanSquares;
                for (k = 0; k < this.transformation / 2; ++k) {
                    this.sourcePoint[k][0] = attempt[k][0];
                    this.sourcePoint[k][1] = attempt[k][1];
                }
                lambda /= 4.0;
            } else {
                lambda *= 4.0;
            }
            turboRegProgressBar.skipProgressBar(this.iterationCost);
            --workload;
        } while (iteration < this.maxIterations * this.iterationPower - 1 && this.pixelPrecision <= displacement);
        this.invertGauss(hessian);
        update = this.matrixMultiply(hessian, gradient);
        for (k = 0; k < this.transformation / 2; ++k) {
            attempt[k][0] = this.sourcePoint[k][0] - update[2 * k];
            attempt[k][1] = this.sourcePoint[k][1] - update[2 * k + 1];
        }
        matrix = this.getTransformationMatrix(attempt, this.targetPoint);
        switch (this.transformation) {
            case 2: {
                meanSquares = this.getTranslationMeanSquares(matrix);
                break;
            }
            case 4: {
                meanSquares = this.getScaledRotationMeanSquares(attempt, matrix);
                break;
            }
            case 6: {
                meanSquares = this.getAffineMeanSquares(attempt, matrix);
            }
        }
        ++iteration;
        if (meanSquares < bestMeanSquares) {
            for (k = 0; k < this.transformation / 2; ++k) {
                this.sourcePoint[k][0] = attempt[k][0];
                this.sourcePoint[k][1] = attempt[k][1];
            }
        }
        turboRegProgressBar.skipProgressBar(workload * this.iterationCost);
    }

    private void inverseMarquardtLevenbergRigidBodyOptimization(int workload) {
        int j;
        int i2;
        double s;
        double c;
        double angle;
        double displacement;
        int k;
        double[][] attempt = new double[2][3];
        double[][] hessian = new double[this.transformation][this.transformation];
        double[][] pseudoHessian = new double[this.transformation][this.transformation];
        double[] gradient = new double[this.transformation];
        double[][] matrix = this.getTransformationMatrix(this.targetPoint, this.sourcePoint);
        double[] update = new double[this.transformation];
        double bestMeanSquares = 0.0;
        double meanSquares = 0.0;
        double lambda = 1.0;
        int iteration = 0;
        for (k = 0; k < this.transformation; ++k) {
            this.sourcePoint[k][0] = matrix[0][0] + this.targetPoint[k][0] * matrix[0][1] + this.targetPoint[k][1] * matrix[0][2];
            this.sourcePoint[k][1] = matrix[1][0] + this.targetPoint[k][0] * matrix[1][1] + this.targetPoint[k][1] * matrix[1][2];
        }
        matrix = this.getTransformationMatrix(this.sourcePoint, this.targetPoint);
        bestMeanSquares = this.getRigidBodyMeanSquares(matrix, hessian, gradient);
        ++iteration;
        do {
            for (k = 0; k < this.transformation; ++k) {
                pseudoHessian[k][k] = (1.0 + lambda) * hessian[k][k];
            }
            this.invertGauss(pseudoHessian);
            update = this.matrixMultiply(pseudoHessian, gradient);
            angle = Math.atan2(matrix[0][2], matrix[0][1]) - update[0];
            attempt[0][1] = Math.cos(angle);
            attempt[0][2] = Math.sin(angle);
            attempt[1][1] = -attempt[0][2];
            attempt[1][2] = attempt[0][1];
            c = Math.cos(update[0]);
            s = Math.sin(update[0]);
            attempt[0][0] = (matrix[0][0] + update[1]) * c - (matrix[1][0] + update[2]) * s;
            attempt[1][0] = (matrix[0][0] + update[1]) * s + (matrix[1][0] + update[2]) * c;
            displacement = Math.sqrt(update[1] * update[1] + update[2] * update[2]) + 0.25 * Math.sqrt((double)(this.inNx * this.inNx) + (double)(this.inNy * this.inNy)) * Math.abs(update[0]);
            meanSquares = this.accelerated ? this.getRigidBodyMeanSquares(attempt, gradient) : this.getRigidBodyMeanSquares(attempt, hessian, gradient);
            ++iteration;
            if (meanSquares < bestMeanSquares) {
                bestMeanSquares = meanSquares;
                for (i2 = 0; i2 < 2; ++i2) {
                    for (j = 0; j < 3; ++j) {
                        matrix[i2][j] = attempt[i2][j];
                    }
                }
                lambda /= 4.0;
            } else {
                lambda *= 4.0;
            }
            turboRegProgressBar.skipProgressBar(this.iterationCost);
            --workload;
        } while (iteration < this.maxIterations * this.iterationPower - 1 && this.pixelPrecision <= displacement);
        this.invertGauss(hessian);
        update = this.matrixMultiply(hessian, gradient);
        angle = Math.atan2(matrix[0][2], matrix[0][1]) - update[0];
        attempt[0][1] = Math.cos(angle);
        attempt[0][2] = Math.sin(angle);
        attempt[1][1] = -attempt[0][2];
        attempt[1][2] = attempt[0][1];
        c = Math.cos(update[0]);
        s = Math.sin(update[0]);
        attempt[0][0] = (matrix[0][0] + update[1]) * c - (matrix[1][0] + update[2]) * s;
        attempt[1][0] = (matrix[0][0] + update[1]) * s + (matrix[1][0] + update[2]) * c;
        meanSquares = this.getRigidBodyMeanSquares(attempt);
        ++iteration;
        if (meanSquares < bestMeanSquares) {
            for (i2 = 0; i2 < 2; ++i2) {
                for (j = 0; j < 3; ++j) {
                    matrix[i2][j] = attempt[i2][j];
                }
            }
        }
        for (k = 0; k < this.transformation; ++k) {
            this.sourcePoint[k][0] = (this.targetPoint[k][0] - matrix[0][0]) * matrix[0][1] + (this.targetPoint[k][1] - matrix[1][0]) * matrix[1][1];
            this.sourcePoint[k][1] = (this.targetPoint[k][0] - matrix[0][0]) * matrix[0][2] + (this.targetPoint[k][1] - matrix[1][0]) * matrix[1][2];
        }
        turboRegProgressBar.skipProgressBar(workload * this.iterationCost);
    }

    private void invertGauss(double[][] matrix) {
        int j;
        double absMax;
        double max;
        int i2;
        int n = matrix.length;
        double[][] inverse = new double[n][n];
        for (i2 = 0; i2 < n; ++i2) {
            int j2;
            max = matrix[i2][0];
            absMax = Math.abs(max);
            for (j2 = 0; j2 < n; ++j2) {
                inverse[i2][j2] = 0.0;
                if (!(absMax < Math.abs(matrix[i2][j2]))) continue;
                max = matrix[i2][j2];
                absMax = Math.abs(max);
            }
            inverse[i2][i2] = 1.0 / max;
            j2 = 0;
            while (j2 < n) {
                double[] dArray = matrix[i2];
                int n2 = j2++;
                dArray[n2] = dArray[n2] / max;
            }
        }
        for (j = 0; j < n; ++j) {
            int i3;
            max = matrix[j][j];
            absMax = Math.abs(max);
            int k = j;
            for (i3 = j + 1; i3 < n; ++i3) {
                if (!(absMax < Math.abs(matrix[i3][j]))) continue;
                max = matrix[i3][j];
                absMax = Math.abs(max);
                k = i3;
            }
            if (k != j) {
                double[] partialLine = new double[n - j];
                double[] fullLine = new double[n];
                System.arraycopy(matrix[j], j, partialLine, 0, n - j);
                System.arraycopy(matrix[k], j, matrix[j], j, n - j);
                System.arraycopy(partialLine, 0, matrix[k], j, n - j);
                System.arraycopy(inverse[j], 0, fullLine, 0, n);
                System.arraycopy(inverse[k], 0, inverse[j], 0, n);
                System.arraycopy(fullLine, 0, inverse[k], 0, n);
            }
            k = 0;
            while (k <= j) {
                double[] dArray = inverse[j];
                int n3 = k++;
                dArray[n3] = dArray[n3] / max;
            }
            k = j + 1;
            while (k < n) {
                double[] dArray = matrix[j];
                int n4 = k;
                dArray[n4] = dArray[n4] / max;
                double[] dArray2 = inverse[j];
                int n5 = k++;
                dArray2[n5] = dArray2[n5] / max;
            }
            for (i3 = j + 1; i3 < n; ++i3) {
                for (k = 0; k <= j; ++k) {
                    double[] dArray = inverse[i3];
                    int n6 = k;
                    dArray[n6] = dArray[n6] - matrix[i3][j] * inverse[j][k];
                }
                for (k = j + 1; k < n; ++k) {
                    double[] dArray = matrix[i3];
                    int n7 = k;
                    dArray[n7] = dArray[n7] - matrix[i3][j] * matrix[j][k];
                    double[] dArray3 = inverse[i3];
                    int n8 = k;
                    dArray3[n8] = dArray3[n8] - matrix[i3][j] * inverse[j][k];
                }
            }
        }
        for (j = n - 1; 1 <= j; --j) {
            for (int i4 = j - 1; 0 <= i4; --i4) {
                int k;
                for (k = 0; k <= j; ++k) {
                    double[] dArray = inverse[i4];
                    int n9 = k;
                    dArray[n9] = dArray[n9] - matrix[i4][j] * inverse[j][k];
                }
                for (k = j + 1; k < n; ++k) {
                    double[] dArray = matrix[i4];
                    int n10 = k;
                    dArray[n10] = dArray[n10] - matrix[i4][j] * matrix[j][k];
                    double[] dArray4 = inverse[i4];
                    int n11 = k;
                    dArray4[n11] = dArray4[n11] - matrix[i4][j] * inverse[j][k];
                }
            }
        }
        for (i2 = 0; i2 < n; ++i2) {
            System.arraycopy(inverse[i2], 0, matrix[i2], 0, n);
        }
    }

    private void marquardtLevenbergOptimization(int workload) {
        int k;
        double displacement;
        double[][] attempt = new double[this.transformation / 2][2];
        double[][] hessian = new double[this.transformation][this.transformation];
        double[][] pseudoHessian = new double[this.transformation][this.transformation];
        double[] gradient = new double[this.transformation];
        double[][] matrix = this.getTransformationMatrix(this.targetPoint, this.sourcePoint);
        double[] update = new double[this.transformation];
        double bestMeanSquares = 0.0;
        double meanSquares = 0.0;
        double lambda = 1.0;
        int iteration = 0;
        bestMeanSquares = this.getBilinearMeanSquares(matrix, hessian, gradient);
        ++iteration;
        do {
            for (k = 0; k < this.transformation; ++k) {
                pseudoHessian[k][k] = (1.0 + lambda) * hessian[k][k];
            }
            this.invertGauss(pseudoHessian);
            update = this.matrixMultiply(pseudoHessian, gradient);
            displacement = 0.0;
            for (k = 0; k < this.transformation / 2; ++k) {
                attempt[k][0] = this.sourcePoint[k][0] - update[2 * k];
                attempt[k][1] = this.sourcePoint[k][1] - update[2 * k + 1];
                displacement += Math.sqrt(update[2 * k] * update[2 * k] + update[2 * k + 1] * update[2 * k + 1]);
            }
            displacement /= 0.5 * (double)this.transformation;
            matrix = this.getTransformationMatrix(this.targetPoint, attempt);
            meanSquares = this.getBilinearMeanSquares(matrix, hessian, gradient);
            ++iteration;
            if (meanSquares < bestMeanSquares) {
                bestMeanSquares = meanSquares;
                for (k = 0; k < this.transformation / 2; ++k) {
                    this.sourcePoint[k][0] = attempt[k][0];
                    this.sourcePoint[k][1] = attempt[k][1];
                }
                lambda /= 4.0;
            } else {
                lambda *= 4.0;
            }
            turboRegProgressBar.skipProgressBar(this.iterationCost);
            --workload;
        } while (iteration < this.maxIterations * this.iterationPower - 1 && this.pixelPrecision <= displacement);
        this.invertGauss(hessian);
        update = this.matrixMultiply(hessian, gradient);
        for (k = 0; k < this.transformation / 2; ++k) {
            attempt[k][0] = this.sourcePoint[k][0] - update[2 * k];
            attempt[k][1] = this.sourcePoint[k][1] - update[2 * k + 1];
        }
        matrix = this.getTransformationMatrix(this.targetPoint, attempt);
        meanSquares = this.getBilinearMeanSquares(matrix);
        ++iteration;
        if (meanSquares < bestMeanSquares) {
            for (k = 0; k < this.transformation / 2; ++k) {
                this.sourcePoint[k][0] = attempt[k][0];
                this.sourcePoint[k][1] = attempt[k][1];
            }
        }
        turboRegProgressBar.skipProgressBar(workload * this.iterationCost);
    }

    private double[] matrixMultiply(double[][] matrix, double[] vector) {
        double[] result = new double[matrix.length];
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            result[i2] = 0.0;
            for (int j = 0; j < vector.length; ++j) {
                int n = i2;
                result[n] = result[n] + matrix[i2][j] * vector[j];
            }
        }
        return result;
    }

    private void scaleBottomDownLandmarks() {
        for (int depth = 1; depth < this.pyramidDepth; ++depth) {
            int n;
            if (this.transformation == 3) {
                for (n = 0; n < this.transformation; ++n) {
                    double[] dArray = this.sourcePoint[n];
                    dArray[0] = dArray[0] * 0.5;
                    double[] dArray2 = this.sourcePoint[n];
                    dArray2[1] = dArray2[1] * 0.5;
                    double[] dArray3 = this.targetPoint[n];
                    dArray3[0] = dArray3[0] * 0.5;
                    double[] dArray4 = this.targetPoint[n];
                    dArray4[1] = dArray4[1] * 0.5;
                }
                continue;
            }
            for (n = 0; n < this.transformation / 2; ++n) {
                double[] dArray = this.sourcePoint[n];
                dArray[0] = dArray[0] * 0.5;
                double[] dArray5 = this.sourcePoint[n];
                dArray5[1] = dArray5[1] * 0.5;
                double[] dArray6 = this.targetPoint[n];
                dArray6[0] = dArray6[0] * 0.5;
                double[] dArray7 = this.targetPoint[n];
                dArray7[1] = dArray7[1] * 0.5;
            }
        }
    }

    private void scaleUpLandmarks() {
        if (this.transformation == 3) {
            for (int n = 0; n < this.transformation; ++n) {
                double[] dArray = this.sourcePoint[n];
                dArray[0] = dArray[0] * 2.0;
                double[] dArray2 = this.sourcePoint[n];
                dArray2[1] = dArray2[1] * 2.0;
                double[] dArray3 = this.targetPoint[n];
                dArray3[0] = dArray3[0] * 2.0;
                double[] dArray4 = this.targetPoint[n];
                dArray4[1] = dArray4[1] * 2.0;
            }
        } else {
            for (int n = 0; n < this.transformation / 2; ++n) {
                double[] dArray = this.sourcePoint[n];
                dArray[0] = dArray[0] * 2.0;
                double[] dArray5 = this.sourcePoint[n];
                dArray5[1] = dArray5[1] * 2.0;
                double[] dArray6 = this.targetPoint[n];
                dArray6[0] = dArray6[0] * 2.0;
                double[] dArray7 = this.targetPoint[n];
                dArray7[1] = dArray7[1] * 2.0;
            }
        }
    }

    private void translationTransform(double[][] matrix) {
        double dx = matrix[0][0];
        double dy = matrix[1][0];
        double dx0 = dx;
        this.x = dx - Math.floor(dx);
        this.y = dy - Math.floor(dy);
        if (!this.accelerated) {
            this.xWeights();
            this.yWeights();
        }
        int k = 0;
        turboRegProgressBar.addWorkload(this.outNy);
        for (int v = 0; v < this.outNy; ++v) {
            int u;
            int yMsk;
            dy += 1.0;
            this.y = this.y;
            int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
            if (0 <= yMsk && yMsk < this.inNy) {
                yMsk *= this.inNx;
                if (!this.accelerated) {
                    this.yIndexes();
                }
                dx = dx0;
                for (u = 0; u < this.outNx; ++u) {
                    int xMsk;
                    dx += 1.0;
                    this.x = this.x;
                    int n2 = xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx) {
                        xMsk += yMsk;
                        if (this.accelerated) {
                            this.outImg[k++] = this.inImg[xMsk];
                            continue;
                        }
                        this.xIndexes();
                        this.outImg[k++] = (float)this.interpolate();
                        continue;
                    }
                    this.outImg[k++] = 0.0f;
                }
            } else {
                for (u = 0; u < this.outNx; ++u) {
                    this.outImg[k++] = 0.0f;
                }
            }
            turboRegProgressBar.stepProgressBar();
        }
        turboRegProgressBar.workloadDone(this.outNy);
    }

    private void translationTransform(double[][] matrix, float[] outMsk) {
        double dx = matrix[0][0];
        double dy = matrix[1][0];
        double dx0 = dx;
        this.x = dx - Math.floor(dx);
        this.y = dy - Math.floor(dy);
        if (!this.accelerated) {
            this.xWeights();
            this.yWeights();
        }
        int k = 0;
        turboRegProgressBar.addWorkload(this.outNy);
        for (int v = 0; v < this.outNy; ++v) {
            int u;
            int yMsk;
            dy += 1.0;
            this.y = this.y;
            int n = yMsk = 0.0 <= this.y ? (int)(this.y + 0.5) : (int)(this.y - 0.5);
            if (0 <= yMsk && yMsk < this.inNy) {
                yMsk *= this.inNx;
                if (!this.accelerated) {
                    this.yIndexes();
                }
                dx = dx0;
                u = 0;
                while (u < this.outNx) {
                    int xMsk;
                    dx += 1.0;
                    this.x = this.x;
                    int n2 = xMsk = 0.0 <= this.x ? (int)(this.x + 0.5) : (int)(this.x - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx) {
                        xMsk += yMsk;
                        if (this.accelerated) {
                            this.outImg[k] = this.inImg[xMsk];
                        } else {
                            this.xIndexes();
                            this.outImg[k] = (float)this.interpolate();
                        }
                        outMsk[k] = this.inMsk[xMsk];
                    } else {
                        this.outImg[k] = 0.0f;
                        outMsk[k] = 0.0f;
                    }
                    ++u;
                    ++k;
                }
            } else {
                u = 0;
                while (u < this.outNx) {
                    this.outImg[k] = 0.0f;
                    outMsk[k] = 0.0f;
                    ++u;
                    ++k;
                }
            }
            turboRegProgressBar.stepProgressBar();
        }
        turboRegProgressBar.workloadDone(this.outNy);
    }

    private void xDxWeights() {
        this.s = 1.0 - this.x;
        this.dxWeight[0] = 0.5 * this.x * this.x;
        this.xWeight[0] = this.x * this.dxWeight[0] / 3.0;
        this.dxWeight[3] = -0.5 * this.s * this.s;
        this.xWeight[3] = this.s * this.dxWeight[3] / -3.0;
        this.dxWeight[1] = 1.0 - 2.0 * this.dxWeight[0] + this.dxWeight[3];
        this.xWeight[1] = 0.6666666666666666 + (1.0 + this.x) * this.dxWeight[3];
        this.dxWeight[2] = 1.5 * this.x * (this.x - 1.3333333333333333);
        this.xWeight[2] = 0.6666666666666666 - (2.0 - this.x) * this.dxWeight[0];
    }

    private void xIndexes() {
        this.p = 0.0 <= this.x ? (int)this.x + 2 : (int)this.x + 1;
        for (int k = 0; k < 4; ++k) {
            int n = this.q = this.p < 0 ? -1 - this.p : this.p;
            if (this.twiceInNx <= this.q) {
                this.q -= this.twiceInNx * (this.q / this.twiceInNx);
            }
            this.xIndex[k] = this.inNx <= this.q ? this.twiceInNx - 1 - this.q : this.q;
            --this.p;
        }
    }

    private void xWeights() {
        this.s = 1.0 - this.x;
        this.xWeight[3] = this.s * this.s * this.s / 6.0;
        this.s = this.x * this.x;
        this.xWeight[2] = 0.6666666666666666 - 0.5 * this.s * (2.0 - this.x);
        this.xWeight[0] = this.s * this.x / 6.0;
        this.xWeight[1] = 1.0 - this.xWeight[0] - this.xWeight[2] - this.xWeight[3];
    }

    private void yDyWeights() {
        this.t = 1.0 - this.y;
        this.dyWeight[0] = 0.5 * this.y * this.y;
        this.yWeight[0] = this.y * this.dyWeight[0] / 3.0;
        this.dyWeight[3] = -0.5 * this.t * this.t;
        this.yWeight[3] = this.t * this.dyWeight[3] / -3.0;
        this.dyWeight[1] = 1.0 - 2.0 * this.dyWeight[0] + this.dyWeight[3];
        this.yWeight[1] = 0.6666666666666666 + (1.0 + this.y) * this.dyWeight[3];
        this.dyWeight[2] = 1.5 * this.y * (this.y - 1.3333333333333333);
        this.yWeight[2] = 0.6666666666666666 - (2.0 - this.y) * this.dyWeight[0];
    }

    private void yIndexes() {
        this.p = 0.0 <= this.y ? (int)this.y + 2 : (int)this.y + 1;
        for (int k = 0; k < 4; ++k) {
            int n = this.q = this.p < 0 ? -1 - this.p : this.p;
            if (this.twiceInNy <= this.q) {
                this.q -= this.twiceInNy * (this.q / this.twiceInNy);
            }
            this.yIndex[k] = this.inNy <= this.q ? (this.twiceInNy - 1 - this.q) * this.inNx : this.q * this.inNx;
            --this.p;
        }
    }

    private void yWeights() {
        this.t = 1.0 - this.y;
        this.yWeight[3] = this.t * this.t * this.t / 6.0;
        this.t = this.y * this.y;
        this.yWeight[2] = 0.6666666666666666 - 0.5 * this.t * (2.0 - this.y);
        this.yWeight[0] = this.t * this.y / 6.0;
        this.yWeight[1] = 1.0 - this.yWeight[0] - this.yWeight[2] - this.yWeight[3];
    }
}

