/*
 * Decompiled with CFR 0.152.
 */
package registration.turboregold;

import ij.IJ;
import ij.gui.Toolbar;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class turboRegPointToolbar
extends Canvas
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private static final int NUM_TOOLS = 19;
    private static final int OFFSET = 3;
    private static final int SIZE = 22;
    private final Color gray = Color.lightGray;
    private final Color brighter = this.gray.brighter();
    private final Color darker = this.gray.darker();
    private final Color evenDarker = this.darker.darker();
    private final boolean[] down = new boolean[19];
    private turboRegPointToolbar instance;
    private Toolbar previousInstance;
    private Graphics g;
    private int currentTool = 1;
    private int x;
    private int y;
    private int xOffset;
    private int yOffset;

    @Override
    public void paint(Graphics g) {
        this.drawButtons(g);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int newTool = 0;
        for (int i2 = 0; i2 < 19; ++i2) {
            if (i2 * 22 >= x || x >= i2 * 22 + 22) continue;
            newTool = i2;
        }
        this.setTool(newTool);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public turboRegPointToolbar(Toolbar previousToolbar) {
        this.previousInstance = previousToolbar;
        this.instance = this;
        Container container = previousToolbar.getParent();
        Component[] component = container.getComponents();
        for (int i2 = 0; i2 < component.length; ++i2) {
            if (component[i2] != previousToolbar) continue;
            container.remove((Component)previousToolbar);
            container.add((Component)this, i2);
            break;
        }
        this.resetButtons();
        this.down[this.currentTool] = true;
        this.setTool(this.currentTool);
        this.setForeground(Color.black);
        this.setBackground(this.gray);
        this.addMouseListener(this);
        container.validate();
    }

    public int getCurrentTool() {
        return this.currentTool;
    }

    public void restorePreviousToolbar() {
        Container container = this.instance.getParent();
        Component[] component = container.getComponents();
        for (int i2 = 0; i2 < component.length; ++i2) {
            if (component[i2] != this.instance) continue;
            container.remove(this.instance);
            container.add((Component)this.previousInstance, i2);
            container.validate();
            break;
        }
    }

    public void setTool(int tool) {
        if (tool == this.currentTool) {
            return;
        }
        this.down[tool] = true;
        this.down[this.currentTool] = false;
        Graphics g = this.getGraphics();
        this.drawButton(g, this.currentTool);
        this.drawButton(g, tool);
        g.dispose();
        this.showMessage(tool);
        this.currentTool = tool;
    }

    private void d(int x, int y) {
        this.g.drawLine(this.x, this.y, x += this.xOffset, y += this.yOffset);
        this.x = x;
        this.y = y;
    }

    private void drawButton(Graphics g, int tool) {
        this.fill3DRect(g, tool * 22 + 1, 1, 22, 21, !this.down[tool]);
        g.setColor(Color.black);
        int x = tool * 22 + 3;
        int y = 3;
        if (this.down[tool]) {
            ++x;
            ++y;
        }
        this.g = g;
        switch (tool) {
            case 1: {
                this.xOffset = x;
                this.yOffset = y;
                this.m(1, 1);
                this.d(1, 10);
                this.m(2, 2);
                this.d(2, 9);
                this.m(3, 3);
                this.d(3, 8);
                this.m(4, 4);
                this.d(4, 7);
                this.m(5, 5);
                this.d(5, 7);
                this.m(6, 6);
                this.d(6, 7);
                this.m(7, 7);
                this.d(7, 7);
                this.m(11, 5);
                this.d(11, 6);
                this.m(10, 7);
                this.d(10, 8);
                this.m(12, 7);
                this.d(12, 8);
                this.m(9, 9);
                this.d(9, 11);
                this.m(13, 9);
                this.d(13, 11);
                this.m(10, 12);
                this.d(10, 15);
                this.m(12, 12);
                this.d(12, 15);
                this.m(11, 9);
                this.d(11, 10);
                this.m(11, 13);
                this.d(11, 15);
                this.m(9, 13);
                this.d(13, 13);
                break;
            }
            case 11: {
                this.xOffset = x + 2;
                this.yOffset = y + 2;
                this.m(3, 0);
                this.d(3, 0);
                this.d(5, 0);
                this.d(8, 3);
                this.d(8, 5);
                this.d(7, 6);
                this.d(7, 7);
                this.d(6, 7);
                this.d(5, 8);
                this.d(3, 8);
                this.d(0, 5);
                this.d(0, 3);
                this.d(3, 0);
                this.m(8, 8);
                this.d(9, 8);
                this.d(13, 12);
                this.d(13, 13);
                this.d(12, 13);
                this.d(8, 9);
                this.d(8, 8);
            }
        }
    }

    private void drawButtons(Graphics g) {
        for (int i2 = 0; i2 < 19; ++i2) {
            this.drawButton(g, i2);
        }
    }

    private void fill3DRect(Graphics g, int x, int y, int width, int height, boolean raised) {
        if (raised) {
            g.setColor(this.gray);
        } else {
            g.setColor(this.darker);
        }
        g.fillRect(x + 1, y + 1, width - 2, height - 2);
        g.setColor(raised ? this.brighter : this.evenDarker);
        g.drawLine(x, y, x, y + height - 1);
        g.drawLine(x + 1, y, x + width - 2, y);
        g.setColor(raised ? this.evenDarker : this.brighter);
        g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 2);
    }

    private void m(int x, int y) {
        this.x = this.xOffset + x;
        this.y = this.yOffset + y;
    }

    private void resetButtons() {
        for (int i2 = 0; i2 < 19; ++i2) {
            this.down[i2] = false;
        }
    }

    private void showMessage(int tool) {
        switch (tool) {
            case 1: {
                IJ.showStatus((String)"Move crosses");
                break;
            }
            case 11: {
                IJ.showStatus((String)"Magnifying glass");
                break;
            }
            default: {
                IJ.showStatus((String)"Undefined operation");
            }
        }
    }
}

