/*
 * Decompiled with CFR 0.152.
 */
package registration.turboregold;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

class turboRegPointHandler
extends PolygonRoi {
    public static final int MAGNIFIER = 11;
    public static final int MOVE_CROSS = 1;
    public static final int NUM_POINTS = 4;
    private static final long serialVersionUID = 1L;
    private static final int CROSS_HALFSIZE = 5;
    private static final double GOLDEN_RATIO = 0.5 * (Math.sqrt(5.0) - 1.0);
    private boolean interactive = true;
    private boolean started = false;
    private double[][] precisionPoint = new double[4][2];
    private final Point[] point = new Point[4];
    private final Color[] spectrum = new Color[4];
    private int transformation;
    private int currentPoint = 0;

    public void draw(Graphics g) {
        if (this.started) {
            double mag = this.ic.getMagnification();
            int dx = (int)(mag / 2.0);
            int dy = (int)(mag / 2.0);
            if (this.transformation == 3) {
                if (this.currentPoint == 0) {
                    Point p;
                    for (int k = 1; k < this.transformation; ++k) {
                        p = this.point[k];
                        g.setColor(this.spectrum[k]);
                        g.fillRect(this.ic.screenX(p.x) - 2 + dx, this.ic.screenY(p.y) - 2 + dy, 5, 5);
                    }
                    this.drawHorizon(g);
                    p = this.point[0];
                    g.setColor(this.spectrum[0]);
                    if (WindowManager.getCurrentImage() == this.imp) {
                        g.drawLine(this.ic.screenX(p.x - 5 - 1) + dx, this.ic.screenY(p.y - 1) + dy, this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y - 1) + dy);
                        g.drawLine(this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y - 1) + dy, this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y - 5 - 1) + dy);
                        g.drawLine(this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y - 5 - 1) + dy, this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y - 5 - 1) + dy);
                        g.drawLine(this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y - 5 - 1) + dy, this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y - 1) + dy);
                        g.drawLine(this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y - 1) + dy, this.ic.screenX(p.x + 5 + 1) + dx, this.ic.screenY(p.y - 1) + dy);
                        g.drawLine(this.ic.screenX(p.x + 5 + 1) + dx, this.ic.screenY(p.y - 1) + dy, this.ic.screenX(p.x + 5 + 1) + dx, this.ic.screenY(p.y + 1) + dy);
                        g.drawLine(this.ic.screenX(p.x + 5 + 1) + dx, this.ic.screenY(p.y + 1) + dy, this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y + 1) + dy);
                        g.drawLine(this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y + 1) + dy, this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y + 5 + 1) + dy);
                        g.drawLine(this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y + 5 + 1) + dy, this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y + 5 + 1) + dy);
                        g.drawLine(this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y + 5 + 1) + dy, this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y + 1) + dy);
                        g.drawLine(this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y + 1) + dy, this.ic.screenX(p.x - 5 - 1) + dx, this.ic.screenY(p.y + 1) + dy);
                        g.drawLine(this.ic.screenX(p.x - 5 - 1) + dx, this.ic.screenY(p.y + 1) + dy, this.ic.screenX(p.x - 5 - 1) + dx, this.ic.screenY(p.y - 1) + dy);
                        if (1.0 < this.ic.getMagnification()) {
                            g.drawLine(this.ic.screenX(p.x - 5) + dx, this.ic.screenY(p.y) + dy, this.ic.screenX(p.x + 5) + dx, this.ic.screenY(p.y) + dy);
                            g.drawLine(this.ic.screenX(p.x) + dx, this.ic.screenY(p.y - 5) + dy, this.ic.screenX(p.x) + dx, this.ic.screenY(p.y + 5) + dy);
                        }
                    } else {
                        g.drawLine(this.ic.screenX(p.x - 5 + 1) + dx, this.ic.screenY(p.y - 5 + 1) + dy, this.ic.screenX(p.x + 5 - 1) + dx, this.ic.screenY(p.y + 5 - 1) + dy);
                        g.drawLine(this.ic.screenX(p.x - 5 + 1) + dx, this.ic.screenY(p.y + 5 - 1) + dy, this.ic.screenX(p.x + 5 - 1) + dx, this.ic.screenY(p.y - 5 + 1) + dy);
                    }
                } else {
                    Point p = this.point[0];
                    g.setColor(this.spectrum[0]);
                    g.drawLine(this.ic.screenX(p.x - 5) + dx, this.ic.screenY(p.y) + dy, this.ic.screenX(p.x + 5) + dx, this.ic.screenY(p.y) + dy);
                    g.drawLine(this.ic.screenX(p.x) + dx, this.ic.screenY(p.y - 5) + dy, this.ic.screenX(p.x) + dx, this.ic.screenY(p.y + 5) + dy);
                    this.drawHorizon(g);
                    if (WindowManager.getCurrentImage() == this.imp) {
                        this.drawArcs(g);
                        for (int k = 1; k < this.transformation; ++k) {
                            p = this.point[k];
                            g.setColor(this.spectrum[k]);
                            if (k == this.currentPoint) {
                                g.drawRect(this.ic.screenX(p.x) - 3 + dx, this.ic.screenY(p.y) - 3 + dy, 6, 6);
                                continue;
                            }
                            g.fillRect(this.ic.screenX(p.x) - 2 + dx, this.ic.screenY(p.y) - 2 + dy, 5, 5);
                        }
                    } else {
                        for (int k = 1; k < this.transformation; ++k) {
                            p = this.point[k];
                            g.setColor(this.spectrum[k]);
                            if (k == this.currentPoint) {
                                g.drawRect(this.ic.screenX(p.x) - 2 + dx, this.ic.screenY(p.y) - 2 + dy, 5, 5);
                                continue;
                            }
                            g.fillRect(this.ic.screenX(p.x) - 2 + dx, this.ic.screenY(p.y) - 2 + dy, 5, 5);
                        }
                    }
                }
            } else {
                for (int k = 0; k < this.transformation / 2; ++k) {
                    Point p = this.point[k];
                    g.setColor(this.spectrum[k]);
                    if (k == this.currentPoint) {
                        if (WindowManager.getCurrentImage() == this.imp) {
                            g.drawLine(this.ic.screenX(p.x - 5 - 1) + dx, this.ic.screenY(p.y - 1) + dy, this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y - 1) + dy);
                            g.drawLine(this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y - 1) + dy, this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y - 5 - 1) + dy);
                            g.drawLine(this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y - 5 - 1) + dy, this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y - 5 - 1) + dy);
                            g.drawLine(this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y - 5 - 1) + dy, this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y - 1) + dy);
                            g.drawLine(this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y - 1) + dy, this.ic.screenX(p.x + 5 + 1) + dx, this.ic.screenY(p.y - 1) + dy);
                            g.drawLine(this.ic.screenX(p.x + 5 + 1) + dx, this.ic.screenY(p.y - 1) + dy, this.ic.screenX(p.x + 5 + 1) + dx, this.ic.screenY(p.y + 1) + dy);
                            g.drawLine(this.ic.screenX(p.x + 5 + 1) + dx, this.ic.screenY(p.y + 1) + dy, this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y + 1) + dy);
                            g.drawLine(this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y + 1) + dy, this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y + 5 + 1) + dy);
                            g.drawLine(this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y + 5 + 1) + dy, this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y + 5 + 1) + dy);
                            g.drawLine(this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y + 5 + 1) + dy, this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y + 1) + dy);
                            g.drawLine(this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y + 1) + dy, this.ic.screenX(p.x - 5 - 1) + dx, this.ic.screenY(p.y + 1) + dy);
                            g.drawLine(this.ic.screenX(p.x - 5 - 1) + dx, this.ic.screenY(p.y + 1) + dy, this.ic.screenX(p.x - 5 - 1) + dx, this.ic.screenY(p.y - 1) + dy);
                            if (!(1.0 < this.ic.getMagnification())) continue;
                            g.drawLine(this.ic.screenX(p.x - 5) + dx, this.ic.screenY(p.y) + dy, this.ic.screenX(p.x + 5) + dx, this.ic.screenY(p.y) + dy);
                            g.drawLine(this.ic.screenX(p.x) + dx, this.ic.screenY(p.y - 5) + dy, this.ic.screenX(p.x) + dx, this.ic.screenY(p.y + 5) + dy);
                            continue;
                        }
                        g.drawLine(this.ic.screenX(p.x - 5 + 1) + dx, this.ic.screenY(p.y - 5 + 1) + dy, this.ic.screenX(p.x + 5 - 1) + dx, this.ic.screenY(p.y + 5 - 1) + dy);
                        g.drawLine(this.ic.screenX(p.x - 5 + 1) + dx, this.ic.screenY(p.y + 5 - 1) + dy, this.ic.screenX(p.x + 5 - 1) + dx, this.ic.screenY(p.y - 5 + 1) + dy);
                        continue;
                    }
                    g.drawLine(this.ic.screenX(p.x - 5) + dx, this.ic.screenY(p.y) + dy, this.ic.screenX(p.x + 5) + dx, this.ic.screenY(p.y) + dy);
                    g.drawLine(this.ic.screenX(p.x) + dx, this.ic.screenY(p.y - 5) + dy, this.ic.screenX(p.x) + dx, this.ic.screenY(p.y + 5) + dy);
                }
            }
            if (this.updateFullWindow) {
                this.updateFullWindow = false;
                this.imp.draw();
            }
        }
    }

    public turboRegPointHandler(double[][] precisionPoint, int transformation) {
        super(new Polygon(), 2);
        this.transformation = transformation;
        this.precisionPoint = precisionPoint;
        this.interactive = false;
    }

    public turboRegPointHandler(ImagePlus imp, int transformation) {
        super(0, 0, imp);
        this.imp = imp;
        this.transformation = transformation;
        this.setTransformation(transformation);
        imp.setRoi((Roi)this);
        this.started = true;
    }

    public turboRegPointHandler(int transformation, ImagePlus imp) {
        super(new Polygon(), 2);
        this.imp = imp;
        this.transformation = transformation;
        this.setTransformation(transformation);
        imp.setRoi((Roi)this);
        this.started = true;
    }

    public int findClosest(int x, int y) {
        x = this.ic.offScreenX(x);
        y = this.ic.offScreenY(y);
        int closest = 0;
        Point p = this.point[closest];
        double distance = (double)(x - p.x) * (double)(x - p.x) + (double)(y - p.y) * (double)(y - p.y);
        if (this.transformation == 3) {
            for (int k = 1; k < this.transformation; ++k) {
                p = this.point[k];
                double candidate = (double)(x - p.x) * (double)(x - p.x) + (double)(y - p.y) * (double)(y - p.y);
                if (!(candidate < distance)) continue;
                distance = candidate;
                closest = k;
            }
        } else {
            for (int k = 1; k < this.transformation / 2; ++k) {
                p = this.point[k];
                double candidate = (double)(x - p.x) * (double)(x - p.x) + (double)(y - p.y) * (double)(y - p.y);
                if (!(candidate < distance)) continue;
                distance = candidate;
                closest = k;
            }
        }
        this.currentPoint = closest;
        return this.currentPoint;
    }

    public Point getPoint() {
        return this.point[this.currentPoint];
    }

    public double[][] getPoints() {
        if (this.interactive) {
            if (this.transformation == 3) {
                double[][] points = new double[this.transformation][2];
                for (int k = 0; k < this.transformation; ++k) {
                    points[k][0] = this.point[k].x;
                    points[k][1] = this.point[k].y;
                }
                return points;
            }
            double[][] points = new double[this.transformation / 2][2];
            for (int k = 0; k < this.transformation / 2; ++k) {
                points[k][0] = this.point[k].x;
                points[k][1] = this.point[k].y;
            }
            return points;
        }
        return this.precisionPoint;
    }

    public void movePoint(int x, int y) {
        this.interactive = true;
        x = this.ic.offScreenX(x);
        y = this.ic.offScreenY(y);
        x = x < 0 ? 0 : x;
        x = this.imp.getWidth() <= x ? this.imp.getWidth() - 1 : x;
        y = y < 0 ? 0 : y;
        int n = y = this.imp.getHeight() <= y ? this.imp.getHeight() - 1 : y;
        if (this.transformation == 3 && this.currentPoint != 0) {
            Point p = new Point(x, y);
            Point q = this.point[3 - this.currentPoint];
            double radius = 0.5 * Math.sqrt((this.ic.screenX(p.x) - this.ic.screenX(q.x)) * (this.ic.screenX(p.x) - this.ic.screenX(q.x)) + (this.ic.screenY(p.y) - this.ic.screenY(q.y)) * (this.ic.screenY(p.y) - this.ic.screenY(q.y)));
            if (5.0 < radius) {
                this.point[this.currentPoint].x = x;
                this.point[this.currentPoint].y = y;
            }
        } else {
            this.point[this.currentPoint].x = x;
            this.point[this.currentPoint].y = y;
        }
    }

    public void setCurrentPoint(int currentPoint) {
        this.currentPoint = currentPoint;
    }

    public void setPoints(double[][] precisionPoint) {
        this.interactive = false;
        if (this.transformation == 3) {
            for (int k = 0; k < this.transformation; ++k) {
                this.point[k].x = (int)Math.round(precisionPoint[k][0]);
                this.point[k].y = (int)Math.round(precisionPoint[k][1]);
                this.precisionPoint[k][0] = precisionPoint[k][0];
                this.precisionPoint[k][1] = precisionPoint[k][1];
            }
        } else {
            for (int k = 0; k < this.transformation / 2; ++k) {
                this.point[k].x = (int)Math.round(precisionPoint[k][0]);
                this.point[k].y = (int)Math.round(precisionPoint[k][1]);
                this.precisionPoint[k][0] = precisionPoint[k][0];
                this.precisionPoint[k][1] = precisionPoint[k][1];
            }
        }
    }

    public void setTransformation(int transformation) {
        this.interactive = true;
        this.transformation = transformation;
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        this.currentPoint = 0;
        switch (transformation) {
            case 2: {
                this.point[0] = new Point(Math.round((float)Math.floor(0.5 * (double)width)), Math.round((float)Math.floor(0.5 * (double)height)));
                break;
            }
            case 3: {
                this.point[0] = new Point(Math.round((float)Math.floor(0.5 * (double)width)), Math.round((float)Math.floor(0.5 * (double)height)));
                this.point[1] = new Point(Math.round((float)Math.floor(0.5 * (double)width)), Math.round((float)Math.ceil(0.25 * GOLDEN_RATIO * (double)height)));
                this.point[2] = new Point(Math.round((float)Math.floor(0.5 * (double)width)), height - Math.round((float)Math.ceil(0.25 * GOLDEN_RATIO * (double)height)));
                break;
            }
            case 4: {
                this.point[0] = new Point(Math.round((float)Math.floor(0.25 * GOLDEN_RATIO * (double)width)), Math.round((float)Math.floor(0.5 * (double)height)));
                this.point[1] = new Point(width - Math.round((float)Math.ceil(0.25 * GOLDEN_RATIO * (double)width)), Math.round((float)Math.floor(0.5 * (double)height)));
                break;
            }
            case 6: {
                this.point[0] = new Point(Math.round((float)Math.floor(0.5 * (double)width)), Math.round((float)Math.floor(0.25 * GOLDEN_RATIO * (double)height)));
                this.point[1] = new Point(Math.round((float)Math.floor(0.25 * GOLDEN_RATIO * (double)width)), height - Math.round((float)Math.ceil(0.25 * GOLDEN_RATIO * (double)height)));
                this.point[2] = new Point(width - Math.round((float)Math.ceil(0.25 * GOLDEN_RATIO * (double)width)), height - Math.round((float)Math.ceil(0.25 * GOLDEN_RATIO * (double)height)));
                break;
            }
            case 8: {
                this.point[0] = new Point(Math.round((float)Math.floor(0.25 * GOLDEN_RATIO * (double)width)), Math.round((float)Math.floor(0.25 * GOLDEN_RATIO * (double)height)));
                this.point[1] = new Point(Math.round((float)Math.floor(0.25 * GOLDEN_RATIO * (double)width)), height - Math.round((float)Math.ceil(0.25 * GOLDEN_RATIO * (double)height)));
                this.point[2] = new Point(width - Math.round((float)Math.ceil(0.25 * GOLDEN_RATIO * (double)width)), Math.round((float)Math.floor(0.25 * GOLDEN_RATIO * (double)height)));
                this.point[3] = new Point(width - Math.round((float)Math.ceil(0.25 * GOLDEN_RATIO * (double)width)), height - Math.round((float)Math.ceil(0.25 * GOLDEN_RATIO * (double)height)));
            }
        }
        this.setSpectrum();
        this.imp.updateAndDraw();
    }

    private void drawArcs(Graphics g) {
        double mag = this.ic.getMagnification();
        int dx = (int)(mag / 2.0);
        int dy = (int)(mag / 2.0);
        Point p = this.point[1];
        Point q = this.point[2];
        double x0 = this.ic.screenX(p.x) + this.ic.screenX(q.x);
        double y0 = this.ic.screenY(p.y) + this.ic.screenY(q.y);
        double dx0 = this.ic.screenX(p.x) - this.ic.screenX(q.x);
        double dy0 = this.ic.screenY(p.y) - this.ic.screenY(q.y);
        double radius = 0.5 * Math.sqrt(dx0 * dx0 + dy0 * dy0);
        double orientation = Math.atan2(dx0, dy0);
        double spacerAngle = Math.asin(5.0 / radius);
        g.setColor(this.spectrum[1]);
        g.drawArc((int)Math.round(0.5 * x0 - radius) + dx, (int)Math.round(0.5 * y0 - radius) + dy, (int)Math.round(2.0 * radius), (int)Math.round(2.0 * radius), (int)Math.round((orientation + spacerAngle + Math.PI) * 180.0 / Math.PI), (int)Math.round((Math.PI - 2.0 * spacerAngle) * 180.0 / Math.PI));
        g.setColor(this.spectrum[2]);
        g.drawArc((int)Math.round(0.5 * x0 - radius) + dx, (int)Math.round(0.5 * y0 - radius) + dy, (int)Math.round(2.0 * radius), (int)Math.round(2.0 * radius), (int)Math.round((orientation + spacerAngle) * 180.0 / Math.PI), (int)Math.round((Math.PI - 2.0 * spacerAngle) * 180.0 / Math.PI));
    }

    private void drawHorizon(Graphics g) {
        double mag = this.ic.getMagnification();
        int dx = (int)(mag / 2.0);
        int dy = (int)(mag / 2.0);
        Point p = this.point[1];
        Point q = this.point[2];
        double x0 = this.ic.screenX(p.x) + this.ic.screenX(q.x);
        double y0 = this.ic.screenY(p.y) + this.ic.screenY(q.y);
        double dx0 = this.ic.screenX(p.x) - this.ic.screenX(q.x);
        double dy0 = this.ic.screenY(p.y) - this.ic.screenY(q.y);
        double radius = 0.5 * Math.sqrt(dx0 * dx0 + dy0 * dy0);
        double spacerAngle = Math.asin(5.0 / radius);
        double s0 = Math.sin(spacerAngle);
        double s = 0.5 * dx0 / radius;
        double c = 0.5 * dy0 / radius;
        g.setColor(this.spectrum[1]);
        double u = 0.5 * (x0 + s0 * dx0);
        double v = 0.5 * (y0 + s0 * dy0);
        if (Math.abs(s) < Math.abs(c)) {
            g.drawLine(-dx, (int)Math.round(v + (u + 2.0 * (double)dx) * s / c) + dy, (int)Math.round(mag * (double)this.ic.getSrcRect().width - 1.0) + dx, (int)Math.round(v - (mag * (double)this.ic.getSrcRect().width - 1.0 - u) * s / c) + dy);
        } else {
            g.drawLine((int)Math.round(u + (v + 2.0 * (double)dy) * c / s) + dx, -dy, (int)Math.round(u - (mag * (double)this.ic.getSrcRect().height - 1.0 - v) * c / s) + dx, (int)Math.round(mag * (double)this.ic.getSrcRect().height - 1.0) + dy);
        }
        g.setColor(this.spectrum[2]);
        u = 0.5 * (x0 - s0 * dx0);
        v = 0.5 * (y0 - s0 * dy0);
        if (Math.abs(s) < Math.abs(c)) {
            g.drawLine(-dx, (int)Math.round(v + (u + 2.0 * (double)dx) * s / c) + dy, (int)Math.round(mag * (double)this.ic.getSrcRect().width - 1.0) + dx, (int)Math.round(v - (mag * (double)this.ic.getSrcRect().width - 1.0 - u) * s / c) + dy);
        } else {
            g.drawLine((int)Math.round(u + (v + 2.0 * (double)dy) * c / s) + dx, -dy, (int)Math.round(u - (mag * (double)this.ic.getSrcRect().height - 1.0 - v) * c / s) + dx, (int)Math.round(mag * (double)this.ic.getSrcRect().height - 1.0) + dy);
        }
    }

    private void setSpectrum() {
        if (this.transformation == 3) {
            this.spectrum[0] = Color.green;
            this.spectrum[1] = new Color(16, 119, 169);
            this.spectrum[2] = new Color(119, 85, 51);
        } else {
            this.spectrum[0] = Color.green;
            this.spectrum[1] = Color.yellow;
            this.spectrum[2] = Color.magenta;
            this.spectrum[3] = Color.cyan;
        }
    }
}

