/*
 * Decompiled with CFR 0.152.
 */
package registration.turboregold;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.measure.Calibration;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import registration.turboregold.turboRegPointHandler;
import registration.turboregold.turboRegPointToolbar;

class turboRegPointAction
extends ImageCanvas
implements AdjustmentListener,
FocusListener,
KeyListener,
MouseListener,
MouseMotionListener {
    private ImagePlus mainImp;
    private ImagePlus secondaryImp;
    private turboRegPointHandler mainPh;
    private turboRegPointHandler secondaryPh;
    private turboRegPointToolbar tb;
    private static final long serialVersionUID = 1L;

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        this.updateAndDraw();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.updateAndDraw();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.updateAndDraw();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 44: {
                if (1 < this.mainImp.getCurrentSlice()) {
                    this.mainImp.setSlice(this.mainImp.getCurrentSlice() - 1);
                    this.updateStatus();
                }
                return;
            }
            case 46: {
                if (this.mainImp.getCurrentSlice() < this.mainImp.getStackSize()) {
                    this.mainImp.setSlice(this.mainImp.getCurrentSlice() + 1);
                    this.updateStatus();
                }
                return;
            }
        }
        int x = this.mainPh.getPoint().x;
        int y = this.mainPh.getPoint().y;
        switch (e.getKeyCode()) {
            case 40: {
                this.mainPh.movePoint(this.mainImp.getWindow().getCanvas().screenX(x), this.mainImp.getWindow().getCanvas().screenY(y + (int)Math.ceil(1.0 / this.mainImp.getWindow().getCanvas().getMagnification())));
                this.mainImp.setRoi((Roi)this.mainPh);
                break;
            }
            case 37: {
                this.mainPh.movePoint(this.mainImp.getWindow().getCanvas().screenX(x - (int)Math.ceil(1.0 / this.mainImp.getWindow().getCanvas().getMagnification())), this.mainImp.getWindow().getCanvas().screenY(y));
                this.mainImp.setRoi((Roi)this.mainPh);
                break;
            }
            case 39: {
                this.mainPh.movePoint(this.mainImp.getWindow().getCanvas().screenX(x + (int)Math.ceil(1.0 / this.mainImp.getWindow().getCanvas().getMagnification())), this.mainImp.getWindow().getCanvas().screenY(y));
                this.mainImp.setRoi((Roi)this.mainPh);
                break;
            }
            case 32: {
                break;
            }
            case 38: {
                this.mainPh.movePoint(this.mainImp.getWindow().getCanvas().screenX(x), this.mainImp.getWindow().getCanvas().screenY(y - (int)Math.ceil(1.0 / this.mainImp.getWindow().getCanvas().getMagnification())));
                this.mainImp.setRoi((Roi)this.mainPh);
            }
        }
        this.updateStatus();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        WindowManager.setCurrentWindow((ImageWindow)this.mainImp.getWindow());
        this.mainImp.getWindow().toFront();
        this.mainImp.getWindow().getCanvas().setCursor(crosshairCursor);
        this.updateAndDraw();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mainImp.getWindow().getCanvas().setCursor(defaultCursor);
        IJ.showStatus((String)"");
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        switch (this.tb.getCurrentTool()) {
            case 11: {
                int flags = e.getModifiers();
                if ((flags & 0xE) != 0) {
                    this.mainImp.getWindow().getCanvas().zoomOut(x, y);
                    break;
                }
                this.mainImp.getWindow().getCanvas().zoomIn(x, y);
                break;
            }
            case 1: {
                int currentPoint = this.mainPh.findClosest(x, y);
                this.secondaryPh.setCurrentPoint(currentPoint);
                this.updateAndDraw();
                break;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.tb.getCurrentTool() == 1) {
            this.mainPh.movePoint(x, y);
            this.updateAndDraw();
        }
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        x = this.mainImp.getWindow().getCanvas().offScreenX(x);
        y = this.mainImp.getWindow().getCanvas().offScreenY(y);
        IJ.showStatus((String)(this.mainImp.getLocationAsString(x, y) + this.getValueAsString(x, y)));
    }

    public turboRegPointAction(ImagePlus imp, turboRegPointHandler ph, turboRegPointToolbar tb) {
        super(imp);
        this.mainImp = imp;
        this.mainPh = ph;
        this.tb = tb;
    }

    public void setSecondaryPointHandler(ImagePlus secondaryImp, turboRegPointHandler secondaryPh) {
        this.secondaryImp = secondaryImp;
        this.secondaryPh = secondaryPh;
    }

    private String getValueAsString(int x, int y) {
        Calibration cal = this.imp.getCalibration();
        int[] v = this.imp.getPixel(x, y);
        switch (this.imp.getType()) {
            case 0: 
            case 1: {
                double cValue = cal.getCValue(v[0]);
                if (cValue == (double)v[0]) {
                    return ", value=" + v[0];
                }
                return ", value=" + IJ.d2s((double)cValue) + " (" + v[0] + ")";
            }
            case 2: {
                return ", value=" + Float.intBitsToFloat(v[0]);
            }
            case 3: {
                return ", index=" + v[3] + ", value=" + v[0] + "," + v[1] + "," + v[2];
            }
            case 4: {
                return ", value=" + v[0] + "," + v[1] + "," + v[2];
            }
        }
        return "";
    }

    private void updateAndDraw() {
        this.mainImp.setRoi((Roi)this.mainPh);
        this.secondaryImp.setRoi((Roi)this.secondaryPh);
    }

    private void updateStatus() {
        Point p = this.mainPh.getPoint();
        if (p == null) {
            IJ.showStatus((String)"");
            return;
        }
        int x = p.x;
        int y = p.y;
        IJ.showStatus((String)(this.imp.getLocationAsString(x, y) + this.getValueAsString(x, y)));
    }
}

