/*
 * Decompiled with CFR 0.152.
 */
package registration.turboregold;

import ij.ImagePlus;
import java.util.Stack;
import registration.turboregold.turboRegProgressBar;

class turboRegImage
implements Runnable {
    private final Stack<Object> pyramid = new Stack();
    private Thread t = new Thread(this);
    private float[] image;
    private float[] coefficient;
    private float[] xGradient;
    private float[] yGradient;
    private int width;
    private int height;
    private int pyramidDepth;
    private int transformation;
    private boolean isTarget;

    @Override
    public void run() {
        this.coefficient = this.getBasicFromCardinal2D();
        switch (this.transformation) {
            case -1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                if (this.isTarget) {
                    this.buildCoefficientPyramid();
                    break;
                }
                this.imageToXYGradient2D();
                this.buildImageAndGradientPyramid();
                break;
            }
            case 8: {
                if (this.isTarget) {
                    this.buildImagePyramid();
                    break;
                }
                this.buildCoefficientPyramid();
            }
        }
    }

    public turboRegImage(ImagePlus imp, int transformation, boolean isTarget) {
        this.t.setDaemon(true);
        this.transformation = transformation;
        this.isTarget = isTarget;
        this.width = imp.getWidth();
        this.height = imp.getHeight();
        int k = 0;
        turboRegProgressBar.addWorkload(this.height);
        if (imp.getType() == 0) {
            this.image = new float[this.width * this.height];
            byte[] pixels = (byte[])imp.getProcessor().getPixels();
            for (int y = 0; y < this.height; ++y) {
                int x = 0;
                while (x < this.width) {
                    this.image[k] = pixels[k] & 0xFF;
                    ++x;
                    ++k;
                }
                turboRegProgressBar.stepProgressBar();
            }
        } else if (imp.getType() == 1) {
            this.image = new float[this.width * this.height];
            short[] pixels = (short[])imp.getProcessor().getPixels();
            for (int y = 0; y < this.height; ++y) {
                int x = 0;
                while (x < this.width) {
                    this.image[k] = pixels[k] & 0xFFFF;
                    ++x;
                    ++k;
                }
                turboRegProgressBar.stepProgressBar();
            }
        } else if (imp.getType() == 2) {
            this.image = (float[])imp.getProcessor().getPixels();
        }
        turboRegProgressBar.workloadDone(this.height);
    }

    public float[] getCoefficient() {
        return this.coefficient;
    }

    public int getHeight() {
        return this.height;
    }

    public float[] getImage() {
        return this.image;
    }

    public Stack<Object> getPyramid() {
        return this.pyramid;
    }

    public int getPyramidDepth() {
        return this.pyramidDepth;
    }

    public Thread getThread() {
        return this.t;
    }

    public int getWidth() {
        return this.width;
    }

    public float[] getXGradient() {
        return this.xGradient;
    }

    public float[] getYGradient() {
        return this.yGradient;
    }

    public void setPyramidDepth(int pyramidDepth) {
        this.pyramidDepth = pyramidDepth;
    }

    public void setTransformation(int transformation) {
        this.transformation = transformation;
    }

    private void antiSymmetricFirMirrorOffBounds1D(double[] h, double[] c, double[] s) {
        if (2 <= c.length) {
            s[0] = h[1] * (c[1] - c[0]);
            for (int i2 = 1; i2 < s.length - 1; ++i2) {
                s[i2] = h[1] * (c[i2 + 1] - c[i2 - 1]);
            }
            s[s.length - 1] = h[1] * (c[c.length - 1] - c[c.length - 2]);
        } else {
            s[0] = 0.0;
        }
    }

    private void basicToCardinal2D(float[] basic, float[] cardinal, int width, int height, int degree) {
        double[] hLine = new double[width];
        double[] vLine = new double[height];
        double[] hData = new double[width];
        double[] vData = new double[height];
        double[] h = null;
        switch (degree) {
            case 3: {
                h = new double[]{0.6666666666666666, 0.16666666666666666};
                break;
            }
            case 7: {
                h = new double[]{0.4793650793650794, 0.2363095238095238, 0.023809523809523808, 1.984126984126984E-4};
                break;
            }
            default: {
                h = new double[]{1.0};
            }
        }
        int workload = width + height;
        turboRegProgressBar.addWorkload(workload);
        for (int y = 0; y < height && !this.t.isInterrupted(); ++y) {
            this.extractRow(basic, y, hLine);
            this.symmetricFirMirrorOffBounds1D(h, hLine, hData);
            this.putRow(cardinal, y, hData);
            turboRegProgressBar.stepProgressBar();
            --workload;
        }
        for (int x = 0; x < width && !this.t.isInterrupted(); ++x) {
            this.extractColumn(cardinal, width, x, vLine);
            this.symmetricFirMirrorOffBounds1D(h, vLine, vData);
            this.putColumn(cardinal, width, x, vData);
            turboRegProgressBar.stepProgressBar();
            --workload;
        }
        turboRegProgressBar.skipProgressBar(workload);
        turboRegProgressBar.workloadDone(width + height);
    }

    private void buildCoefficientPyramid() {
        float[] fullDual = new float[this.width * this.height];
        int halfWidth = this.width;
        int halfHeight = this.height;
        if (1 < this.pyramidDepth) {
            this.basicToCardinal2D(this.coefficient, fullDual, this.width, this.height, 7);
        }
        for (int depth = 1; depth < this.pyramidDepth && !this.t.isInterrupted(); ++depth) {
            int fullWidth = halfWidth;
            int fullHeight = halfHeight;
            float[] halfDual = this.getHalfDual2D(fullDual, fullWidth, fullHeight);
            float[] halfCoefficient = this.getBasicFromCardinal2D(halfDual, halfWidth /= 2, halfHeight /= 2, 7);
            this.pyramid.push(halfCoefficient);
            this.pyramid.push(halfHeight);
            this.pyramid.push(halfWidth);
            fullDual = halfDual;
        }
    }

    private void buildImageAndGradientPyramid() {
        float[] fullDual = new float[this.width * this.height];
        int halfWidth = this.width;
        int halfHeight = this.height;
        if (1 < this.pyramidDepth) {
            this.cardinalToDual2D(this.image, fullDual, this.width, this.height, 3);
        }
        for (int depth = 1; depth < this.pyramidDepth && !this.t.isInterrupted(); ++depth) {
            int fullWidth = halfWidth;
            int fullHeight = halfHeight;
            float[] halfDual = this.getHalfDual2D(fullDual, fullWidth, fullHeight);
            float[] halfImage = this.getBasicFromCardinal2D(halfDual, halfWidth /= 2, halfHeight /= 2, 7);
            float[] halfXGradient = new float[halfWidth * halfHeight];
            float[] halfYGradient = new float[halfWidth * halfHeight];
            this.coefficientToXYGradient2D(halfImage, halfXGradient, halfYGradient, halfWidth, halfHeight);
            this.basicToCardinal2D(halfImage, halfImage, halfWidth, halfHeight, 3);
            this.pyramid.push(halfYGradient);
            this.pyramid.push(halfXGradient);
            this.pyramid.push(halfImage);
            this.pyramid.push(halfHeight);
            this.pyramid.push(halfWidth);
            fullDual = halfDual;
        }
    }

    private void buildImagePyramid() {
        float[] fullDual = new float[this.width * this.height];
        int halfWidth = this.width;
        int halfHeight = this.height;
        if (1 < this.pyramidDepth) {
            this.cardinalToDual2D(this.image, fullDual, this.width, this.height, 3);
        }
        for (int depth = 1; depth < this.pyramidDepth && !this.t.isInterrupted(); ++depth) {
            int fullWidth = halfWidth;
            int fullHeight = halfHeight;
            float[] halfDual = this.getHalfDual2D(fullDual, fullWidth, fullHeight);
            float[] halfImage = new float[(halfWidth /= 2) * (halfHeight /= 2)];
            this.dualToCardinal2D(halfDual, halfImage, halfWidth, halfHeight, 3);
            this.pyramid.push(halfImage);
            this.pyramid.push(halfHeight);
            this.pyramid.push(halfWidth);
            fullDual = halfDual;
        }
    }

    private void cardinalToDual2D(float[] cardinal, float[] dual, int width, int height, int degree) {
        this.basicToCardinal2D(this.getBasicFromCardinal2D(cardinal, width, height, degree), dual, width, height, 2 * degree + 1);
    }

    private void coefficientToGradient1D(double[] c) {
        double[] h = new double[]{0.0, 0.5};
        double[] s = new double[c.length];
        this.antiSymmetricFirMirrorOffBounds1D(h, c, s);
        System.arraycopy(s, 0, c, 0, s.length);
    }

    private void coefficientToSamples1D(double[] c) {
        double[] h = new double[]{0.6666666666666666, 0.16666666666666666};
        double[] s = new double[c.length];
        this.symmetricFirMirrorOffBounds1D(h, c, s);
        System.arraycopy(s, 0, c, 0, s.length);
    }

    private void coefficientToXYGradient2D(float[] basic, float[] xGradient, float[] yGradient, int width, int height) {
        double[] hLine = new double[width];
        double[] hData = new double[width];
        double[] vLine = new double[height];
        int workload = 2 * (width + height);
        turboRegProgressBar.addWorkload(workload);
        for (int y = 0; y < height && !this.t.isInterrupted(); ++y) {
            this.extractRow(basic, y, hLine);
            System.arraycopy(hLine, 0, hData, 0, width);
            this.coefficientToGradient1D(hLine);
            turboRegProgressBar.stepProgressBar();
            --workload;
            this.coefficientToSamples1D(hData);
            this.putRow(xGradient, y, hLine);
            this.putRow(yGradient, y, hData);
            turboRegProgressBar.stepProgressBar();
            --workload;
        }
        for (int x = 0; x < width && !this.t.isInterrupted(); ++x) {
            this.extractColumn(xGradient, width, x, vLine);
            this.coefficientToSamples1D(vLine);
            this.putColumn(xGradient, width, x, vLine);
            turboRegProgressBar.stepProgressBar();
            --workload;
            this.extractColumn(yGradient, width, x, vLine);
            this.coefficientToGradient1D(vLine);
            this.putColumn(yGradient, width, x, vLine);
            turboRegProgressBar.stepProgressBar();
            --workload;
        }
        turboRegProgressBar.skipProgressBar(workload);
        turboRegProgressBar.workloadDone(2 * (width + height));
    }

    private void dualToCardinal2D(float[] dual, float[] cardinal, int width, int height, int degree) {
        this.basicToCardinal2D(this.getBasicFromCardinal2D(dual, width, height, 2 * degree + 1), cardinal, width, height, degree);
    }

    private void extractColumn(float[] array, int width, int x, double[] column) {
        for (int i2 = 0; i2 < column.length; ++i2) {
            column[i2] = array[x];
            x += width;
        }
    }

    private void extractRow(float[] array, int y, double[] row) {
        y *= row.length;
        for (int i2 = 0; i2 < row.length; ++i2) {
            row[i2] = array[y++];
        }
    }

    private float[] getBasicFromCardinal2D() {
        float[] basic = new float[this.width * this.height];
        double[] hLine = new double[this.width];
        double[] vLine = new double[this.height];
        turboRegProgressBar.addWorkload(this.width + this.height);
        for (int y = 0; y < this.height; ++y) {
            this.extractRow(this.image, y, hLine);
            this.samplesToInterpolationCoefficient1D(hLine, 3, 0.0);
            this.putRow(basic, y, hLine);
            turboRegProgressBar.stepProgressBar();
        }
        for (int x = 0; x < this.width; ++x) {
            this.extractColumn(basic, this.width, x, vLine);
            this.samplesToInterpolationCoefficient1D(vLine, 3, 0.0);
            this.putColumn(basic, this.width, x, vLine);
            turboRegProgressBar.stepProgressBar();
        }
        turboRegProgressBar.workloadDone(this.width + this.height);
        return basic;
    }

    private float[] getBasicFromCardinal2D(float[] cardinal, int width, int height, int degree) {
        float[] basic = new float[width * height];
        double[] hLine = new double[width];
        double[] vLine = new double[height];
        int workload = width + height;
        turboRegProgressBar.addWorkload(workload);
        for (int y = 0; y < height && !this.t.isInterrupted(); ++y) {
            this.extractRow(cardinal, y, hLine);
            this.samplesToInterpolationCoefficient1D(hLine, degree, 0.0);
            this.putRow(basic, y, hLine);
            turboRegProgressBar.stepProgressBar();
            --workload;
        }
        for (int x = 0; x < width && !this.t.isInterrupted(); ++x) {
            this.extractColumn(basic, width, x, vLine);
            this.samplesToInterpolationCoefficient1D(vLine, degree, 0.0);
            this.putColumn(basic, width, x, vLine);
            turboRegProgressBar.stepProgressBar();
            --workload;
        }
        turboRegProgressBar.skipProgressBar(workload);
        turboRegProgressBar.workloadDone(width + height);
        return basic;
    }

    private float[] getHalfDual2D(float[] fullDual, int fullWidth, int fullHeight) {
        int halfWidth = fullWidth / 2;
        int halfHeight = fullHeight / 2;
        double[] hLine = new double[fullWidth];
        double[] hData = new double[halfWidth];
        double[] vLine = new double[fullHeight];
        double[] vData = new double[halfHeight];
        float[] demiDual = new float[halfWidth * fullHeight];
        float[] halfDual = new float[halfWidth * halfHeight];
        int workload = halfWidth + fullHeight;
        turboRegProgressBar.addWorkload(workload);
        for (int y = 0; y < fullHeight && !this.t.isInterrupted(); ++y) {
            this.extractRow(fullDual, y, hLine);
            this.reduceDual1D(hLine, hData);
            this.putRow(demiDual, y, hData);
            turboRegProgressBar.stepProgressBar();
            --workload;
        }
        for (int x = 0; x < halfWidth && !this.t.isInterrupted(); ++x) {
            this.extractColumn(demiDual, halfWidth, x, vLine);
            this.reduceDual1D(vLine, vData);
            this.putColumn(halfDual, halfWidth, x, vData);
            turboRegProgressBar.stepProgressBar();
            --workload;
        }
        turboRegProgressBar.skipProgressBar(workload);
        turboRegProgressBar.workloadDone(halfWidth + fullHeight);
        return halfDual;
    }

    private double getInitialAntiCausalCoefficientMirrorOffBounds(double[] c, double z, double tolerance) {
        return z * c[c.length - 1] / (z - 1.0);
    }

    private double getInitialCausalCoefficientMirrorOffBounds(double[] c, double z, double tolerance) {
        double z1 = z;
        double zn = Math.pow(z, c.length);
        double sum = (1.0 + z) * (c[0] + zn * c[c.length - 1]);
        int horizon = c.length;
        if (0.0 < tolerance) {
            horizon = 2 + (int)(Math.log(tolerance) / Math.log(Math.abs(z)));
            horizon = horizon < c.length ? horizon : c.length;
        }
        zn *= zn;
        for (int n = 1; n < horizon - 1; ++n) {
            sum += ((z1 *= z) + (zn /= z)) * c[n];
        }
        return sum / (1.0 - Math.pow(z, 2 * c.length));
    }

    private void imageToXYGradient2D() {
        double[] hLine = new double[this.width];
        double[] vLine = new double[this.height];
        this.xGradient = new float[this.width * this.height];
        this.yGradient = new float[this.width * this.height];
        int workload = this.width + this.height;
        turboRegProgressBar.addWorkload(workload);
        for (int y = 0; y < this.height && !this.t.isInterrupted(); ++y) {
            this.extractRow(this.image, y, hLine);
            this.samplesToInterpolationCoefficient1D(hLine, 3, 0.0);
            this.coefficientToGradient1D(hLine);
            this.putRow(this.xGradient, y, hLine);
            turboRegProgressBar.stepProgressBar();
            --workload;
        }
        for (int x = 0; x < this.width && !this.t.isInterrupted(); ++x) {
            this.extractColumn(this.image, this.width, x, vLine);
            this.samplesToInterpolationCoefficient1D(vLine, 3, 0.0);
            this.coefficientToGradient1D(vLine);
            this.putColumn(this.yGradient, this.width, x, vLine);
            turboRegProgressBar.stepProgressBar();
            --workload;
        }
        turboRegProgressBar.skipProgressBar(workload);
        turboRegProgressBar.workloadDone(this.width + this.height);
    }

    private void putColumn(float[] array, int width, int x, double[] column) {
        for (int i2 = 0; i2 < column.length; ++i2) {
            array[x] = (float)column[i2];
            x += width;
        }
    }

    private void putRow(float[] array, int y, double[] row) {
        y *= row.length;
        for (int i2 = 0; i2 < row.length; ++i2) {
            array[y++] = (float)row[i2];
        }
    }

    private void reduceDual1D(double[] c, double[] s) {
        double[] h = new double[]{0.375, 0.25, 0.0625};
        if (2 <= s.length) {
            s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]);
            int i2 = 2;
            for (int j = 1; j < s.length - 1; ++j) {
                s[j] = h[0] * c[i2] + h[1] * (c[i2 - 1] + c[i2 + 1]) + h[2] * (c[i2 - 2] + c[i2 + 2]);
                i2 += 2;
            }
            s[s.length - 1] = c.length == 2 * s.length ? h[0] * c[c.length - 2] + h[1] * (c[c.length - 3] + c[c.length - 1]) + h[2] * (c[c.length - 4] + c[c.length - 1]) : h[0] * c[c.length - 3] + h[1] * (c[c.length - 4] + c[c.length - 2]) + h[2] * (c[c.length - 5] + c[c.length - 1]);
        } else {
            switch (c.length) {
                case 3: {
                    s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]);
                    break;
                }
                case 2: {
                    s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + 2.0 * h[2] * c[1];
                }
            }
        }
    }

    private void samplesToInterpolationCoefficient1D(double[] c, int degree, double tolerance) {
        int k;
        double[] z = new double[]{};
        double lambda = 1.0;
        switch (degree) {
            case 3: {
                z = new double[]{Math.sqrt(3.0) - 2.0};
                break;
            }
            case 7: {
                z = new double[]{-0.5352804307964382, -0.12255461519232669, -0.009148694809608277};
            }
        }
        if (c.length == 1) {
            return;
        }
        for (k = 0; k < z.length; ++k) {
            lambda *= (1.0 - z[k]) * (1.0 - 1.0 / z[k]);
        }
        int n = 0;
        while (n < c.length) {
            int n2 = n++;
            c[n2] = c[n2] * lambda;
        }
        for (k = 0; k < z.length; ++k) {
            int n3;
            c[0] = this.getInitialCausalCoefficientMirrorOffBounds(c, z[k], tolerance);
            for (n3 = 1; n3 < c.length; ++n3) {
                int n4 = n3;
                c[n4] = c[n4] + z[k] * c[n3 - 1];
            }
            c[c.length - 1] = this.getInitialAntiCausalCoefficientMirrorOffBounds(c, z[k], tolerance);
            for (n3 = c.length - 2; 0 <= n3; --n3) {
                c[n3] = z[k] * (c[n3 + 1] - c[n3]);
            }
        }
    }

    private void symmetricFirMirrorOffBounds1D(double[] h, double[] c, double[] s) {
        block0 : switch (h.length) {
            case 2: {
                if (2 <= c.length) {
                    s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]);
                    for (int i2 = 1; i2 < s.length - 1; ++i2) {
                        s[i2] = h[0] * c[i2] + h[1] * (c[i2 - 1] + c[i2 + 1]);
                    }
                    s[s.length - 1] = h[0] * c[c.length - 1] + h[1] * (c[c.length - 2] + c[c.length - 1]);
                    break;
                }
                s[0] = (h[0] + 2.0 * h[1]) * c[0];
                break;
            }
            case 4: {
                if (6 <= c.length) {
                    s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                    s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[4]);
                    s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + h[2] * (c[0] + c[4]) + h[3] * (c[0] + c[5]);
                    for (int i3 = 3; i3 < s.length - 3; ++i3) {
                        s[i3] = h[0] * c[i3] + h[1] * (c[i3 - 1] + c[i3 + 1]) + h[2] * (c[i3 - 2] + c[i3 + 2]) + h[3] * (c[i3 - 3] + c[i3 + 3]);
                    }
                    s[s.length - 3] = h[0] * c[c.length - 3] + h[1] * (c[c.length - 4] + c[c.length - 2]) + h[2] * (c[c.length - 5] + c[c.length - 1]) + h[3] * (c[c.length - 6] + c[c.length - 1]);
                    s[s.length - 2] = h[0] * c[c.length - 2] + h[1] * (c[c.length - 3] + c[c.length - 1]) + h[2] * (c[c.length - 4] + c[c.length - 1]) + h[3] * (c[c.length - 5] + c[c.length - 2]);
                    s[s.length - 1] = h[0] * c[c.length - 1] + h[1] * (c[c.length - 2] + c[c.length - 1]) + h[2] * (c[c.length - 3] + c[c.length - 2]) + h[3] * (c[c.length - 4] + c[c.length - 3]);
                    break;
                }
                switch (c.length) {
                    case 5: {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                        s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[4]);
                        s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + (h[2] + h[3]) * (c[0] + c[4]);
                        s[3] = h[0] * c[3] + h[1] * (c[2] + c[4]) + h[2] * (c[1] + c[4]) + h[3] * (c[0] + c[3]);
                        s[4] = h[0] * c[4] + h[1] * (c[3] + c[4]) + h[2] * (c[2] + c[3]) + h[3] * (c[1] + c[2]);
                        break block0;
                    }
                    case 4: {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                        s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[3]);
                        s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + h[2] * (c[0] + c[3]) + h[3] * (c[0] + c[2]);
                        s[3] = h[0] * c[3] + h[1] * (c[2] + c[3]) + h[2] * (c[1] + c[2]) + h[3] * (c[0] + c[1]);
                        break block0;
                    }
                    case 3: {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + 2.0 * h[3] * c[2];
                        s[1] = h[0] * c[1] + (h[1] + h[2]) * (c[0] + c[2]) + 2.0 * h[3] * c[1];
                        s[2] = h[0] * c[2] + h[1] * (c[1] + c[2]) + h[2] * (c[0] + c[1]) + 2.0 * h[3] * c[0];
                        break block0;
                    }
                    case 2: {
                        s[0] = (h[0] + h[1] + h[3]) * c[0] + (h[1] + 2.0 * h[2] + h[3]) * c[1];
                        s[1] = (h[0] + h[1] + h[3]) * c[1] + (h[1] + 2.0 * h[2] + h[3]) * c[0];
                        break block0;
                    }
                    case 1: {
                        s[0] = (h[0] + 2.0 * (h[1] + h[2] + h[3])) * c[0];
                    }
                }
            }
        }
    }
}

