/*
 * Decompiled with CFR 0.152.
 */
package registration.turboregold;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import registration.turboregold.turboRegDialog;
import registration.turboregold.turboRegImage;
import registration.turboregold.turboRegMask;
import registration.turboregold.turboRegPointHandler;
import registration.turboregold.turboRegTransform;

class turboRegFinalAction
implements Runnable {
    public static final int AUTOMATIC = 1;
    public static final int MANUAL = 2;
    public static final int BATCH = 3;
    private Thread t;
    private turboRegDialog td;
    private volatile ImagePlus sourceImp;
    private volatile ImagePlus targetImp;
    private volatile turboRegImage sourceImg;
    private volatile turboRegImage targetImg;
    private volatile turboRegMask sourceMsk;
    private volatile turboRegMask targetMsk;
    private volatile turboRegPointHandler sourcePh;
    private volatile turboRegPointHandler targetPh;
    private volatile int operation;
    private volatile int pyramidDepth;
    private volatile int sourceColorPlane;
    private volatile int transformation;
    private volatile boolean accelerated;
    private volatile boolean saveOnExit;
    private volatile boolean colorOutput;

    @Override
    public void run() {
        double[][] sourcePoints = null;
        double[][] targetPoints = null;
        turboRegTransform tt = null;
        ImageStack outputStack = null;
        ImagePlus outputImp = null;
        switch (this.operation) {
            case 1: 
            case 2: {
                if (this.td != null) {
                    if (this.operation == 2 && this.accelerated) {
                        this.td.stopThreads();
                    } else {
                        this.td.joinThreads();
                    }
                }
                tt = new turboRegTransform(this.sourceImg, this.sourceMsk, this.sourcePh, this.targetImg, this.targetMsk, this.targetPh, this.transformation, this.accelerated, this.td != null);
                if (this.operation == 1) {
                    tt.doRegistration();
                }
                if (this.colorOutput) {
                    outputStack = new ImageStack(this.targetImg.getWidth(), this.targetImg.getHeight());
                    FloatProcessor fp = new FloatProcessor(this.targetImg.getWidth(), this.targetImg.getHeight());
                    fp.setMinAndMax(0.0, 255.0);
                    outputStack.addSlice("Red", (ImageProcessor)fp);
                    fp = new FloatProcessor(this.targetImg.getWidth(), this.targetImg.getHeight());
                    fp.setMinAndMax(0.0, 255.0);
                    outputStack.addSlice("Green", (ImageProcessor)fp);
                    fp = new FloatProcessor(this.targetImg.getWidth(), this.targetImg.getHeight());
                    fp.setMinAndMax(0.0, 255.0);
                    outputStack.addSlice("Blue", (ImageProcessor)fp);
                    outputImp = new ImagePlus("Registered", outputStack);
                    outputStack.setPixels((Object)tt.doFinalTransform(this.sourceImg, this.sourcePh, this.targetImg, this.targetPh, this.transformation, this.accelerated), this.sourceColorPlane);
                    for (int c = 1; c <= 3; ++c) {
                        if (c == this.sourceColorPlane) continue;
                        this.sourceImp.setSlice(c);
                        this.sourceImg = new turboRegImage(this.sourceImp, -1, false);
                        this.sourceImg.setPyramidDepth(1);
                        this.sourceImg.getThread().start();
                        try {
                            this.sourceImg.getThread().join();
                        }
                        catch (InterruptedException e) {
                            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
                        }
                        this.sourceImg.setTransformation(this.transformation);
                        outputStack.setPixels((Object)tt.doFinalTransform(this.sourceImg, this.sourcePh, this.targetImg, this.targetPh, this.transformation, this.accelerated), c);
                    }
                    StackConverter scnv = new StackConverter(outputImp);
                    scnv.convertToGray8();
                    ImageConverter icnv = new ImageConverter(outputImp);
                    ImageConverter.setDoScaling((boolean)false);
                    icnv.convertRGBStackToRGB();
                    if (this.td != null) {
                        outputImp.show();
                    }
                } else {
                    outputImp = tt.doFinalTransform(this.targetImg.getWidth(), this.targetImg.getHeight());
                }
                if (this.saveOnExit) {
                    tt.saveTransformation(null);
                }
                if (this.td == null) break;
                this.td.restoreAll();
                break;
            }
            case 3: {
                int k;
                outputStack = new ImageStack(this.targetImg.getWidth(), this.targetImg.getHeight());
                for (int i2 = 0; i2 < this.sourceImp.getStackSize(); ++i2) {
                    outputStack.addSlice("", (ImageProcessor)new FloatProcessor(this.targetImg.getWidth(), this.targetImg.getHeight()));
                }
                outputImp = new ImagePlus("Registered", outputStack);
                if (this.transformation == 3) {
                    targetPoints = new double[this.transformation][2];
                    sourcePoints = new double[this.transformation][2];
                    for (k = 0; k < this.transformation; ++k) {
                        sourcePoints[k][0] = this.sourcePh.getPoints()[k][0];
                        sourcePoints[k][1] = this.sourcePh.getPoints()[k][1];
                        targetPoints[k][0] = this.targetPh.getPoints()[k][0];
                        targetPoints[k][1] = this.targetPh.getPoints()[k][1];
                    }
                } else {
                    targetPoints = new double[this.transformation / 2][2];
                    sourcePoints = new double[this.transformation / 2][2];
                    for (k = 0; k < this.transformation / 2; ++k) {
                        sourcePoints[k][0] = this.sourcePh.getPoints()[k][0];
                        sourcePoints[k][1] = this.sourcePh.getPoints()[k][1];
                        targetPoints[k][0] = this.targetPh.getPoints()[k][0];
                        targetPoints[k][1] = this.targetPh.getPoints()[k][1];
                    }
                }
                if (this.td != null) {
                    this.td.joinThreads();
                }
                tt = new turboRegTransform(this.sourceImg, null, this.sourcePh, this.targetImg, this.targetMsk, this.targetPh, this.transformation, this.accelerated, this.td != null);
                if (2 <= this.sourceImp.getStackSize()) {
                    this.sourceImp.setSlice(2);
                    this.sourceImg = new turboRegImage(this.sourceImp, this.transformation, false);
                    this.sourceImg.setPyramidDepth(this.pyramidDepth);
                    this.sourceImg.getThread().start();
                }
                tt.doRegistration();
                String pathAndFilename = "";
                if (this.saveOnExit) {
                    pathAndFilename = tt.saveTransformation(null);
                }
                tt.doBatchFinalTransform((float[])outputStack.getProcessor(1).getPixels());
                outputImp.setSlice(1);
                outputImp.getProcessor().resetMinAndMax();
                if (this.td != null) {
                    outputImp.show();
                }
                Runtime.getRuntime().gc();
                for (int i3 = 2; i3 <= this.sourceImp.getStackSize(); ++i3) {
                    this.targetPh.setPoints(targetPoints);
                    this.sourcePh = new turboRegPointHandler(this.sourceImp, this.transformation);
                    this.sourcePh.setPoints(sourcePoints);
                    try {
                        this.sourceImg.getThread().join();
                    }
                    catch (InterruptedException e) {
                        IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
                    }
                    tt = new turboRegTransform(this.sourceImg, null, this.sourcePh, this.targetImg, this.targetMsk, this.targetPh, this.transformation, this.accelerated, this.td != null);
                    if (i3 < this.sourceImp.getStackSize()) {
                        this.sourceImp.setSlice(i3 + 1);
                        this.sourceImg = new turboRegImage(this.sourceImp, this.transformation, false);
                        this.sourceImg.setPyramidDepth(this.pyramidDepth);
                        this.sourceImg.getThread().start();
                    }
                    tt.doRegistration();
                    if (this.saveOnExit) {
                        tt.appendTransformation(pathAndFilename);
                    }
                    tt.doBatchFinalTransform((float[])outputStack.getProcessor(i3).getPixels());
                    outputImp.setSlice(i3);
                    outputImp.getProcessor().resetMinAndMax();
                    Runtime.getRuntime().gc();
                }
                this.sourceImp.killRoi();
                this.targetImp.killRoi();
                outputImp.setSlice(1);
                outputImp.getProcessor().resetMinAndMax();
                if (this.td == null) break;
                this.td.restoreAll();
                break;
            }
        }
    }

    public turboRegFinalAction(turboRegDialog dialog) {
        this.td = dialog;
        this.t = new Thread(this);
    }

    public turboRegFinalAction(turboRegImage sourceImg, turboRegMask sourceMsk, turboRegPointHandler sourcePh, turboRegImage targetImg, turboRegMask targetMsk, turboRegPointHandler targetPh, int transformation) {
        this.sourceImg = sourceImg;
        this.sourceMsk = sourceMsk;
        this.sourcePh = sourcePh;
        this.targetImg = targetImg;
        this.targetMsk = targetMsk;
        this.targetPh = targetPh;
        this.transformation = transformation;
        this.accelerated = false;
        this.saveOnExit = false;
        this.operation = 1;
        this.colorOutput = false;
        this.td = null;
        this.t = new Thread(this);
    }

    public Thread getThread() {
        return this.t;
    }

    public void setup(turboRegImage sourceImg, turboRegMask sourceMsk, turboRegPointHandler sourcePh, turboRegImage targetImg, turboRegMask targetMsk, turboRegPointHandler targetPh, int transformation, boolean accelerated, boolean saveOnExit, int operation) {
        this.sourceImg = sourceImg;
        this.sourceMsk = sourceMsk;
        this.sourcePh = sourcePh;
        this.targetImg = targetImg;
        this.targetMsk = targetMsk;
        this.targetPh = targetPh;
        this.transformation = transformation;
        this.accelerated = accelerated;
        this.saveOnExit = saveOnExit;
        this.operation = operation;
        this.colorOutput = false;
    }

    public void setup(ImagePlus sourceImp, turboRegImage sourceImg, turboRegMask sourceMsk, turboRegPointHandler sourcePh, int sourceColorPlane, turboRegImage targetImg, turboRegMask targetMsk, turboRegPointHandler targetPh, int transformation, boolean accelerated, boolean saveOnExit, int operation) {
        this.sourceImp = sourceImp;
        this.sourceImg = sourceImg;
        this.sourceMsk = sourceMsk;
        this.sourcePh = sourcePh;
        this.sourceColorPlane = sourceColorPlane;
        this.targetImg = targetImg;
        this.targetMsk = targetMsk;
        this.targetPh = targetPh;
        this.transformation = transformation;
        this.accelerated = accelerated;
        this.saveOnExit = saveOnExit;
        this.operation = operation;
        this.colorOutput = true;
    }

    public void setup(ImagePlus sourceImp, turboRegImage sourceImg, turboRegPointHandler sourcePh, ImagePlus targetImp, turboRegImage targetImg, turboRegMask targetMsk, turboRegPointHandler targetPh, int transformation, boolean accelerated, boolean saveOnExit, int pyramidDepth) {
        this.sourceImp = sourceImp;
        this.sourceImg = sourceImg;
        this.sourcePh = sourcePh;
        this.targetImp = targetImp;
        this.targetImg = targetImg;
        this.targetMsk = targetMsk;
        this.targetPh = targetPh;
        this.transformation = transformation;
        this.accelerated = accelerated;
        this.saveOnExit = saveOnExit;
        this.pyramidDepth = pyramidDepth;
        this.operation = 3;
    }
}

