/*
 * Decompiled with CFR 0.152.
 */
package registration.turboregold;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.gui.Toolbar;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import registration.turboregold.turboRegFinalAction;
import registration.turboregold.turboRegImage;
import registration.turboregold.turboRegMask;
import registration.turboregold.turboRegPointAction;
import registration.turboregold.turboRegPointHandler;
import registration.turboregold.turboRegPointToolbar;
import registration.turboregold.turboRegProgressBar;
import registration.turboregold.turboRegTransform;

public class turboRegDialog
extends Dialog
implements ActionListener {
    public static final int AFFINE = 6;
    public static final int GENERIC_TRANSFORMATION = -1;
    public static final int BILINEAR = 8;
    public static final int BLUE = 3;
    public static final int BLACK = 0;
    public static final int GREEN = 2;
    public static final int MIN_SIZE = 12;
    public static final int RED = 1;
    public static final int RIGID_BODY = 3;
    public static final int SCALED_ROTATION = 4;
    public static final int TRANSLATION = 2;
    private ImagePlus[] admissibleImageList;
    private ImageCanvas sourceIc;
    private ImageCanvas targetIc;
    private ImagePlus sourceImp;
    private ImagePlus targetImp;
    private Scrollbar sourceScrollbar;
    private Scrollbar targetScrollbar;
    private static boolean saveOnExit = false;
    private static boolean accelerated = true;
    private static final long serialVersionUID = 1L;
    private static int transformation = 3;
    private static int sourceColorPlane = 0;
    private static int targetColorPlane = 0;
    private final Button automaticButton = new Button("Automatic");
    private final Button batchButton = new Button("Batch");
    private final CheckboxGroup sourceKrgbGroup = new CheckboxGroup();
    private final Checkbox sourceBlack = new Checkbox("K", this.sourceKrgbGroup, sourceColorPlane == 0);
    private final Checkbox sourceRed = new Checkbox("R", this.sourceKrgbGroup, sourceColorPlane == 1);
    private final Checkbox sourceGreen = new Checkbox("G", this.sourceKrgbGroup, sourceColorPlane == 2);
    private final Checkbox sourceBlue = new Checkbox("B", this.sourceKrgbGroup, sourceColorPlane == 3);
    private final CheckboxGroup targetKrgbGroup = new CheckboxGroup();
    private final Checkbox targetBlack = new Checkbox("K", this.targetKrgbGroup, targetColorPlane == 0);
    private final Checkbox targetRed = new Checkbox("R", this.targetKrgbGroup, targetColorPlane == 1);
    private final Checkbox targetGreen = new Checkbox("G", this.targetKrgbGroup, targetColorPlane == 2);
    private final Checkbox targetBlue = new Checkbox("B", this.targetKrgbGroup, targetColorPlane == 3);
    private final CheckboxGroup transformationGroup = new CheckboxGroup();
    private final Checkbox translation = new Checkbox("Translation", this.transformationGroup, transformation == 2);
    private final Checkbox rigidBody = new Checkbox("Rigid Body", this.transformationGroup, transformation == 3);
    private final Checkbox scaledRotation = new Checkbox("Scaled Rotation", this.transformationGroup, transformation == 4);
    private final Checkbox affine = new Checkbox("Affine", this.transformationGroup, transformation == 6);
    private final Checkbox bilinear = new Checkbox("Bilinear", this.transformationGroup, transformation == 8);
    private final turboRegFinalAction finalAction = new turboRegFinalAction(this);
    private final turboRegPointToolbar tb = new turboRegPointToolbar(Toolbar.getInstance());
    private int sourceChoiceIndex = 0;
    private int targetChoiceIndex = 1;
    private int pyramidDepth;
    private turboRegImage sourceImg;
    private turboRegImage targetImg;
    private turboRegMask sourceMsk;
    private turboRegMask targetMsk;
    private turboRegPointAction sourcePa;
    private turboRegPointAction targetPa;
    private turboRegPointHandler sourcePh;
    private turboRegPointHandler targetPh;

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Load...")) {
            if (!this.loadLandmarks()) {
                IJ.error((String)"Invalid Landmarks");
            }
        } else if (ae.getActionCommand().equals("Save Now...")) {
            turboRegTransform tt = new turboRegTransform(this.sourceImg, this.sourceMsk, this.sourcePh, this.targetImg, this.targetMsk, this.targetPh, transformation, accelerated, true);
            tt.saveTransformation(null);
        } else if (ae.getActionCommand().equals("Cancel")) {
            this.dispose();
            this.restoreAll();
        } else if (ae.getActionCommand().equals("Manual")) {
            this.dispose();
            if (this.sourceImp.getStack().isRGB()) {
                this.finalAction.setup(this.sourceImp, this.sourceImg, this.sourceMsk, this.sourcePh, sourceColorPlane, this.targetImg, this.targetMsk, this.targetPh, transformation, accelerated, saveOnExit, 2);
            } else {
                this.finalAction.setup(this.sourceImg, this.sourceMsk, this.sourcePh, this.targetImg, this.targetMsk, this.targetPh, transformation, accelerated, saveOnExit, 2);
            }
            this.finalAction.getThread().start();
        } else if (ae.getActionCommand().equals("Automatic")) {
            this.dispose();
            if (this.sourceImp.getStack().isRGB()) {
                this.finalAction.setup(this.sourceImp, this.sourceImg, this.sourceMsk, this.sourcePh, sourceColorPlane, this.targetImg, this.targetMsk, this.targetPh, transformation, accelerated, saveOnExit, 1);
            } else {
                this.finalAction.setup(this.sourceImg, this.sourceMsk, this.sourcePh, this.targetImg, this.targetMsk, this.targetPh, transformation, accelerated, saveOnExit, 1);
            }
            this.finalAction.getThread().start();
        } else if (ae.getActionCommand().equals("Batch")) {
            this.dispose();
            this.finalAction.setup(this.sourceImp, this.sourceImg, this.sourcePh, this.targetImp, this.targetImg, this.targetMsk, this.targetPh, transformation, accelerated, saveOnExit, this.pyramidDepth);
            this.finalAction.getThread().start();
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 20, 20, 20);
    }

    public turboRegDialog(Frame parentWindow, ImagePlus[] admissibleImageList) {
        super(parentWindow, "TurboReg", false);
        this.admissibleImageList = admissibleImageList;
        this.defaultSourceColorPlane();
        this.defaultTargetColorPlane();
        this.createImages();
        this.startThreads();
        this.setLayout(new GridLayout(0, 1));
        final Choice sourceChoice = new Choice();
        for (int k = 0; k < admissibleImageList.length; ++k) {
            sourceChoice.add(admissibleImageList[k].getTitle());
        }
        sourceChoice.select(this.sourceChoiceIndex);
        final Choice targetChoice = new Choice();
        for (int k = 0; k < admissibleImageList.length; ++k) {
            targetChoice.add(admissibleImageList[k].getTitle());
        }
        targetChoice.select(this.targetChoiceIndex);
        Panel sourcePanel = new Panel();
        sourcePanel.setLayout(new FlowLayout(1));
        sourceChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int newChoiceIndex = sourceChoice.getSelectedIndex();
                if (turboRegDialog.this.sourceChoiceIndex != newChoiceIndex) {
                    if (turboRegDialog.this.targetChoiceIndex != newChoiceIndex) {
                        turboRegDialog.this.sourceChoiceIndex = newChoiceIndex;
                        turboRegDialog.this.cancelSource();
                        turboRegDialog.this.defaultSourceColorPlane();
                        turboRegDialog.this.createSourceImages();
                        turboRegDialog.this.startSourceThreads();
                    } else {
                        turboRegDialog.this.targetChoiceIndex = turboRegDialog.this.sourceChoiceIndex;
                        turboRegDialog.this.sourceChoiceIndex = newChoiceIndex;
                        targetChoice.select(turboRegDialog.this.targetChoiceIndex);
                        turboRegDialog.this.permuteImages();
                        turboRegDialog.this.startThreads();
                    }
                    turboRegDialog.this.sourcePa.setSecondaryPointHandler(turboRegDialog.this.targetImp, turboRegDialog.this.targetPh);
                    turboRegDialog.this.targetPa.setSecondaryPointHandler(turboRegDialog.this.sourceImp, turboRegDialog.this.sourcePh);
                    turboRegDialog.this.batchButton.setEnabled(1 < turboRegDialog.this.sourceImp.getStackSize() && !turboRegDialog.this.sourceImp.getStack().isRGB() && !turboRegDialog.this.targetImp.getStack().isRGB());
                }
                turboRegDialog.this.repaint();
            }
        });
        this.sourceRed.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (turboRegDialog.this.sourceKrgbGroup.getSelectedCheckbox().getLabel().equals("R") && sourceColorPlane != 1) {
                    turboRegDialog.this.sourceKrgbGroup.setSelectedCheckbox(turboRegDialog.this.sourceRed);
                    turboRegDialog.this.stopSourceThreads();
                    turboRegDialog.this.setSourceColorPlane(1);
                    turboRegDialog.this.startSourceThreads();
                }
                turboRegDialog.this.repaint();
            }
        });
        this.sourceGreen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (turboRegDialog.this.sourceKrgbGroup.getSelectedCheckbox().getLabel().equals("G") && sourceColorPlane != 2) {
                    turboRegDialog.this.sourceKrgbGroup.setSelectedCheckbox(turboRegDialog.this.sourceGreen);
                    turboRegDialog.this.stopSourceThreads();
                    turboRegDialog.this.setSourceColorPlane(2);
                    turboRegDialog.this.startSourceThreads();
                }
                turboRegDialog.this.repaint();
            }
        });
        this.sourceBlue.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (turboRegDialog.this.sourceKrgbGroup.getSelectedCheckbox().getLabel().equals("B") && sourceColorPlane != 3) {
                    turboRegDialog.this.sourceKrgbGroup.setSelectedCheckbox(turboRegDialog.this.sourceBlue);
                    turboRegDialog.this.stopSourceThreads();
                    turboRegDialog.this.setSourceColorPlane(3);
                    turboRegDialog.this.startSourceThreads();
                }
                turboRegDialog.this.repaint();
            }
        });
        Label sourceLabel = new Label("Source: ");
        sourcePanel.add(sourceLabel);
        sourcePanel.add(sourceChoice);
        sourcePanel.add(this.sourceRed);
        sourcePanel.add(this.sourceGreen);
        sourcePanel.add(this.sourceBlue);
        sourcePanel.add(this.sourceBlack);
        Panel targetPanel = new Panel();
        targetPanel.setLayout(new FlowLayout(1));
        targetChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int newChoiceIndex = targetChoice.getSelectedIndex();
                if (turboRegDialog.this.targetChoiceIndex != newChoiceIndex) {
                    if (turboRegDialog.this.sourceChoiceIndex != newChoiceIndex) {
                        turboRegDialog.this.targetChoiceIndex = newChoiceIndex;
                        turboRegDialog.this.cancelTarget();
                        turboRegDialog.this.defaultTargetColorPlane();
                        turboRegDialog.this.createTargetImages();
                        turboRegDialog.this.startTargetThreads();
                    } else {
                        turboRegDialog.this.sourceChoiceIndex = turboRegDialog.this.targetChoiceIndex;
                        turboRegDialog.this.targetChoiceIndex = newChoiceIndex;
                        sourceChoice.select(turboRegDialog.this.sourceChoiceIndex);
                        turboRegDialog.this.permuteImages();
                        turboRegDialog.this.startThreads();
                    }
                    turboRegDialog.this.sourcePa.setSecondaryPointHandler(turboRegDialog.this.targetImp, turboRegDialog.this.targetPh);
                    turboRegDialog.this.targetPa.setSecondaryPointHandler(turboRegDialog.this.sourceImp, turboRegDialog.this.sourcePh);
                    turboRegDialog.this.batchButton.setEnabled(1 < turboRegDialog.this.sourceImp.getStackSize() && !turboRegDialog.this.sourceImp.getStack().isRGB() && !turboRegDialog.this.targetImp.getStack().isRGB());
                }
                turboRegDialog.this.repaint();
            }
        });
        this.targetRed.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (turboRegDialog.this.targetKrgbGroup.getSelectedCheckbox().getLabel().equals("R") && targetColorPlane != 1) {
                    turboRegDialog.this.targetKrgbGroup.setSelectedCheckbox(turboRegDialog.this.targetRed);
                    turboRegDialog.this.stopTargetThreads();
                    turboRegDialog.this.setTargetColorPlane(1);
                    turboRegDialog.this.startTargetThreads();
                }
                turboRegDialog.this.repaint();
            }
        });
        this.targetGreen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (turboRegDialog.this.targetKrgbGroup.getSelectedCheckbox().getLabel().equals("G") && targetColorPlane != 2) {
                    turboRegDialog.this.targetKrgbGroup.setSelectedCheckbox(turboRegDialog.this.targetGreen);
                    turboRegDialog.this.stopTargetThreads();
                    turboRegDialog.this.setTargetColorPlane(2);
                    turboRegDialog.this.startTargetThreads();
                }
                turboRegDialog.this.repaint();
            }
        });
        this.targetBlue.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (turboRegDialog.this.targetKrgbGroup.getSelectedCheckbox().getLabel().equals("B") && targetColorPlane != 3) {
                    turboRegDialog.this.targetKrgbGroup.setSelectedCheckbox(turboRegDialog.this.targetBlue);
                    turboRegDialog.this.stopTargetThreads();
                    turboRegDialog.this.setTargetColorPlane(3);
                    turboRegDialog.this.startTargetThreads();
                }
                turboRegDialog.this.repaint();
            }
        });
        Label targetLabel = new Label("Target: ");
        targetPanel.add(targetLabel);
        targetPanel.add(targetChoice);
        targetPanel.add(this.targetRed);
        targetPanel.add(this.targetGreen);
        targetPanel.add(this.targetBlue);
        targetPanel.add(this.targetBlack);
        Panel transformationPanel = new Panel();
        transformationPanel.setLayout(new FlowLayout(1));
        this.translation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (turboRegDialog.this.transformationGroup.getSelectedCheckbox().getLabel().equals("Translation") && transformation != 2) {
                    if (transformation == 8) {
                        transformation = 2;
                        turboRegDialog.this.cancelImages();
                        turboRegDialog.this.createImages();
                        turboRegDialog.this.startThreads();
                    } else {
                        transformation = 2;
                        turboRegDialog.this.setTransformation();
                    }
                }
                turboRegDialog.this.repaint();
            }
        });
        this.rigidBody.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (turboRegDialog.this.transformationGroup.getSelectedCheckbox().getLabel().equals("Rigid Body") && transformation != 3) {
                    if (transformation == 8) {
                        transformation = 3;
                        turboRegDialog.this.cancelImages();
                        turboRegDialog.this.createImages();
                        turboRegDialog.this.startThreads();
                    } else {
                        transformation = 3;
                        turboRegDialog.this.setTransformation();
                    }
                }
                turboRegDialog.this.repaint();
            }
        });
        this.scaledRotation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (turboRegDialog.this.transformationGroup.getSelectedCheckbox().getLabel().equals("Scaled Rotation") && transformation != 4) {
                    if (transformation == 8) {
                        transformation = 4;
                        turboRegDialog.this.cancelImages();
                        turboRegDialog.this.createImages();
                        turboRegDialog.this.startThreads();
                    } else {
                        transformation = 4;
                        turboRegDialog.this.setTransformation();
                    }
                }
                turboRegDialog.this.repaint();
            }
        });
        this.affine.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (turboRegDialog.this.transformationGroup.getSelectedCheckbox().getLabel().equals("Affine") && transformation != 6) {
                    if (transformation == 8) {
                        transformation = 6;
                        turboRegDialog.this.cancelImages();
                        turboRegDialog.this.createImages();
                        turboRegDialog.this.startThreads();
                    } else {
                        transformation = 6;
                        turboRegDialog.this.setTransformation();
                    }
                }
                turboRegDialog.this.repaint();
            }
        });
        this.bilinear.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (turboRegDialog.this.transformationGroup.getSelectedCheckbox().getLabel().equals("Bilinear") && transformation != 8) {
                    transformation = 8;
                    turboRegDialog.this.cancelImages();
                    turboRegDialog.this.createImages();
                    turboRegDialog.this.startThreads();
                }
                turboRegDialog.this.repaint();
            }
        });
        transformationPanel.add(this.translation);
        transformationPanel.add(this.rigidBody);
        transformationPanel.add(this.scaledRotation);
        transformationPanel.add(this.affine);
        transformationPanel.add(this.bilinear);
        Panel pointPanel = new Panel();
        pointPanel.setLayout(new FlowLayout(1));
        Label pointLabel = new Label("Landmarks: ");
        Button loadButton = new Button("Load...");
        loadButton.addActionListener(this);
        Button saveButton = new Button("Save Now...");
        saveButton.addActionListener(this);
        final Checkbox saveCheck = new Checkbox("Save on Exit", saveOnExit);
        saveCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                saveOnExit = saveCheck.getState();
                turboRegDialog.this.repaint();
            }
        });
        pointPanel.add(pointLabel);
        pointPanel.add(loadButton);
        pointPanel.add(saveButton);
        pointPanel.add(saveCheck);
        Panel accelerationPanel = new Panel();
        accelerationPanel.setLayout(new FlowLayout(1));
        Label acceleratedLabel = new Label("Quality: ");
        final CheckboxGroup accelerationGroup = new CheckboxGroup();
        Checkbox fast = new Checkbox("Fast", accelerationGroup, accelerated);
        Checkbox accurate = new Checkbox("Accurate", accelerationGroup, !accelerated);
        fast.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (accelerationGroup.getSelectedCheckbox().getLabel().equals("Fast")) {
                    accelerated = true;
                }
                turboRegDialog.this.automaticButton.setEnabled(!accelerated || 1 < turboRegDialog.this.pyramidDepth);
                turboRegDialog.this.repaint();
            }
        });
        accurate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (accelerationGroup.getSelectedCheckbox().getLabel().equals("Accurate")) {
                    accelerated = false;
                }
                turboRegDialog.this.automaticButton.setEnabled(!accelerated || 1 < turboRegDialog.this.pyramidDepth);
                turboRegDialog.this.repaint();
            }
        });
        accelerationPanel.add(acceleratedLabel);
        accelerationPanel.add(fast);
        accelerationPanel.add(accurate);
        Panel creditsPanel = new Panel();
        creditsPanel.setLayout(new FlowLayout(1));
        Button creditsButton = new Button("Credits...");
        creditsButton.addActionListener(this);
        creditsPanel.add(creditsButton);
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout(1));
        Button cancelButton = new Button("Cancel");
        cancelButton.addActionListener(this);
        Button manualButton = new Button("Manual");
        manualButton.addActionListener(this);
        this.automaticButton.addActionListener(this);
        this.batchButton.setEnabled(1 < this.sourceImp.getStackSize() && !this.sourceImp.getStack().isRGB() && !this.targetImp.getStack().isRGB());
        this.batchButton.addActionListener(this);
        buttonPanel.add(cancelButton);
        buttonPanel.add(manualButton);
        buttonPanel.add(this.automaticButton);
        buttonPanel.add(this.batchButton);
        Label separation1 = new Label("");
        Label separation2 = new Label("");
        this.add(separation1);
        this.add(sourcePanel);
        this.add(targetPanel);
        this.add(transformationPanel);
        this.add(pointPanel);
        this.add(accelerationPanel);
        this.add(separation2);
        this.add(buttonPanel);
        this.add(creditsPanel);
        this.pack();
    }

    public void joinThreads() {
        try {
            this.sourceImg.getThread().join();
            this.sourceMsk.getThread().join();
            this.targetImg.getThread().join();
            this.targetMsk.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
        }
    }

    public void restoreAll() {
        this.cancelImages();
        this.tb.restorePreviousToolbar();
        Toolbar.getInstance().repaint();
        turboRegProgressBar.resetProgressBar();
        Runtime.getRuntime().gc();
    }

    public void stopThreads() {
        this.stopSourceThreads();
        this.stopTargetThreads();
    }

    private void cancelImages() {
        this.cancelSource();
        this.cancelTarget();
    }

    private void cancelSource() {
        this.cancelSource(this.sourcePh);
        this.sourcePh = null;
        Runtime.getRuntime().gc();
    }

    private double[][] cancelSource(turboRegPointHandler sourcePh) {
        this.stopSourceThreads();
        if (this.sourceScrollbar != null) {
            this.sourceScrollbar.removeAdjustmentListener(this.sourcePa);
            this.sourceScrollbar = null;
        }
        ImageWindow iw = this.sourceImp.getWindow();
        iw.removeKeyListener((KeyListener)this.sourcePa);
        this.sourceIc.removeKeyListener((KeyListener)this.sourcePa);
        this.sourceIc.removeMouseMotionListener((MouseMotionListener)this.sourcePa);
        this.sourceIc.removeMouseListener((MouseListener)this.sourcePa);
        this.sourceIc.addMouseListener((MouseListener)this.sourceIc);
        this.sourceIc.addMouseMotionListener((MouseMotionListener)this.sourceIc);
        this.sourceIc.addKeyListener((KeyListener)IJ.getInstance());
        iw.addKeyListener((KeyListener)IJ.getInstance());
        this.sourceIc = null;
        this.sourceImp.killRoi();
        this.sourceImp.updateAndDraw();
        this.sourceImp = null;
        this.sourceImg = null;
        this.sourceMsk = null;
        this.sourcePa = null;
        this.sourceScrollbar = null;
        return sourcePh.getPoints();
    }

    private void cancelTarget() {
        this.cancelTarget(this.targetPh);
        this.targetPh = null;
        Runtime.getRuntime().gc();
    }

    private double[][] cancelTarget(turboRegPointHandler targetPh) {
        this.stopTargetThreads();
        if (this.targetScrollbar != null) {
            this.targetScrollbar.removeAdjustmentListener(this.targetPa);
            this.targetScrollbar = null;
        }
        ImageWindow iw = this.targetImp.getWindow();
        iw.removeKeyListener((KeyListener)this.targetPa);
        this.targetIc.removeKeyListener((KeyListener)this.targetPa);
        this.targetIc.removeMouseMotionListener((MouseMotionListener)this.targetPa);
        this.targetIc.removeMouseListener((MouseListener)this.targetPa);
        this.targetIc.addMouseListener((MouseListener)this.targetIc);
        this.targetIc.addMouseMotionListener((MouseMotionListener)this.targetIc);
        this.targetIc.addKeyListener((KeyListener)IJ.getInstance());
        iw.addKeyListener((KeyListener)IJ.getInstance());
        this.targetIc = null;
        this.targetImp.killRoi();
        this.targetImp.updateAndDraw();
        this.targetImp = null;
        this.targetImg = null;
        this.targetMsk = null;
        this.targetPa = null;
        this.targetScrollbar = null;
        return targetPh.getPoints();
    }

    private void createImages() {
        this.createSourceImages();
        this.createTargetImages();
        this.sourcePa.setSecondaryPointHandler(this.targetImp, this.targetPh);
        this.targetPa.setSecondaryPointHandler(this.sourceImp, this.sourcePh);
        this.getPyramidDepth();
        this.sourceImg.setPyramidDepth(this.pyramidDepth);
        this.sourceMsk.setPyramidDepth(this.pyramidDepth);
        this.targetImg.setPyramidDepth(this.pyramidDepth);
        this.targetMsk.setPyramidDepth(this.pyramidDepth);
    }

    private void createSourceImages() {
        this.sourceImp = this.admissibleImageList[this.sourceChoiceIndex];
        if (this.sourceImp.getStack().isRGB()) {
            this.sourceBlack.setEnabled(false);
            this.sourceRed.setEnabled(true);
            this.sourceGreen.setEnabled(true);
            this.sourceBlue.setEnabled(true);
            switch (sourceColorPlane) {
                case 1: {
                    this.sourceKrgbGroup.setSelectedCheckbox(this.sourceRed);
                    break;
                }
                case 2: {
                    this.sourceKrgbGroup.setSelectedCheckbox(this.sourceGreen);
                    break;
                }
                case 3: {
                    this.sourceKrgbGroup.setSelectedCheckbox(this.sourceBlue);
                }
            }
            this.sourceImp.setSlice(sourceColorPlane);
            this.sourceImg = new turboRegImage(this.sourceImp, transformation, false);
            this.sourceMsk = new turboRegMask(this.sourceImp);
            this.sourceMsk.clearMask();
        } else {
            this.sourceBlack.setEnabled(true);
            this.sourceRed.setEnabled(false);
            this.sourceGreen.setEnabled(false);
            this.sourceBlue.setEnabled(false);
            this.sourceKrgbGroup.setSelectedCheckbox(this.sourceBlack);
            sourceColorPlane = 0;
            this.sourceImp.setSlice(1);
            this.sourceImg = new turboRegImage(this.sourceImp, transformation, false);
            if (2 <= this.sourceImp.getStackSize()) {
                this.sourceImp.setSlice(2);
            }
            this.sourceMsk = new turboRegMask(this.sourceImp);
            this.sourceImp.setSlice(1);
            if (this.sourceImp.getStackSize() < 2) {
                this.sourceMsk.clearMask();
            }
        }
        ImageWindow iw = this.sourceImp.getWindow();
        this.sourceIc = iw.getCanvas();
        iw.removeKeyListener((KeyListener)IJ.getInstance());
        this.sourceIc.removeKeyListener((KeyListener)IJ.getInstance());
        this.sourceIc.removeMouseMotionListener((MouseMotionListener)this.sourceIc);
        this.sourceIc.removeMouseListener((MouseListener)this.sourceIc);
        this.sourcePh = new turboRegPointHandler(this.sourceImp, transformation);
        this.sourcePa = new turboRegPointAction(this.sourceImp, this.sourcePh, this.tb);
        this.sourceIc.addMouseListener((MouseListener)this.sourcePa);
        this.sourceIc.addMouseMotionListener((MouseMotionListener)this.sourcePa);
        this.sourceIc.addKeyListener((KeyListener)this.sourcePa);
        iw.addKeyListener((KeyListener)this.sourcePa);
        if (this.sourceImp.getWindow() instanceof StackWindow) {
            StackWindow sw = (StackWindow)this.sourceImp.getWindow();
            Component[] component = sw.getComponents();
            for (int i2 = 0; i2 < component.length; ++i2) {
                if (!(component[i2] instanceof Scrollbar)) continue;
                this.sourceScrollbar = (Scrollbar)component[i2];
                this.sourceScrollbar.addAdjustmentListener(this.sourcePa);
            }
        } else {
            this.sourceScrollbar = null;
        }
        this.sourceImp.updateAndDraw();
    }

    private void createTargetImages() {
        this.targetImp = this.admissibleImageList[this.targetChoiceIndex];
        if (this.targetImp.getStack().isRGB()) {
            this.targetBlack.setEnabled(false);
            this.targetRed.setEnabled(true);
            this.targetGreen.setEnabled(true);
            this.targetBlue.setEnabled(true);
            switch (targetColorPlane) {
                case 1: {
                    this.targetKrgbGroup.setSelectedCheckbox(this.targetRed);
                    break;
                }
                case 2: {
                    this.targetKrgbGroup.setSelectedCheckbox(this.targetGreen);
                    break;
                }
                case 3: {
                    this.targetKrgbGroup.setSelectedCheckbox(this.targetBlue);
                }
            }
            this.targetImp.setSlice(targetColorPlane);
            this.targetImg = new turboRegImage(this.targetImp, transformation, true);
            this.targetMsk = new turboRegMask(this.targetImp);
            this.targetMsk.clearMask();
        } else {
            this.targetBlack.setEnabled(true);
            this.targetRed.setEnabled(false);
            this.targetGreen.setEnabled(false);
            this.targetBlue.setEnabled(false);
            this.targetKrgbGroup.setSelectedCheckbox(this.targetBlack);
            targetColorPlane = 0;
            this.targetImp.setSlice(1);
            this.targetImg = new turboRegImage(this.targetImp, transformation, true);
            if (2 <= this.targetImp.getStackSize()) {
                this.targetImp.setSlice(2);
            }
            this.targetMsk = new turboRegMask(this.targetImp);
            this.targetImp.setSlice(1);
            if (this.targetImp.getStackSize() < 2) {
                this.targetMsk.clearMask();
            }
        }
        ImageWindow iw = this.targetImp.getWindow();
        this.targetIc = iw.getCanvas();
        iw.removeKeyListener((KeyListener)IJ.getInstance());
        this.targetIc.removeKeyListener((KeyListener)IJ.getInstance());
        this.targetIc.removeMouseMotionListener((MouseMotionListener)this.targetIc);
        this.targetIc.removeMouseListener((MouseListener)this.targetIc);
        this.targetPh = new turboRegPointHandler(this.targetImp, transformation);
        this.targetPa = new turboRegPointAction(this.targetImp, this.targetPh, this.tb);
        this.targetIc.addMouseListener((MouseListener)this.targetPa);
        this.targetIc.addMouseMotionListener((MouseMotionListener)this.targetPa);
        this.targetIc.addKeyListener((KeyListener)this.targetPa);
        iw.addKeyListener((KeyListener)this.targetPa);
        if (this.targetImp.getWindow() instanceof StackWindow) {
            StackWindow sw = (StackWindow)this.targetImp.getWindow();
            Component[] component = sw.getComponents();
            for (int i2 = 0; i2 < component.length; ++i2) {
                if (!(component[i2] instanceof Scrollbar)) continue;
                this.targetScrollbar = (Scrollbar)component[i2];
                this.targetScrollbar.addAdjustmentListener(this.targetPa);
            }
        } else {
            this.targetScrollbar = null;
        }
        this.targetImp.updateAndDraw();
    }

    private void defaultSourceColorPlane() {
        this.sourceImp = this.admissibleImageList[this.sourceChoiceIndex];
        sourceColorPlane = this.sourceImp.getStack().isRGB() ? this.sourceImp.getCurrentSlice() : 0;
    }

    private void defaultTargetColorPlane() {
        this.targetImp = this.admissibleImageList[this.targetChoiceIndex];
        targetColorPlane = this.targetImp.getStack().isRGB() ? this.targetImp.getCurrentSlice() : 0;
    }

    private void getPyramidDepth() {
        int sw = this.sourceImp.getWidth();
        int sh = this.sourceImp.getHeight();
        int tw = this.targetImp.getWidth();
        int th = this.targetImp.getHeight();
        int minsize = 24;
        this.pyramidDepth = 1;
        while (minsize <= sw && minsize <= sh && minsize <= tw && minsize <= th) {
            sw >>= 1;
            sh >>= 1;
            tw >>= 1;
            th >>= 1;
            ++this.pyramidDepth;
        }
        this.automaticButton.setEnabled(!accelerated || 1 < this.pyramidDepth);
    }

    private boolean loadLandmarks() {
        int transformation;
        Frame f = new Frame();
        FileDialog fd = new FileDialog(f, "Landmarks", 0);
        fd.setVisible(true);
        String path = fd.getDirectory();
        String filename = fd.getFile();
        if (path == null || filename == null) {
            return true;
        }
        double[][] targetPoint = new double[4][2];
        double[][] sourcePoint = new double[4][2];
        try {
            int i2;
            FileReader fr = new FileReader(path + filename);
            BufferedReader br = new BufferedReader(fr);
            int k = 1;
            String line = br.readLine();
            if (!line.equals("Transformation")) {
                fr.close();
                IJ.log((String)("Line " + k + ": 'Transformation'"));
                return false;
            }
            ++k;
            line = br.readLine();
            if (line.equals("TRANSLATION")) {
                transformation = 2;
            } else if (line.equals("RIGID_BODY")) {
                transformation = 3;
            } else if (line.equals("SCALED_ROTATION")) {
                transformation = 4;
            } else if (line.equals("AFFINE")) {
                transformation = 6;
            } else if (line.equals("BILINEAR")) {
                transformation = 8;
            } else {
                fr.close();
                IJ.log((String)("Line " + k + ": 'TRANSLATION' | 'RIGID_BODY' | 'SCALED_ROTATION' | 'AFFINE' | 'BILINEAR'"));
                return false;
            }
            ++k;
            line = br.readLine();
            if (!line.equals("")) {
                fr.close();
                IJ.log((String)("Line " + k + ": ''"));
                return false;
            }
            ++k;
            line = br.readLine();
            if (!line.equals("Source size")) {
                fr.close();
                IJ.log((String)("Line " + k + ": 'Source size'"));
                return false;
            }
            ++k;
            line = br.readLine();
            if (line == null) {
                fr.close();
                IJ.log((String)("Line " + k + ": #sourceWidth# <tab> #sourceHeight#"));
                return false;
            }
            int separatorIndex = (line = line.trim()).indexOf(9);
            if (separatorIndex == -1) {
                fr.close();
                IJ.log((String)("Line " + k + ": #sourceWidth# <tab> #sourceHeight#"));
                return false;
            }
            String xString = line.substring(0, separatorIndex);
            String yString = line.substring(separatorIndex);
            xString = xString.trim();
            yString = yString.trim();
            if (Integer.parseInt(xString) != this.sourceImp.getWidth()) {
                fr.close();
                IJ.log((String)("Line " + k + ": The source width should not differ from that in the landmarks file"));
                return false;
            }
            if (Integer.parseInt(yString) != this.sourceImp.getHeight()) {
                fr.close();
                IJ.log((String)("Line " + k + ": The source height should not differ from that in the landmarks file"));
                return false;
            }
            ++k;
            line = br.readLine();
            if (!line.isEmpty()) {
                fr.close();
                IJ.log((String)("Line " + k + ": ''"));
                return false;
            }
            ++k;
            line = br.readLine();
            if (!line.equals("Target size")) {
                fr.close();
                IJ.log((String)("Line " + k + ": 'Target size'"));
                return false;
            }
            ++k;
            line = br.readLine();
            if (line == null) {
                fr.close();
                IJ.log((String)("Line " + k + ": #targetWidth# <tab> #targetHeight#"));
                return false;
            }
            separatorIndex = (line = line.trim()).indexOf(9);
            if (separatorIndex == -1) {
                fr.close();
                IJ.log((String)("Line " + k + ": #targetWidth# <tab> #targetHeight#"));
                return false;
            }
            xString = line.substring(0, separatorIndex);
            yString = line.substring(separatorIndex);
            xString = xString.trim();
            yString = yString.trim();
            if (Integer.parseInt(xString) != this.targetImp.getWidth()) {
                fr.close();
                IJ.log((String)("Line " + k + ": The target width should not differ from that in the landmarks file"));
                return false;
            }
            if (Integer.parseInt(yString) != this.targetImp.getHeight()) {
                fr.close();
                IJ.log((String)("Line " + k + ": The target height should not differ from that in the landmarks file"));
                return false;
            }
            ++k;
            line = br.readLine();
            if (!line.isEmpty()) {
                fr.close();
                IJ.log((String)("Line " + k + ": ''"));
                return false;
            }
            ++k;
            line = br.readLine();
            if (!line.equals("Refined source landmarks")) {
                fr.close();
                IJ.log((String)("Line " + k + ": 'Refined source landmarks'"));
                return false;
            }
            if (transformation == 3) {
                for (i2 = 0; i2 < transformation; ++i2) {
                    ++k;
                    line = br.readLine();
                    if (line == null) {
                        fr.close();
                        IJ.log((String)("Line " + k + ": #xSourcePoint# <tab> #ySourcePoint#"));
                        return false;
                    }
                    separatorIndex = (line = line.trim()).indexOf(9);
                    if (separatorIndex == -1) {
                        fr.close();
                        IJ.log((String)("Line " + k + ": #xSourcePoint# <tab> #ySourcePoint#"));
                        return false;
                    }
                    xString = line.substring(0, separatorIndex);
                    yString = line.substring(separatorIndex);
                    xString = xString.trim();
                    yString = yString.trim();
                    sourcePoint[i2][0] = Double.parseDouble(xString);
                    sourcePoint[i2][1] = Double.parseDouble(yString);
                }
            } else {
                for (i2 = 0; i2 < transformation / 2; ++i2) {
                    ++k;
                    line = br.readLine();
                    if (line == null) {
                        fr.close();
                        IJ.log((String)("Line " + k + ": #xSourcePoint# <tab> #ySourcePoint#"));
                        return false;
                    }
                    separatorIndex = (line = line.trim()).indexOf(9);
                    if (separatorIndex == -1) {
                        fr.close();
                        IJ.log((String)("Line " + k + ": #xSourcePoint# <tab> #ySourcePoint#"));
                        return false;
                    }
                    xString = line.substring(0, separatorIndex);
                    yString = line.substring(separatorIndex);
                    xString = xString.trim();
                    yString = yString.trim();
                    sourcePoint[i2][0] = Double.parseDouble(xString);
                    sourcePoint[i2][1] = Double.parseDouble(yString);
                }
            }
            ++k;
            line = br.readLine();
            if (!line.isEmpty()) {
                fr.close();
                IJ.log((String)("Line " + k + ": ''"));
                return false;
            }
            ++k;
            line = br.readLine();
            if (!line.equals("Target landmarks")) {
                fr.close();
                IJ.log((String)("Line " + k + ": 'Target landmarks'"));
                return false;
            }
            if (transformation == 3) {
                for (i2 = 0; i2 < transformation; ++i2) {
                    ++k;
                    line = br.readLine();
                    if (line == null) {
                        fr.close();
                        IJ.log((String)("Line " + k + ": #xTargetPoint# <tab> #yTargetPoint#"));
                        return false;
                    }
                    separatorIndex = (line = line.trim()).indexOf(9);
                    if (separatorIndex == -1) {
                        fr.close();
                        IJ.log((String)("Line " + k + ": #xTargetPoint# <tab> #yTargetPoint#"));
                        return false;
                    }
                    xString = line.substring(0, separatorIndex);
                    yString = line.substring(separatorIndex);
                    xString = xString.trim();
                    yString = yString.trim();
                    targetPoint[i2][0] = Double.parseDouble(xString);
                    targetPoint[i2][1] = Double.parseDouble(yString);
                }
            } else {
                for (i2 = 0; i2 < transformation / 2; ++i2) {
                    ++k;
                    line = br.readLine();
                    if (line == null) {
                        fr.close();
                        IJ.log((String)("Line " + k + ": #xTargetPoint# <tab> #yTargetPoint#"));
                        return false;
                    }
                    separatorIndex = (line = line.trim()).indexOf(9);
                    if (separatorIndex == -1) {
                        fr.close();
                        IJ.log((String)("Line " + k + ": #xTargetPoint# <tab> #yTargetPoint#"));
                        return false;
                    }
                    xString = line.substring(0, separatorIndex);
                    yString = line.substring(separatorIndex);
                    xString = xString.trim();
                    yString = yString.trim();
                    targetPoint[i2][0] = Double.parseDouble(xString);
                    targetPoint[i2][1] = Double.parseDouble(yString);
                }
            }
            fr.close();
        }
        catch (FileNotFoundException e) {
            IJ.log((String)("File not found exception " + e.getMessage()));
            return false;
        }
        catch (IOException e) {
            IJ.log((String)("IOException exception " + e.getMessage()));
            return false;
        }
        catch (NumberFormatException e) {
            IJ.log((String)("Number format exception " + e.getMessage()));
            return false;
        }
        if (transformation != turboRegDialog.transformation) {
            if (transformation == 8 || turboRegDialog.transformation == 8) {
                this.cancelImages();
                this.createImages();
                this.startThreads();
            }
            turboRegDialog.transformation = transformation;
            this.setTransformation();
        }
        this.sourcePh.setPoints(sourcePoint);
        this.targetPh.setPoints(targetPoint);
        switch (transformation) {
            case 2: {
                this.transformationGroup.setSelectedCheckbox(this.translation);
                break;
            }
            case 3: {
                this.transformationGroup.setSelectedCheckbox(this.rigidBody);
                break;
            }
            case 6: {
                this.transformationGroup.setSelectedCheckbox(this.affine);
                break;
            }
            case 4: {
                this.transformationGroup.setSelectedCheckbox(this.scaledRotation);
                break;
            }
            case 8: {
                this.transformationGroup.setSelectedCheckbox(this.bilinear);
            }
        }
        this.sourceImp.updateAndDraw();
        this.targetImp.updateAndDraw();
        return true;
    }

    private void permuteImages() {
        int rescuedSourceColorPlane = sourceColorPlane;
        int rescuedTargetColorPlane = targetColorPlane;
        double[][] rescuedSourcePoints = this.cancelSource(this.sourcePh);
        double[][] rescuedTargetPoints = this.cancelTarget(this.targetPh);
        sourceColorPlane = rescuedTargetColorPlane;
        targetColorPlane = rescuedSourceColorPlane;
        this.createSourceImages();
        this.sourcePh.setPoints(rescuedTargetPoints);
        this.createTargetImages();
        this.targetPh.setPoints(rescuedSourcePoints);
        this.sourceImp.updateAndDraw();
        this.targetImp.updateAndDraw();
    }

    private void setSourceColorPlane(int colorPlane) {
        sourceColorPlane = colorPlane;
        switch (sourceColorPlane) {
            case 1: {
                this.sourceKrgbGroup.setSelectedCheckbox(this.sourceRed);
                break;
            }
            case 2: {
                this.sourceKrgbGroup.setSelectedCheckbox(this.sourceGreen);
                break;
            }
            case 3: {
                this.sourceKrgbGroup.setSelectedCheckbox(this.sourceBlue);
            }
        }
        this.sourceImp.setSlice(sourceColorPlane);
        this.sourceImg = new turboRegImage(this.sourceImp, transformation, false);
        this.sourceMsk = new turboRegMask(this.sourceImp);
        this.sourceMsk.clearMask();
    }

    private void setTargetColorPlane(int colorPlane) {
        targetColorPlane = colorPlane;
        switch (targetColorPlane) {
            case 1: {
                this.targetKrgbGroup.setSelectedCheckbox(this.targetRed);
                break;
            }
            case 2: {
                this.targetKrgbGroup.setSelectedCheckbox(this.targetGreen);
                break;
            }
            case 3: {
                this.targetKrgbGroup.setSelectedCheckbox(this.targetBlue);
            }
        }
        this.targetImp.setSlice(targetColorPlane);
        this.targetImg = new turboRegImage(this.targetImp, transformation, true);
        this.targetMsk = new turboRegMask(this.targetImp);
        this.targetMsk.clearMask();
    }

    private void setTransformation() {
        this.sourceImg.setTransformation(transformation);
        this.sourcePh.setTransformation(transformation);
        this.targetImg.setTransformation(transformation);
        this.targetPh.setTransformation(transformation);
    }

    private void startSourceThreads() {
        this.getPyramidDepth();
        this.sourceImg.setPyramidDepth(this.pyramidDepth);
        this.sourceMsk.setPyramidDepth(this.pyramidDepth);
        if (this.pyramidDepth != this.targetImg.getPyramidDepth()) {
            ImagePlus imp = this.targetImp;
            double[][] points = this.cancelTarget(this.targetPh);
            this.targetImp = imp;
            this.createTargetImages();
            this.targetPh.setPoints(points);
            this.targetImp.updateAndDraw();
            this.targetImg.setPyramidDepth(this.pyramidDepth);
            this.targetMsk.setPyramidDepth(this.pyramidDepth);
            this.startTargetThreads();
        }
        this.sourceImg.getThread().start();
        this.sourceMsk.getThread().start();
    }

    private void startTargetThreads() {
        this.getPyramidDepth();
        this.targetImg.setPyramidDepth(this.pyramidDepth);
        this.targetMsk.setPyramidDepth(this.pyramidDepth);
        if (this.pyramidDepth != this.sourceImg.getPyramidDepth()) {
            ImagePlus imp = this.sourceImp;
            double[][] points = this.cancelSource(this.sourcePh);
            this.sourceImp = imp;
            this.createSourceImages();
            this.sourcePh.setPoints(points);
            this.sourceImp.updateAndDraw();
            this.sourceImg.setPyramidDepth(this.pyramidDepth);
            this.sourceMsk.setPyramidDepth(this.pyramidDepth);
            this.startSourceThreads();
        }
        this.targetImg.getThread().start();
        this.targetMsk.getThread().start();
    }

    private void startThreads() {
        this.getPyramidDepth();
        this.sourceImg.setPyramidDepth(this.pyramidDepth);
        this.sourceMsk.setPyramidDepth(this.pyramidDepth);
        this.sourceImg.getThread().start();
        this.sourceMsk.getThread().start();
        this.targetImg.setPyramidDepth(this.pyramidDepth);
        this.targetMsk.setPyramidDepth(this.pyramidDepth);
        this.targetImg.getThread().start();
        this.targetMsk.getThread().start();
    }

    private void stopSourceThreads() {
        while (this.sourceImg.getThread().isAlive()) {
            this.sourceImg.getThread().interrupt();
        }
        this.sourceImg.getThread();
        Thread.interrupted();
        while (this.sourceMsk.getThread().isAlive()) {
            this.sourceMsk.getThread().interrupt();
        }
        this.sourceMsk.getThread();
        Thread.interrupted();
    }

    private void stopTargetThreads() {
        while (this.targetImg.getThread().isAlive()) {
            this.targetImg.getThread().interrupt();
        }
        this.targetImg.getThread();
        Thread.interrupted();
        while (this.targetMsk.getThread().isAlive()) {
            this.targetMsk.getThread().interrupt();
        }
        this.targetMsk.getThread();
        Thread.interrupted();
    }
}

