/*
 * Decompiled with CFR 0.152.
 */
package registration.turboregold;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GUI;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Stack;
import java.util.Vector;
import registration.turboregold.turboRegDialog;
import registration.turboregold.turboRegFinalAction;
import registration.turboregold.turboRegImage;
import registration.turboregold.turboRegMask;
import registration.turboregold.turboRegPointHandler;
import registration.turboregold.turboRegTransform;

public class TurboReg
implements PlugIn {
    private double[][] sourcePoints = new double[4][2];
    private double[][] targetPoints = new double[4][2];
    private ImagePlus transformedImage = null;
    public static final int AFFINE = 6;
    public static final int BILINEAR = 8;
    public static final int RIGID_BODY = 3;
    public static final int SCALED_ROTATION = 4;
    public static final int TRANSLATION = 2;

    public void run(String commandLine) {
        String options = Macro.getOptions();
        if (!commandLine.isEmpty()) {
            options = commandLine;
        }
        if (options == null) {
            Runtime.getRuntime().gc();
            ImagePlus[] admissibleImageList = this.createAdmissibleImageList();
            if (admissibleImageList.length < 2) {
                IJ.error((String)"At least two grayscale or RGB-stack images are required");
                return;
            }
            turboRegDialog dialog = new turboRegDialog((Frame)IJ.getInstance(), admissibleImageList);
            GUI.center((Window)dialog);
            dialog.setVisible(true);
        } else {
            String[] token = this.getTokens(options);
            if (token.length < 1) {
                this.dumpSyntax(options);
                IJ.error((String)"Invalid syntax");
                return;
            }
            if (token[0].equals("-help")) {
                this.dumpSyntax(options);
            } else if (token[0].equals("-align")) {
                switch (token.length) {
                    case 19: 
                    case 23: 
                    case 27: 
                    case 31: {
                        break;
                    }
                    default: {
                        this.dumpSyntax(options);
                        IJ.error((String)"Invalid syntax");
                        return;
                    }
                }
                ImagePlus source = null;
                int[] sourceCrop = new int[4];
                ImagePlus target = null;
                int[] targetCrop = new int[4];
                int transformation = -1;
                Boolean interactive = null;
                try {
                    int k;
                    if (token[1].equals("-file")) {
                        source = new ImagePlus(token[2]);
                    } else if (token[1].equals("-window")) {
                        int[] IDlist = WindowManager.getIDList();
                        if (IDlist == null) {
                            source = null;
                        } else {
                            for (k = 0; k < IDlist.length && !(source = WindowManager.getImage((int)IDlist[k])).getTitle().equals(token[2]); ++k) {
                                source = null;
                            }
                        }
                    } else {
                        this.dumpSyntax(options);
                        IJ.error((String)("Invalid reference type: " + token[1]));
                        return;
                    }
                    if (source == null) {
                        this.dumpSyntax(options);
                        IJ.error((String)("Invalid source: " + token[2]));
                        return;
                    }
                    for (int i2 = 0; i2 < 4; ++i2) {
                        sourceCrop[i2] = Integer.parseInt(token[i2 + 3]);
                    }
                    if (token[7].equals("-file")) {
                        target = new ImagePlus(token[8]);
                    } else if (token[7].equals("-window")) {
                        int[] IDlist = WindowManager.getIDList();
                        if (IDlist == null) {
                            target = null;
                        } else {
                            for (k = 0; k < IDlist.length && !(target = WindowManager.getImage((int)IDlist[k])).getTitle().equals(token[8]); ++k) {
                                target = null;
                            }
                        }
                    } else {
                        this.dumpSyntax(options);
                        IJ.error((String)("Invalid reference type: " + token[7]));
                        return;
                    }
                    if (target == null) {
                        this.dumpSyntax(options);
                        IJ.error((String)("Invalid target: " + token[8]));
                        return;
                    }
                    for (int i3 = 0; i3 < 4; ++i3) {
                        targetCrop[i3] = Integer.parseInt(token[i3 + 9]);
                    }
                    transformation = this.getTransformation(token[13]);
                    switch (transformation) {
                        case 2: {
                            if (token.length != 19) {
                                this.dumpSyntax(options);
                                IJ.error((String)"Invalid number of source and target points");
                                return;
                            }
                            this.sourcePoints[0][0] = Double.parseDouble(token[14]);
                            this.sourcePoints[0][1] = Double.parseDouble(token[15]);
                            this.targetPoints[0][0] = Double.parseDouble(token[16]);
                            this.targetPoints[0][1] = Double.parseDouble(token[17]);
                            interactive = this.getInteractive(token[18]);
                            break;
                        }
                        case 4: {
                            if (token.length != 23) {
                                this.dumpSyntax(options);
                                IJ.error((String)"Invalid number of source and target points");
                                return;
                            }
                            this.sourcePoints[0][0] = Double.parseDouble(token[14]);
                            this.sourcePoints[0][1] = Double.parseDouble(token[15]);
                            this.targetPoints[0][0] = Double.parseDouble(token[16]);
                            this.targetPoints[0][1] = Double.parseDouble(token[17]);
                            this.sourcePoints[1][0] = Double.parseDouble(token[18]);
                            this.sourcePoints[1][1] = Double.parseDouble(token[19]);
                            this.targetPoints[1][0] = Double.parseDouble(token[20]);
                            this.targetPoints[1][1] = Double.parseDouble(token[21]);
                            interactive = this.getInteractive(token[22]);
                            break;
                        }
                        case 3: 
                        case 6: {
                            if (token.length != 27) {
                                this.dumpSyntax(options);
                                IJ.error((String)"Invalid number of source and target points");
                                return;
                            }
                            this.sourcePoints[0][0] = Double.parseDouble(token[14]);
                            this.sourcePoints[0][1] = Double.parseDouble(token[15]);
                            this.targetPoints[0][0] = Double.parseDouble(token[16]);
                            this.targetPoints[0][1] = Double.parseDouble(token[17]);
                            this.sourcePoints[1][0] = Double.parseDouble(token[18]);
                            this.sourcePoints[1][1] = Double.parseDouble(token[19]);
                            this.targetPoints[1][0] = Double.parseDouble(token[20]);
                            this.targetPoints[1][1] = Double.parseDouble(token[21]);
                            this.sourcePoints[2][0] = Double.parseDouble(token[22]);
                            this.sourcePoints[2][1] = Double.parseDouble(token[23]);
                            this.targetPoints[2][0] = Double.parseDouble(token[24]);
                            this.targetPoints[2][1] = Double.parseDouble(token[25]);
                            interactive = this.getInteractive(token[26]);
                            break;
                        }
                        case 8: {
                            if (token.length != 31) {
                                this.dumpSyntax(options);
                                IJ.error((String)"Invalid number of source and target points");
                                return;
                            }
                            this.sourcePoints[0][0] = Double.parseDouble(token[14]);
                            this.sourcePoints[0][1] = Double.parseDouble(token[15]);
                            this.targetPoints[0][0] = Double.parseDouble(token[16]);
                            this.targetPoints[0][1] = Double.parseDouble(token[17]);
                            this.sourcePoints[1][0] = Double.parseDouble(token[18]);
                            this.sourcePoints[1][1] = Double.parseDouble(token[19]);
                            this.targetPoints[1][0] = Double.parseDouble(token[20]);
                            this.targetPoints[1][1] = Double.parseDouble(token[21]);
                            this.sourcePoints[2][0] = Double.parseDouble(token[22]);
                            this.sourcePoints[2][1] = Double.parseDouble(token[23]);
                            this.targetPoints[2][0] = Double.parseDouble(token[24]);
                            this.targetPoints[2][1] = Double.parseDouble(token[25]);
                            this.sourcePoints[3][0] = Double.parseDouble(token[26]);
                            this.sourcePoints[3][1] = Double.parseDouble(token[27]);
                            this.targetPoints[3][0] = Double.parseDouble(token[28]);
                            this.targetPoints[3][1] = Double.parseDouble(token[29]);
                            interactive = this.getInteractive(token[30]);
                            break;
                        }
                        default: {
                            this.dumpSyntax(options);
                            IJ.error((String)"Invalid transformation");
                            return;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    this.dumpSyntax(options);
                    IJ.log((String)("Number format exception " + e.getMessage()));
                    IJ.error((String)"Invalid syntax");
                    return;
                }
                if (interactive == null) {
                    this.dumpSyntax(options);
                    IJ.error((String)"Invalid directive for interactivity");
                    return;
                }
                this.transformedImage = this.alignImages(source, sourceCrop, target, targetCrop, transformation, interactive);
            } else if (token[0].equals("-transform")) {
                switch (token.length) {
                    case 11: 
                    case 15: 
                    case 19: 
                    case 23: {
                        break;
                    }
                    default: {
                        this.dumpSyntax(options);
                        IJ.error((String)"Invalid syntax");
                        return;
                    }
                }
                ImagePlus source = null;
                int outputWidth = -1;
                int outputHeight = -1;
                int transformation = -1;
                Boolean interactive = null;
                try {
                    if (token[1].equals("-file")) {
                        source = new ImagePlus(token[2]);
                    } else if (token[1].equals("-window")) {
                        int[] IDlist = WindowManager.getIDList();
                        for (int k = 0; k < IDlist.length && !(source = WindowManager.getImage((int)IDlist[k])).getTitle().equals(token[2]); ++k) {
                            source = null;
                        }
                    } else {
                        this.dumpSyntax(options);
                        IJ.error((String)("Invalid reference type: " + token[1]));
                        return;
                    }
                    if (source == null) {
                        this.dumpSyntax(options);
                        IJ.error((String)("Invalid source: " + token[2]));
                        return;
                    }
                    outputWidth = Integer.parseInt(token[3]);
                    if (outputWidth <= 0) {
                        this.dumpSyntax(options);
                        IJ.error((String)("Invalid output width: " + token[3]));
                        return;
                    }
                    outputHeight = Integer.parseInt(token[4]);
                    if (outputHeight <= 0) {
                        this.dumpSyntax(options);
                        IJ.error((String)("Invalid output height: " + token[4]));
                        return;
                    }
                    transformation = this.getTransformation(token[5]);
                    switch (transformation) {
                        case 2: {
                            if (token.length != 11) {
                                this.dumpSyntax(options);
                                IJ.error((String)"Invalid number of source and target points");
                                return;
                            }
                            this.sourcePoints[0][0] = Double.parseDouble(token[6]);
                            this.sourcePoints[0][1] = Double.parseDouble(token[7]);
                            this.targetPoints[0][0] = Double.parseDouble(token[8]);
                            this.targetPoints[0][1] = Double.parseDouble(token[9]);
                            interactive = this.getInteractive(token[10]);
                            break;
                        }
                        case 4: {
                            if (token.length != 15) {
                                this.dumpSyntax(options);
                                IJ.error((String)"Invalid number of source and target points");
                                return;
                            }
                            this.sourcePoints[0][0] = Double.parseDouble(token[6]);
                            this.sourcePoints[0][1] = Double.parseDouble(token[7]);
                            this.targetPoints[0][0] = Double.parseDouble(token[8]);
                            this.targetPoints[0][1] = Double.parseDouble(token[9]);
                            this.sourcePoints[1][0] = Double.parseDouble(token[10]);
                            this.sourcePoints[1][1] = Double.parseDouble(token[11]);
                            this.targetPoints[1][0] = Double.parseDouble(token[12]);
                            this.targetPoints[1][1] = Double.parseDouble(token[13]);
                            interactive = this.getInteractive(token[14]);
                            break;
                        }
                        case 3: 
                        case 6: {
                            if (token.length != 19) {
                                this.dumpSyntax(options);
                                IJ.error((String)"Invalid number of source and target points");
                                return;
                            }
                            this.sourcePoints[0][0] = Double.parseDouble(token[6]);
                            this.sourcePoints[0][1] = Double.parseDouble(token[7]);
                            this.targetPoints[0][0] = Double.parseDouble(token[8]);
                            this.targetPoints[0][1] = Double.parseDouble(token[9]);
                            this.sourcePoints[1][0] = Double.parseDouble(token[10]);
                            this.sourcePoints[1][1] = Double.parseDouble(token[11]);
                            this.targetPoints[1][0] = Double.parseDouble(token[12]);
                            this.targetPoints[1][1] = Double.parseDouble(token[13]);
                            this.sourcePoints[2][0] = Double.parseDouble(token[14]);
                            this.sourcePoints[2][1] = Double.parseDouble(token[15]);
                            this.targetPoints[2][0] = Double.parseDouble(token[16]);
                            this.targetPoints[2][1] = Double.parseDouble(token[17]);
                            interactive = this.getInteractive(token[18]);
                            break;
                        }
                        case 8: {
                            if (token.length != 23) {
                                this.dumpSyntax(options);
                                IJ.error((String)"Invalid number of source and target points");
                                return;
                            }
                            this.sourcePoints[0][0] = Double.parseDouble(token[6]);
                            this.sourcePoints[0][1] = Double.parseDouble(token[7]);
                            this.targetPoints[0][0] = Double.parseDouble(token[8]);
                            this.targetPoints[0][1] = Double.parseDouble(token[9]);
                            this.sourcePoints[1][0] = Double.parseDouble(token[10]);
                            this.sourcePoints[1][1] = Double.parseDouble(token[11]);
                            this.targetPoints[1][0] = Double.parseDouble(token[12]);
                            this.targetPoints[1][1] = Double.parseDouble(token[13]);
                            this.sourcePoints[2][0] = Double.parseDouble(token[14]);
                            this.sourcePoints[2][1] = Double.parseDouble(token[15]);
                            this.targetPoints[2][0] = Double.parseDouble(token[16]);
                            this.targetPoints[2][1] = Double.parseDouble(token[17]);
                            this.sourcePoints[3][0] = Double.parseDouble(token[18]);
                            this.sourcePoints[3][1] = Double.parseDouble(token[19]);
                            this.targetPoints[3][0] = Double.parseDouble(token[20]);
                            this.targetPoints[3][1] = Double.parseDouble(token[21]);
                            interactive = this.getInteractive(token[22]);
                            break;
                        }
                        default: {
                            this.dumpSyntax(options);
                            IJ.error((String)"Invalid transformation");
                            return;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    this.dumpSyntax(options);
                    IJ.log((String)("Number format exception " + e.getMessage()));
                    IJ.error((String)"Invalid syntax");
                    return;
                }
                if (interactive == null) {
                    this.dumpSyntax(options);
                    IJ.error((String)"Invalid directive for interactivity");
                    return;
                }
                this.transformedImage = this.transformImage(source, outputWidth, outputHeight, transformation, interactive);
            } else {
                this.dumpSyntax(options);
                IJ.error((String)"Invalid operation");
            }
        }
    }

    public void Align(ImagePlus source, int transformation, ImagePlus target, int ... coordinates) {
        switch (coordinates.length) {
            case 12: 
            case 17: 
            case 20: 
            case 24: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Number of parameters incorrect.");
            }
        }
        int[] sourceCrop = new int[4];
        int[] targetCrop = new int[4];
        System.arraycopy(coordinates, 0, sourceCrop, 0, 4);
        System.arraycopy(coordinates, 4, targetCrop, 0, 4);
        switch (transformation) {
            case 2: {
                if (coordinates.length != 12) {
                    throw new IllegalArgumentException("12 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[8];
                this.sourcePoints[0][1] = coordinates[9];
                this.targetPoints[0][0] = coordinates[10];
                this.targetPoints[0][1] = coordinates[11];
                break;
            }
            case 4: {
                if (coordinates.length != 16) {
                    throw new IllegalArgumentException("17 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[8];
                this.sourcePoints[0][1] = coordinates[9];
                this.targetPoints[0][0] = coordinates[10];
                this.targetPoints[0][1] = coordinates[11];
                this.sourcePoints[1][0] = coordinates[12];
                this.sourcePoints[1][1] = coordinates[13];
                this.targetPoints[1][0] = coordinates[14];
                this.targetPoints[1][1] = coordinates[15];
                break;
            }
            case 3: 
            case 6: {
                if (coordinates.length != 20) {
                    throw new IllegalArgumentException("20 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[8];
                this.sourcePoints[0][1] = coordinates[9];
                this.targetPoints[0][0] = coordinates[10];
                this.targetPoints[0][1] = coordinates[11];
                this.sourcePoints[1][0] = coordinates[12];
                this.sourcePoints[1][1] = coordinates[13];
                this.targetPoints[1][0] = coordinates[14];
                this.targetPoints[1][1] = coordinates[15];
                this.sourcePoints[2][0] = coordinates[16];
                this.sourcePoints[2][1] = coordinates[17];
                this.targetPoints[2][0] = coordinates[18];
                this.targetPoints[2][1] = coordinates[19];
                break;
            }
            case 8: {
                if (coordinates.length != 24) {
                    throw new IllegalArgumentException("24 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[8];
                this.sourcePoints[0][1] = coordinates[9];
                this.targetPoints[0][0] = coordinates[10];
                this.targetPoints[0][1] = coordinates[11];
                this.sourcePoints[1][0] = coordinates[12];
                this.sourcePoints[1][1] = coordinates[13];
                this.targetPoints[1][0] = coordinates[14];
                this.targetPoints[1][1] = coordinates[15];
                this.sourcePoints[2][0] = coordinates[16];
                this.sourcePoints[2][1] = coordinates[17];
                this.targetPoints[2][0] = coordinates[18];
                this.targetPoints[2][1] = coordinates[19];
                this.sourcePoints[3][0] = coordinates[20];
                this.sourcePoints[3][1] = coordinates[21];
                this.targetPoints[3][0] = coordinates[22];
                this.targetPoints[3][1] = coordinates[23];
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid transformation.");
            }
        }
        this.transformedImage = this.alignImages(source, sourceCrop, target, targetCrop, transformation, false);
    }

    public void Transform(ImagePlus source, int transformation, int ... coordinates) {
        switch (coordinates.length) {
            case 4: 
            case 8: 
            case 12: 
            case 16: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameters number.");
            }
        }
        switch (transformation) {
            case 2: {
                if (coordinates.length != 4) {
                    throw new IllegalArgumentException("4 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[0];
                this.sourcePoints[0][1] = coordinates[1];
                this.targetPoints[0][0] = coordinates[2];
                this.targetPoints[0][1] = coordinates[3];
                break;
            }
            case 4: {
                if (coordinates.length != 8) {
                    throw new IllegalArgumentException("8 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[0];
                this.sourcePoints[0][1] = coordinates[1];
                this.targetPoints[0][0] = coordinates[2];
                this.targetPoints[0][1] = coordinates[3];
                this.sourcePoints[1][0] = coordinates[4];
                this.sourcePoints[1][1] = coordinates[5];
                this.targetPoints[1][0] = coordinates[6];
                this.targetPoints[1][1] = coordinates[7];
                break;
            }
            case 3: 
            case 6: {
                if (coordinates.length != 12) {
                    throw new IllegalArgumentException("12 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[0];
                this.sourcePoints[0][1] = coordinates[1];
                this.targetPoints[0][0] = coordinates[2];
                this.targetPoints[0][1] = coordinates[3];
                this.sourcePoints[1][0] = coordinates[4];
                this.sourcePoints[1][1] = coordinates[5];
                this.targetPoints[1][0] = coordinates[6];
                this.targetPoints[1][1] = coordinates[7];
                this.sourcePoints[2][0] = coordinates[8];
                this.sourcePoints[2][1] = coordinates[9];
                this.targetPoints[2][0] = coordinates[10];
                this.targetPoints[2][1] = coordinates[11];
                break;
            }
            case 8: {
                if (coordinates.length != 16) {
                    throw new IllegalArgumentException("16 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[0];
                this.sourcePoints[0][1] = coordinates[1];
                this.targetPoints[0][0] = coordinates[2];
                this.targetPoints[0][1] = coordinates[3];
                this.sourcePoints[1][0] = coordinates[4];
                this.sourcePoints[1][1] = coordinates[5];
                this.targetPoints[1][0] = coordinates[6];
                this.targetPoints[1][1] = coordinates[7];
                this.sourcePoints[2][0] = coordinates[8];
                this.sourcePoints[2][1] = coordinates[9];
                this.targetPoints[2][0] = coordinates[10];
                this.targetPoints[2][1] = coordinates[11];
                this.sourcePoints[3][0] = coordinates[12];
                this.sourcePoints[3][1] = coordinates[13];
                this.targetPoints[3][0] = coordinates[14];
                this.targetPoints[3][1] = coordinates[15];
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid transformation.");
            }
        }
        this.transformedImage = this.transformImage(source, source.getWidth(), source.getHeight(), transformation, false);
    }

    public void Transform(ImagePlus source, int transformation) {
        this.transformedImage = this.transformImage(source, source.getWidth(), source.getHeight(), transformation, false);
    }

    public double[][] getSourcePoints() {
        return this.sourcePoints;
    }

    public double[][] getTargetPoints() {
        return this.targetPoints;
    }

    public ImagePlus getTransformedImage() {
        return this.transformedImage;
    }

    private ImagePlus alignImages(ImagePlus source, int[] sourceCrop, ImagePlus target, int[] targetCrop, int transformation, boolean interactive) {
        if (source.getType() != 1 && source.getType() != 2 && (source.getType() != 0 || source.getStack().isRGB() || source.getStack().isHSB())) {
            IJ.error((String)(source.getTitle() + " should be grayscale (8, 16, or 32 bit)"));
            return null;
        }
        if (target.getType() != 1 && target.getType() != 2 && (target.getType() != 0 || target.getStack().isRGB() || target.getStack().isHSB())) {
            IJ.error((String)(target.getTitle() + " should be grayscale (8, 16, or 32 bit)"));
            return null;
        }
        source.setRoi(sourceCrop[0], sourceCrop[1], sourceCrop[2], sourceCrop[3]);
        target.setRoi(targetCrop[0], targetCrop[1], targetCrop[2], targetCrop[3]);
        source.setSlice(1);
        target.setSlice(1);
        ImagePlus sourceImp = new ImagePlus("source", source.getProcessor().crop());
        ImagePlus targetImp = new ImagePlus("target", target.getProcessor().crop());
        turboRegImage sourceImg = new turboRegImage(sourceImp, transformation, false);
        turboRegImage targetImg = new turboRegImage(targetImp, transformation, true);
        int pyramidDepth = this.getPyramidDepth(sourceImp.getWidth(), sourceImp.getHeight(), targetImp.getWidth(), targetImp.getHeight());
        sourceImg.setPyramidDepth(pyramidDepth);
        targetImg.setPyramidDepth(pyramidDepth);
        sourceImg.getThread().start();
        targetImg.getThread().start();
        if (2 <= source.getStackSize()) {
            source.setSlice(2);
        }
        if (2 <= target.getStackSize()) {
            target.setSlice(2);
        }
        ImagePlus sourceMskImp = new ImagePlus("source mask", source.getProcessor().crop());
        ImagePlus targetMskImp = new ImagePlus("target mask", target.getProcessor().crop());
        turboRegMask sourceMsk = new turboRegMask(sourceMskImp);
        turboRegMask targetMsk = new turboRegMask(targetMskImp);
        source.setSlice(1);
        target.setSlice(1);
        if (source.getStackSize() < 2) {
            sourceMsk.clearMask();
        }
        if (target.getStackSize() < 2) {
            targetMsk.clearMask();
        }
        sourceMsk.setPyramidDepth(pyramidDepth);
        targetMsk.setPyramidDepth(pyramidDepth);
        sourceMsk.getThread().start();
        targetMsk.getThread().start();
        switch (transformation) {
            case 2: {
                double[] dArray = this.sourcePoints[0];
                dArray[0] = dArray[0] - (double)sourceCrop[0];
                double[] dArray2 = this.sourcePoints[0];
                dArray2[1] = dArray2[1] - (double)sourceCrop[1];
                double[] dArray3 = this.targetPoints[0];
                dArray3[0] = dArray3[0] - (double)targetCrop[0];
                double[] dArray4 = this.targetPoints[0];
                dArray4[1] = dArray4[1] - (double)targetCrop[1];
                break;
            }
            case 4: {
                int k;
                for (k = 0; k < 2; ++k) {
                    double[] dArray = this.sourcePoints[k];
                    dArray[0] = dArray[0] - (double)sourceCrop[0];
                    double[] dArray5 = this.sourcePoints[k];
                    dArray5[1] = dArray5[1] - (double)sourceCrop[1];
                    double[] dArray6 = this.targetPoints[k];
                    dArray6[0] = dArray6[0] - (double)targetCrop[0];
                    double[] dArray7 = this.targetPoints[k];
                    dArray7[1] = dArray7[1] - (double)targetCrop[1];
                }
                break;
            }
            case 3: 
            case 6: {
                int k;
                for (k = 0; k < 3; ++k) {
                    double[] dArray = this.sourcePoints[k];
                    dArray[0] = dArray[0] - (double)sourceCrop[0];
                    double[] dArray8 = this.sourcePoints[k];
                    dArray8[1] = dArray8[1] - (double)sourceCrop[1];
                    double[] dArray9 = this.targetPoints[k];
                    dArray9[0] = dArray9[0] - (double)targetCrop[0];
                    double[] dArray10 = this.targetPoints[k];
                    dArray10[1] = dArray10[1] - (double)targetCrop[1];
                }
                break;
            }
            case 8: {
                int k;
                for (k = 0; k < 4; ++k) {
                    double[] dArray = this.sourcePoints[k];
                    dArray[0] = dArray[0] - (double)sourceCrop[0];
                    double[] dArray11 = this.sourcePoints[k];
                    dArray11[1] = dArray11[1] - (double)sourceCrop[1];
                    double[] dArray12 = this.targetPoints[k];
                    dArray12[0] = dArray12[0] - (double)targetCrop[0];
                    double[] dArray13 = this.targetPoints[k];
                    dArray13[1] = dArray13[1] - (double)targetCrop[1];
                }
                break;
            }
        }
        turboRegPointHandler sourcePh = null == sourceImp.getWindow() ? new turboRegPointHandler(transformation, sourceImp) : new turboRegPointHandler(sourceImp, transformation);
        turboRegPointHandler targetPh = null == sourceImp.getWindow() ? new turboRegPointHandler(transformation, targetImp) : new turboRegPointHandler(targetImp, transformation);
        sourcePh.setPoints(this.sourcePoints);
        targetPh.setPoints(this.targetPoints);
        try {
            sourceMsk.getThread().join();
            targetMsk.getThread().join();
            sourceImg.getThread().join();
            targetImg.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
        }
        turboRegFinalAction finalAction = new turboRegFinalAction(sourceImg, sourceMsk, sourcePh, targetImg, targetMsk, targetPh, transformation);
        finalAction.getThread().start();
        try {
            finalAction.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
        }
        this.sourcePoints = sourcePh.getPoints();
        this.targetPoints = targetPh.getPoints();
        ResultsTable table = Analyzer.getResultsTable();
        table.reset();
        switch (transformation) {
            case 2: {
                table.incrementCounter();
                double[] dArray = this.sourcePoints[0];
                dArray[0] = dArray[0] + (double)sourceCrop[0];
                table.addValue("sourceX", this.sourcePoints[0][0]);
                double[] dArray14 = this.sourcePoints[0];
                dArray14[1] = dArray14[1] + (double)sourceCrop[1];
                table.addValue("sourceY", this.sourcePoints[0][1]);
                double[] dArray15 = this.targetPoints[0];
                dArray15[0] = dArray15[0] + (double)targetCrop[0];
                table.addValue("targetX", this.targetPoints[0][0]);
                double[] dArray16 = this.targetPoints[0];
                dArray16[1] = dArray16[1] + (double)targetCrop[1];
                table.addValue("targetY", this.targetPoints[0][1]);
                break;
            }
            case 4: {
                for (int k = 0; k < 2; ++k) {
                    table.incrementCounter();
                    double[] dArray = this.sourcePoints[k];
                    dArray[0] = dArray[0] + (double)sourceCrop[0];
                    table.addValue("sourceX", this.sourcePoints[k][0]);
                    double[] dArray17 = this.sourcePoints[k];
                    dArray17[1] = dArray17[1] + (double)sourceCrop[1];
                    table.addValue("sourceY", this.sourcePoints[k][1]);
                    double[] dArray18 = this.targetPoints[k];
                    dArray18[0] = dArray18[0] + (double)targetCrop[0];
                    table.addValue("targetX", this.targetPoints[k][0]);
                    double[] dArray19 = this.targetPoints[k];
                    dArray19[1] = dArray19[1] + (double)targetCrop[1];
                    table.addValue("targetY", this.targetPoints[k][1]);
                }
                break;
            }
            case 3: 
            case 6: {
                for (int k = 0; k < 3; ++k) {
                    table.incrementCounter();
                    double[] dArray = this.sourcePoints[k];
                    dArray[0] = dArray[0] + (double)sourceCrop[0];
                    table.addValue("sourceX", this.sourcePoints[k][0]);
                    double[] dArray20 = this.sourcePoints[k];
                    dArray20[1] = dArray20[1] + (double)sourceCrop[1];
                    table.addValue("sourceY", this.sourcePoints[k][1]);
                    double[] dArray21 = this.targetPoints[k];
                    dArray21[0] = dArray21[0] + (double)targetCrop[0];
                    table.addValue("targetX", this.targetPoints[k][0]);
                    double[] dArray22 = this.targetPoints[k];
                    dArray22[1] = dArray22[1] + (double)targetCrop[1];
                    table.addValue("targetY", this.targetPoints[k][1]);
                }
                break;
            }
            case 8: {
                for (int k = 0; k < 4; ++k) {
                    table.incrementCounter();
                    double[] dArray = this.sourcePoints[k];
                    dArray[0] = dArray[0] + (double)sourceCrop[0];
                    table.addValue("sourceX", this.sourcePoints[k][0]);
                    double[] dArray23 = this.sourcePoints[k];
                    dArray23[1] = dArray23[1] + (double)sourceCrop[1];
                    table.addValue("sourceY", this.sourcePoints[k][1]);
                    double[] dArray24 = this.targetPoints[k];
                    dArray24[0] = dArray24[0] + (double)targetCrop[0];
                    table.addValue("targetX", this.targetPoints[k][0]);
                    double[] dArray25 = this.targetPoints[k];
                    dArray25[1] = dArray25[1] + (double)targetCrop[1];
                    table.addValue("targetY", this.targetPoints[k][1]);
                }
                break;
            }
            default: {
                throw new Error("Should not occur.");
            }
        }
        if (interactive) {
            table.show("Results");
        }
        source.killRoi();
        target.killRoi();
        return this.transformImage(source, target.getWidth(), target.getHeight(), transformation, interactive);
    }

    private ImagePlus[] createAdmissibleImageList() {
        int[] windowList = WindowManager.getIDList();
        Stack<ImagePlus> stack = new Stack<ImagePlus>();
        for (int k = 0; windowList != null && k < windowList.length; ++k) {
            ImagePlus imp = WindowManager.getImage((int)windowList[k]);
            if (imp == null || imp.getType() != 1 && imp.getType() != 2 && (imp.getType() != 0 || imp.getStack().isHSB())) continue;
            stack.push(imp);
        }
        ImagePlus[] admissibleImageList = new ImagePlus[stack.size()];
        int k = 0;
        while (!stack.isEmpty()) {
            admissibleImageList[k++] = (ImagePlus)stack.pop();
        }
        return admissibleImageList;
    }

    private void dumpSyntax(String options) {
        IJ.log((String)options);
        IJ.log((String)"");
        IJ.log((String)"___");
        IJ.log((String)"");
        IJ.log((String)"ARGUMENTS: { -help | -align | -transform }");
        IJ.log((String)"");
        IJ.log((String)"-help SHOWS THIS MESSAGE");
        IJ.log((String)"");
        IJ.log((String)"-align");
        IJ.log((String)"{ -file | -window }");
        IJ.log((String)"  sourceFilename STRING WITH OPTIONAL QUOTES");
        IJ.log((String)"  sourceWindowTitle STRING WITH OPTIONAL QUOTES");
        IJ.log((String)"sourceCropLeft INTEGER");
        IJ.log((String)"sourceCropTop INTEGER");
        IJ.log((String)"sourceCropRight INTEGER");
        IJ.log((String)"sourceCropBottom INTEGER");
        IJ.log((String)"{ -file | -window }");
        IJ.log((String)"  targetFilename STRING WITH OPTIONAL QUOTES");
        IJ.log((String)"  targetWindowTitle STRING WITH OPTIONAL QUOTES");
        IJ.log((String)"targetCropLeft INTEGER");
        IJ.log((String)"targetCropTop INTEGER");
        IJ.log((String)"targetCropRight INTEGER");
        IJ.log((String)"targetCropBottom INTEGER");
        IJ.log((String)"{ -translation | -rigidBody | -scaledRotation | -affine | -bilinear }");
        IJ.log((String)"sourcePointsX[<*>] FLOATING-POINT");
        IJ.log((String)"sourcePointsY[<*>] FLOATING-POINT");
        IJ.log((String)"targetPointsX[<*>] FLOATING-POINT");
        IJ.log((String)"targetPointsY[<*>] FLOATING-POINT");
        IJ.log((String)"{ -hideOutput | -showOutput }");
        IJ.log((String)"");
        IJ.log((String)"-transform");
        IJ.log((String)"{ -file | -window }");
        IJ.log((String)"  sourceFilename STRING WITH OPTIONAL QUOTES");
        IJ.log((String)"  sourceWindowTitle STRING WITH OPTIONAL QUOTES");
        IJ.log((String)"outputWidth INTEGER");
        IJ.log((String)"outputHeight INTEGER");
        IJ.log((String)"{ -translation | -rigidBody | -scaledRotation | -affine | -bilinear }");
        IJ.log((String)"sourcePointsX[<*>] FLOATING-POINT");
        IJ.log((String)"sourcePointsY[<*>] FLOATING-POINT");
        IJ.log((String)"targetPointsX[<*>] FLOATING-POINT");
        IJ.log((String)"targetPointsY[<*>] FLOATING-POINT");
        IJ.log((String)"{ -hideOutput | -showOutput }");
        IJ.log((String)"");
        IJ.log((String)"<*> FOR TRANSLATION: 1 BLOCK OF FOUR COORDINATES");
        IJ.log((String)"<*> FOR RIGID-BODY: 3 BLOCKS OF FOUR COORDINATES");
        IJ.log((String)"<*> FOR SCALED-ROTATION: 2 BLOCKS OF FOUR COORDINATES");
        IJ.log((String)"<*> FOR AFFINE: 3 BLOCKS OF FOUR COORDINATES");
        IJ.log((String)"<*> FOR BILINEAR: 4 BLOCKS OF FOUR COORDINATES");
        IJ.log((String)"");
        IJ.log((String)"~~~");
    }

    private Boolean getInteractive(String token) {
        if (token.equals("-hideOutput")) {
            return false;
        }
        if (token.equals("-showOutput")) {
            return true;
        }
        return null;
    }

    private int getPyramidDepth(int sw, int sh, int tw, int th) {
        int pyramidDepth = 1;
        int minsize = 24;
        while (minsize <= sw && minsize <= sh && minsize <= tw && minsize <= th) {
            sw >>= 1;
            sh >>= 1;
            tw >>= 1;
            th >>= 1;
            ++pyramidDepth;
        }
        return pyramidDepth;
    }

    private String[] getTokens(String options) {
        String fileSeparator = System.getProperty("file.separator");
        options = fileSeparator.equals("\\") ? options.replaceAll("\\\\", "/") : options.replaceAll(fileSeparator, "/");
        String[] token = new String[]{};
        StringReader sr = new StringReader(options);
        StreamTokenizer st = new StreamTokenizer(sr);
        st.resetSyntax();
        st.whitespaceChars(0, 32);
        st.wordChars(33, 255);
        st.quoteChar(34);
        Vector<String> v = new Vector<String>(13);
        try {
            while (st.nextToken() != -1) {
                v.add(st.sval.substring(0));
            }
        }
        catch (IOException e) {
            IJ.log((String)("IOException exception " + e.getMessage()));
            return token;
        }
        token = v.toArray(token);
        return token;
    }

    private int getTransformation(String token) {
        if (token.equals("-translation")) {
            return 2;
        }
        if (token.equals("-rigidBody")) {
            return 3;
        }
        if (token.equals("-scaledRotation")) {
            return 4;
        }
        if (token.equals("-affine")) {
            return 6;
        }
        if (token.equals("-bilinear")) {
            return 8;
        }
        return -1;
    }

    private ImagePlus transformImage(ImagePlus source, int width, int height, int transformation, boolean interactive) {
        if (source.getType() != 1 && source.getType() != 2 && (source.getType() != 0 || source.getStack().isRGB() || source.getStack().isHSB())) {
            IJ.error((String)(source.getTitle() + " should be grayscale (8, 16, or 32 bit)"));
            return null;
        }
        source.setSlice(1);
        turboRegImage sourceImg = new turboRegImage(source, -1, false);
        sourceImg.getThread().start();
        if (2 <= source.getStackSize()) {
            source.setSlice(2);
        }
        turboRegMask sourceMsk = new turboRegMask(source);
        source.setSlice(1);
        if (source.getStackSize() < 2) {
            sourceMsk.clearMask();
        }
        turboRegPointHandler sourcePh = new turboRegPointHandler(this.sourcePoints, transformation);
        turboRegPointHandler targetPh = new turboRegPointHandler(this.targetPoints, transformation);
        try {
            sourceImg.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
        }
        turboRegTransform regTransform = new turboRegTransform(sourceImg, sourceMsk, sourcePh, null, null, targetPh, transformation, false, false);
        ImagePlus transImage = regTransform.doFinalTransform(width, height);
        if (interactive) {
            transImage.setSlice(1);
            transImage.getProcessor().resetMinAndMax();
            transImage.show();
            transImage.updateAndDraw();
        }
        return transImage;
    }
}

