/*
 * Decompiled with CFR 0.152.
 */
package registration.turboregold;

import filesAndFolders.FileNameFilters;
import ij.ImagePlus;
import imageJ.IJInterfacor;
import imageTiTi.ImageIO;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import processing.filters.SignalFilter;
import registration.turboregold.TurboReg;

public class StackRegistrationOld {
    public static final int AFFINE = 6;
    public static final int RIGID_BODY = 3;
    public static final int SCALED_ROTATION = 4;
    public static final int TRANSLATION = 2;

    public void Process(String folderpath, List<String> subacq, Comparator<File> cmpf, int transformation, String resultpath) throws Exception, Error {
        for (String acq : subacq) {
            FilenameFilter acqfnf = FileNameFilters.ImagesPNGorTIF;
            Object[] images = new File(folderpath).listFiles(acqfnf);
            Arrays.sort(images);
            System.out.println("Registration (" + acq + "), " + images.length + " images, Middle = " + ((File)images[images.length >> 1]).getName());
            this.Process(folderpath, ((File)images[images.length >> 1]).getName(), acqfnf, cmpf, transformation, resultpath);
            images = null;
            acqfnf = null;
        }
        Iterator<String> iter = null;
    }

    public void Process(String folderpath, String imagename, FilenameFilter fnf, Comparator<File> cmpf, int transformation, String resultpath) throws Exception, Error {
        ImagePlus result;
        ImagePlus impsource;
        BufferedImage source;
        int i2;
        int pos;
        TurboReg turboreg = new TurboReg();
        File resfolder = new File(resultpath);
        if (!resfolder.exists()) {
            resfolder.mkdirs();
        }
        Object[] images = new File(folderpath).listFiles(fnf);
        if (cmpf == null) {
            Arrays.sort(images);
        } else {
            Arrays.sort(images, cmpf);
        }
        for (pos = 0; pos < images.length && !((File)images[pos]).getName().equalsIgnoreCase(imagename); ++pos) {
        }
        if (images.length <= pos) {
            throw new IllegalArgumentException("The image name was not found.");
        }
        BufferedImage target = ImageIO.Read(((File)images[pos]).getAbsolutePath());
        ImagePlus imptarget = IJInterfacor.BufferedImageToImagePlus(target);
        ImageIO.Write(target, resultpath + "/" + ((File)images[pos]).getName(), 6);
        int width = target.getWidth();
        int height = target.getHeight();
        for (i2 = pos + 1; i2 < images.length; ++i2) {
            source = ImageIO.Read(((File)images[i2]).getAbsoluteFile());
            if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)target)) {
                throw new IllegalArgumentException("Images have different types and dimensions.");
            }
            impsource = IJInterfacor.BufferedImageToImagePlus(source);
            switch (transformation) {
                case 6: {
                    turboreg.Align(impsource, 6, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 2, 3 * height >> 2, width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2);
                    break;
                }
                case 2: {
                    turboreg.Align(impsource, 2, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 1, width >> 1, height >> 1);
                    break;
                }
                case 3: {
                    turboreg.Align(impsource, 3, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 1, width >> 1, height >> 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 1, 3 * height >> 2, width >> 1, 3 * height >> 2);
                    break;
                }
                case 4: {
                    turboreg.Align(impsource, 4, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 2, height >> 1, width >> 2, height >> 1, 3 * width >> 2, height >> 1, 3 * width >> 2, height >> 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transformation.");
                }
            }
            result = turboreg.getTransformedImage();
            ImageIO.Write(result.getBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
            target = source;
            imptarget = result;
            impsource = null;
            source = null;
        }
        target = ImageIO.Read(((File)images[pos]).getAbsoluteFile());
        imptarget = IJInterfacor.BufferedImageToImagePlus(target);
        for (i2 = pos - 1; i2 >= 0; --i2) {
            source = ImageIO.Read(((File)images[i2]).getAbsoluteFile());
            if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)target)) {
                throw new IllegalArgumentException("Images have different types and dimensions.");
            }
            impsource = IJInterfacor.BufferedImageToImagePlus(source);
            switch (transformation) {
                case 6: {
                    turboreg.Align(impsource, 6, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 2, 3 * height >> 2, width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2);
                    break;
                }
                case 2: {
                    turboreg.Align(impsource, 2, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 1, width >> 1, height >> 1);
                    break;
                }
                case 3: {
                    turboreg.Align(impsource, 3, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 1, width >> 1, height >> 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 1, 3 * height >> 2, width >> 1, 3 * height >> 2);
                    break;
                }
                case 4: {
                    turboreg.Align(impsource, 4, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 2, height >> 1, width >> 2, height >> 1, 3 * width >> 2, height >> 1, 3 * width >> 2, height >> 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transformation.");
                }
            }
            result = turboreg.getTransformedImage();
            ImageIO.Write(result.getBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
            target = source;
            imptarget = result;
            impsource = null;
            source = null;
        }
        turboreg = null;
        resfolder = null;
        images = null;
    }

    public void Process(BufferedImage source, BufferedImage target, String folderpath, FilenameFilter fnf, Comparator<File> cmpf, int transformation, String resultpath, int nbCPU) throws Exception, Error {
        TurboReg turboreg = new TurboReg();
        File resfolder = new File(resultpath);
        if (!resfolder.exists()) {
            resfolder.mkdirs();
        }
        Object[] images = new File(folderpath).listFiles(fnf);
        if (cmpf == null) {
            Arrays.sort(images);
        } else {
            Arrays.sort(images, cmpf);
        }
        ImagePlus imptarget = IJInterfacor.BufferedImageToImagePlus(target);
        int width = target.getWidth();
        int height = target.getHeight();
        ImagePlus impsrc = IJInterfacor.BufferedImageToImagePlus(source);
        switch (transformation) {
            case 6: {
                turboreg.Align(impsrc, 6, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 2, 3 * height >> 2, width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2);
                break;
            }
            case 2: {
                turboreg.Align(impsrc, 2, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 1, width >> 1, height >> 1);
                break;
            }
            case 3: {
                turboreg.Align(impsrc, 3, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 1, width >> 1, height >> 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 1, 3 * height >> 2, width >> 1, 3 * height >> 2);
                break;
            }
            case 4: {
                turboreg.Align(impsrc, 4, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 2, height >> 1, width >> 2, height >> 1, 3 * width >> 2, height >> 1, 3 * width >> 2, height >> 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid transformation.");
            }
        }
        impsrc = null;
        imptarget = null;
        for (int i2 = 0; i2 < images.length; ++i2) {
            BufferedImage image = ImageIO.Read((File)images[i2]);
            ImagePlus impim = IJInterfacor.BufferedImageToImagePlus(image);
            turboreg.Transform(impim, transformation);
            ImageIO.Write(turboreg.getTransformedImage().getBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
            impim = null;
            image = null;
        }
        turboreg = null;
        resfolder = null;
        images = null;
    }

    public void Process(String folderpath, List<String> subacq, Comparator<File> cmpf, int transformation, SignalFilter filter, String resultpath, int nbCPU) throws Exception, Error {
        for (String acq : subacq) {
            FilenameFilter acqfnf = FileNameFilters.ImagesPNGorTIF;
            Object[] images = new File(folderpath).listFiles(acqfnf);
            Arrays.sort(images);
            System.out.println("Registration (" + acq + "), " + images.length + " images, Middle = " + ((File)images[images.length >> 1]).getName());
            this.Process(folderpath, ((File)images[images.length >> 1]).getName(), acqfnf, cmpf, transformation, filter, resultpath, nbCPU);
            images = null;
            acqfnf = null;
        }
        Iterator<String> iter = null;
    }

    public void Process(String folderpath, String imagename, FilenameFilter fnf, Comparator<File> cmpf, int transformation, SignalFilter filter, String resultpath, int nbCPU) throws Exception, Error {
        ImagePlus impsrcfilt;
        ImagePlus impsrc;
        BufferedImage sourcefiltered;
        BufferedImage source;
        int i2;
        int pos;
        TurboReg turboreg = new TurboReg();
        File resfolder = new File(resultpath);
        if (!resfolder.exists()) {
            resfolder.mkdirs();
        }
        Object[] images = new File(folderpath).listFiles(fnf);
        if (cmpf == null) {
            Arrays.sort(images);
        } else {
            Arrays.sort(images, cmpf);
        }
        for (pos = 0; pos < images.length && !((File)images[pos]).getName().equalsIgnoreCase(imagename); ++pos) {
        }
        if (images.length <= pos) {
            throw new IllegalArgumentException("The image name was not found.");
        }
        BufferedImage target = ImageIO.Read(((File)images[pos]).getAbsolutePath());
        BufferedImage targetfiltered = filter.Filter(target, nbCPU);
        ImagePlus imptarget = IJInterfacor.BufferedImageToImagePlus(targetfiltered);
        ImageIO.Write(target, resultpath + "/" + ((File)images[pos]).getName(), 6);
        int width = target.getWidth();
        int height = target.getHeight();
        for (i2 = pos + 1; i2 < images.length; ++i2) {
            source = ImageIO.Read(((File)images[i2]).getAbsoluteFile());
            sourcefiltered = filter.Filter(source, nbCPU);
            if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)target)) {
                throw new IllegalArgumentException("Images have different types and dimensions.");
            }
            impsrc = IJInterfacor.BufferedImageToImagePlus(source);
            impsrcfilt = IJInterfacor.BufferedImageToImagePlus(sourcefiltered);
            switch (transformation) {
                case 6: {
                    turboreg.Align(impsrcfilt, 6, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 2, 3 * height >> 2, width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2);
                    break;
                }
                case 2: {
                    turboreg.Align(impsrcfilt, 2, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 1, width >> 1, height >> 1);
                    break;
                }
                case 3: {
                    turboreg.Align(impsrcfilt, 3, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 1, width >> 1, height >> 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 1, 3 * height >> 2, width >> 1, 3 * height >> 2);
                    break;
                }
                case 4: {
                    turboreg.Align(impsrcfilt, 4, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 2, height >> 1, width >> 2, height >> 1, 3 * width >> 2, height >> 1, 3 * width >> 2, height >> 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transformation.");
                }
            }
            imptarget = turboreg.getTransformedImage();
            turboreg.Transform(impsrc, transformation);
            ImageIO.Write(turboreg.getTransformedImage().getBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
            impsrcfilt = null;
            impsrc = null;
            sourcefiltered = null;
            source = null;
        }
        target = ImageIO.Read(((File)images[pos]).getAbsoluteFile());
        targetfiltered = filter.Filter(target, nbCPU);
        imptarget = IJInterfacor.BufferedImageToImagePlus(target);
        for (i2 = pos - 1; i2 >= 0; --i2) {
            source = ImageIO.Read(((File)images[i2]).getAbsoluteFile());
            sourcefiltered = filter.Filter(source, nbCPU);
            if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)target)) {
                throw new IllegalArgumentException("Images have different types and dimensions.");
            }
            impsrc = IJInterfacor.BufferedImageToImagePlus(source);
            impsrcfilt = IJInterfacor.BufferedImageToImagePlus(sourcefiltered);
            switch (transformation) {
                case 6: {
                    turboreg.Align(impsrcfilt, 6, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 2, 3 * height >> 2, width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2);
                    break;
                }
                case 2: {
                    turboreg.Align(impsrcfilt, 2, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 1, width >> 1, height >> 1);
                    break;
                }
                case 3: {
                    turboreg.Align(impsrcfilt, 3, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 1, height >> 1, width >> 1, height >> 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 1, 3 * height >> 2, width >> 1, 3 * height >> 2);
                    break;
                }
                case 4: {
                    turboreg.Align(impsrcfilt, 4, imptarget, 0, 0, width - 1, height - 1, 0, 0, width - 1, height - 1, width >> 2, height >> 1, width >> 2, height >> 1, 3 * width >> 2, height >> 1, 3 * width >> 2, height >> 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transformation.");
                }
            }
            imptarget = turboreg.getTransformedImage();
            turboreg.Transform(impsrc, transformation);
            ImageIO.Write(turboreg.getTransformedImage().getBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
            impsrcfilt = null;
            impsrc = null;
            sourcefiltered = null;
            source = null;
        }
        turboreg = null;
        resfolder = null;
        images = null;
    }
}

