/*
 * Decompiled with CFR 0.152.
 */
package registration.turboreg;

import arrayTiTi.ArrayNew;
import registration.turboreg.TurboRegImage;
import registration.turboreg.TurboRegMask;
import registration.turboreg.TurboRegTransform;

class turboRegFinalActionStochastic
implements Runnable {
    public static final int AUTOMATIC = 1;
    public static final int MANUAL = 2;
    public static final int BATCH = 3;
    private Thread t;
    private volatile TurboRegImage sourceImg;
    private volatile TurboRegImage targetImg;
    private volatile TurboRegMask sourceMsk;
    private volatile TurboRegMask targetMsk;
    private volatile int operation;
    private volatile int transformation;
    private final double[][] sourcePoints = new double[4][2];
    private final double[][] targetPoints = new double[4][2];
    private final int nbIterations;
    private double margin;
    private final int nbCPU;
    private final boolean Aggressive;
    public double[][][] sourcelist;
    public double[][][] targetlist;
    public int[] sourceCrop = null;
    public int[] targetCrop = null;

    public turboRegFinalActionStochastic(int nbIterations, boolean Aggressive, int nbCPU) {
        if (nbIterations < 7) {
            throw new IllegalArgumentException("At least 7 iterations are required.");
        }
        this.t = new Thread(this);
        this.nbIterations = nbIterations;
        this.Aggressive = Aggressive;
        this.nbCPU = nbCPU;
        this.sourcelist = new double[nbIterations][][];
        this.targetlist = new double[nbIterations][][];
    }

    public turboRegFinalActionStochastic(TurboRegImage sourceImg, TurboRegMask sourceMsk, TurboRegImage targetImg, TurboRegMask targetMsk, int transformation, int nbIterations, boolean Aggressive, int nbCPU) {
        if (nbIterations < 7) {
            throw new IllegalArgumentException("At least 7 iterations are required.");
        }
        this.sourceImg = sourceImg;
        this.sourceMsk = sourceMsk;
        this.targetImg = targetImg;
        this.targetMsk = targetMsk;
        this.transformation = transformation;
        this.nbIterations = nbIterations;
        this.Aggressive = Aggressive;
        this.nbCPU = nbCPU;
        this.operation = 1;
        this.t = new Thread(this);
        this.sourcelist = new double[nbIterations][][];
        this.targetlist = new double[nbIterations][][];
    }

    @Override
    public void run() {
        this.FindMargin();
        switch (this.operation) {
            case 1: 
            case 2: {
                int nb;
                TurboRegTransform tt = new TurboRegTransform(this.sourceImg, this.sourceMsk, this.targetImg, this.targetMsk, this.transformation, false, this.nbCPU);
                switch (this.transformation) {
                    case 6: {
                        nb = 3;
                        break;
                    }
                    case 8: {
                        nb = 4;
                        break;
                    }
                    case 3: {
                        nb = 3;
                        break;
                    }
                    case 4: {
                        nb = 2;
                        break;
                    }
                    case 2: {
                        nb = 1;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Transformation not supported (yet).");
                    }
                }
                if (this.operation == 1) {
                    for (int i2 = 0; i2 < this.nbIterations; ++i2) {
                        this.GenerateNewPoints(this.targetImg.getWidth(), this.targetImg.getHeight());
                        tt.doRegistrationStochastic(this.sourcePoints, this.targetPoints);
                        for (int j = 0; j < nb; ++j) {
                            double[] dArray = this.sourcePoints[j];
                            dArray[0] = dArray[0] + (double)this.sourceCrop[0];
                            double[] dArray2 = this.sourcePoints[j];
                            dArray2[1] = dArray2[1] + (double)this.sourceCrop[1];
                            double[] dArray3 = this.targetPoints[j];
                            dArray3[0] = dArray3[0] + (double)this.targetCrop[0];
                            double[] dArray4 = this.targetPoints[j];
                            dArray4[1] = dArray4[1] + (double)this.targetCrop[1];
                        }
                        this.sourcelist[i2] = ArrayNew.Clone((double[][])this.sourcePoints);
                        this.targetlist[i2] = ArrayNew.Clone((double[][])this.targetPoints);
                    }
                }
                tt.Kill();
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation not supported (yet).");
            }
        }
    }

    private void FindMargin() {
        int w = this.sourceCrop[2] - this.sourceCrop[0];
        int h = this.sourceCrop[3] - this.sourceCrop[1];
        int div = this.Aggressive ? 3 : 2;
        this.margin = Math.min(w >> div, h >> div);
        this.margin = (int)(this.margin / 2.0);
    }

    private void GenerateNewPoints(int width, int height) {
        int div = this.Aggressive ? 3 : 2;
        int mul = this.Aggressive ? 7 : 3;
        block0 : switch (this.transformation) {
            case 3: 
            case 6: {
                switch ((int)(Math.random() * 8.0)) {
                    case 0: {
                        double d = (width >> div) + this.Random();
                        this.targetPoints[0][0] = d;
                        this.sourcePoints[0][0] = d;
                        double d2 = (height >> div) + this.Random();
                        this.targetPoints[0][1] = d2;
                        this.sourcePoints[0][1] = d2;
                        double d3 = (width >> div) + this.Random();
                        this.targetPoints[1][0] = d3;
                        this.sourcePoints[1][0] = d3;
                        double d4 = (mul * height >> div) + this.Random();
                        this.targetPoints[1][1] = d4;
                        this.sourcePoints[1][1] = d4;
                        double d5 = (mul * width >> div) + this.Random();
                        this.targetPoints[2][0] = d5;
                        this.sourcePoints[2][0] = d5;
                        double d6 = (height >> div) + this.Random();
                        this.targetPoints[2][1] = d6;
                        this.sourcePoints[2][1] = d6;
                        break block0;
                    }
                    case 1: {
                        double d = (width >> div) + this.Random();
                        this.targetPoints[0][0] = d;
                        this.sourcePoints[0][0] = d;
                        double d7 = (height >> div) + this.Random();
                        this.targetPoints[0][1] = d7;
                        this.sourcePoints[0][1] = d7;
                        double d8 = (width >> div) + this.Random();
                        this.targetPoints[1][0] = d8;
                        this.sourcePoints[1][0] = d8;
                        double d9 = (mul * height >> div) + this.Random();
                        this.targetPoints[1][1] = d9;
                        this.sourcePoints[1][1] = d9;
                        double d10 = (mul * width >> div) + this.Random();
                        this.targetPoints[2][0] = d10;
                        this.sourcePoints[2][0] = d10;
                        double d11 = (height >> 1) + this.Random();
                        this.targetPoints[2][1] = d11;
                        this.sourcePoints[2][1] = d11;
                        break block0;
                    }
                    case 2: {
                        double d = (width >> div) + this.Random();
                        this.targetPoints[0][0] = d;
                        this.sourcePoints[0][0] = d;
                        double d12 = (height >> div) + this.Random();
                        this.targetPoints[0][1] = d12;
                        this.sourcePoints[0][1] = d12;
                        double d13 = (width >> div) + this.Random();
                        this.targetPoints[1][0] = d13;
                        this.sourcePoints[1][0] = d13;
                        double d14 = (mul * height >> div) + this.Random();
                        this.targetPoints[1][1] = d14;
                        this.sourcePoints[1][1] = d14;
                        double d15 = (mul * width >> div) + this.Random();
                        this.targetPoints[2][0] = d15;
                        this.sourcePoints[2][0] = d15;
                        double d16 = (mul * height >> div) + this.Random();
                        this.targetPoints[2][1] = d16;
                        this.sourcePoints[2][1] = d16;
                        break block0;
                    }
                    case 3: {
                        double d = (mul * width >> div) + this.Random();
                        this.targetPoints[0][0] = d;
                        this.sourcePoints[0][0] = d;
                        double d17 = (height >> div) + this.Random();
                        this.targetPoints[0][1] = d17;
                        this.sourcePoints[0][1] = d17;
                        double d18 = (mul * width >> div) + this.Random();
                        this.targetPoints[1][0] = d18;
                        this.sourcePoints[1][0] = d18;
                        double d19 = (mul * height >> div) + this.Random();
                        this.targetPoints[1][1] = d19;
                        this.sourcePoints[1][1] = d19;
                        double d20 = (width >> div) + this.Random();
                        this.targetPoints[2][0] = d20;
                        this.sourcePoints[2][0] = d20;
                        double d21 = (height >> div) + this.Random();
                        this.targetPoints[2][1] = d21;
                        this.sourcePoints[2][1] = d21;
                        break block0;
                    }
                    case 4: {
                        double d = (mul * width >> div) + this.Random();
                        this.targetPoints[0][0] = d;
                        this.sourcePoints[0][0] = d;
                        double d22 = (height >> div) + this.Random();
                        this.targetPoints[0][1] = d22;
                        this.sourcePoints[0][1] = d22;
                        double d23 = (mul * width >> div) + this.Random();
                        this.targetPoints[1][0] = d23;
                        this.sourcePoints[1][0] = d23;
                        double d24 = (mul * height >> div) + this.Random();
                        this.targetPoints[1][1] = d24;
                        this.sourcePoints[1][1] = d24;
                        double d25 = (width >> div) + this.Random();
                        this.targetPoints[2][0] = d25;
                        this.sourcePoints[2][0] = d25;
                        double d26 = (height >> 1) + this.Random();
                        this.targetPoints[2][1] = d26;
                        this.sourcePoints[2][1] = d26;
                        break block0;
                    }
                    case 5: {
                        double d = (mul * width >> div) + this.Random();
                        this.targetPoints[0][0] = d;
                        this.sourcePoints[0][0] = d;
                        double d27 = (height >> div) + this.Random();
                        this.targetPoints[0][1] = d27;
                        this.sourcePoints[0][1] = d27;
                        double d28 = (mul * width >> div) + this.Random();
                        this.targetPoints[1][0] = d28;
                        this.sourcePoints[1][0] = d28;
                        double d29 = (mul * height >> div) + this.Random();
                        this.targetPoints[1][1] = d29;
                        this.sourcePoints[1][1] = d29;
                        double d30 = (width >> div) + this.Random();
                        this.targetPoints[2][0] = d30;
                        this.sourcePoints[2][0] = d30;
                        double d31 = (mul * height >> div) + this.Random();
                        this.targetPoints[2][1] = d31;
                        this.sourcePoints[2][1] = d31;
                        break block0;
                    }
                    case 6: {
                        double d = (width >> div) + this.Random();
                        this.targetPoints[0][0] = d;
                        this.sourcePoints[0][0] = d;
                        double d32 = (height >> div) + this.Random();
                        this.targetPoints[0][1] = d32;
                        this.sourcePoints[0][1] = d32;
                        double d33 = (mul * width >> div) + this.Random();
                        this.targetPoints[1][0] = d33;
                        this.sourcePoints[1][0] = d33;
                        double d34 = (height >> div) + this.Random();
                        this.targetPoints[1][1] = d34;
                        this.sourcePoints[1][1] = d34;
                        double d35 = (width >> 1) + this.Random();
                        this.targetPoints[2][0] = d35;
                        this.sourcePoints[2][0] = d35;
                        double d36 = (mul * height >> div) + this.Random();
                        this.targetPoints[2][1] = d36;
                        this.sourcePoints[2][1] = d36;
                        break block0;
                    }
                    case 7: {
                        double d = (width >> div) + this.Random();
                        this.targetPoints[0][0] = d;
                        this.sourcePoints[0][0] = d;
                        double d37 = (mul * height >> div) + this.Random();
                        this.targetPoints[0][1] = d37;
                        this.sourcePoints[0][1] = d37;
                        double d38 = (mul * width >> div) + this.Random();
                        this.targetPoints[1][0] = d38;
                        this.sourcePoints[1][0] = d38;
                        double d39 = (mul * height >> div) + this.Random();
                        this.targetPoints[1][1] = d39;
                        this.sourcePoints[1][1] = d39;
                        double d40 = (width >> 1) + this.Random();
                        this.targetPoints[2][0] = d40;
                        this.sourcePoints[2][0] = d40;
                        double d41 = (height >> div) + this.Random();
                        this.targetPoints[2][1] = d41;
                        this.sourcePoints[2][1] = d41;
                        break block0;
                    }
                }
                throw new IllegalStateException("Should not occur.");
            }
            default: {
                throw new IllegalStateException("Operations not supported (yet).");
            }
        }
        int k = this.transformation >> 1;
        for (int i2 = 0; i2 < k; ++i2) {
            double[] dArray = this.sourcePoints[i2];
            dArray[0] = dArray[0] - (double)this.sourceCrop[0];
            double[] dArray2 = this.sourcePoints[i2];
            dArray2[1] = dArray2[1] - (double)this.sourceCrop[1];
            double[] dArray3 = this.targetPoints[i2];
            dArray3[0] = dArray3[0] - (double)this.targetCrop[0];
            double[] dArray4 = this.targetPoints[i2];
            dArray4[1] = dArray4[1] - (double)this.targetCrop[1];
        }
    }

    private int Random() {
        return (int)((Math.random() < 0.5 ? -1.0 : 1.0) * Math.random() * this.margin);
    }

    public Thread getThread() {
        return this.t;
    }
}

