/*
 * Decompiled with CFR 0.152.
 */
package registration.turboreg;

import registration.turboreg.TurboRegImage;
import registration.turboreg.TurboRegMask;
import registration.turboreg.TurboRegTransform;

class turboRegFinalAction
implements Runnable {
    public static final int AUTOMATIC = 1;
    public static final int MANUAL = 2;
    public static final int BATCH = 3;
    private Thread t;
    private volatile TurboRegImage sourceImg;
    private volatile TurboRegImage targetImg;
    private volatile TurboRegMask sourceMsk;
    private volatile TurboRegMask targetMsk;
    private volatile int operation;
    private volatile int transformation;
    public double[][] sourcePoints = null;
    public double[][] targetPoints = null;
    private final int nbCPU;

    @Override
    public void run() {
        switch (this.operation) {
            case 1: 
            case 2: {
                TurboRegTransform tt = new TurboRegTransform(this.sourceImg, this.sourceMsk, this.targetImg, this.targetMsk, this.transformation, false, this.nbCPU);
                if (this.operation == 1) {
                    tt.doRegistration(this.sourcePoints, this.targetPoints);
                }
                tt.Kill();
                break;
            }
            default: {
                throw new UnsupportedOperationException("");
            }
        }
    }

    public turboRegFinalAction(int nbCPU) {
        this.t = new Thread(this);
        this.nbCPU = nbCPU;
    }

    public turboRegFinalAction(TurboRegImage sourceImg, TurboRegMask sourceMsk, TurboRegImage targetImg, TurboRegMask targetMsk, int transformation, int nbCPU) {
        this.sourceImg = sourceImg;
        this.sourceMsk = sourceMsk;
        this.targetImg = targetImg;
        this.targetMsk = targetMsk;
        this.transformation = transformation;
        this.nbCPU = nbCPU;
        this.operation = 1;
        this.t = new Thread(this);
    }

    public Thread getThread() {
        return this.t;
    }
}

