/*
 * Decompiled with CFR 0.152.
 */
package registration.turboreg;

import arrayTiTi.ArrayFeatures;
import ij.IJ;
import ij.ImagePlus;
import java.util.Arrays;
import registration.turboreg.TurboRegImage;
import registration.turboreg.TurboRegMask;
import registration.turboreg.TurboRegTransform;
import registration.turboreg.turboRegFinalActionStochastic;

public class TurboRegStochastic {
    private ImagePlus transformedImage = null;
    public static final int AFFINE = 6;
    public static final int BILINEAR = 8;
    public static final int RIGID_BODY = 3;
    public static final int SCALED_ROTATION = 4;
    public static final int TRANSLATION = 2;
    private final ArrayFeatures AF = new ArrayFeatures();
    private final int nbCPU;

    public TurboRegStochastic(int nbCPU) {
        this.nbCPU = nbCPU;
    }

    public void Align(ImagePlus source, int transformation, ImagePlus target, int nbIterations, boolean Aggressive, int ... cropcoordinates) {
        if (cropcoordinates.length != 8) {
            throw new IllegalArgumentException("8 crop coordinates required.");
        }
        int[] sourceCrop = new int[4];
        System.arraycopy(cropcoordinates, 0, sourceCrop, 0, 4);
        int[] targetCrop = new int[4];
        System.arraycopy(cropcoordinates, 4, targetCrop, 0, 4);
        this.transformedImage = this.alignImages(source, sourceCrop, target, targetCrop, transformation, nbIterations, Aggressive);
    }

    private ImagePlus alignImages(ImagePlus source, int[] sourceCrop, ImagePlus target, int[] targetCrop, int transformation, int nbIterations, boolean Aggressive) {
        if (source.getType() != 1 && source.getType() != 2 && (source.getType() != 0 || source.getStack().isRGB() || source.getStack().isHSB())) {
            IJ.error((String)(source.getTitle() + " should be grayscale (8, 16, or 32 bit)"));
            return null;
        }
        if (target.getType() != 1 && target.getType() != 2 && (target.getType() != 0 || target.getStack().isRGB() || target.getStack().isHSB())) {
            IJ.error((String)(target.getTitle() + " should be grayscale (8, 16, or 32 bit)"));
            return null;
        }
        source.setRoi(sourceCrop[0], sourceCrop[1], sourceCrop[2], sourceCrop[3]);
        target.setRoi(targetCrop[0], targetCrop[1], targetCrop[2], targetCrop[3]);
        source.setSlice(1);
        target.setSlice(1);
        ImagePlus sourceImp = new ImagePlus("source", source.getProcessor().crop());
        ImagePlus targetImp = new ImagePlus("target", target.getProcessor().crop());
        TurboRegImage sourceImg = new TurboRegImage(sourceImp, transformation, false, this.nbCPU);
        TurboRegImage targetImg = new TurboRegImage(targetImp, transformation, true, this.nbCPU);
        int pyramidDepth = this.getPyramidDepth(sourceImp.getWidth(), sourceImp.getHeight(), targetImp.getWidth(), targetImp.getHeight());
        sourceImg.setPyramidDepth(pyramidDepth);
        targetImg.setPyramidDepth(pyramidDepth);
        sourceImg.getThread().start();
        targetImg.getThread().start();
        if (2 <= source.getStackSize()) {
            source.setSlice(2);
        }
        if (2 <= target.getStackSize()) {
            target.setSlice(2);
        }
        ImagePlus sourceMskImp = new ImagePlus("source mask", source.getProcessor().crop());
        ImagePlus targetMskImp = new ImagePlus("target mask", target.getProcessor().crop());
        TurboRegMask sourceMsk = new TurboRegMask(sourceMskImp);
        TurboRegMask targetMsk = new TurboRegMask(targetMskImp);
        source.setSlice(1);
        target.setSlice(1);
        if (source.getStackSize() < 2) {
            sourceMsk.clearMask();
        }
        if (target.getStackSize() < 2) {
            targetMsk.clearMask();
        }
        sourceMsk.setPyramidDepth(pyramidDepth);
        targetMsk.setPyramidDepth(pyramidDepth);
        sourceMsk.getThread().start();
        targetMsk.getThread().start();
        try {
            sourceMsk.getThread().join();
            targetMsk.getThread().join();
            sourceImg.getThread().join();
            targetImg.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
        }
        turboRegFinalActionStochastic finalAction = new turboRegFinalActionStochastic(sourceImg, sourceMsk, targetImg, targetMsk, transformation, nbIterations, Aggressive, this.nbCPU);
        finalAction.sourceCrop = sourceCrop;
        finalAction.targetCrop = targetCrop;
        finalAction.getThread().start();
        try {
            finalAction.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
        }
        source.killRoi();
        target.killRoi();
        ImagePlus result = this.transformImage(source, transformation, finalAction.sourcelist, finalAction.targetlist);
        sourceImg.Kill();
        targetImg.Kill();
        return result;
    }

    private ImagePlus transformImage(ImagePlus source, int transformation, double[][][] srclist, double[][][] tarlist) {
        if (source.getType() != 1 && source.getType() != 2 && (source.getType() != 0 || source.getStack().isRGB() || source.getStack().isHSB())) {
            IJ.error((String)(source.getTitle() + " should be grayscale (8, 16, or 32 bit)"));
            return null;
        }
        source.setSlice(1);
        TurboRegImage sourceImg = new TurboRegImage(source, -1, false, this.nbCPU);
        sourceImg.getThread().start();
        if (2 <= source.getStackSize()) {
            source.setSlice(2);
        }
        TurboRegMask sourceMsk = new TurboRegMask(source);
        source.setSlice(1);
        if (source.getStackSize() < 2) {
            sourceMsk.clearMask();
        }
        try {
            sourceImg.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
        }
        TurboRegTransform tt = new TurboRegTransform(sourceImg, sourceMsk, null, null, transformation, false, this.nbCPU);
        double[][][] matrices = new double[srclist.length][][];
        for (int i2 = 0; i2 < matrices.length; ++i2) {
            matrices[i2] = tt.getTransformationMatrix(tarlist[i2], srclist[i2]);
        }
        int w = matrices[0][0].length;
        int h = matrices[0].length;
        double[][] matrix = new double[h][w];
        double[] buffer = new double[srclist.length];
        int from = (matrices.length >> 1) - 2;
        int to = (matrices.length >> 1) + 3;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                for (int i3 = 0; i3 < matrices.length; ++i3) {
                    buffer[i3] = matrices[i3][y][x];
                }
                Arrays.sort(buffer);
                matrix[y][x] = this.AF.Average(buffer, from, to);
            }
        }
        ImagePlus trans = tt.doFinalTransform(source.getWidth(), source.getHeight(), matrix);
        sourceImg.Kill();
        tt.Kill();
        return trans;
    }

    private ImagePlus transformImage(ImagePlus source, int width, int height, int transformation, double[][] src, double[][] tar) {
        if (source.getType() != 1 && source.getType() != 2 && (source.getType() != 0 || source.getStack().isRGB() || source.getStack().isHSB())) {
            IJ.error((String)(source.getTitle() + " should be grayscale (8, 16, or 32 bit)"));
            return null;
        }
        source.setSlice(1);
        TurboRegImage sourceImg = new TurboRegImage(source, -1, false, this.nbCPU);
        sourceImg.getThread().start();
        if (2 <= source.getStackSize()) {
            source.setSlice(2);
        }
        TurboRegMask sourceMsk = new TurboRegMask(source);
        source.setSlice(1);
        if (source.getStackSize() < 2) {
            sourceMsk.clearMask();
        }
        try {
            sourceImg.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
        }
        TurboRegTransform tt = new TurboRegTransform(sourceImg, sourceMsk, null, null, transformation, false, this.nbCPU);
        ImagePlus transImage = tt.doFinalTransform(width, height, src, tar);
        tt.Kill();
        sourceImg.Kill();
        return transImage;
    }

    private ImagePlus transformImage(ImagePlus source, int width, int height, int transformation, double[][] matrix) {
        if (source.getType() != 1 && source.getType() != 2 && (source.getType() != 0 || source.getStack().isRGB() || source.getStack().isHSB())) {
            IJ.error((String)(source.getTitle() + " should be grayscale (8, 16, or 32 bit)"));
            return null;
        }
        source.setSlice(1);
        TurboRegImage sourceImg = new TurboRegImage(source, -1, false, this.nbCPU);
        sourceImg.getThread().start();
        if (2 <= source.getStackSize()) {
            source.setSlice(2);
        }
        TurboRegMask sourceMsk = new TurboRegMask(source);
        source.setSlice(1);
        if (source.getStackSize() < 2) {
            sourceMsk.clearMask();
        }
        try {
            sourceImg.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
        }
        TurboRegTransform tt = new TurboRegTransform(sourceImg, sourceMsk, null, null, transformation, false, this.nbCPU);
        ImagePlus transImage = tt.doFinalTransform(width, height, matrix);
        tt.Kill();
        sourceImg.Kill();
        return transImage;
    }

    private int getPyramidDepth(int sw, int sh, int tw, int th) {
        int pyramidDepth = 1;
        int minsize = 24;
        while (minsize <= sw && minsize <= sh && minsize <= tw && minsize <= th) {
            sw >>= 1;
            sh >>= 1;
            tw >>= 1;
            th >>= 1;
            ++pyramidDepth;
        }
        return pyramidDepth;
    }

    public ImagePlus getTransformedImage() {
        return this.transformedImage;
    }
}

