/*
 * Decompiled with CFR 0.152.
 */
package registration.turboreg;

import ij.IJ;
import ij.ImagePlus;
import registration.turboreg.TurboRegImage;
import registration.turboreg.TurboRegMask;
import registration.turboreg.TurboRegTransform;
import registration.turboreg.turboRegFinalAction;

public class TurboReg {
    private final double[][] sourcePoints = new double[4][2];
    private final double[][] targetPoints = new double[4][2];
    private ImagePlus transformedImage = null;
    public static final int AFFINE = 6;
    public static final int BILINEAR = 8;
    public static final int RIGID_BODY = 3;
    public static final int SCALED_ROTATION = 4;
    public static final int TRANSLATION = 2;
    private final int nbCPU;

    public TurboReg(int nbCPU) {
        this.nbCPU = nbCPU;
    }

    public void Align(ImagePlus source, int transformation, ImagePlus target, int ... coordinates) {
        switch (coordinates.length) {
            case 12: 
            case 17: 
            case 20: 
            case 24: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Number of parameters incorrect.");
            }
        }
        int[] sourceCrop = new int[4];
        int[] targetCrop = new int[4];
        System.arraycopy(coordinates, 0, sourceCrop, 0, 4);
        System.arraycopy(coordinates, 4, targetCrop, 0, 4);
        switch (transformation) {
            case 2: {
                if (coordinates.length != 12) {
                    throw new IllegalArgumentException("12 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[8];
                this.sourcePoints[0][1] = coordinates[9];
                this.targetPoints[0][0] = coordinates[10];
                this.targetPoints[0][1] = coordinates[11];
                break;
            }
            case 4: {
                if (coordinates.length != 16) {
                    throw new IllegalArgumentException("16 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[8];
                this.sourcePoints[0][1] = coordinates[9];
                this.targetPoints[0][0] = coordinates[10];
                this.targetPoints[0][1] = coordinates[11];
                this.sourcePoints[1][0] = coordinates[12];
                this.sourcePoints[1][1] = coordinates[13];
                this.targetPoints[1][0] = coordinates[14];
                this.targetPoints[1][1] = coordinates[15];
                break;
            }
            case 3: 
            case 6: {
                if (coordinates.length != 20) {
                    throw new IllegalArgumentException("20 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[8];
                this.sourcePoints[0][1] = coordinates[9];
                this.targetPoints[0][0] = coordinates[10];
                this.targetPoints[0][1] = coordinates[11];
                this.sourcePoints[1][0] = coordinates[12];
                this.sourcePoints[1][1] = coordinates[13];
                this.targetPoints[1][0] = coordinates[14];
                this.targetPoints[1][1] = coordinates[15];
                this.sourcePoints[2][0] = coordinates[16];
                this.sourcePoints[2][1] = coordinates[17];
                this.targetPoints[2][0] = coordinates[18];
                this.targetPoints[2][1] = coordinates[19];
                break;
            }
            case 8: {
                if (coordinates.length != 24) {
                    throw new IllegalArgumentException("24 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[8];
                this.sourcePoints[0][1] = coordinates[9];
                this.targetPoints[0][0] = coordinates[10];
                this.targetPoints[0][1] = coordinates[11];
                this.sourcePoints[1][0] = coordinates[12];
                this.sourcePoints[1][1] = coordinates[13];
                this.targetPoints[1][0] = coordinates[14];
                this.targetPoints[1][1] = coordinates[15];
                this.sourcePoints[2][0] = coordinates[16];
                this.sourcePoints[2][1] = coordinates[17];
                this.targetPoints[2][0] = coordinates[18];
                this.targetPoints[2][1] = coordinates[19];
                this.sourcePoints[3][0] = coordinates[20];
                this.sourcePoints[3][1] = coordinates[21];
                this.targetPoints[3][0] = coordinates[22];
                this.targetPoints[3][1] = coordinates[23];
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid transformation.");
            }
        }
        this.transformedImage = this.alignImages(source, sourceCrop, target, targetCrop, transformation);
    }

    private ImagePlus alignImages(ImagePlus source, int[] sourceCrop, ImagePlus target, int[] targetCrop, int transformation) {
        if (source.getType() != 1 && source.getType() != 2 && (source.getType() != 0 || source.getStack().isRGB() || source.getStack().isHSB())) {
            IJ.error((String)(source.getTitle() + " should be grayscale (8, 16, or 32 bit)"));
            return null;
        }
        if (target.getType() != 1 && target.getType() != 2 && (target.getType() != 0 || target.getStack().isRGB() || target.getStack().isHSB())) {
            IJ.error((String)(target.getTitle() + " should be grayscale (8, 16, or 32 bit)"));
            return null;
        }
        source.setRoi(sourceCrop[0], sourceCrop[1], sourceCrop[2], sourceCrop[3]);
        target.setRoi(targetCrop[0], targetCrop[1], targetCrop[2], targetCrop[3]);
        source.setSlice(1);
        target.setSlice(1);
        ImagePlus sourceImp = new ImagePlus("source", source.getProcessor().crop());
        ImagePlus targetImp = new ImagePlus("target", target.getProcessor().crop());
        TurboRegImage sourceImg = new TurboRegImage(sourceImp, transformation, false, this.nbCPU);
        TurboRegImage targetImg = new TurboRegImage(targetImp, transformation, true, this.nbCPU);
        int pyramidDepth = this.getPyramidDepth(sourceImp.getWidth(), sourceImp.getHeight(), targetImp.getWidth(), targetImp.getHeight());
        sourceImg.setPyramidDepth(pyramidDepth);
        targetImg.setPyramidDepth(pyramidDepth);
        sourceImg.getThread().start();
        targetImg.getThread().start();
        if (2 <= source.getStackSize()) {
            source.setSlice(2);
        }
        if (2 <= target.getStackSize()) {
            target.setSlice(2);
        }
        ImagePlus sourceMskImp = new ImagePlus("source mask", source.getProcessor().crop());
        ImagePlus targetMskImp = new ImagePlus("target mask", target.getProcessor().crop());
        TurboRegMask sourceMsk = new TurboRegMask(sourceMskImp);
        TurboRegMask targetMsk = new TurboRegMask(targetMskImp);
        source.setSlice(1);
        target.setSlice(1);
        if (source.getStackSize() < 2) {
            sourceMsk.clearMask();
        }
        if (target.getStackSize() < 2) {
            targetMsk.clearMask();
        }
        sourceMsk.setPyramidDepth(pyramidDepth);
        targetMsk.setPyramidDepth(pyramidDepth);
        sourceMsk.getThread().start();
        targetMsk.getThread().start();
        switch (transformation) {
            case 2: {
                double[] dArray = this.sourcePoints[0];
                dArray[0] = dArray[0] - (double)sourceCrop[0];
                double[] dArray2 = this.sourcePoints[0];
                dArray2[1] = dArray2[1] - (double)sourceCrop[1];
                double[] dArray3 = this.targetPoints[0];
                dArray3[0] = dArray3[0] - (double)targetCrop[0];
                double[] dArray4 = this.targetPoints[0];
                dArray4[1] = dArray4[1] - (double)targetCrop[1];
                break;
            }
            case 4: {
                int k;
                for (k = 0; k < 2; ++k) {
                    double[] dArray = this.sourcePoints[k];
                    dArray[0] = dArray[0] - (double)sourceCrop[0];
                    double[] dArray5 = this.sourcePoints[k];
                    dArray5[1] = dArray5[1] - (double)sourceCrop[1];
                    double[] dArray6 = this.targetPoints[k];
                    dArray6[0] = dArray6[0] - (double)targetCrop[0];
                    double[] dArray7 = this.targetPoints[k];
                    dArray7[1] = dArray7[1] - (double)targetCrop[1];
                }
                break;
            }
            case 3: 
            case 6: {
                int k;
                for (k = 0; k < 3; ++k) {
                    double[] dArray = this.sourcePoints[k];
                    dArray[0] = dArray[0] - (double)sourceCrop[0];
                    double[] dArray8 = this.sourcePoints[k];
                    dArray8[1] = dArray8[1] - (double)sourceCrop[1];
                    double[] dArray9 = this.targetPoints[k];
                    dArray9[0] = dArray9[0] - (double)targetCrop[0];
                    double[] dArray10 = this.targetPoints[k];
                    dArray10[1] = dArray10[1] - (double)targetCrop[1];
                }
                break;
            }
            case 8: {
                int k;
                for (k = 0; k < 4; ++k) {
                    double[] dArray = this.sourcePoints[k];
                    dArray[0] = dArray[0] - (double)sourceCrop[0];
                    double[] dArray11 = this.sourcePoints[k];
                    dArray11[1] = dArray11[1] - (double)sourceCrop[1];
                    double[] dArray12 = this.targetPoints[k];
                    dArray12[0] = dArray12[0] - (double)targetCrop[0];
                    double[] dArray13 = this.targetPoints[k];
                    dArray13[1] = dArray13[1] - (double)targetCrop[1];
                }
                break;
            }
        }
        try {
            sourceMsk.getThread().join();
            targetMsk.getThread().join();
            sourceImg.getThread().join();
            targetImg.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
        }
        turboRegFinalAction finalAction = new turboRegFinalAction(sourceImg, sourceMsk, targetImg, targetMsk, transformation, this.nbCPU);
        finalAction.sourcePoints = this.sourcePoints;
        finalAction.targetPoints = this.targetPoints;
        finalAction.getThread().start();
        try {
            finalAction.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
        }
        switch (transformation) {
            case 2: {
                double[] dArray = this.sourcePoints[0];
                dArray[0] = dArray[0] + (double)sourceCrop[0];
                double[] dArray14 = this.sourcePoints[0];
                dArray14[1] = dArray14[1] + (double)sourceCrop[1];
                double[] dArray15 = this.targetPoints[0];
                dArray15[0] = dArray15[0] + (double)targetCrop[0];
                double[] dArray16 = this.targetPoints[0];
                dArray16[1] = dArray16[1] + (double)targetCrop[1];
                break;
            }
            case 4: {
                for (int k = 0; k < 2; ++k) {
                    double[] dArray = this.sourcePoints[k];
                    dArray[0] = dArray[0] + (double)sourceCrop[0];
                    double[] dArray17 = this.sourcePoints[k];
                    dArray17[1] = dArray17[1] + (double)sourceCrop[1];
                    double[] dArray18 = this.targetPoints[k];
                    dArray18[0] = dArray18[0] + (double)targetCrop[0];
                    double[] dArray19 = this.targetPoints[k];
                    dArray19[1] = dArray19[1] + (double)targetCrop[1];
                }
                break;
            }
            case 3: 
            case 6: {
                for (int k = 0; k < 3; ++k) {
                    double[] dArray = this.sourcePoints[k];
                    dArray[0] = dArray[0] + (double)sourceCrop[0];
                    double[] dArray20 = this.sourcePoints[k];
                    dArray20[1] = dArray20[1] + (double)sourceCrop[1];
                    double[] dArray21 = this.targetPoints[k];
                    dArray21[0] = dArray21[0] + (double)targetCrop[0];
                    double[] dArray22 = this.targetPoints[k];
                    dArray22[1] = dArray22[1] + (double)targetCrop[1];
                }
                break;
            }
            case 8: {
                for (int k = 0; k < 4; ++k) {
                    double[] dArray = this.sourcePoints[k];
                    dArray[0] = dArray[0] + (double)sourceCrop[0];
                    double[] dArray23 = this.sourcePoints[k];
                    dArray23[1] = dArray23[1] + (double)sourceCrop[1];
                    double[] dArray24 = this.targetPoints[k];
                    dArray24[0] = dArray24[0] + (double)targetCrop[0];
                    double[] dArray25 = this.targetPoints[k];
                    dArray25[1] = dArray25[1] + (double)targetCrop[1];
                }
                break;
            }
            default: {
                throw new Error("Should not occur.");
            }
        }
        source.killRoi();
        target.killRoi();
        ImagePlus result = this.transformImage(source, target.getWidth(), target.getHeight(), transformation);
        sourceImg.Kill();
        targetImg.Kill();
        return result;
    }

    private ImagePlus transformImage(ImagePlus source, int width, int height, int transformation) {
        if (source.getType() != 1 && source.getType() != 2 && (source.getType() != 0 || source.getStack().isRGB() || source.getStack().isHSB())) {
            IJ.error((String)(source.getTitle() + " should be grayscale (8, 16, or 32 bit)"));
            return null;
        }
        source.setSlice(1);
        TurboRegImage sourceImg = new TurboRegImage(source, -1, false, this.nbCPU);
        sourceImg.getThread().start();
        if (2 <= source.getStackSize()) {
            source.setSlice(2);
        }
        TurboRegMask sourceMsk = new TurboRegMask(source);
        source.setSlice(1);
        if (source.getStackSize() < 2) {
            sourceMsk.clearMask();
        }
        try {
            sourceImg.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.log((String)("Unexpected interruption exception " + e.getMessage()));
        }
        TurboRegTransform regTransform = new TurboRegTransform(sourceImg, sourceMsk, null, null, transformation, false, this.nbCPU);
        ImagePlus transImage = regTransform.doFinalTransform(width, height, this.sourcePoints, this.targetPoints);
        regTransform.Kill();
        sourceImg.Kill();
        return transImage;
    }

    public void Transform(ImagePlus source, int transformation, int ... coordinates) {
        switch (coordinates.length) {
            case 4: 
            case 8: 
            case 12: 
            case 16: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameters number.");
            }
        }
        switch (transformation) {
            case 2: {
                if (coordinates.length != 4) {
                    throw new IllegalArgumentException("4 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[0];
                this.sourcePoints[0][1] = coordinates[1];
                this.targetPoints[0][0] = coordinates[2];
                this.targetPoints[0][1] = coordinates[3];
                break;
            }
            case 4: {
                if (coordinates.length != 8) {
                    throw new IllegalArgumentException("8 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[0];
                this.sourcePoints[0][1] = coordinates[1];
                this.targetPoints[0][0] = coordinates[2];
                this.targetPoints[0][1] = coordinates[3];
                this.sourcePoints[1][0] = coordinates[4];
                this.sourcePoints[1][1] = coordinates[5];
                this.targetPoints[1][0] = coordinates[6];
                this.targetPoints[1][1] = coordinates[7];
                break;
            }
            case 3: 
            case 6: {
                if (coordinates.length != 12) {
                    throw new IllegalArgumentException("12 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[0];
                this.sourcePoints[0][1] = coordinates[1];
                this.targetPoints[0][0] = coordinates[2];
                this.targetPoints[0][1] = coordinates[3];
                this.sourcePoints[1][0] = coordinates[4];
                this.sourcePoints[1][1] = coordinates[5];
                this.targetPoints[1][0] = coordinates[6];
                this.targetPoints[1][1] = coordinates[7];
                this.sourcePoints[2][0] = coordinates[8];
                this.sourcePoints[2][1] = coordinates[9];
                this.targetPoints[2][0] = coordinates[10];
                this.targetPoints[2][1] = coordinates[11];
                break;
            }
            case 8: {
                if (coordinates.length != 16) {
                    throw new IllegalArgumentException("16 parameters required.");
                }
                this.sourcePoints[0][0] = coordinates[0];
                this.sourcePoints[0][1] = coordinates[1];
                this.targetPoints[0][0] = coordinates[2];
                this.targetPoints[0][1] = coordinates[3];
                this.sourcePoints[1][0] = coordinates[4];
                this.sourcePoints[1][1] = coordinates[5];
                this.targetPoints[1][0] = coordinates[6];
                this.targetPoints[1][1] = coordinates[7];
                this.sourcePoints[2][0] = coordinates[8];
                this.sourcePoints[2][1] = coordinates[9];
                this.targetPoints[2][0] = coordinates[10];
                this.targetPoints[2][1] = coordinates[11];
                this.sourcePoints[3][0] = coordinates[12];
                this.sourcePoints[3][1] = coordinates[13];
                this.targetPoints[3][0] = coordinates[14];
                this.targetPoints[3][1] = coordinates[15];
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid transformation.");
            }
        }
        this.transformedImage = this.transformImage(source, source.getWidth(), source.getHeight(), transformation);
    }

    public void Transform(ImagePlus source, int transformation) {
        this.transformedImage = this.transformImage(source, source.getWidth(), source.getHeight(), transformation);
    }

    private int getPyramidDepth(int sw, int sh, int tw, int th) {
        int pyramidDepth = 1;
        int minsize = 24;
        while (minsize <= sw && minsize <= sh && minsize <= tw && minsize <= th) {
            sw >>= 1;
            sh >>= 1;
            tw >>= 1;
            th >>= 1;
            ++pyramidDepth;
        }
        return pyramidDepth;
    }

    public ImagePlus getTransformedImage() {
        return this.transformedImage;
    }
}

