/*
 * Decompiled with CFR 0.152.
 */
package registration.turboreg;

import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import imageJ.IJInterfacor;
import imageTiTi.ImageIO;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import processing.filters.SignalFilter;
import registration.RegistrationTools;
import registration.turboreg.TurboReg;
import registration.turboreg.TurboRegStochastic;
import utils.strings.StringToolsImageDV;
import utils.times.Chronometer;

public class StackRegistration {
    public static final int AFFINE = 6;
    public static final int RIGID_BODY = 3;
    public static final int SCALED_ROTATION = 4;
    public static final int TRANSLATION = 2;
    private final Chronometer chrono = new Chronometer();
    public double time = 0.0;

    public void Process(String folderpath, List<String> subacq, Comparator<File> cmpf, int transformation, String resultpath, int nbCPU) throws Exception, Error {
        for (String acq : subacq) {
            FilenameFilter acqfnf = (dir, name) -> name.contains(acq) && name.charAt(0) != '.' && (name.contains(".tif") || name.contains(".png"));
            Object[] images = new File(folderpath).listFiles(acqfnf);
            Arrays.sort(images);
            System.out.println("Registration (" + acq + "), " + images.length + " images, Middle = " + ((File)images[images.length >> 1]).getName());
            this.Process(folderpath, ((File)images[images.length >> 1]).getName(), acqfnf, cmpf, transformation, resultpath, nbCPU);
            images = null;
            acqfnf = null;
        }
        Iterator<String> iter = null;
    }

    public void Process(String folderpath, String imagename, FilenameFilter fnf, Comparator<File> cmpf, int transformation, String resultpath, int nbCPU) throws Exception, Error {
        this.Process(folderpath, imagename, fnf, cmpf, transformation, 0, resultpath, nbCPU);
    }

    public void Process(String folderpath, String imagename, FilenameFilter fnf, Comparator<File> cmpf, int transformation, int crop, String resultpath, int nbCPU) throws Exception, Error {
        FloatProcessor processor;
        ImagePlus result;
        int marker;
        ImagePlus impsource;
        BufferedImage source;
        int i2;
        int pos;
        TurboReg turboreg = new TurboReg(nbCPU);
        File resfolder = new File(resultpath);
        if (!resfolder.exists()) {
            resfolder.mkdirs();
        }
        Object[] images = new File(folderpath).listFiles(fnf);
        if (cmpf == null) {
            Arrays.sort(images);
        } else {
            Arrays.sort(images, cmpf);
        }
        for (pos = 0; pos < images.length && !((File)images[pos]).getName().equalsIgnoreCase(imagename); ++pos) {
        }
        if (images.length <= pos) {
            throw new IllegalArgumentException("The image name was not found.");
        }
        BufferedImage target = ImageIO.Read(((File)images[pos]).getAbsolutePath());
        ImagePlus imptarget = IJInterfacor.BufferedImageToImagePlus(target);
        String ext = StringToolsImageDV.FindExtension((String)((File)images[pos]).getName());
        ImageIO.Write(target, resultpath + "/" + ((File)images[pos]).getName().replace(ext, "png"), 6);
        int width = target.getWidth();
        int height = target.getHeight();
        this.time = 0.0;
        for (i2 = pos + 1; i2 < images.length; ++i2) {
            source = ImageIO.Read(((File)images[i2]).getAbsoluteFile());
            if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)target)) {
                System.out.println("source = " + source.getType() + " => " + source.getWidth() + " x " + source.getHeight());
                System.out.println("target = " + target.getType() + " => " + target.getWidth() + " x " + target.getHeight());
                throw new IllegalArgumentException("Images have different types and dimensions.");
            }
            impsource = IJInterfacor.BufferedImageToImagePlus(source);
            marker = this.chrono.NewMarker();
            switch (transformation) {
                case 6: {
                    turboreg.Align(impsource, 6, imptarget, crop, crop, width - crop - 1, height - crop - 1, crop, crop, width - crop - 1, height - crop - 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 2, 3 * height >> 2, width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2);
                    break;
                }
                case 2: {
                    turboreg.Align(impsource, 2, imptarget, crop, crop, width - crop - 1, height - crop - 1, crop, crop, width - crop - 1, height - crop - 1, width >> 1, height >> 1, width >> 1, height >> 1);
                    break;
                }
                case 3: {
                    turboreg.Align(impsource, 3, imptarget, crop, crop, width - crop - 1, height - crop - 1, crop, crop, width - crop - 1, height - crop - 1, width >> 1, height >> 1, width >> 1, height >> 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 1, 3 * height >> 2, width >> 1, 3 * height >> 2);
                    break;
                }
                case 4: {
                    turboreg.Align(impsource, 4, imptarget, crop, crop, width - crop - 1, height - crop - 1, crop, crop, width - crop - 1, height - crop - 1, width >> 2, height >> 1, width >> 2, height >> 1, 3 * width >> 2, height >> 1, 3 * width >> 2, height >> 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transformation.");
                }
            }
            result = turboreg.getTransformedImage();
            this.time += this.chrono.getTimeSinceMarker(marker);
            this.chrono.FreeMarker(marker);
            switch (source.getType()) {
                case 10: {
                    ImageIO.Write(result.getBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                    break;
                }
                case 11: {
                    if (result.getProcessor() instanceof ShortProcessor) {
                        ImageIO.Write(((ShortProcessor)result.getProcessor()).get16BitBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                        break;
                    }
                    if (result.getProcessor() instanceof FloatProcessor) {
                        processor = (FloatProcessor)result.getProcessor();
                        processor.findMinAndMax();
                        ImageIO.Write(((FloatProcessor)result.getProcessor()).convertToShortProcessor(true).get16BitBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                        break;
                    }
                    throw new IllegalStateException("Image encoding not supported (yet).");
                }
                default: {
                    throw new IllegalStateException("Image type not supported");
                }
            }
            target = source;
            imptarget = result;
            impsource = null;
            source = null;
        }
        System.gc();
        target = ImageIO.Read(((File)images[pos]).getAbsoluteFile());
        imptarget = IJInterfacor.BufferedImageToImagePlus(target);
        for (i2 = pos - 1; i2 >= 0; --i2) {
            source = ImageIO.Read(((File)images[i2]).getAbsoluteFile());
            if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)target)) {
                System.out.println("source = " + source.getType() + " => " + source.getWidth() + " x " + source.getHeight());
                System.out.println("target = " + target.getType() + " => " + target.getWidth() + " x " + target.getHeight());
                throw new IllegalArgumentException("Images have different types and dimensions.");
            }
            impsource = IJInterfacor.BufferedImageToImagePlus(source);
            marker = this.chrono.NewMarker();
            switch (transformation) {
                case 6: {
                    turboreg.Align(impsource, 6, imptarget, crop, crop, width - crop - 1, height - crop - 1, crop, crop, width - crop - 1, height - crop - 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 2, 3 * height >> 2, width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2);
                    break;
                }
                case 2: {
                    turboreg.Align(impsource, 2, imptarget, crop, crop, width - crop - 1, height - crop - 1, crop, crop, width - crop - 1, height - crop - 1, width >> 1, height >> 1, width >> 1, height >> 1);
                    break;
                }
                case 3: {
                    turboreg.Align(impsource, 3, imptarget, crop, crop, width - crop - 1, height - crop - 1, crop, crop, width - crop - 1, height - crop - 1, width >> 1, height >> 1, width >> 1, height >> 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 1, 3 * height >> 2, width >> 1, 3 * height >> 2);
                    break;
                }
                case 4: {
                    turboreg.Align(impsource, 4, imptarget, crop, crop, width - crop - 1, height - crop - 1, crop, crop, width - crop - 1, height - crop - 1, width >> 2, height >> 1, width >> 2, height >> 1, 3 * width >> 2, height >> 1, 3 * width >> 2, height >> 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transformation.");
                }
            }
            result = turboreg.getTransformedImage();
            this.time += this.chrono.getTimeSinceMarker(marker);
            this.chrono.FreeMarker(marker);
            switch (source.getType()) {
                case 10: {
                    ImageIO.Write(result.getBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                    break;
                }
                case 11: {
                    if (result.getProcessor() instanceof ShortProcessor) {
                        ImageIO.Write(((ShortProcessor)result.getProcessor()).get16BitBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                        break;
                    }
                    if (result.getProcessor() instanceof FloatProcessor) {
                        processor = (FloatProcessor)result.getProcessor();
                        processor.findMinAndMax();
                        ImageIO.Write(((FloatProcessor)result.getProcessor()).convertToShortProcessor(true).get16BitBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                        break;
                    }
                    throw new IllegalStateException("Image encoding not supported (yet).");
                }
                default: {
                    throw new IllegalStateException("Image type not supported");
                }
            }
            target = source;
            imptarget = result;
            impsource = null;
            source = null;
        }
        RegistrationTools.CreateCheckImages(resultpath, resultpath + "/Check/");
        System.out.println("Total Time = " + this.time);
        turboreg = null;
        resfolder = null;
        images = null;
    }

    public void StochasticProcess(String folderpath, String imagename, FilenameFilter fnf, Comparator<File> cmpf, int transformation, int nbIterations, boolean Aggressive, SignalFilter filter, String resultpath, int nbCPU) throws Exception, Error {
        this.StochasticProcess(folderpath, imagename, fnf, cmpf, transformation, 0, nbIterations, Aggressive, filter, resultpath, nbCPU);
    }

    public void StochasticProcess(String folderpath, String imagename, FilenameFilter fnf, Comparator<File> cmpf, int transformation, int crop, int nbIterations, boolean Aggressive, SignalFilter filter, String resultpath, int nbCPU) throws Exception, Error {
        this.StochasticProcess(folderpath, imagename, fnf, cmpf, transformation, crop, crop, crop, crop, nbIterations, Aggressive, filter, resultpath, nbCPU);
    }

    public void StochasticProcess(String folderpath, String imagename, FilenameFilter fnf, Comparator<File> cmpf, int transformation, int cropX0, int cropY0, int cropX1, int cropY1, int nbIterations, boolean Aggressive, SignalFilter filter, String resultpath, int nbCPU) throws Exception, Error {
        FloatProcessor processor;
        ImagePlus result;
        int marker;
        ImagePlus impsource;
        BufferedImage source;
        int i2;
        int pos;
        if (nbIterations < 7) {
            throw new IllegalArgumentException("At least 7 iterations are required.");
        }
        TurboRegStochastic turboreg = new TurboRegStochastic(nbCPU);
        File resfolder = new File(resultpath);
        if (!resfolder.exists()) {
            resfolder.mkdirs();
        }
        Object[] images = new File(folderpath).listFiles(fnf);
        if (cmpf == null) {
            Arrays.sort(images);
        } else {
            Arrays.sort(images, cmpf);
        }
        for (pos = 0; pos < images.length && !((File)images[pos]).getName().equalsIgnoreCase(imagename); ++pos) {
        }
        if (images.length <= pos) {
            throw new IllegalArgumentException("The image name was not found.");
        }
        BufferedImage target = ImageIO.Read(((File)images[pos]).getAbsolutePath());
        if (filter != null) {
            target = filter.Filter(target, nbCPU);
        }
        ImagePlus imptarget = IJInterfacor.BufferedImageToImagePlus(target);
        String ext = StringToolsImageDV.FindExtension((String)((File)images[pos]).getName());
        ImageIO.Write(target, resultpath + "/" + ((File)images[pos]).getName().replace(ext, "png"), 6);
        int width = target.getWidth();
        int height = target.getHeight();
        this.time = 0.0;
        for (i2 = pos + 1; i2 < images.length; ++i2) {
            source = ImageIO.Read(((File)images[i2]).getAbsoluteFile());
            if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)target)) {
                System.out.println("source = " + source.getType() + " => " + source.getWidth() + " x " + source.getHeight());
                System.out.println("target = " + target.getType() + " => " + target.getWidth() + " x " + target.getHeight());
                throw new IllegalArgumentException("Images have different types and dimensions.");
            }
            if (filter != null) {
                source = filter.Filter(source, nbCPU);
            }
            impsource = IJInterfacor.BufferedImageToImagePlus(source);
            marker = this.chrono.NewMarker();
            switch (transformation) {
                case 6: {
                    turboreg.Align(impsource, 6, imptarget, nbIterations, Aggressive, cropX0, cropY0, width - cropX1, height - cropX1, cropX0, cropY0, width - cropX1, height - cropX1);
                    break;
                }
                case 2: {
                    turboreg.Align(impsource, 2, imptarget, nbIterations, Aggressive, cropX0, cropY0, width - cropX1, height - cropX1, cropX0, cropY0, width - cropX1, height - cropX1);
                    break;
                }
                case 3: {
                    turboreg.Align(impsource, 3, imptarget, nbIterations, Aggressive, cropX0, cropY0, width - cropX1, height - cropX1, cropX0, cropY0, width - cropX1, height - cropX1);
                    break;
                }
                case 4: {
                    turboreg.Align(impsource, 4, imptarget, nbIterations, Aggressive, cropX0, cropY0, width - cropX1, height - cropX1, cropX0, cropY0, width - cropX1, height - cropX1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transformation.");
                }
            }
            result = turboreg.getTransformedImage();
            this.time += this.chrono.getTimeSinceMarker(marker);
            this.chrono.FreeMarker(marker);
            switch (source.getType()) {
                case 10: {
                    ImageIO.Write(result.getBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                    break;
                }
                case 11: {
                    if (result.getProcessor() instanceof ShortProcessor) {
                        ImageIO.Write(((ShortProcessor)result.getProcessor()).get16BitBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                        break;
                    }
                    if (result.getProcessor() instanceof FloatProcessor) {
                        processor = (FloatProcessor)result.getProcessor();
                        processor.findMinAndMax();
                        ImageIO.Write(((FloatProcessor)result.getProcessor()).convertToShortProcessor(true).get16BitBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                        break;
                    }
                    throw new IllegalStateException("Image encoding not supported (yet).");
                }
                default: {
                    throw new IllegalStateException("Image type not supported");
                }
            }
            target = source;
            imptarget = result;
            impsource = null;
            source = null;
        }
        System.gc();
        target = ImageIO.Read(((File)images[pos]).getAbsoluteFile());
        imptarget = IJInterfacor.BufferedImageToImagePlus(target);
        for (i2 = pos - 1; i2 >= 0; --i2) {
            source = ImageIO.Read(((File)images[i2]).getAbsoluteFile());
            if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)target)) {
                System.out.println("source = " + source.getType() + " => " + source.getWidth() + " x " + source.getHeight());
                System.out.println("target = " + target.getType() + " => " + target.getWidth() + " x " + target.getHeight());
                throw new IllegalArgumentException("Images have different types and dimensions.");
            }
            impsource = IJInterfacor.BufferedImageToImagePlus(source);
            marker = this.chrono.NewMarker();
            switch (transformation) {
                case 6: {
                    turboreg.Align(impsource, 6, imptarget, nbIterations, Aggressive, cropX0, cropY0, width - cropX1, height - cropX1, cropX0, cropY0, width - cropX1, height - cropX1);
                    break;
                }
                case 2: {
                    turboreg.Align(impsource, 2, imptarget, nbIterations, Aggressive, cropX0, cropY0, width - cropX1, height - cropX1, cropX0, cropY0, width - cropX1, height - cropX1);
                    break;
                }
                case 3: {
                    turboreg.Align(impsource, 3, imptarget, nbIterations, Aggressive, cropX0, cropY0, width - cropX1, height - cropX1, cropX0, cropY0, width - cropX1, height - cropX1);
                    break;
                }
                case 4: {
                    turboreg.Align(impsource, 4, imptarget, nbIterations, Aggressive, cropX0, cropY0, width - cropX1, height - cropX1, cropX0, cropY0, width - cropX1, height - cropX1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transformation.");
                }
            }
            result = turboreg.getTransformedImage();
            this.time += this.chrono.getTimeSinceMarker(marker);
            this.chrono.FreeMarker(marker);
            switch (source.getType()) {
                case 10: {
                    ImageIO.Write(result.getBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                    break;
                }
                case 11: {
                    if (result.getProcessor() instanceof ShortProcessor) {
                        ImageIO.Write(((ShortProcessor)result.getProcessor()).get16BitBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                        break;
                    }
                    if (result.getProcessor() instanceof FloatProcessor) {
                        processor = (FloatProcessor)result.getProcessor();
                        processor.findMinAndMax();
                        ImageIO.Write(((FloatProcessor)result.getProcessor()).convertToShortProcessor(true).get16BitBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                        break;
                    }
                    throw new IllegalStateException("Image encoding not supported (yet).");
                }
                default: {
                    throw new IllegalStateException("Image type not supported");
                }
            }
            target = source;
            imptarget = result;
            impsource = null;
            source = null;
        }
        RegistrationTools.CreateCheckImages(resultpath, resultpath + "/Check/");
        System.out.println("Total Time = " + this.time);
        turboreg = null;
        resfolder = null;
        images = null;
    }

    public BufferedImage StochasticProcess(BufferedImage source, BufferedImage target, int transformation, int nbIterations, boolean Aggressive, int nbCPU) throws Exception, Error {
        return this.StochasticProcess(source, target, transformation, 0, nbIterations, Aggressive, nbCPU);
    }

    public BufferedImage StochasticProcess(BufferedImage source, BufferedImage target, int transformation, int crop, int nbIterations, boolean Aggressive, int nbCPU) throws Exception, Error {
        return this.StochasticProcess(source, target, transformation, crop, crop, crop, crop, nbIterations, Aggressive, nbCPU);
    }

    public BufferedImage StochasticProcess(BufferedImage source, BufferedImage target, int transformation, int cropX0, int cropY0, int cropX1, int cropY1, int nbIterations, boolean Aggressive, int nbCPU) throws Exception, Error {
        if (nbIterations < 7) {
            throw new IllegalArgumentException("At least 7 iterations are required.");
        }
        TurboRegStochastic turboreg = new TurboRegStochastic(nbCPU);
        ImagePlus imptarget = IJInterfacor.BufferedImageToImagePlus(target);
        int width = target.getWidth();
        int height = target.getHeight();
        this.time = 0.0;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)target)) {
            System.err.println("source = " + source.getType() + " => " + source.getWidth() + " x " + source.getHeight());
            System.err.println("target = " + target.getType() + " => " + target.getWidth() + " x " + target.getHeight());
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        ImagePlus impsource = IJInterfacor.BufferedImageToImagePlus(source);
        int marker = this.chrono.NewMarker();
        switch (transformation) {
            case 6: {
                turboreg.Align(impsource, 6, imptarget, nbIterations, Aggressive, cropX0, cropY0, width - cropX1, height - cropX1, cropX0, cropY0, width - cropX1, height - cropX1);
                break;
            }
            case 2: {
                turboreg.Align(impsource, 2, imptarget, nbIterations, Aggressive, cropX0, cropY0, width - cropX1, height - cropX1, cropX0, cropY0, width - cropX1, height - cropX1);
                break;
            }
            case 3: {
                turboreg.Align(impsource, 3, imptarget, nbIterations, Aggressive, cropX0, cropY0, width - cropX1, height - cropX1, cropX0, cropY0, width - cropX1, height - cropX1);
                break;
            }
            case 4: {
                turboreg.Align(impsource, 4, imptarget, nbIterations, Aggressive, cropX0, cropY0, width - cropX1, height - cropX1, cropX0, cropY0, width - cropX1, height - cropX1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid transformation.");
            }
        }
        ImagePlus result = turboreg.getTransformedImage();
        this.time += this.chrono.getTimeSinceMarker(marker);
        this.chrono.FreeMarker(marker);
        impsource = null;
        imptarget = null;
        switch (source.getType()) {
            case 10: {
                return result.getBufferedImage();
            }
            case 11: {
                if (result.getProcessor() instanceof ShortProcessor) {
                    return ((ShortProcessor)result.getProcessor()).get16BitBufferedImage();
                }
                if (result.getProcessor() instanceof FloatProcessor) {
                    FloatProcessor processor = (FloatProcessor)result.getProcessor();
                    processor.findMinAndMax();
                    return ((FloatProcessor)result.getProcessor()).convertToShortProcessor(true).get16BitBufferedImage();
                }
                throw new IllegalStateException("Image encoding not supported (yet).");
            }
        }
        throw new IllegalStateException("Image type not supported");
    }

    public void Process(BufferedImage source, BufferedImage target, String folderpath, FilenameFilter fnf, Comparator<File> cmpf, int transformation, int crop, String resultpath, int nbCPU) throws Exception, Error {
        TurboReg turboreg = new TurboReg(nbCPU);
        File resfolder = new File(resultpath);
        if (!resfolder.exists()) {
            resfolder.mkdirs();
        }
        Object[] images = new File(folderpath).listFiles(fnf);
        if (cmpf == null) {
            Arrays.sort(images);
        } else {
            Arrays.sort(images, cmpf);
        }
        ImagePlus imptarget = IJInterfacor.BufferedImageToImagePlus(target);
        int width = target.getWidth();
        int height = target.getHeight();
        ImagePlus impsrc = IJInterfacor.BufferedImageToImagePlus(source);
        switch (transformation) {
            case 6: {
                turboreg.Align(impsrc, 6, imptarget, crop, crop, width - crop - 1, height - crop - 1, crop, crop, width - crop - 1, height - crop - 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 2, 3 * height >> 2, width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2, 3 * width >> 2, 3 * height >> 2);
                break;
            }
            case 2: {
                turboreg.Align(impsrc, 2, imptarget, crop, crop, width - crop - 1, height - crop - 1, crop, crop, width - crop - 1, height - crop - 1, width >> 1, height >> 1, width >> 1, height >> 1);
                break;
            }
            case 3: {
                turboreg.Align(impsrc, 3, imptarget, crop, crop, width - crop - 1, height - crop - 1, crop, crop, width - crop - 1, height - crop - 1, width >> 1, height >> 1, width >> 1, height >> 1, width >> 1, height >> 2, width >> 1, height >> 2, width >> 1, 3 * height >> 2, width >> 1, 3 * height >> 2);
                break;
            }
            case 4: {
                turboreg.Align(impsrc, 4, imptarget, crop, crop, width - crop - 1, height - crop - 1, crop, crop, width - crop - 1, height - crop - 1, width >> 2, height >> 1, width >> 2, height >> 1, 3 * width >> 2, height >> 1, 3 * width >> 2, height >> 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid transformation.");
            }
        }
        impsrc = null;
        imptarget = null;
        for (int i2 = images.length - 1; 0 <= i2; --i2) {
            BufferedImage image = ImageIO.Read((File)images[i2]);
            ImagePlus impim = IJInterfacor.BufferedImageToImagePlus(image);
            turboreg.Transform(impim, transformation);
            ImageProcessor processor = turboreg.getTransformedImage().getProcessor();
            if (processor instanceof ByteProcessor) {
                ImageIO.Write(((ByteProcessor)processor).getBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
            } else if (processor instanceof ShortProcessor) {
                ImageIO.Write(((ShortProcessor)processor).get16BitBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
            } else if (processor instanceof FloatProcessor) {
                ((FloatProcessor)processor).findMinAndMax();
                ImageIO.Write(((FloatProcessor)processor).convertToShortProcessor(true).get16BitBufferedImage(), resultpath + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
            }
            processor = null;
            impim = null;
            image = null;
        }
        turboreg = null;
        resfolder = null;
        images = null;
    }
}

