/*
 * Decompiled with CFR 0.152.
 */
package registration;

import arrayTiTi.ArrayFeatures;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import org.jtransforms.dct.FloatDCT_2D;

public class Similarity {
    public static double alpha = 0.05;

    public static FichierTabule Similarities(String directory, FilenameFilter fnf, int methods) throws IOException {
        return Similarity.Similarities(directory, fnf, methods, 0);
    }

    public static FichierTabule Similarities(String directory, FilenameFilter fnf, int methods, int crop) throws IOException {
        boolean sos;
        boolean mi;
        boolean mie;
        boolean rc;
        if (crop < 0 || 50 <= crop) {
            throw new IllegalArgumentException("The crop must be into the range [0,49].");
        }
        Object[] images = new File(directory).listFiles(fnf);
        if (images.length <= 1) {
            throw new IllegalArgumentException("Not enough images found: " + images.length);
        }
        Arrays.sort(images);
        int nb = 0;
        if (8 <= methods) {
            rc = true;
            methods -= 8;
            ++nb;
        } else {
            rc = false;
        }
        if (4 <= methods) {
            mie = true;
            methods -= 4;
            ++nb;
        } else {
            mie = false;
        }
        if (2 <= methods) {
            mi = true;
            methods -= 2;
            ++nb;
        } else {
            mi = false;
        }
        if (1 <= methods) {
            sos = true;
            ++nb;
        } else {
            sos = false;
        }
        int[] types = new int[nb + 1];
        Arrays.fill(types, 1);
        types[types.length - 1] = 2;
        FichierTabule file = new FichierTabule(images.length - 1, types, "Similarities");
        types = null;
        nb = 0;
        if (sos) {
            file.setColumnName(nb++, "Sum of Square");
        }
        if (mi) {
            file.setColumnName(nb++, "Mutual Information");
        }
        if (mie) {
            file.setColumnName(nb++, "Mutual Information Entropy");
        }
        if (rc) {
            file.setColumnName(nb++, "Residual Complexity");
        }
        file.setColumnName(nb, "Images");
        BufferedImage im1 = ImageIO.Read(((File)images[0]).getAbsoluteFile());
        int cw = (int)((double)im1.getWidth() * (1.0 - 0.01 * (double)crop));
        int ch = (int)((double)im1.getHeight() * (1.0 - 0.01 * (double)crop));
        int sx = im1.getWidth() - cw >> 1;
        int sy = im1.getHeight() - ch >> 1;
        BufferedImage crop1 = new BufferedImage(cw, ch, im1.getType());
        ImageNew.SubImageWH((BufferedImage)im1, (int)sx, (int)sy, (int)cw, (int)ch, (BufferedImage)crop1);
        BufferedImage crop2 = ImageNew.Same((BufferedImage)crop1);
        for (int x = 1; x < images.length; ++x) {
            if (!((File)images[x]).isFile()) continue;
            BufferedImage im2 = ImageIO.Read(((File)images[x]).getAbsoluteFile());
            ImageNew.SubImageWH((BufferedImage)im2, (int)sx, (int)sy, (int)cw, (int)ch, (BufferedImage)crop2);
            nb = 0;
            if (sos) {
                file.setValue(x - 1, nb++, Similarity.SumOfSquaredDifferences(crop1, crop2));
            }
            if (mi) {
                file.setValue(x - 1, nb++, Similarity.MutualInformation(crop1, crop2));
            }
            if (mie) {
                file.setValue(x - 1, nb++, Similarity.MutualInformationEntropy(crop1, crop2));
            }
            if (rc) {
                file.setValue(x - 1, nb++, Similarity.ResidualComplexity(crop1, crop2));
            }
            file.setValue(x - 1, nb, ((File)images[x - 1]).getName() + " vs " + ((File)images[x]).getName());
            ImageNew.Copy((BufferedImage)crop2, (BufferedImage)crop1);
            im1 = im2;
            im2 = null;
        }
        im1 = null;
        return file;
    }

    public static FichierTabule Similarities(File src, File[] targets, int methods, boolean reduce) throws IOException {
        return Similarity.Similarities(src, targets, methods, reduce, 0);
    }

    public static FichierTabule Similarities(File src, File[] targets, int methods, boolean reduce, int crop) throws IOException {
        boolean sos;
        boolean mi;
        boolean mie;
        boolean rc;
        if (crop < 0 || 50 <= crop) {
            throw new IllegalArgumentException("The crop must be into the range [0,49].");
        }
        int nb = 0;
        if (8 <= methods) {
            rc = true;
            methods -= 8;
            ++nb;
        } else {
            rc = false;
        }
        if (4 <= methods) {
            mie = true;
            methods -= 4;
            ++nb;
        } else {
            mie = false;
        }
        if (2 <= methods) {
            mi = true;
            methods -= 2;
            ++nb;
        } else {
            mi = false;
        }
        if (1 <= methods) {
            sos = true;
            ++nb;
        } else {
            sos = false;
        }
        int[] types = new int[nb + 1];
        Arrays.fill(types, 1);
        types[types.length - 1] = 2;
        FichierTabule file = new FichierTabule(targets.length, types, "Similarities");
        types = null;
        nb = 0;
        if (sos) {
            file.setColumnName(nb++, "Sum of Square");
        }
        if (mi) {
            file.setColumnName(nb++, "Mutual Information");
        }
        if (mie) {
            file.setColumnName(nb++, "Mutual Information Entropy");
        }
        if (rc) {
            file.setColumnName(nb++, "Residual Complexity");
        }
        file.setColumnName(nb, "Images");
        BufferedImage im1 = ImageIO.Read(src.getAbsoluteFile());
        if (reduce && im1.getType() == 11) {
            im1 = ImageConverter.UShortGrayToGray((BufferedImage)im1, (boolean)true);
        }
        int cw = (int)((double)im1.getWidth() * (1.0 - 0.01 * (double)crop));
        int ch = (int)((double)im1.getHeight() * (1.0 - 0.01 * (double)crop));
        int sx = im1.getWidth() - cw >> 1;
        int sy = im1.getHeight() - ch >> 1;
        BufferedImage crop1 = new BufferedImage(cw, ch, im1.getType());
        ImageNew.SubImageWH((BufferedImage)im1, (int)sx, (int)sy, (int)cw, (int)ch, (BufferedImage)crop1);
        im1 = null;
        BufferedImage crop2 = ImageNew.Same((BufferedImage)crop1);
        for (int x = 0; x < targets.length; ++x) {
            BufferedImage im2 = ImageIO.Read(targets[x].getAbsoluteFile());
            if (reduce && im2.getType() == 11) {
                im2 = ImageConverter.UShortGrayToGray((BufferedImage)im2, (boolean)true);
            }
            ImageNew.SubImageWH((BufferedImage)im2, (int)sx, (int)sy, (int)cw, (int)ch, (BufferedImage)crop2);
            nb = 0;
            if (sos) {
                file.setValue(x, nb++, Similarity.SumOfSquaredDifferences(crop1, crop2));
            }
            if (mi) {
                file.setValue(x, nb++, Similarity.MutualInformation(crop1, crop2));
            }
            if (mie) {
                file.setValue(x, nb++, Similarity.MutualInformationEntropy(crop1, crop2));
            }
            if (rc) {
                file.setValue(x, nb++, Similarity.ResidualComplexity(crop1, crop2));
            }
            file.setValue(x, nb, src.getName() + " vs " + targets[x].getName());
            im2 = null;
        }
        return file;
    }

    public static double SumOfSquaredDifferences(BufferedImage image1, BufferedImage image2) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image1, (BufferedImage)image2)) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        long sum = 0L;
        switch (image1.getType()) {
            case 10: {
                byte[] bbim1 = ((DataBufferByte)image1.getRaster().getDataBuffer()).getData();
                byte[] bbim2 = ((DataBufferByte)image2.getRaster().getDataBuffer()).getData();
                for (int i2 = 0; i2 < bbim1.length; ++i2) {
                    int tmp = (bbim1[i2] & 0xFF) - (bbim2[i2] & 0xFF);
                    sum += (long)(tmp * tmp);
                }
                bbim2 = null;
                bbim1 = null;
                break;
            }
            case 11: {
                short[] sbim1 = ((DataBufferUShort)image1.getRaster().getDataBuffer()).getData();
                short[] sbim2 = ((DataBufferUShort)image2.getRaster().getDataBuffer()).getData();
                for (int i3 = 0; i3 < sbim1.length; ++i3) {
                    int tmp = (sbim1[i3] & 0xFFFF) - (sbim2[i3] & 0xFFFF);
                    sum += (long)(tmp * tmp);
                }
                sbim2 = null;
                sbim1 = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return (double)sum / (double)(image1.getWidth() * image1.getHeight());
    }

    public static double SumOfSquaredDifferences(BufferedImage image1, BufferedImage image2, int ForbiddenValue) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image1, (BufferedImage)image2)) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        int nb = 0;
        long sum = 0L;
        switch (image1.getType()) {
            case 10: {
                byte[] bbim1 = ((DataBufferByte)image1.getRaster().getDataBuffer()).getData();
                byte[] bbim2 = ((DataBufferByte)image2.getRaster().getDataBuffer()).getData();
                for (int i2 = 0; i2 < bbim1.length; ++i2) {
                    int v2;
                    int v1 = bbim1[i2] & 0xFF;
                    if (v1 == ForbiddenValue || (v2 = bbim2[i2] & 0xFF) == ForbiddenValue) continue;
                    ++nb;
                    int tmp = v1 - v2;
                    sum += (long)(tmp * tmp);
                }
                bbim2 = null;
                bbim1 = null;
                break;
            }
            case 11: {
                short[] sbim1 = ((DataBufferUShort)image1.getRaster().getDataBuffer()).getData();
                short[] sbim2 = ((DataBufferUShort)image2.getRaster().getDataBuffer()).getData();
                for (int i3 = 0; i3 < sbim1.length; ++i3) {
                    int v2;
                    int v1 = sbim1[i3] & 0xFFFF;
                    if (v1 == ForbiddenValue || (v2 = sbim2[i3] & 0xFFFF) == ForbiddenValue) continue;
                    ++nb;
                    int tmp = v1 - v2;
                    sum += (long)(tmp * tmp);
                }
                sbim2 = null;
                sbim1 = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return (double)sum / (double)nb;
    }

    public static double MutualInformation(BufferedImage image1, BufferedImage image2) {
        int[] p2;
        int[] p1;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image1, (BufferedImage)image2)) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        int length = -1;
        double mi = 0.0;
        int[][] p12 = null;
        switch (image1.getType()) {
            case 10: {
                byte[] bbim1 = ((DataBufferByte)image1.getRaster().getDataBuffer()).getData();
                byte[] bbim2 = ((DataBufferByte)image2.getRaster().getDataBuffer()).getData();
                length = 256;
                p1 = new int[length];
                p2 = new int[length];
                p12 = new int[length][length];
                for (int i2 = 0; i2 < bbim1.length; ++i2) {
                    int v1 = bbim1[i2] & 0xFF;
                    int v2 = bbim2[i2] & 0xFF;
                    int n = v1;
                    p1[n] = p1[n] + 1;
                    int n2 = v2;
                    p2[n2] = p2[n2] + 1;
                    int[] nArray = p12[v1];
                    int n3 = v2;
                    nArray[n3] = nArray[n3] + 1;
                }
                bbim2 = null;
                bbim1 = null;
                break;
            }
            case 11: {
                short[] sbim1 = ((DataBufferUShort)image1.getRaster().getDataBuffer()).getData();
                short[] sbim2 = ((DataBufferUShort)image2.getRaster().getDataBuffer()).getData();
                length = 65536;
                p1 = new int[length];
                p2 = new int[length];
                p12 = new int[length][length];
                for (int i3 = 0; i3 < sbim1.length; ++i3) {
                    int v1 = sbim1[i3] & 0xFFFF;
                    int v2 = sbim2[i3] & 0xFFFF;
                    int n = v1;
                    p1[n] = p1[n] + 1;
                    int n4 = v2;
                    p2[n4] = p2[n4] + 1;
                    int[] nArray = p12[v1];
                    int n5 = v2;
                    nArray[n5] = nArray[n5] + 1;
                }
                sbim2 = null;
                sbim1 = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        for (int y = 0; y < length; ++y) {
            for (int x = 0; x < length; ++x) {
                if (p12[x][y] == 0 || p1[x] == 0 || p2[y] == 0) continue;
                mi += -((double)p12[x][y]) * Math.log((double)p12[x][y] / (double)p1[x] * ((double)p12[x][y] / (double)p2[y]));
            }
        }
        p2 = null;
        p1 = null;
        p12 = null;
        return mi / (double)(image1.getWidth() * image1.getHeight());
    }

    public static double MutualInformationEntropy(BufferedImage image1, BufferedImage image2) {
        int y;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image1, (BufferedImage)image2)) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        int length = -1;
        double[][] pxy = null;
        switch (image1.getType()) {
            case 10: {
                byte[] bbim1 = ((DataBufferByte)image1.getRaster().getDataBuffer()).getData();
                byte[] bbim2 = ((DataBufferByte)image2.getRaster().getDataBuffer()).getData();
                length = 256;
                pxy = new double[length][length];
                for (int i2 = 0; i2 < bbim1.length; ++i2) {
                    double[] dArray = pxy[bbim1[i2] & 0xFF];
                    int n = bbim2[i2] & 0xFF;
                    dArray[n] = dArray[n] + 1.0;
                }
                bbim2 = null;
                bbim1 = null;
                break;
            }
            case 11: {
                short[] sbim1 = ((DataBufferUShort)image1.getRaster().getDataBuffer()).getData();
                short[] sbim2 = ((DataBufferUShort)image2.getRaster().getDataBuffer()).getData();
                length = 65536;
                pxy = new double[length][length];
                for (int i3 = 0; i3 < sbim1.length; ++i3) {
                    double[] dArray = pxy[sbim1[i3] & 0xFFFF];
                    int n = sbim2[i3] & 0xFFFF;
                    dArray[n] = dArray[n] + 1.0;
                }
                sbim2 = null;
                sbim1 = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        double[] px = new double[length];
        double[] py = new double[length];
        for (y = 0; y < length; ++y) {
            for (int x = 0; x < length; ++x) {
                int n = x;
                px[n] = px[n] + pxy[x][y];
                int n2 = y;
                py[n2] = py[n2] + pxy[x][y];
            }
        }
        for (int x = 0; x < length; ++x) {
            px[x] = 0.0 < px[x] ? -px[x] * Math.log(px[x]) : 0.0;
        }
        for (y = 0; y < length; ++y) {
            py[y] = 0.0 < py[y] ? -py[y] * Math.log(py[y]) : 0.0;
        }
        for (y = 0; y < length; ++y) {
            for (int x = 0; x < length; ++x) {
                pxy[x][y] = 0.0 < pxy[x][y] ? -pxy[x][y] * Math.log(pxy[x][y]) : 0.0;
            }
        }
        ArrayFeatures AF = new ArrayFeatures();
        double Hx = AF.Integral(px);
        double Hy = AF.Integral(py);
        double Hxy = AF.Integral(pxy);
        AF = null;
        py = null;
        px = null;
        pxy = null;
        return (Hxy - Hx - Hy) / (double)(image1.getWidth() * image1.getHeight());
    }

    public static double ResidualComplexity(BufferedImage image1, BufferedImage image2) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image1, (BufferedImage)image2)) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("Alpha is negative or null.");
        }
        FloatDCT_2D dct = new FloatDCT_2D((long)image1.getHeight(), (long)image1.getWidth());
        BufferedImage imdct = ImageNew.Float((int)image1.getWidth(), (int)image1.getHeight(), (int)1);
        ImageArithmetic.Subtract(image1, image2, imdct);
        float[] fbdct = ((DataBufferFloat)imdct.getRaster().getDataBuffer()).getData();
        dct.forward(fbdct, true);
        double sim = 0.0;
        for (int x = 0; x < fbdct.length; ++x) {
            sim += Math.log((double)(fbdct[x] * fbdct[x]) / alpha + 1.0);
        }
        fbdct = null;
        dct = null;
        imdct = null;
        return sim / (double)(image1.getWidth() * image1.getHeight());
    }
}

