/*
 * Decompiled with CFR 0.152.
 */
package registration;

import filesAndFolders.FileNameFilters;
import filesAndFolders.FilesFolders;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class RegistrationTools {
    public static void CreateCheckImages(String srcdir, String resdir) throws IOException {
        int nbImages = 3;
        BufferedImage[] xim = new BufferedImage[3];
        BufferedImage[] yim = new BufferedImage[3];
        int[] xind = new int[3];
        int[] yind = new int[3];
        File[] images = new File(srcdir).listFiles(FileNameFilters.ImagesPNGorTIF);
        Arrays.sort(images, FilesFolders.ComparatorLength());
        for (int i2 = 0; i2 < images.length; ++i2) {
            try {
                BufferedImage image = ImageIO.Read(images[i2]);
                int width = image.getWidth();
                int height = image.getHeight();
                byte[] bbim = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                if (xim[0] == null) {
                    xind[0] = width >> 2;
                    xind[1] = width >> 1;
                    xind[2] = 3 * width >> 2;
                    for (int x = 0; x < xind.length; ++x) {
                        xim[x] = ImageNew.New((int)height, (int)images.length, (int)10);
                    }
                    yind[0] = height >> 2;
                    yind[1] = height >> 1;
                    yind[2] = 3 * height >> 2;
                    for (int y = 0; y < yind.length; ++y) {
                        yim[y] = ImageNew.New((int)width, (int)images.length, (int)10);
                    }
                }
                for (int ind = 0; ind < 3; ++ind) {
                    byte[] bbx = ((DataBufferByte)xim[ind].getRaster().getDataBuffer()).getData();
                    int y = 0;
                    int pos = xind[ind];
                    int xpos = i2 * height;
                    while (y < height) {
                        bbx[xpos] = bbim[pos];
                        ++y;
                        pos += width;
                        ++xpos;
                    }
                    byte[] bby = ((DataBufferByte)yim[ind].getRaster().getDataBuffer()).getData();
                    System.arraycopy(bbim, yind[ind] * width, bby, i2 * width, width);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        File resfile = new File(resdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        for (int ind = 0; ind < 3; ++ind) {
            ImageIO.Write(xim[ind], resfile.getAbsolutePath() + "/RegistrationCheckX_" + ind + ".png", 6);
            ImageIO.Write(yim[ind], resfile.getAbsolutePath() + "/RegistrationCheckY_" + ind + ".png", 6);
        }
    }
}

