/*
 * Decompiled with CFR 0.152.
 */
package processing.zprojection;

import arrayTiTi.ArrayArithmetic;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import morphee.Dilate;
import morphee.Erode;
import morphee.StructuringElement;
import morphee.filters.ToggleMapping;
import processing.filters.DynamicExpansion;
import stackTiTi.StackIO;

public class ZProjectionCMM {
    public static final int BLACK = 0;
    public static final int WHITE = 1;
    public static final int BLACK_AND_WHITE = 2;
    private final Dilate dilate = new Dilate();
    private final Erode erode = new Erode();
    private final ToggleMapping tm = new ToggleMapping();
    private final DynamicExpansion dynexp = new DynamicExpansion();
    private BufferedImage[] List_Im_Proc = null;
    private BufferedImage[] List_Im_MaxValue = null;
    private BufferedImage[] List_Im_MaxIndex;
    private BufferedImage im;
    private BufferedImage imtmp;
    private BufferedImage imresidu;
    private BufferedImage Wproj;
    private BufferedImage Bproj;
    private BufferedImage WmaxIndex;
    private BufferedImage BmaxIndex;
    private double[] imcumul;

    public ZProjectionCMM() {
        this.tm.UntilStabilization = false;
        this.Bproj = null;
        this.Wproj = null;
        this.imresidu = null;
        this.imtmp = null;
        this.im = null;
        this.imcumul = null;
    }

    public void Classic(File[] files, FilenameFilter fnf, int TypeProjection, int setype, int nbIterations, boolean stretch, BufferedImage result, int nbCPU) throws IOException {
        BufferedImage[] stack = StackIO.ReadImageSequence(files);
        this.Classic(stack, TypeProjection, setype, nbIterations, stretch, result, nbCPU);
    }

    public void Classic(String pathfolder, FilenameFilter fnf, int TypeProjection, int setype, int nbIterations, boolean stretch, BufferedImage result, int nbCPU) throws IOException {
        BufferedImage[] stack = StackIO.ReadImageSequence(pathfolder, fnf);
        this.Classic(stack, TypeProjection, setype, nbIterations, stretch, result, nbCPU);
    }

    public void Classic(BufferedImage[] stack, int TypeProjection, int setype, int nbIterations, boolean stretch, BufferedImage result, int nbCPU) throws IOException {
        int max;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)stack[0], (BufferedImage)result)) {
            throw new IllegalArgumentException("Stack and result images have differents dimensions.");
        }
        switch (setype) {
            case -9: 
            case -1: {
                StructuringElement se = new StructuringElement(new Object[]{1, setype});
                this.dilate.setStructuringElement(se);
                this.erode.setStructuringElement(se);
                this.tm.setStructuringElement(se);
                se = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Structuring element type not supported (yet).");
            }
        }
        if (this.im == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)this.im, (BufferedImage)stack[0]) || nbIterations != this.List_Im_Proc.length) {
            this.Free();
            this.Allocations(stack[0], nbIterations);
        }
        switch (stack[0].getType()) {
            case 10: {
                max = 255;
                break;
            }
            case 11: {
                max = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        if (TypeProjection == 0 || TypeProjection == 2) {
            this.Bproj = ImageNew.Same((BufferedImage)stack[0]);
            this.BlackZProject(stack, this.Bproj, nbCPU);
            if (stretch) {
                this.dynexp.Filter(this.Bproj, 0, max, this.Bproj, nbCPU);
            }
            ImageNew.Copy((BufferedImage)this.Bproj, (BufferedImage)result);
        }
        if (TypeProjection == 1 || TypeProjection == 2) {
            this.Wproj = ImageNew.Same((BufferedImage)stack[0]);
            this.WhiteZProject(stack, this.Wproj, max, nbCPU);
            if (stretch) {
                this.dynexp.Filter(this.Wproj, 0, max, this.Wproj, nbCPU);
            }
            ImageNew.Copy((BufferedImage)this.Wproj, (BufferedImage)result);
        }
        if (TypeProjection == 2) {
            switch (result.getType()) {
                case 10: {
                    byte[] bbblack = ((DataBufferByte)this.Bproj.getRaster().getDataBuffer()).getData();
                    byte[] bbwhite = ((DataBufferByte)this.Wproj.getRaster().getDataBuffer()).getData();
                    byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                    for (int x = 0; x < bbres.length; ++x) {
                        bbres[x] = (byte)((bbblack[x] & 0xFF) + (bbwhite[x] & 0xFF) >> 1);
                    }
                    bbres = null;
                    bbwhite = null;
                    bbblack = null;
                    break;
                }
                case 11: {
                    short[] sbblack = ((DataBufferUShort)this.Bproj.getRaster().getDataBuffer()).getData();
                    short[] sbwhite = ((DataBufferUShort)this.Wproj.getRaster().getDataBuffer()).getData();
                    short[] sbres = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                    for (int x = 0; x < sbres.length; ++x) {
                        sbres[x] = (short)((sbblack[x] & 0xFFFF) + (sbwhite[x] & 0xFFFF) >> 1);
                    }
                    sbres = null;
                    sbwhite = null;
                    sbblack = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported (yet).");
                }
            }
        }
    }

    private void BlackZProject(BufferedImage[] stack, BufferedImage imout, int nbCPU) {
        int i2;
        ImageOperations.Fill((BufferedImage)this.im, (int)0);
        Arrays.fill(this.imcumul, 0.0);
        for (i2 = 0; i2 < this.List_Im_Proc.length; ++i2) {
            ImageOperations.Fill((BufferedImage)this.List_Im_Proc[i2], (int)0);
            ImageOperations.Fill((BufferedImage)this.List_Im_MaxValue[i2], (int)0);
            ImageOperations.Fill((BufferedImage)this.List_Im_MaxIndex[i2], (int)0);
        }
        for (i2 = 0; i2 < stack.length; ++i2) {
            ImageNew.Copy((BufferedImage)stack[i2], (BufferedImage)this.im);
            for (int j = 0; j < this.List_Im_Proc.length; ++j) {
                this.dilate.Filter(this.im, this.imtmp, nbCPU);
                this.erode.Filter(this.imtmp, imout, nbCPU);
                ImageOperations.Differences((BufferedImage)imout, (BufferedImage)this.im, (BufferedImage)imout);
                ImageComparator.Compare((BufferedImage)imout, (String)"<=", (BufferedImage)this.List_Im_MaxValue[j], (BufferedImage)this.List_Im_MaxIndex[j], (int)i2, (BufferedImage)this.List_Im_MaxIndex[j]);
                ImageComparator.Compare((BufferedImage)imout, (String)">", (BufferedImage)this.List_Im_MaxValue[j], (BufferedImage)imout, (BufferedImage)this.List_Im_MaxValue[j], (BufferedImage)this.List_Im_MaxValue[j]);
                ImageOperations.Maximum((BufferedImage)this.List_Im_Proc[j], (BufferedImage)imout, (BufferedImage)this.List_Im_Proc[j]);
                ImageNew.Copy((BufferedImage)this.imtmp, (BufferedImage)this.im);
            }
            ImageArithmetic.Add(this.im, this.imcumul, this.imcumul);
        }
        ArrayArithmetic.Divide((double[])this.imcumul, (double)stack.length, (double[])this.imcumul);
        ImageConverter.ArrayToImage((double[])this.imcumul, (BufferedImage)this.imresidu);
        this.tm.Filter(this.imresidu, imout, nbCPU);
        ImageOperations.Fill((BufferedImage)this.BmaxIndex, (int)0);
        for (int j = this.List_Im_Proc.length - 1; j >= 0; --j) {
            ImageNew.Copy((BufferedImage)imout, (BufferedImage)this.im);
            this.erode.Filter(imout, this.imtmp, nbCPU);
            ImageOperations.Differences((BufferedImage)this.imtmp, (BufferedImage)this.List_Im_Proc[j], (BufferedImage)imout);
            ImageComparator.Compare((BufferedImage)imout, (String)"<", (BufferedImage)this.im, (BufferedImage)this.List_Im_MaxIndex[j], (int)0, (BufferedImage)this.BmaxIndex);
        }
    }

    private void WhiteZProject(BufferedImage[] stack, BufferedImage imout, int max, int nbCPU) {
        int i2;
        ImageOperations.Fill((BufferedImage)this.im, (int)0);
        Arrays.fill(this.imcumul, 0.0);
        for (i2 = 0; i2 < this.List_Im_Proc.length; ++i2) {
            ImageOperations.Fill((BufferedImage)this.List_Im_Proc[i2], (int)0);
            ImageOperations.Fill((BufferedImage)this.List_Im_MaxValue[i2], (int)0);
            ImageOperations.Fill((BufferedImage)this.List_Im_MaxIndex[i2], (int)0);
        }
        for (i2 = 0; i2 < stack.length; ++i2) {
            ImageNew.Copy((BufferedImage)stack[i2], (BufferedImage)this.im);
            for (int j = 0; j < this.List_Im_Proc.length; ++j) {
                this.erode.Filter(this.im, this.imtmp, nbCPU);
                this.dilate.Filter(this.imtmp, imout, nbCPU);
                ImageOperations.Differences((BufferedImage)this.im, (BufferedImage)imout, (BufferedImage)imout);
                ImageComparator.Compare((BufferedImage)imout, (String)"<=", (BufferedImage)this.List_Im_MaxValue[j], (BufferedImage)this.List_Im_MaxIndex[j], (int)i2, (BufferedImage)this.List_Im_MaxIndex[j]);
                ImageComparator.Compare((BufferedImage)imout, (String)">", (BufferedImage)this.List_Im_MaxValue[j], (BufferedImage)imout, (BufferedImage)this.List_Im_MaxValue[j], (BufferedImage)this.List_Im_MaxValue[j]);
                ImageOperations.Maximum((BufferedImage)this.List_Im_Proc[j], (BufferedImage)imout, (BufferedImage)this.List_Im_Proc[j]);
                ImageNew.Copy((BufferedImage)this.imtmp, (BufferedImage)this.im);
            }
            ImageArithmetic.Add(this.im, this.imcumul, this.imcumul);
        }
        ArrayArithmetic.Divide((double[])this.imcumul, (double)stack.length, (double[])this.imcumul);
        ImageConverter.ArrayToImage((double[])this.imcumul, (BufferedImage)this.imresidu);
        this.tm.Filter(this.imresidu, imout, nbCPU);
        ImageOperations.Fill((BufferedImage)this.WmaxIndex, (int)0);
        for (int j = this.List_Im_Proc.length - 1; j >= 0; --j) {
            ImageNew.Copy((BufferedImage)imout, (BufferedImage)this.im);
            this.dilate.Filter(imout, this.imtmp, nbCPU);
            ImageArithmetic.Add(this.imtmp, this.List_Im_Proc[j], imout, max, max);
            ImageComparator.Compare((BufferedImage)imout, (String)">", (BufferedImage)this.im, (BufferedImage)this.List_Im_MaxIndex[j], (int)0, (BufferedImage)this.WmaxIndex);
        }
    }

    private void Allocations(BufferedImage sample, int nbIterations) {
        int i2;
        this.List_Im_Proc = new BufferedImage[nbIterations];
        for (i2 = 0; i2 < nbIterations; ++i2) {
            this.List_Im_Proc[i2] = ImageNew.Same((BufferedImage)sample);
        }
        this.List_Im_MaxValue = new BufferedImage[nbIterations];
        for (i2 = 0; i2 < nbIterations; ++i2) {
            this.List_Im_MaxValue[i2] = ImageNew.Same((BufferedImage)sample);
        }
        this.List_Im_MaxIndex = new BufferedImage[nbIterations];
        for (i2 = 0; i2 < nbIterations; ++i2) {
            this.List_Im_MaxIndex[i2] = ImageNew.Same((BufferedImage)sample, (int)10);
        }
        this.im = ImageNew.Same((BufferedImage)sample);
        this.imtmp = ImageNew.Same((BufferedImage)sample);
        this.imresidu = ImageNew.Same((BufferedImage)sample);
        this.Wproj = ImageNew.Same((BufferedImage)sample);
        this.Bproj = ImageNew.Same((BufferedImage)sample);
        this.WmaxIndex = ImageNew.Same((BufferedImage)sample, (int)10);
        this.BmaxIndex = ImageNew.Same((BufferedImage)sample, (int)10);
        this.imcumul = new double[sample.getHeight() * sample.getWidth()];
    }

    private void Free() {
        if (this.List_Im_Proc != null) {
            Arrays.fill(this.List_Im_Proc, null);
        }
        this.List_Im_Proc = null;
        if (this.List_Im_MaxValue != null) {
            Arrays.fill(this.List_Im_MaxValue, null);
        }
        this.List_Im_MaxValue = null;
        if (this.List_Im_MaxIndex != null) {
            Arrays.fill(this.List_Im_MaxIndex, null);
        }
        this.List_Im_MaxIndex = null;
        this.BmaxIndex = null;
        this.WmaxIndex = null;
        this.Bproj = null;
        this.Wproj = null;
        this.imresidu = null;
        this.imtmp = null;
        this.im = null;
        this.imcumul = null;
    }

    public BufferedImage WhiteProjection() {
        return this.Wproj;
    }

    public BufferedImage BlackProjection() {
        return this.Bproj;
    }

    public BufferedImage WhiteMaxIndex() {
        return this.WmaxIndex;
    }

    public BufferedImage BlackMaxIndex() {
        return this.BmaxIndex;
    }
}

