/*
 * Decompiled with CFR 0.152.
 */
package processing.zprojection;

import arrayTiTi.ArrayFeatures;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;

public class ZProjection {
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int MEAN = 2;
    public static final int MEDIAN = 3;
    public static final int SD = 4;
    public static final int MEDMEAN = 5;
    private final ArrayFeatures AF = new ArrayFeatures();

    public BufferedImage Project(BufferedImage[] stack, int mode, int start, int end) {
        BufferedImage result = ImageNew.Same((BufferedImage)stack[0]);
        this.Project(stack, mode, result, start, end);
        return result;
    }

    public void Project(BufferedImage[] stack, int mode, BufferedImage result, int start, int end) {
        switch (mode) {
            case 0: {
                this.Min(stack, result, start, end);
                break;
            }
            case 1: {
                this.Max(stack, result, start, end);
                break;
            }
            case 2: {
                this.Mean(stack, result, start, end);
                break;
            }
            case 3: {
                this.Median(stack, result, start, end);
                break;
            }
            case 4: {
                this.StandardDeviation(stack, result, start, end);
                break;
            }
            default: {
                throw new IllegalArgumentException("Mode of projection not supported.");
            }
        }
    }

    public BufferedImage Min(BufferedImage[] stack, int start, int end) {
        BufferedImage result = ImageNew.Same((BufferedImage)stack[0]);
        this.Min(stack, result, start, end);
        return result;
    }

    public void Min(BufferedImage[] stack, BufferedImage result, int start, int end) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)stack[0], (BufferedImage)result)) {
            throw new IllegalArgumentException("Stack and result image have different dimensions.");
        }
        int size = end - start + 1;
        switch (stack[0].getType()) {
            case 10: {
                int x;
                byte[] resultbuffer = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                byte[][] bytebuffer = new byte[size][];
                int nb = 0;
                for (x = start; x <= end; ++x) {
                    bytebuffer[nb++] = ((DataBufferByte)stack[x].getRaster().getDataBuffer()).getData();
                }
                int length = bytebuffer[0].length;
                for (x = 0; x < length; ++x) {
                    int min = 255;
                    for (int s = 0; s < size; ++s) {
                        int v = bytebuffer[s][x] & 0xFF;
                        if (v >= min) continue;
                        min = v;
                    }
                    resultbuffer[x] = (byte)min;
                }
                break;
            }
            case 11: {
                int x;
                short[] resbuffer = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                short[][] shortbuffer = new short[size][];
                int nb = 0;
                for (x = start; x <= end; ++x) {
                    shortbuffer[nb++] = ((DataBufferUShort)stack[x].getRaster().getDataBuffer()).getData();
                }
                int length = shortbuffer[0].length;
                for (x = 0; x < length; ++x) {
                    int min = 65535;
                    for (int s = 0; s < size; ++s) {
                        int v = shortbuffer[s][x] & 0xFFFF;
                        if (v >= min) continue;
                        min = v;
                    }
                    resbuffer[x] = (short)min;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type in stack not supported. Only gray level.");
            }
        }
    }

    public BufferedImage Max(BufferedImage[] stack, int start, int end) {
        BufferedImage result = ImageNew.Same((BufferedImage)stack[0]);
        this.Max(stack, result, start, end);
        return result;
    }

    public void Max(BufferedImage[] stack, BufferedImage result, int start, int end) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)stack[0], (BufferedImage)result)) {
            throw new IllegalArgumentException("Stack and result image have different dimensions.");
        }
        int size = end - start + 1;
        switch (stack[0].getType()) {
            case 10: {
                int x;
                byte[] resultbuffer = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                byte[][] bytebuffer = new byte[size][];
                int nb = 0;
                for (x = start; x <= end; ++x) {
                    bytebuffer[nb++] = ((DataBufferByte)stack[x].getRaster().getDataBuffer()).getData();
                }
                int length = bytebuffer[0].length;
                for (x = 0; x < length; ++x) {
                    int max = 0;
                    for (int s = 0; s < size; ++s) {
                        int v = bytebuffer[s][x] & 0xFF;
                        if (v <= max) continue;
                        max = v;
                    }
                    resultbuffer[x] = (byte)max;
                }
                break;
            }
            case 11: {
                int x;
                short[] resbuffer = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                short[][] shortbuffer = new short[size][];
                int nb = 0;
                for (x = start; x <= end; ++x) {
                    shortbuffer[nb++] = ((DataBufferUShort)stack[x].getRaster().getDataBuffer()).getData();
                }
                int length = shortbuffer[0].length;
                for (x = 0; x < length; ++x) {
                    int max = 0;
                    for (int s = 0; s < size; ++s) {
                        int v = shortbuffer[s][x] & 0xFFFF;
                        if (v <= max) continue;
                        max = v;
                    }
                    resbuffer[x] = (short)max;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type in stack not supported. Only gray level.");
            }
        }
    }

    public BufferedImage Mean(BufferedImage[] stack, int start, int end) {
        BufferedImage result = ImageNew.Same((BufferedImage)stack[0]);
        this.Mean(stack, result, start, end);
        return result;
    }

    public void Mean(BufferedImage[] stack, BufferedImage result, int start, int end) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)stack[0], (BufferedImage)result)) {
            throw new IllegalArgumentException("Stack and result image have different dimensions.");
        }
        int size = end - start + 1;
        switch (stack[0].getType()) {
            case 10: {
                int x;
                byte[] resultbuffer = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                byte[][] bytebuffer = new byte[size][];
                int nb = 0;
                for (x = start; x <= end; ++x) {
                    bytebuffer[nb++] = ((DataBufferByte)stack[x].getRaster().getDataBuffer()).getData();
                }
                int length = bytebuffer[0].length;
                for (x = 0; x < length; ++x) {
                    int mean = 0;
                    for (int s = 0; s < size; ++s) {
                        mean += bytebuffer[s][x] & 0xFF;
                    }
                    resultbuffer[x] = (byte)((double)mean / (double)size + 0.5);
                }
                break;
            }
            case 11: {
                int x;
                short[] resbuffer = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                short[][] shortbuffer = new short[size][];
                int nb = 0;
                for (x = start; x <= end; ++x) {
                    shortbuffer[nb++] = ((DataBufferUShort)stack[x].getRaster().getDataBuffer()).getData();
                }
                int length = shortbuffer[0].length;
                for (x = 0; x < length; ++x) {
                    int mean = 0;
                    for (int s = 0; s < size; ++s) {
                        mean += shortbuffer[s][x] & 0xFFFF;
                    }
                    resbuffer[x] = (short)((double)mean / (double)size + 0.5);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type in stack not supported. Only gray level.");
            }
        }
    }

    public BufferedImage Median(BufferedImage[] stack, int start, int end) {
        BufferedImage result = ImageNew.Same((BufferedImage)stack[0]);
        this.Median(stack, result, start, end);
        return result;
    }

    public void Median(BufferedImage[] stack, BufferedImage result, int start, int end) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)stack[0], (BufferedImage)result)) {
            throw new IllegalArgumentException("Stack and result image have different dimensions.");
        }
        int size = end - start + 1;
        int[] buffer = new int[size];
        switch (stack[0].getType()) {
            case 10: {
                int x;
                byte[] resultbuffer = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                byte[][] bytebuffer = new byte[size][];
                int nb = 0;
                for (x = start; x <= end; ++x) {
                    bytebuffer[nb++] = ((DataBufferByte)stack[x].getRaster().getDataBuffer()).getData();
                }
                int length = bytebuffer[0].length;
                for (x = 0; x < length; ++x) {
                    for (int s = 0; s < size; ++s) {
                        buffer[s] = bytebuffer[s][x] & 0xFF;
                    }
                    Arrays.sort(buffer);
                    resultbuffer[x] = (byte)buffer[size >> 1];
                }
                break;
            }
            case 11: {
                int x;
                short[] resbuffer = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                short[][] shortbuffer = new short[size][];
                int nb = 0;
                for (x = start; x <= end; ++x) {
                    shortbuffer[nb++] = ((DataBufferUShort)stack[x].getRaster().getDataBuffer()).getData();
                }
                int length = shortbuffer[0].length;
                for (x = 0; x < length; ++x) {
                    for (int s = 0; s < size; ++s) {
                        buffer[s] = shortbuffer[s][x] & 0xFFFF;
                    }
                    Arrays.sort(buffer);
                    resbuffer[x] = (short)buffer[size >> 1];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type in stack not supported. Only gray level.");
            }
        }
    }

    public BufferedImage StandardDeviation(BufferedImage[] stack, int start, int end) {
        BufferedImage result = ImageNew.Same((BufferedImage)stack[0]);
        this.StandardDeviation(stack, result, start, end);
        return result;
    }

    public void StandardDeviation(BufferedImage[] stack, BufferedImage result, int start, int end) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)stack[0], (BufferedImage)result)) {
            throw new IllegalArgumentException("Stack and result image have different dimensions.");
        }
        int size = end - start + 1;
        switch (stack[0].getType()) {
            case 10: {
                int x;
                byte[] resultbuffer = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                byte[][] bytebuffer = new byte[size][];
                int nb = 0;
                for (x = start; x <= end; ++x) {
                    bytebuffer[nb++] = ((DataBufferByte)stack[x].getRaster().getDataBuffer()).getData();
                }
                int length = bytebuffer[0].length;
                for (x = 0; x < length; ++x) {
                    int s;
                    double mean = 0.0;
                    double sd = 0.0;
                    for (s = 0; s < size; ++s) {
                        mean += (double)(bytebuffer[s][x] & 0xFF);
                    }
                    mean /= (double)size;
                    for (s = 0; s < size; ++s) {
                        sd += Math.pow(mean - (double)(bytebuffer[s][x] & 0xFF), 2.0);
                    }
                    sd /= (double)size;
                    sd = Math.sqrt(sd);
                    resultbuffer[x] = (byte)(sd + 0.5);
                }
                break;
            }
            case 11: {
                int x;
                short[] resbuffer = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                short[][] shortbuffer = new short[size][];
                int nb = 0;
                for (x = start; x <= end; ++x) {
                    shortbuffer[nb++] = ((DataBufferUShort)stack[x].getRaster().getDataBuffer()).getData();
                }
                int length = shortbuffer[0].length;
                for (x = 0; x < length; ++x) {
                    int s;
                    double mean = 0.0;
                    double sd = 0.0;
                    for (s = 0; s < size; ++s) {
                        mean += (double)(shortbuffer[s][x] & 0xFFFF);
                    }
                    mean /= (double)size;
                    for (s = 0; s < size; ++s) {
                        sd += Math.pow(mean - (double)(shortbuffer[s][x] & 0xFFFF), 2.0);
                    }
                    sd /= (double)size;
                    sd = Math.sqrt(sd);
                    resbuffer[x] = (short)(sd + 0.5);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type in stack not supported. Only gray level.");
            }
        }
    }

    public BufferedImage MedianMean(BufferedImage[] stack, int start, int end) {
        BufferedImage result = ImageNew.Same((BufferedImage)stack[0]);
        this.MedianMean(stack, result, start, end);
        return result;
    }

    public void MedianMean(BufferedImage[] stack, BufferedImage result, int start, int end) {
        int max;
        int min;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)stack[0], (BufferedImage)result)) {
            throw new IllegalArgumentException("Stack and result image have different dimensions.");
        }
        int size = end - start + 1;
        int[] buffer = new int[size];
        if (size < 5) {
            throw new IllegalArgumentException("Not enough images.");
        }
        if (size == 5) {
            min = 1;
            max = 4;
        } else if (size < 10) {
            min = 2;
            max = size - 2;
        } else if (size < 30) {
            min = 3;
            max = size - 3;
        } else {
            min = size >> 2;
            max = size - (size >> 2);
        }
        switch (stack[0].getType()) {
            case 10: {
                int x;
                byte[] resultbuffer = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                byte[][] bytebuffer = new byte[size][];
                int nb = 0;
                for (x = start; x <= end; ++x) {
                    bytebuffer[nb++] = ((DataBufferByte)stack[x].getRaster().getDataBuffer()).getData();
                }
                int length = bytebuffer[0].length;
                for (x = 0; x < length; ++x) {
                    for (int s = 0; s < size; ++s) {
                        buffer[s] = bytebuffer[s][x] & 0xFF;
                    }
                    Arrays.sort(buffer);
                    resultbuffer[x] = (byte)this.AF.Average(buffer, min, max);
                }
                break;
            }
            case 11: {
                int x;
                short[] resbuffer = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                short[][] shortbuffer = new short[size][];
                int nb = 0;
                for (x = start; x <= end; ++x) {
                    shortbuffer[nb++] = ((DataBufferUShort)stack[x].getRaster().getDataBuffer()).getData();
                }
                int length = shortbuffer[0].length;
                for (x = 0; x < length; ++x) {
                    for (int s = 0; s < size; ++s) {
                        buffer[s] = shortbuffer[s][x] & 0xFFFF;
                    }
                    Arrays.sort(buffer);
                    resbuffer[x] = (short)this.AF.Average(buffer, min, max);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type in stack not supported. Only gray level.");
            }
        }
    }
}

