/*
 * Decompiled with CFR 0.152.
 */
package processing.transformations;

import ij.ImagePlus;
import ij.process.ImageProcessor;
import imageJ.IJInterfacor;
import imageTiTi.ImageTools;
import imagescience.image.ColorImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.transform.Embed;
import imagescience.transform.Translate;
import imagescience.utility.I5DResource;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class Transformations {
    public static final int NEAREST = 0;
    public static final int LINEAR = 1;
    public static final int CUBIC = 2;
    public static final int BSPLINE3 = 3;
    public static final int OMOMS3 = 4;
    public static final int BSPLINE5 = 5;
    public static final int ZERO = 0;
    public static final int MINIMUM = 1;
    public static final int MAXIMUM = 2;
    public static final int REPEAT = 4;
    public static final int MIRROR = 5;
    public static final int CLAMP = 6;

    public BufferedImage Rotations(BufferedImage source, double xangle, double yangle, double zangle, int Option, boolean Adjust, boolean Antialias) {
        throw new UnsupportedOperationException("This method requires an upgrade.");
    }

    public BufferedImage Affine(BufferedImage source, double[][] matrix, int Option, double bgvalue, boolean Adjust, boolean Antialias) {
        throw new UnsupportedOperationException("This method requires an upgrade.");
    }

    public BufferedImage Embed(BufferedImage source, int newxdim, int newydim, int newzdim, int newtdim, int newcdim, int xpos, int ypos, int zpos, int tpos, int cpos, int Filling, boolean Adopt) {
        ImagePlus imp = IJInterfacor.BufferedImageToImagePlus(source);
        Image img = Image.wrap((ImagePlus)imp);
        Embed embedder = new Embed();
        switch (Filling) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new Error("Option (filling) incorrecte : " + Filling);
            }
        }
        if (newxdim < 1) {
            throw new Error("Zero or negative x-size for new image : " + newxdim);
        }
        if (newydim < 1) {
            throw new Error("Zero or negative y-size for new image : " + newydim);
        }
        if (newzdim < 1) {
            throw new Error("Zero or negative z-size for new image : " + newzdim);
        }
        if (newtdim < 1) {
            throw new Error("Zero or negative t-size for new image : " + newtdim);
        }
        if (newcdim < 1) {
            throw new Error("Zero or negative ch-size for new image : " + newcdim);
        }
        Dimensions newdims = new Dimensions(newxdim, newydim, newzdim, newtdim, newcdim);
        Coordinates inpos = new Coordinates(xpos, ypos, zpos - 1, tpos - 1, cpos - 1);
        Image newimg = embedder.run(img, newdims, inpos, Filling);
        ImagePlus newimp = newimg.imageplus();
        newimp.setCalibration(imp.getCalibration().copy());
        ImageProcessor ip = imp.getProcessor();
        ImageProcessor newip = newimp.getProcessor();
        ColorModel cm = ip.getColorModel();
        newip.setColorModel(cm);
        newimp.getStack().setColorModel(cm);
        double[] minmax = newimg.extrema();
        if (Adopt) {
            newip.setMinAndMax(ip.getMin(), ip.getMax());
        } else {
            newip.setMinAndMax(minmax[0], minmax[1]);
        }
        boolean i5dinstalled = false;
        try {
            Class.forName("i5d.Image5D");
            i5dinstalled = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (i5dinstalled && !(newimg instanceof ColorImage) && (newdims.t > 1 || newdims.c > 1)) {
            if (I5DResource.instance((ImagePlus)imp)) {
                newimp = I5DResource.convert((ImagePlus)newimp, (boolean)false);
                int[][] idx = new int[2][];
                Dimensions indims = img.dimensions();
                switch (Filling) {
                    case 0: 
                    case 1: 
                    case 2: {
                        idx[0] = new int[indims.c];
                        idx[1] = new int[indims.c];
                        for (int i2 = 0; i2 < indims.c; ++i2) {
                            idx[0][i2] = i2 + 1;
                            idx[1][i2] = inpos.c + i2 + 1;
                        }
                        break;
                    }
                    case 3: {
                        int i3;
                        idx[0] = new int[newdims.c];
                        idx[1] = new int[newdims.c];
                        for (i3 = 0; i3 < indims.c; ++i3) {
                            idx[0][inpos.c + i3] = i3 + 1;
                        }
                        for (i3 = 0; i3 < newdims.c; ++i3) {
                            idx[1][i3] = i3 + 1;
                        }
                        i3 = inpos.c - 1;
                        int i0 = inpos.c + indims.c - 1;
                        while (i3 >= 0) {
                            idx[0][i3] = idx[0][i0];
                            --i3;
                            --i0;
                        }
                        i3 = inpos.c + indims.c;
                        i0 = inpos.c;
                        while (i3 < newdims.c) {
                            idx[0][i3] = idx[0][i0];
                            ++i3;
                            ++i0;
                        }
                        break;
                    }
                    case 4: {
                        int i0;
                        int idiff;
                        int i4;
                        int i5;
                        idx[0] = new int[newdims.c];
                        idx[1] = new int[newdims.c];
                        for (i5 = 0; i5 < indims.c; ++i5) {
                            idx[0][inpos.c + i5] = i5 + 1;
                        }
                        for (i5 = 0; i5 < newdims.c; ++i5) {
                            idx[1][i5] = i5 + 1;
                        }
                        int ifs = 2;
                        int indimssm1 = indims.c - 1;
                        if (indims.c == 1) {
                            ++indimssm1;
                            ifs = 1;
                        }
                        for (i4 = inpos.c - 1; i4 >= 0; --i4) {
                            idiff = i4 - inpos.c;
                            i0 = idiff / indimssm1;
                            i0 += i0 % ifs;
                            idx[0][i4] = idx[0][inpos.c + Math.abs(idiff - i0 * indimssm1)];
                        }
                        for (i4 = inpos.c + indims.c; i4 < newdims.c; ++i4) {
                            idiff = i4 - inpos.c;
                            i0 = idiff / indimssm1;
                            i0 += i0 % ifs;
                            idx[0][i4] = idx[0][inpos.c + Math.abs(idiff - i0 * indimssm1)];
                        }
                        break;
                    }
                    case 5: {
                        int i6;
                        int i7;
                        idx[0] = new int[newdims.c];
                        idx[1] = new int[newdims.c];
                        for (i7 = 0; i7 < indims.c; ++i7) {
                            idx[0][inpos.c + i7] = i7 + 1;
                        }
                        for (i7 = 0; i7 < newdims.c; ++i7) {
                            idx[1][i7] = i7 + 1;
                        }
                        int b = idx[0][inpos.c];
                        int e = idx[0][inpos.c + indims.c - 1];
                        for (i6 = inpos.c - 1; i6 >= 0; --i6) {
                            idx[0][i6] = b;
                        }
                        for (i6 = inpos.c + indims.c; i6 < newdims.c; ++i6) {
                            idx[0][i6] = e;
                        }
                        break;
                    }
                }
                I5DResource.transfer((ImagePlus)imp, (ImagePlus)newimp, (int[][])idx);
            } else {
                newimp = I5DResource.convert((ImagePlus)newimp, (boolean)true);
            }
            if (Adopt) {
                I5DResource.minmax((ImagePlus)newimp, (double)minmax[0], (double)minmax[1]);
            }
        }
        return IJInterfacor.ImageProcessorToBufferedImage(newimg.imageplus().getProcessor());
    }

    public BufferedImage Decalage(BufferedImage source, double xshift, double yshift, double zshift, int Option, double bg) {
        ImagePlus imp = IJInterfacor.BufferedImageToImagePlus(source);
        Image img = Image.wrap((ImagePlus)imp);
        Translate shifter = new Translate();
        shifter.background = bg;
        switch (Option) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new Error("Option incorrecte : " + Option);
            }
        }
        Image newimg = shifter.run(img, xshift, yshift, zshift, Option);
        return IJInterfacor.ImageProcessorToBufferedImage(newimg.imageplus().getProcessor());
    }

    public BufferedImage Adjust(BufferedImage source, int Fond, int Marge) {
        int x;
        int y;
        if (source == null) {
            throw new NullPointerException("BufferedImage source == null");
        }
        if (!ImageTools.isGrayLevel((BufferedImage)source) && source.getType() != 12) {
            throw new IllegalArgumentException("Only gray level or binary image required.");
        }
        if (Marge < 0) {
            throw new Error("Valeur incorrecte de la marge : " + Marge + ", attendu >= 0.");
        }
        int largeur = source.getWidth();
        int hauteur = source.getHeight();
        WritableRaster wr = source.getRaster();
        int minx = largeur;
        int miny = hauteur;
        int maxy = 0;
        int maxx = 0;
        for (y = 0; y < hauteur; ++y) {
            for (x = 0; x < largeur; ++x) {
                if (wr.getSample(x, y, 0) == Fond) continue;
                if (y < miny) {
                    miny = y;
                }
                if (x < minx) {
                    minx = x;
                }
                if (y > maxy) {
                    maxy = y;
                }
                if (x <= maxx) continue;
                maxx = x;
            }
        }
        int NewLargeur = 2 * Marge + maxx - minx + 1;
        int NewHauteur = 2 * Marge + maxy - miny + 1;
        BufferedImage result = new BufferedImage(NewLargeur, NewHauteur, source.getType());
        WritableRaster wrr = result.getRaster();
        for (y = 0; y < NewHauteur; ++y) {
            for (x = 0; x < NewLargeur; ++x) {
                wrr.setSample(x, y, 0, wr.getSample(minx - Marge + x, miny - Marge + y, 0));
            }
        }
        wr = null;
        wrr = null;
        return result;
    }
}

