/*
 * Decompiled with CFR 0.152.
 */
package processing.transformations;

import java.awt.image.BufferedImage;

public class Rotations {
    public BufferedImage Rotate(BufferedImage in, double degree) {
        BufferedImage out = null;
        double angle_radian = -degree * Math.PI / 180.0;
        double tcos = Math.cos(angle_radian);
        double tsin = Math.sin(angle_radian);
        int largeurdest = (int)Math.ceil((double)in.getWidth() * Math.abs(tcos) + (double)in.getHeight() * Math.abs(tsin));
        int hauteurdest = (int)Math.ceil((double)in.getWidth() * Math.abs(tsin) + (double)in.getHeight() * Math.abs(tcos));
        out = new BufferedImage(largeurdest, hauteurdest, in.getType());
        int mxdest = out.getWidth() / 2;
        int mydest = out.getHeight() / 2;
        int mx = in.getWidth() / 2;
        int my = in.getHeight() / 2;
        for (int y = 0; y < hauteurdest; ++y) {
            for (int x = 0; x < largeurdest; ++x) {
                int bx = (int)Math.ceil(tcos * (double)(x - mxdest) + tsin * (double)(y - mydest) + (double)mx);
                int by = (int)Math.ceil(-tsin * (double)(x - mxdest) + tcos * (double)(y - mydest) + (double)my);
                if (bx < 0 || bx >= in.getWidth() || by < 0 || by >= in.getHeight()) continue;
                out.setRGB(x, y, in.getRGB(bx, by));
            }
        }
        return out;
    }

    public double[][] Rotate(double[][] in, double degree) {
        double angle_radian = -degree * Math.PI / 180.0;
        double tcos = Math.cos(angle_radian);
        double tsin = Math.sin(angle_radian);
        int largeurdest = (int)Math.ceil((double)in[0].length * Math.abs(tcos) + (double)in.length * Math.abs(tsin));
        int hauteurdest = (int)Math.ceil((double)in[0].length * Math.abs(tsin) + (double)in.length * Math.abs(tcos));
        double[][] out = new double[hauteurdest][largeurdest];
        int mxdest = out[0].length / 2;
        int mydest = out.length / 2;
        int mx = in[0].length / 2;
        int my = in.length / 2;
        for (int y = 0; y < hauteurdest; ++y) {
            for (int x = 0; x < largeurdest; ++x) {
                int bx = (int)Math.ceil(tcos * (double)(x - mxdest) + tsin * (double)(y - mydest) + (double)mx);
                int by = (int)Math.ceil(-tsin * (double)(x - mxdest) + tcos * (double)(y - mydest) + (double)my);
                if (bx < 0 || bx >= in[0].length || by < 0 || by >= in.length) continue;
                out[y][x] = in[by][bx];
            }
        }
        return out;
    }
}

